/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;

public final class SetOptions {
    private final ConditionalSet conditionalSet;
    private final String comparisonValue;
    private final boolean returnOldValue;
    private final Expiry expiry;
    public static final String RETURN_OLD_VALUE = "GET";

    public String[] toArgs() {
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.conditionalSet != null) {
            optionArgs.add(this.conditionalSet.valkeyApi);
            if (this.conditionalSet == ConditionalSet.ONLY_IF_EQUAL) {
                optionArgs.add(this.comparisonValue);
            }
        }
        if (this.returnOldValue) {
            optionArgs.add(RETURN_OLD_VALUE);
        }
        if (this.expiry != null) {
            optionArgs.add(this.expiry.type.valkeyApi);
            if (this.expiry.type != ExpiryType.KEEP_EXISTING) {
                assert (this.expiry.count != null) : "Set command received expiry type " + String.valueOf((Object)this.expiry.type) + ", but count was not set.";
                optionArgs.add(this.expiry.count.toString());
            }
        }
        return optionArgs.toArray(new String[0]);
    }

    @Generated
    SetOptions(ConditionalSet conditionalSet, String comparisonValue, boolean returnOldValue, Expiry expiry) {
        this.conditionalSet = conditionalSet;
        this.comparisonValue = comparisonValue;
        this.returnOldValue = returnOldValue;
        this.expiry = expiry;
    }

    @Generated
    public static SetOptionsBuilder builder() {
        return new SetOptionsBuilder();
    }

    protected static enum ExpiryType {
        KEEP_EXISTING("KEEPTTL"),
        SECONDS("EX"),
        MILLISECONDS("PX"),
        UNIX_SECONDS("EXAT"),
        UNIX_MILLISECONDS("PXAT");

        private final String valkeyApi;

        @Generated
        private ExpiryType(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }

    public static final class Expiry {
        private final ExpiryType type;
        private Long count;

        private Expiry(ExpiryType type) {
            this.type = type;
        }

        private Expiry(ExpiryType type, Long count) {
            this.type = type;
            this.count = count;
        }

        public static Expiry KeepExisting() {
            return new Expiry(ExpiryType.KEEP_EXISTING);
        }

        public static Expiry Seconds(Long seconds) {
            return new Expiry(ExpiryType.SECONDS, seconds);
        }

        public static Expiry Milliseconds(Long milliseconds) {
            return new Expiry(ExpiryType.MILLISECONDS, milliseconds);
        }

        public static Expiry UnixSeconds(Long unixSeconds) {
            return new Expiry(ExpiryType.UNIX_SECONDS, unixSeconds);
        }

        public static Expiry UnixMilliseconds(Long unixMilliseconds) {
            return new Expiry(ExpiryType.UNIX_MILLISECONDS, unixMilliseconds);
        }
    }

    public static class SetOptionsBuilder {
        @Generated
        private ConditionalSet conditionalSet;
        @Generated
        private String comparisonValue;
        @Generated
        private boolean returnOldValue;
        @Generated
        private Expiry expiry;

        public SetOptionsBuilder conditionalSetOnlyIfExists() {
            this.conditionalSet = ConditionalSet.ONLY_IF_EXISTS;
            this.comparisonValue = null;
            return this;
        }

        public SetOptionsBuilder conditionalSetOnlyIfNotExist() {
            this.conditionalSet = ConditionalSet.ONLY_IF_DOES_NOT_EXIST;
            this.comparisonValue = null;
            return this;
        }

        public SetOptionsBuilder conditionalSetOnlyIfEqualTo(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.conditionalSet = ConditionalSet.ONLY_IF_EQUAL;
            this.comparisonValue = value;
            return this;
        }

        @Generated
        SetOptionsBuilder() {
        }

        @Generated
        public SetOptionsBuilder conditionalSet(ConditionalSet conditionalSet) {
            this.conditionalSet = conditionalSet;
            return this;
        }

        @Generated
        public SetOptionsBuilder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            return this;
        }

        @Generated
        public SetOptionsBuilder returnOldValue(boolean returnOldValue) {
            this.returnOldValue = returnOldValue;
            return this;
        }

        @Generated
        public SetOptionsBuilder expiry(Expiry expiry) {
            this.expiry = expiry;
            return this;
        }

        @Generated
        public SetOptions build() {
            return new SetOptions(this.conditionalSet, this.comparisonValue, this.returnOldValue, this.expiry);
        }

        @Generated
        public String toString() {
            return "SetOptions.SetOptionsBuilder(conditionalSet=" + String.valueOf((Object)this.conditionalSet) + ", comparisonValue=" + this.comparisonValue + ", returnOldValue=" + this.returnOldValue + ", expiry=" + String.valueOf(this.expiry) + ")";
        }
    }

    public static enum ConditionalSet {
        ONLY_IF_EXISTS("XX"),
        ONLY_IF_DOES_NOT_EXIST("NX"),
        ONLY_IF_EQUAL("IFEQ");

        private final String valkeyApi;

        @Generated
        private ConditionalSet(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }

        @Generated
        public String getValkeyApi() {
            return this.valkeyApi;
        }
    }
}

