/*
 * Decompiled with CFR 0.152.
 */
package glide.managers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class JniResponseRegistry {
    private static final ConcurrentHashMap<Long, Object> responseObjects = new ConcurrentHashMap();
    private static final AtomicLong nextId = new AtomicLong(1L);

    public static long storeObject(Object object) {
        if (object == null) {
            return 0L;
        }
        long id = nextId.getAndIncrement();
        responseObjects.put(id, object);
        return id;
    }

    public static Object retrieveAndRemove(long id) {
        if (id == 0L) {
            return null;
        }
        return responseObjects.remove(id);
    }

    public static void clear() {
        responseObjects.clear();
    }

    public static int size() {
        return responseObjects.size();
    }
}

