/*
 * Decompiled with CFR 0.152.
 */
package glide.ffi.resolvers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;

public class NativeUtils {
    private static final int MIN_PREFIX_LENGTH = 3;
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static File temporaryDir;
    private static volatile boolean glideLibLoaded;

    private NativeUtils() {
    }

    public static synchronized void loadGlideLib() {
        if (glideLibLoaded) {
            return;
        }
        String glideLib = "/libglide_rs";
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("mac")) {
                NativeUtils.loadLibraryFromJar(glideLib + ".dylib");
            } else if (osName.contains("linux")) {
                NativeUtils.loadLibraryFromJar(glideLib + ".so");
            } else if (osName.contains("windows")) {
                NativeUtils.loadLibraryFromJar("/glide_rs.dll");
            } else {
                throw new UnsupportedOperationException("OS not supported. Glide is only available on Mac OS, Linux, and Windows systems.");
            }
            glideLibLoaded = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws IOException {
        String filename;
        if (null == path || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        if (temporaryDir == null) {
            temporaryDir = NativeUtils.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
            temporaryDir.deleteOnExit();
        }
        File temp = new File(temporaryDir, filename);
        try (InputStream is = NativeUtils.class.getResourceAsStream(path);){
            if (is == null) {
                NativeUtils.cleanupTempFile(temp);
                throw new FileNotFoundException("File " + path + " was not found inside JAR.");
            }
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            NativeUtils.cleanupTempFile(temp);
            throw e;
        }
        try {
            System.load(temp.getAbsolutePath());
        }
        finally {
            if (NativeUtils.isPosixCompliant()) {
                NativeUtils.cleanupTempFile(temp);
            } else {
                temp.deleteOnExit();
            }
        }
    }

    private static void cleanupTempFile(File temp) {
        if (!temp.delete() && temp.exists()) {
            temp.deleteOnExit();
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    private static File createTempDirectory(String prefix) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, prefix + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }

    static {
        glideLibLoaded = false;
    }
}

