/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import lombok.Generated;

public class TlsAdvancedConfiguration {
    private final boolean useInsecureTLS;
    private final byte[] rootCertificates;

    public static TlsAdvancedConfiguration fromKeyStore(String keyStorePath, char[] keyStorePassword, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (FileInputStream fis = new FileInputStream(keyStorePath);){
            keyStore.load(fis, keyStorePassword);
        }
        StringBuilder pemBuilder = new StringBuilder();
        Enumeration<String> aliases = keyStore.aliases();
        Base64.Encoder base64Encoder = Base64.getEncoder();
        String BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n";
        String END_CERT = "\n-----END CERTIFICATE-----\n";
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            Certificate cert = keyStore.getCertificate(alias);
            pemBuilder.append("-----BEGIN CERTIFICATE-----\n");
            pemBuilder.append(base64Encoder.encodeToString(cert.getEncoded()));
            pemBuilder.append("\n-----END CERTIFICATE-----\n");
        }
        return ((TlsAdvancedConfigurationBuilder)((TlsAdvancedConfigurationBuilder)TlsAdvancedConfiguration.builder().useInsecureTLS(false)).rootCertificates(pemBuilder.toString().getBytes(StandardCharsets.UTF_8))).build();
    }

    @Generated
    private static boolean $default$useInsecureTLS() {
        return false;
    }

    @Generated
    private static byte[] $default$rootCertificates() {
        return null;
    }

    @Generated
    protected TlsAdvancedConfiguration(TlsAdvancedConfigurationBuilder<?, ?> b) {
        this.useInsecureTLS = b.useInsecureTLS$set ? b.useInsecureTLS$value : TlsAdvancedConfiguration.$default$useInsecureTLS();
        this.rootCertificates = b.rootCertificates$set ? b.rootCertificates$value : TlsAdvancedConfiguration.$default$rootCertificates();
    }

    @Generated
    public static TlsAdvancedConfigurationBuilder<?, ?> builder() {
        return new TlsAdvancedConfigurationBuilderImpl();
    }

    @Generated
    public boolean isUseInsecureTLS() {
        return this.useInsecureTLS;
    }

    @Generated
    public byte[] getRootCertificates() {
        return this.rootCertificates;
    }

    @Generated
    private static final class TlsAdvancedConfigurationBuilderImpl
    extends TlsAdvancedConfigurationBuilder<TlsAdvancedConfiguration, TlsAdvancedConfigurationBuilderImpl> {
        @Generated
        private TlsAdvancedConfigurationBuilderImpl() {
        }

        @Override
        @Generated
        protected TlsAdvancedConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TlsAdvancedConfiguration build() {
            return new TlsAdvancedConfiguration(this);
        }
    }

    @Generated
    public static abstract class TlsAdvancedConfigurationBuilder<C extends TlsAdvancedConfiguration, B extends TlsAdvancedConfigurationBuilder<C, B>> {
        @Generated
        private boolean useInsecureTLS$set;
        @Generated
        private boolean useInsecureTLS$value;
        @Generated
        private boolean rootCertificates$set;
        @Generated
        private byte[] rootCertificates$value;

        @Generated
        public B useInsecureTLS(boolean useInsecureTLS) {
            this.useInsecureTLS$value = useInsecureTLS;
            this.useInsecureTLS$set = true;
            return this.self();
        }

        @Generated
        public B rootCertificates(byte[] rootCertificates) {
            this.rootCertificates$value = rootCertificates;
            this.rootCertificates$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TlsAdvancedConfiguration.TlsAdvancedConfigurationBuilder(useInsecureTLS$value=" + this.useInsecureTLS$value + ", rootCertificates$value=" + Arrays.toString(this.rootCertificates$value) + ")";
        }
    }
}

