/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.GlideString;
import glide.utils.ArgsBuilder;
import java.util.ArrayList;
import lombok.Generated;

public final class ZAddOptions {
    private final ConditionalChange conditionalChange;
    private final UpdateOptions updateOptions;

    public String[] toArgs() {
        if (this.conditionalChange == ConditionalChange.ONLY_IF_DOES_NOT_EXIST && this.updateOptions != null) {
            throw new IllegalArgumentException("The GT, LT, and NX options are mutually exclusive. Cannot choose both " + this.updateOptions.valkeyApi + " and NX.");
        }
        ArrayList<String> optionArgs = new ArrayList<String>();
        if (this.conditionalChange != null) {
            optionArgs.add(this.conditionalChange.valkeyApi);
        }
        if (this.updateOptions != null) {
            optionArgs.add(this.updateOptions.valkeyApi);
        }
        return optionArgs.toArray(new String[0]);
    }

    public GlideString[] toArgsBinary() {
        return new ArgsBuilder().add(this.toArgs()).toArray();
    }

    @Generated
    ZAddOptions(ConditionalChange conditionalChange, UpdateOptions updateOptions) {
        this.conditionalChange = conditionalChange;
        this.updateOptions = updateOptions;
    }

    @Generated
    public static ZAddOptionsBuilder builder() {
        return new ZAddOptionsBuilder();
    }

    @Generated
    public static class ZAddOptionsBuilder {
        @Generated
        private ConditionalChange conditionalChange;
        @Generated
        private UpdateOptions updateOptions;

        @Generated
        ZAddOptionsBuilder() {
        }

        @Generated
        public ZAddOptionsBuilder conditionalChange(ConditionalChange conditionalChange) {
            this.conditionalChange = conditionalChange;
            return this;
        }

        @Generated
        public ZAddOptionsBuilder updateOptions(UpdateOptions updateOptions) {
            this.updateOptions = updateOptions;
            return this;
        }

        @Generated
        public ZAddOptions build() {
            return new ZAddOptions(this.conditionalChange, this.updateOptions);
        }

        @Generated
        public String toString() {
            return "ZAddOptions.ZAddOptionsBuilder(conditionalChange=" + String.valueOf((Object)this.conditionalChange) + ", updateOptions=" + String.valueOf((Object)this.updateOptions) + ")";
        }
    }

    public static enum UpdateOptions {
        SCORE_LESS_THAN_CURRENT("LT"),
        SCORE_GREATER_THAN_CURRENT("GT");

        private final String valkeyApi;

        @Generated
        private UpdateOptions(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }

    public static enum ConditionalChange {
        ONLY_IF_EXISTS("XX"),
        ONLY_IF_DOES_NOT_EXIST("NX");

        private final String valkeyApi;

        @Generated
        private ConditionalChange(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }
}

