/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.resources;

import glide.connectors.resources.ThreadPoolResource;
import java.util.function.Supplier;

public class ThreadPoolResourceAllocator {
    private static final Object lock = new Object();
    private static ThreadPoolResource defaultThreadPoolResource = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolResource getOrCreate(Supplier<ThreadPoolResource> supplier) {
        if (defaultThreadPoolResource != null && !defaultThreadPoolResource.getEventLoopGroup().isShuttingDown()) {
            return defaultThreadPoolResource;
        }
        Object object = lock;
        synchronized (object) {
            if (defaultThreadPoolResource == null || defaultThreadPoolResource.getEventLoopGroup().isShuttingDown()) {
                defaultThreadPoolResource = supplier.get();
            }
        }
        return defaultThreadPoolResource;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new ShutdownHook(), "Glide-shutdown-hook"));
    }

    private static class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            if (defaultThreadPoolResource != null) {
                defaultThreadPoolResource.getEventLoopGroup().shutdownGracefully();
                defaultThreadPoolResource = null;
            }
        }
    }
}

