/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models;

import glide.api.models.GlideString;
import java.util.Map;
import java.util.stream.Collectors;

public class ClusterValue<T> {
    private Map<String, T> multiValue = null;
    private T singleValue = null;

    private ClusterValue() {
    }

    public Map<String, T> getMultiValue() {
        assert (this.hasMultiData()) : "No multi value stored";
        return this.multiValue;
    }

    public T getSingleValue() {
        assert (this.hasSingleData()) : "No single value stored";
        return this.singleValue;
    }

    public static <T> ClusterValue<T> of(Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.isEmpty() || map.keySet().toArray()[0] instanceof String) {
                return ClusterValue.ofMultiValue((Map)data);
            }
            return ClusterValue.ofMultiValueBinary((Map)data);
        }
        return ClusterValue.ofSingleValue(data);
    }

    public static <T> ClusterValue<T> ofSingleValue(T data) {
        ClusterValue<T> res = new ClusterValue<T>();
        res.singleValue = data;
        return res;
    }

    public static <T> ClusterValue<T> ofMultiValue(Map<String, T> data) {
        ClusterValue<T> res = new ClusterValue<T>();
        res.multiValue = data;
        return res;
    }

    public static <T> ClusterValue<T> ofMultiValueBinary(Map<GlideString, T> data) {
        ClusterValue<T> res = new ClusterValue<T>();
        res.multiValue = data.entrySet().stream().collect(Collectors.toMap(e -> ((GlideString)e.getKey()).getString(), Map.Entry::getValue));
        return res;
    }

    public boolean hasMultiData() {
        return this.multiValue != null;
    }

    public boolean hasSingleData() {
        return !this.hasMultiData();
    }
}

