/*
 * Decompiled with CFR 0.152.
 */
package glide.api;

import command_request.CommandRequestOuterClass;
import glide.api.BaseClient;
import glide.api.commands.ConnectionManagementCommands;
import glide.api.commands.GenericCommands;
import glide.api.commands.ScriptingAndFunctionsCommands;
import glide.api.commands.ServerManagementCommands;
import glide.api.commands.TransactionsCommands;
import glide.api.models.Batch;
import glide.api.models.GlideString;
import glide.api.models.Transaction;
import glide.api.models.commands.FlushMode;
import glide.api.models.commands.InfoOptions;
import glide.api.models.commands.batch.BatchOptions;
import glide.api.models.commands.function.FunctionLoadOptions;
import glide.api.models.commands.function.FunctionRestorePolicy;
import glide.api.models.commands.scan.ScanOptions;
import glide.api.models.configuration.GlideClientConfiguration;
import glide.utils.ArgsBuilder;
import glide.utils.ArrayTransformUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import response.ResponseOuterClass;

public class GlideClient
extends BaseClient
implements GenericCommands,
ServerManagementCommands,
ConnectionManagementCommands,
ScriptingAndFunctionsCommands,
TransactionsCommands {
    protected GlideClient(BaseClient.ClientBuilder builder) {
        super(builder);
    }

    public static CompletableFuture<GlideClient> createClient(@NonNull GlideClientConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return GlideClient.createClient(config, GlideClient::new);
    }

    @Override
    public CompletableFuture<Object> customCommand(@NonNull String[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.CustomCommand, args, this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> customCommand(@NonNull GlideString[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.CustomCommand, args, this::handleBinaryObjectOrNullResponse);
    }

    @Override
    @Deprecated
    public CompletableFuture<Object[]> exec(@NonNull Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("transaction is marked non-null but is null");
        }
        if (transaction.isBinaryOutput()) {
            return this.commandManager.submitNewBatch(transaction, true, Optional.empty(), this::handleArrayOrNullResponseBinary);
        }
        return this.commandManager.submitNewBatch(transaction, true, Optional.empty(), this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> exec(@NonNull Batch batch, boolean raiseOnError) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (batch.isBinaryOutput()) {
            return this.commandManager.submitNewBatch(batch, raiseOnError, Optional.empty(), this::handleArrayOrNullResponseBinary);
        }
        return this.commandManager.submitNewBatch(batch, raiseOnError, Optional.empty(), this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> exec(@NonNull Batch batch, boolean raiseOnError, @NonNull BatchOptions options) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (batch.isBinaryOutput()) {
            return this.commandManager.submitNewBatch(batch, raiseOnError, Optional.of(options), this::handleArrayOrNullResponseBinary);
        }
        return this.commandManager.submitNewBatch(batch, raiseOnError, Optional.of(options), this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<String> ping() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> ping(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new String[]{message}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> ping(@NonNull GlideString message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Ping, new GlideString[]{message}, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<String> info() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Info, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> info(@NonNull InfoOptions.Section[] sections) {
        if (sections == null) {
            throw new NullPointerException("sections is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Info, (String[])Stream.of(sections).map(Enum::toString).toArray(String[]::new), this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> select(long index) {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Select, new String[]{Long.toString(index)}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Long> clientId() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ClientId, new String[0], this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> clientGetName() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ClientGetName, new String[0], this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> configRewrite() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigRewrite, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> configResetStat() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigResetStat, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Map<String, String>> configGet(@NonNull String[] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigGet, parameters, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<String> configSet(@NonNull Map<String, String> parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ConfigSet, ArrayTransformUtils.convertMapToKeyValueStringArray(parameters), this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> echo(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Echo, new String[]{message}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> echo(@NonNull GlideString message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Echo, new GlideString[]{message}, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<String[]> time() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Time, new String[0], response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Long> lastsave() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LastSave, new String[0], this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> flushall() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushAll, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushall(@NonNull FlushMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushAll, new String[]{mode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushdb() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushDB, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> flushdb(@NonNull FlushMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FlushDB, new String[]{mode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut(int @NonNull [] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String[] arguments = (String[])Arrays.stream(parameters).mapToObj(Integer::toString).toArray(String[]::new);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut(int version) {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, new String[]{"VERSION", Integer.toString(version)}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lolwut(int version, int @NonNull [] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({"VERSION", Integer.toString(version)}, (String[])Arrays.stream(parameters).mapToObj(Integer::toString).toArray(String[]::new));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Lolwut, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Long> dbsize() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.DBSize, new String[0], this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> functionLoad(@NonNull String libraryCode, boolean replace) {
        String[] stringArray;
        if (libraryCode == null) {
            throw new NullPointerException("libraryCode is marked non-null but is null");
        }
        if (replace) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = FunctionLoadOptions.REPLACE.toString();
            stringArray = stringArray2;
            stringArray2[1] = libraryCode;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = libraryCode;
        }
        String[] arguments = stringArray;
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionLoad, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> functionLoad(@NonNull GlideString libraryCode, boolean replace) {
        GlideString[] glideStringArray;
        if (libraryCode == null) {
            throw new NullPointerException("libraryCode is marked non-null but is null");
        }
        if (replace) {
            GlideString[] glideStringArray2 = new GlideString[2];
            glideStringArray2[0] = GlideString.gs(FunctionLoadOptions.REPLACE.toString());
            glideStringArray = glideStringArray2;
            glideStringArray2[1] = libraryCode;
        } else {
            GlideString[] glideStringArray3 = new GlideString[1];
            glideStringArray = glideStringArray3;
            glideStringArray3[0] = libraryCode;
        }
        GlideString[] arguments = glideStringArray;
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionLoad, arguments, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<Boolean> move(@NonNull String key, long dbIndex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Move, new String[]{key, Long.toString(dbIndex)}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> move(@NonNull GlideString key, long dbIndex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Move, new GlideString[]{key, GlideString.gs(Long.toString(dbIndex))}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Map<String, Object>[]> functionList(boolean withCode) {
        String[] stringArray;
        if (withCode) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "WITHCODE";
        } else {
            stringArray = new String[]{};
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, stringArray, response -> this.handleFunctionListResponse(this.handleArrayResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>[]> functionListBinary(boolean withCode) {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, new ArgsBuilder().addIf("WITHCODE", withCode).toArray(), response -> this.handleFunctionListResponseBinary(this.handleArrayResponseBinary((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<String, Object>[]> functionList(@NonNull String libNamePattern, boolean withCode) {
        String[] stringArray;
        if (libNamePattern == null) {
            throw new NullPointerException("libNamePattern is marked non-null but is null");
        }
        if (withCode) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "LIBRARYNAME";
            stringArray2[1] = libNamePattern;
            stringArray = stringArray2;
            stringArray2[2] = "WITHCODE";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "LIBRARYNAME";
            stringArray = stringArray3;
            stringArray3[1] = libNamePattern;
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, stringArray, response -> this.handleFunctionListResponse(this.handleArrayResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>[]> functionListBinary(@NonNull GlideString libNamePattern, boolean withCode) {
        if (libNamePattern == null) {
            throw new NullPointerException("libNamePattern is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionList, new ArgsBuilder().add("LIBRARYNAME").add(libNamePattern).addIf("WITHCODE", withCode).toArray(), response -> this.handleFunctionListResponseBinary(this.handleArrayResponseBinary((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<String> functionFlush() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionFlush, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionFlush(@NonNull FlushMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionFlush, new String[]{mode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionDelete(@NonNull String libName) {
        if (libName == null) {
            throw new NullPointerException("libName is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDelete, new String[]{libName}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionDelete(@NonNull GlideString libName) {
        if (libName == null) {
            throw new NullPointerException("libName is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDelete, new GlideString[]{libName}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<byte[]> functionDump() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionDump, new GlideString[0], this::handleBytesOrNullResponse);
    }

    @Override
    public CompletableFuture<String> functionRestore(byte @NonNull [] payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionRestore, new GlideString[]{GlideString.gs(payload)}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> functionRestore(byte @NonNull [] payload, @NonNull FunctionRestorePolicy policy) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionRestore, new GlideString[]{GlideString.gs(payload), GlideString.gs(policy.toString())}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull String function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcall(function, new String[0], new String[0]);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull GlideString function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcall(function, new GlideString[0], new GlideString[0]);
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull String function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcallReadOnly(function, new String[0], new String[0]);
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull GlideString function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.fcallReadOnly(function, new GlideString[0], new GlideString[0]);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull String source, @NonNull String destination, long destinationDB) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        String[] arguments = new String[]{source, destination, "DB", Long.toString(destinationDB)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull GlideString source, @NonNull GlideString destination, long destinationDB) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{source, destination, GlideString.gs("DB"), GlideString.gs(Long.toString(destinationDB))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull String source, @NonNull String destination, long destinationDB, boolean replace) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        Object[] arguments = new String[]{source, destination, "DB", Long.toString(destinationDB)};
        if (replace) {
            arguments = (String[])ArrayUtils.add((Object[])arguments, (Object)"REPLACE");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, (String[])arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull GlideString source, @NonNull GlideString destination, long destinationDB, boolean replace) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        Object[] arguments = new GlideString[]{source, destination, GlideString.gs("DB"), GlideString.gs(Long.toString(destinationDB))};
        if (replace) {
            arguments = (GlideString[])ArrayUtils.add((Object[])arguments, (Object)GlideString.gs("REPLACE"));
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, (GlideString[])arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<String> functionKill() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionKill, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Map<String, Map<String, Map<String, Object>>>> functionStats() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionStats, new String[0], response -> this.handleFunctionStatsResponse((ResponseOuterClass.Response)response, false).getMultiValue());
    }

    @Override
    public CompletableFuture<Map<String, Map<GlideString, Map<GlideString, Object>>>> functionStatsBinary() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FunctionStats, new GlideString[0], response -> this.handleFunctionStatsBinaryResponse((ResponseOuterClass.Response)response, false).getMultiValue());
    }

    @Override
    public CompletableFuture<String> unwatch() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.UnWatch, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> randomKey() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RandomKey, new String[0], this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> randomKeyBinary() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RandomKey, new GlideString[0], this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> scan(@NonNull String cursor) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Scan, new String[]{cursor}, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> scan(@NonNull GlideString cursor) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Scan, new GlideString[]{cursor}, this::handleArrayResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> scan(@NonNull String cursor, @NonNull ScanOptions options) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = (String[])ArrayUtils.addFirst((Object[])options.toArgs(), (Object)cursor);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Scan, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> scan(@NonNull GlideString cursor, @NonNull ScanOptions options) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(cursor).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Scan, arguments, this::handleArrayResponseBinary);
    }

    @Override
    public CompletableFuture<Boolean[]> scriptExists(@NonNull String[] sha1s) {
        if (sha1s == null) {
            throw new NullPointerException("sha1s is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptExists, sha1s, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<Boolean[]> scriptExists(@NonNull GlideString[] sha1s) {
        if (sha1s == null) {
            throw new NullPointerException("sha1s is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptExists, sha1s, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<String> scriptFlush() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptFlush, new String[0], this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> scriptFlush(@NonNull FlushMode flushMode) {
        if (flushMode == null) {
            throw new NullPointerException("flushMode is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptFlush, new String[]{flushMode.toString()}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> scriptKill() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptKill, new String[0], this::handleStringResponse);
    }
}

