/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.IteratorEnumeration;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;

public class ServletConfigImpl
implements ServletConfig {
    private final ServletInfo servletInfo;
    private final ServletContext servletContext;

    public ServletConfigImpl(ServletInfo servletInfo, ServletContext servletContext) {
        this.servletInfo = servletInfo;
        this.servletContext = servletContext;
    }

    public String getServletName() {
        return this.servletInfo.getName();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.nullName();
        }
        return this.servletInfo.getInitParams().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return new IteratorEnumeration<String>(this.servletInfo.getInitParams().keySet().iterator());
    }
}

