/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.handlers.ServletRequestContext;

class ServletRequestContextThreadSetupAction
implements ThreadSetupHandler {
    static final ServletRequestContextThreadSetupAction INSTANCE = new ServletRequestContextThreadSetupAction();

    private ServletRequestContextThreadSetupAction() {
    }

    @Override
    public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
        return new ThreadSetupHandler.Action<T, C>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call(HttpServerExchange exchange, C context) throws Exception {
                if (exchange == null) {
                    return action.call(null, context);
                }
                ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                ServletRequestContext old = ServletRequestContext.current();
                SecurityActions.setCurrentRequestContext(servletRequestContext);
                try {
                    Object t = action.call(exchange, context);
                    return t;
                }
                finally {
                    ServletRequestContext.setCurrentRequestContext(old);
                }
            }
        };
    }
}

