/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.http2;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.examples.UndertowExample;
import io.undertow.predicate.Predicates;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.LearningPushHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.util.Headers;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.xnio.OptionMap;
import org.xnio.Xnio;

@UndertowExample(value="HTTP2", location="https://localhost:8443")
public class Http2Server {
    private static final char[] STORE_PASSWORD = "password".toCharArray();

    public static void main(String[] args) throws Exception {
        String bindAddress = System.getProperty("bind.address", "localhost");
        SSLContext sslContext = Http2Server.createSSLContext(Http2Server.loadKeyStore("server.keystore"), Http2Server.loadKeyStore("server.truststore"));
        Undertow server = Undertow.builder().setServerOption(UndertowOptions.ENABLE_HTTP2, true).addHttpListener(8080, bindAddress).addHttpsListener(8443, bindAddress, sslContext).setHandler(new SessionAttachmentHandler(new LearningPushHandler(100, -1, Handlers.header((HttpHandler)Handlers.predicate(Predicates.secure(), Handlers.resource(new PathResourceManager(Paths.get(System.getProperty("example.directory", System.getProperty("user.home")), new String[0]), 100L)).setDirectoryListingEnabled(true), new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().add(Headers.LOCATION, "https://" + exchange.getHostName() + ":" + (exchange.getHostPort() + 363) + exchange.getRelativePath());
                exchange.setStatusCode(307);
            }
        }), "x-undertow-transport", ExchangeAttributes.transportProtocol())), new InMemorySessionManager("test"), new SessionCookieConfig())).build();
        server.start();
        SSLContext clientSslContext = Http2Server.createSSLContext(Http2Server.loadKeyStore("client.keystore"), Http2Server.loadKeyStore("client.truststore"));
        LoadBalancingProxyClient proxy = new LoadBalancingProxyClient().addHost(new URI("https://localhost:8443"), null, new UndertowXnioSsl(Xnio.getInstance(), OptionMap.EMPTY, clientSslContext), OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).setConnectionsPerThread(20);
        Undertow reverseProxy = Undertow.builder().setServerOption(UndertowOptions.ENABLE_HTTP2, true).addHttpListener(8081, bindAddress).addHttpsListener(8444, bindAddress, sslContext).setHandler(ProxyHandler.builder().setProxyClient(proxy).setMaxRequestTime(30000).build()).build();
        reverseProxy.start();
    }

    private static KeyStore loadKeyStore(String name) throws Exception {
        String storeLoc = System.getProperty(name);
        InputStream stream = storeLoc == null ? Http2Server.class.getResourceAsStream(name) : Files.newInputStream(Paths.get(storeLoc, new String[0]), new OpenOption[0]);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try (InputStream is = stream;){
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(is, Http2Server.password(name));
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
    }

    static char[] password(String name) {
        String pw = System.getProperty(name + ".password");
        return pw != null ? pw.toCharArray() : STORE_PASSWORD;
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, Http2Server.password("key"));
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }
}

