/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js.templates.trimou;

import io.undertow.js.templates.Template;
import io.undertow.js.templates.TemplateProvider;
import io.undertow.js.templates.Templates;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.AbstractTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.handlebars.HelpersBuilder;

public class TrimouTemplateProvider
implements TemplateProvider {
    private volatile MustacheEngine engine;
    private volatile ResourceManager resourceManager;

    public String name() {
        return "trimou";
    }

    public void init(Map<String, String> properties, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.extra().build()).addTemplateLocator((TemplateLocator)new ResourceManagerTemplateLocator()).setProperty((ConfigurationKey)EngineConfigurationKey.DEBUG_MODE, (Object)Boolean.parseBoolean(properties.get("debug"))).setProperty((ConfigurationKey)EngineConfigurationKey.DEFAULT_FILE_ENCODING, (Object)(properties.containsKey("charset") ? properties.get("charset") : "UTF-8")).build();
    }

    public Template getTemplate(final String templateName) {
        return new Template(){

            public String apply(Object data) {
                return TrimouTemplateProvider.this.engine.getMustache(templateName).render(data);
            }
        };
    }

    private class ResourceManagerTemplateLocator
    extends AbstractTemplateLocator {
        protected ResourceManagerTemplateLocator() {
            super(1);
        }

        public Reader locate(String templateId) {
            try {
                return new StringReader(Templates.loadTemplate((String)templateId, (ResourceManager)TrimouTemplateProvider.this.resourceManager));
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public Set<String> getAllIdentifiers() {
            return Collections.emptySet();
        }
    }
}

