/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.room;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import java.util.HashMap;
import java.util.List;

public class TUIRoomDefine {

    public static interface ExperimentalAPIResponseCallback {
        public void onResponse(String var1);
    }

    public static interface UserSearchCallback {
        public void onSuccess(UserSearchResult var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface PlayCallback {
        public void onPlaying(String var1);

        public void onLoading(String var1);

        public void onPlayError(String var1, TUICommonDefine.Error var2, String var3);
    }

    public static interface RequestCallback {
        public void onAccepted(String var1, String var2);

        public void onRejected(String var1, String var2, String var3);

        public void onCancelled(String var1, String var2);

        public void onTimeout(String var1, String var2);

        public void onError(String var1, String var2, TUICommonDefine.Error var3, String var4);
    }

    public static interface RequestListCallback {
        public void onSuccess(List<Request> var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface GetSeatListCallback {
        public void onSuccess(List<SeatInfo> var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface GetUserListCallback {
        public void onSuccess(UserListResult var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface GetUserInfoCallback {
        public void onSuccess(UserInfo var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface GetRoomMetadataCallback {
        public void onSuccess(HashMap<String, String> var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface GetRoomInfoCallback {
        public void onSuccess(RoomInfo var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface ActionCallback {
        public void onSuccess();

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static class UserSearchResult {
        public String cursor;
        public List<UserInfo> userInfoList;
    }

    public static class UserListResult {
        public long nextSequence;
        public List<UserInfo> userInfoList;
    }

    public static class UserSearchParam {
        public String keyword;
        public String cursor;
    }

    public static class EnterRoomOptions {
        public String password;
    }

    public static class Request {
        public String requestId;
        public RequestAction requestAction;
        public String userId;
        public String userName;
        public String nameCard;
        public String avatarUrl;
        public String content;
        public long timestamp;
    }

    public static class UserVoiceVolume {
        public String userId;
        public int volume;
    }

    public static class SeatLockParams {
        public boolean lockSeat;
        public boolean lockVideo;
        public boolean lockAudio;
    }

    public static class SeatInfo {
        public int index;
        public String userId;
        public String userName;
        public String nameCard;
        public String avatarUrl;
        public boolean isLocked;
        public boolean isVideoLocked;
        public boolean isAudioLocked;
    }

    public static class RoomVideoEncoderParams {
        public VideoQuality videoResolution;
        public ResolutionMode resolutionMode;
        public int fps;
        public int bitrate;
    }

    public static enum UserInfoModifyFlag {
        NONE(0),
        USER_ROLE(1),
        NAME_CARD(2);

        int mValue;

        private UserInfoModifyFlag(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static UserInfoModifyFlag fromInt(int value) {
            for (UserInfoModifyFlag flag : UserInfoModifyFlag.values()) {
                if (flag.mValue != value) continue;
                return flag;
            }
            return NONE;
        }
    }

    public static class UserInfo {
        public String userId;
        public String userName;
        public String nameCard;
        public String avatarUrl;
        public Role userRole;
        public boolean hasAudioStream;
        public boolean hasVideoStream;
        public boolean hasScreenStream;
        public boolean isMessageDisabled;
        public HashMap<String, byte[]> roomCustomInfo;
    }

    public static class LoginUserInfo {
        public String userId;
        public String userName;
        public String avatarUrl;
        @Deprecated
        public HashMap<String, byte[]> customInfo;
    }

    public static class RoomInfo {
        public String roomId;
        public String ownerId;
        public String ownerName;
        public String ownerAvatarUrl;
        public RoomType roomType = RoomType.CONFERENCE;
        public String name;
        public boolean isCameraDisableForAllUser = false;
        public boolean isMicrophoneDisableForAllUser = false;
        public boolean isScreenShareDisableForAllUser = false;
        public boolean isMessageDisableForAllUser = false;
        public boolean isSeatEnabled = false;
        public SeatMode seatMode = SeatMode.FREE_TO_TAKE;
        public int maxSeatCount;
        public long createTime;
        public int memberCount;
        public String password;
    }

    public static enum RequestAction {
        INVALID_ACTION(0),
        REQUEST_TO_OPEN_REMOTE_CAMERA(1),
        REQUEST_TO_OPEN_REMOTE_MICROPHONE(2),
        REQUEST_TO_TAKE_SEAT(4),
        REQUEST_REMOTE_USER_ON_SEAT(5),
        REQUEST_APPLY_TO_ADMIN_TO_OPEN_LOCAL_CAMERA(6),
        REQUEST_APPLY_TO_ADMIN_TO_OPEN_LOCAL_MICROPHONE(7),
        REQUEST_APPLY_TO_ADMIN_TO_OPEN_LOCAL_SCREEN_SHARE(8);

        int mValue;

        private RequestAction(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static RequestAction fromInt(int value) {
            for (RequestAction requestAction : RequestAction.values()) {
                if (requestAction.mValue != value) continue;
                return requestAction;
            }
            return INVALID_ACTION;
        }
    }

    public static enum ResolutionMode {
        LANDSCAPE(0),
        PORTRAIT(1);

        int mValue;

        private ResolutionMode(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static ResolutionMode fromInt(int value) {
            for (ResolutionMode reason : ResolutionMode.values()) {
                if (reason.mValue != value) continue;
                return reason;
            }
            return PORTRAIT;
        }
    }

    public static enum KickedOutOfRoomReason {
        BY_ADMIN(0),
        BY_LOGGED_ON_OTHER_DEVICE(1),
        BY_SERVER(2);

        int mValue;

        private KickedOutOfRoomReason(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static KickedOutOfRoomReason fromInt(int value) {
            for (KickedOutOfRoomReason reason : KickedOutOfRoomReason.values()) {
                if (reason.mValue != value) continue;
                return reason;
            }
            return BY_ADMIN;
        }
    }

    public static enum ChangeReason {
        BY_SELF(0),
        BY_ADMIN(1);

        int mValue;

        private ChangeReason(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static ChangeReason fromInt(int value) {
            for (ChangeReason reason : ChangeReason.values()) {
                if (reason.mValue != value) continue;
                return reason;
            }
            return BY_SELF;
        }
    }

    public static enum VideoStreamType {
        CAMERA_STREAM(0),
        SCREEN_STREAM(1),
        CAMERA_STREAM_LOW(2);

        int mValue;

        private VideoStreamType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static VideoStreamType fromInt(int value) {
            for (VideoStreamType streamType : VideoStreamType.values()) {
                if (streamType.mValue != value) continue;
                return streamType;
            }
            return CAMERA_STREAM;
        }
    }

    public static enum AudioQuality {
        SPEECH(0),
        DEFAULT(1),
        MUSIC(2);

        int mValue;

        private AudioQuality(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static AudioQuality fromInt(int value) {
            for (AudioQuality quality : AudioQuality.values()) {
                if (quality.mValue != value) continue;
                return quality;
            }
            return DEFAULT;
        }
    }

    public static enum VideoQuality {
        Q_360P(1),
        Q_540P(2),
        Q_720P(3),
        Q_1080P(4);

        int mValue;

        private VideoQuality(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static VideoQuality fromInt(int value) {
            for (VideoQuality quality : VideoQuality.values()) {
                if (quality.mValue != value) continue;
                return quality;
            }
            return Q_720P;
        }
    }

    public static enum RoomDismissedReason {
        BY_OWNER(1),
        BY_SERVER(2);

        int mValue;

        private RoomDismissedReason(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static RoomDismissedReason fromInt(int value) {
            for (RoomDismissedReason reason : RoomDismissedReason.values()) {
                if (reason.mValue != value) continue;
                return reason;
            }
            return BY_OWNER;
        }
    }

    public static enum Role {
        ROOM_OWNER(0),
        MANAGER(1),
        GENERAL_USER(2);

        int mValue;

        private Role(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static Role fromInt(int value) {
            for (Role role : Role.values()) {
                if (role.mValue != value) continue;
                return role;
            }
            return GENERAL_USER;
        }
    }

    public static enum MediaDevice {
        MICROPHONE(1),
        CAMERA(2),
        SCREEN_SHARING(3);

        int mValue;

        private MediaDevice(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static MediaDevice fromInt(int value) {
            for (MediaDevice device : MediaDevice.values()) {
                if (device.mValue != value) continue;
                return device;
            }
            return MICROPHONE;
        }
    }

    public static enum SeatMode {
        FREE_TO_TAKE(1),
        APPLY_TO_TAKE(2);

        int mValue;

        private SeatMode(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static SeatMode fromInt(int value) {
            for (SeatMode mode : SeatMode.values()) {
                if (mode.mValue != value) continue;
                return mode;
            }
            return FREE_TO_TAKE;
        }
    }

    public static enum RoomType {
        CONFERENCE(1),
        LIVE(2);

        int mValue;

        private RoomType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static RoomType fromInt(int value) {
            for (RoomType roomType : RoomType.values()) {
                if (roomType.mValue != value) continue;
                return roomType;
            }
            return CONFERENCE;
        }
    }
}

