/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.impl.utils;

import android.text.TextUtils;
import com.tencent.liteav.base.util.LiteavLog;

public class SoLoader {
    private static final String TAG = "SoLoader";
    private static final Object mLoadLock = new Object();
    private static boolean mHasLoaded = false;
    private static String mLibraryPath = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadAllLibraries() {
        Object object = mLoadLock;
        synchronized (object) {
            if (!mHasLoaded) {
                boolean loadIMSdk = SoLoader.loadLibrary("ImSDK");
                LiteavLog.w((String)TAG, (String)("load library ImSDK " + loadIMSdk));
                boolean loadLiteavSdk = SoLoader.loadLibrary("liteavsdk");
                LiteavLog.w((String)TAG, (String)("load library liteavsdk " + loadLiteavSdk));
                boolean loadTuikitEngineRoom = SoLoader.loadLibrary("tuikitengineroom");
                LiteavLog.w((String)TAG, (String)("load library tuikitengineroom " + loadTuikitEngineRoom));
                mHasLoaded = loadIMSdk && loadLiteavSdk && loadTuikitEngineRoom;
            }
            return mHasLoaded;
        }
    }

    public static boolean loadLibrary(String name) {
        try {
            LiteavLog.w((String)TAG, (String)("load library " + name + " from system path "));
            System.loadLibrary(name);
            return true;
        }
        catch (Error e) {
            LiteavLog.e((String)TAG, (String)("load library : " + e.toString()));
            return SoLoader.loadLibrary(mLibraryPath, name);
        }
        catch (Exception e1) {
            LiteavLog.w((String)TAG, (String)("load library : " + e1.toString()));
            return SoLoader.loadLibrary(mLibraryPath, name);
        }
    }

    public static boolean loadLibrary(String path, String name) {
        boolean loadSuccess = false;
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                LiteavLog.w((String)TAG, (String)("load library " + name + " from path " + path));
                String libName = path + "/lib" + name + ".so";
                System.load(libName);
                loadSuccess = true;
            }
        }
        catch (Error e1) {
            LiteavLog.e((String)TAG, (String)("load library : " + e1.toString()));
        }
        catch (Exception e) {
            LiteavLog.w((String)TAG, (String)("load library : " + e.toString()));
        }
        return loadSuccess;
    }

    public static String getLibraryPath() {
        return mLibraryPath;
    }

    public static void setLibraryPath(String path) {
        LiteavLog.w((String)TAG, (String)("setLibraryPath " + path));
        mLibraryPath = path;
    }
}

