/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.impl.utils;

import com.tencent.cloud.tuikit.engine.call.TUICallDefine;
import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ParamsParse {
    private static final String TAG = "ParamsParse";

    public static JSONObject callParamsToJsonObject(TUICallDefine.CallParams callParams) {
        JSONObject jsonObject = new JSONObject();
        if (callParams == null) {
            LiteavLog.w((String)TAG, (String)"callParams is null, return empty JSONObject");
            return jsonObject;
        }
        try {
            if (callParams.roomId != null) {
                jsonObject.put("room_id", (Object)ParamsParse.roomIdToJsonObject(callParams.roomId));
            }
            jsonObject.put("timeout", callParams.timeout);
            jsonObject.put("user_data", (Object)callParams.userData);
            if (callParams.offlinePushInfo != null) {
                JSONObject offlinePushInfoObject = new JSONObject();
                offlinePushInfoObject.put("title", (Object)callParams.offlinePushInfo.getTitle());
                offlinePushInfoObject.put("desc", (Object)callParams.offlinePushInfo.getDesc());
                offlinePushInfoObject.put("ignore_ios_badge", callParams.offlinePushInfo.isIgnoreIOSBadge());
                offlinePushInfoObject.put("ios_sound", (Object)callParams.offlinePushInfo.getIOSSound());
                offlinePushInfoObject.put("android_sound", (Object)callParams.offlinePushInfo.getAndroidSound());
                offlinePushInfoObject.put("android_oppo_channel_id", (Object)callParams.offlinePushInfo.getAndroidOPPOChannelID());
                offlinePushInfoObject.put("android_vivo_classification", callParams.offlinePushInfo.getAndroidVIVOClassification());
                offlinePushInfoObject.put("android_xiaomi_channelid", (Object)callParams.offlinePushInfo.getAndroidXiaoMiChannelID());
                offlinePushInfoObject.put("android_fcm_channelid", (Object)callParams.offlinePushInfo.getAndroidFCMChannelID());
                offlinePushInfoObject.put("android_huawei_category", (Object)callParams.offlinePushInfo.getAndroidHuaWeiCategory());
                offlinePushInfoObject.put("is_disable_push", callParams.offlinePushInfo.isDisablePush());
                offlinePushInfoObject.put("ios_push_type", callParams.offlinePushInfo.getIOSPushType() != null ? callParams.offlinePushInfo.getIOSPushType().getValue() : TUICallDefine.IOSOfflinePushType.APNs.getValue());
                offlinePushInfoObject.put("extension", (Object)callParams.offlinePushInfo.extraInfo);
                jsonObject.put("offline_push_info", (Object)offlinePushInfoObject);
            }
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("callParamsToJsonString failed, error: " + (Object)((Object)e)));
            return new JSONObject();
        }
        return jsonObject;
    }

    public static JSONObject roomIdToJsonObject(TUICommonDefine.RoomId roomId) {
        JSONObject jsonObject = new JSONObject();
        if (roomId == null) {
            LiteavLog.w((String)TAG, (String)"roomId is null, return empty JSONObject");
            return jsonObject;
        }
        try {
            jsonObject.put("int_room_id", roomId.intRoomId);
            jsonObject.put("str_room_id", (Object)roomId.strRoomId);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("callParamsToJsonString failed, error: " + (Object)((Object)e)));
            return new JSONObject();
        }
        return jsonObject;
    }

    public static List<TUICommonDefine.NetworkQualityInfo> getQualityInfoListFromJSONArray(JSONArray params) {
        ArrayList<TUICommonDefine.NetworkQualityInfo> networkQualityList = new ArrayList<TUICommonDefine.NetworkQualityInfo>();
        if (params == null || params.length() <= 0) {
            return networkQualityList;
        }
        try {
            for (int i = 0; i < params.length(); ++i) {
                JSONObject jsonObject = params.getJSONObject(i);
                TUICommonDefine.NetworkQualityInfo info = new TUICommonDefine.NetworkQualityInfo();
                info.userId = jsonObject.getString("user_id");
                info.quality = TUICommonDefine.NetworkQuality.values()[jsonObject.getInt("quality")];
                networkQualityList.add(info);
            }
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("getQualityInfoList failed, error: " + (Object)((Object)e)));
        }
        return networkQualityList;
    }

    public static TUIRoomDefine.UserSearchResult getUserSearchResultFromJSONArray(JSONObject jsonObject) {
        TUIRoomDefine.UserSearchResult result = new TUIRoomDefine.UserSearchResult();
        result.cursor = "";
        result.userInfoList = new ArrayList<TUIRoomDefine.UserInfo>();
        if (jsonObject == null) {
            return result;
        }
        try {
            result.cursor = jsonObject.getString("cursor");
            JSONArray jsonArrayUserList = jsonObject.getJSONArray("user_info_list");
            for (int i = 0; i < jsonArrayUserList.length(); ++i) {
                JSONObject jsonObjectUserInfo = jsonArrayUserList.getJSONObject(i);
                TUIRoomDefine.UserInfo userInfo = ParamsParse.getUserInfoFromJSONObject(jsonObjectUserInfo);
                result.userInfoList.add(userInfo);
            }
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("getUserSearchResultFromJSONArray failed, error: " + (Object)((Object)e)));
        }
        return result;
    }

    public static TUIRoomDefine.UserInfo getUserInfoFromJSONObject(JSONObject jsonObject) {
        TUIRoomDefine.UserInfo userInfo = new TUIRoomDefine.UserInfo();
        try {
            userInfo.userId = jsonObject.getString("userId");
            userInfo.userName = jsonObject.getString("userName");
            userInfo.nameCard = jsonObject.getString("nameCard");
            userInfo.avatarUrl = jsonObject.getString("avatarUrl");
            userInfo.userRole = TUIRoomDefine.Role.fromInt(jsonObject.getInt("userRole"));
            userInfo.hasAudioStream = jsonObject.getBoolean("hasAudioStream");
            userInfo.hasVideoStream = jsonObject.getBoolean("hasVideoStream");
            userInfo.hasScreenStream = jsonObject.getBoolean("hasScreenStream");
            userInfo.isMessageDisabled = jsonObject.getBoolean("isMessageDisabled");
            userInfo.roomCustomInfo = ParamsParse.getRoomCustomInfoFromJSONObject(jsonObject.getJSONObject("roomCustomInfo"));
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("getUserInfoFromJSONObject failed, error: " + (Object)((Object)e)));
        }
        return userInfo;
    }

    public static HashMap<String, byte[]> getRoomCustomInfoFromJSONObject(JSONObject jsonObject) {
        HashMap<String, byte[]> roomCustomInfo = new HashMap<String, byte[]>();
        try {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = jsonObject.getString(key);
                roomCustomInfo.put(key, value.getBytes());
            }
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("getRoomCustomInfo failed, error: " + (Object)((Object)e)));
        }
        return roomCustomInfo;
    }

    public static <T> T getParamFromJSONArray(JSONArray params, int index, Class<T> clazz) {
        try {
            if (params == null || params.length() <= index) {
                return null;
            }
            if (clazz == String.class) {
                return (T)params.getString(index);
            }
            if (clazz == Integer.class) {
                return (T)Integer.valueOf(params.getInt(index));
            }
            if (clazz == Boolean.class) {
                return (T)Boolean.valueOf(params.getBoolean(index));
            }
            if (clazz == JSONObject.class) {
                return (T)params.getJSONObject(index);
            }
            if (clazz == JSONArray.class) {
                return (T)params.getJSONArray(index);
            }
            if (clazz == TUICallDefine.MediaType.class) {
                return (T)((Object)TUICallDefine.MediaType.fromInt(params.getInt(index)));
            }
            if (clazz == TUICallDefine.Role.class) {
                return (T)((Object)TUICallDefine.Role.fromInt(params.getInt(index)));
            }
            if (clazz == TUICallDefine.CallEndReason.class) {
                return (T)((Object)TUICallDefine.CallEndReason.fromInt(params.getInt(index)));
            }
            if (clazz == TUICommonDefine.RoomId.class) {
                TUICommonDefine.RoomId roomId = new TUICommonDefine.RoomId();
                roomId.intRoomId = params.getInt(index);
                roomId.strRoomId = params.getString(index + 1);
                return (T)roomId;
            }
            return null;
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("getParamFromJSONArray json parse fail error" + (Object)((Object)e)));
            return null;
        }
    }

    public static <T> List<T> JSONArrayToList(JSONArray jsonArray, Class<T> clazz) {
        ArrayList<Object> targetList = new ArrayList<Object>();
        if (jsonArray == null) {
            return targetList;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object item = null;
            try {
                if (clazz == String.class) {
                    item = clazz.cast(jsonArray.getString(i));
                } else if (clazz == Integer.class) {
                    item = clazz.cast(jsonArray.getInt(i));
                } else if (clazz == Double.class) {
                    item = clazz.cast(jsonArray.getDouble(i));
                } else {
                    LiteavLog.e((String)TAG, (String)("JSONArrayToList, Unsupported type: " + clazz.getName()));
                }
            }
            catch (JSONException e) {
                LiteavLog.e((String)TAG, (String)("JSONArrayToList, error: " + (Object)((Object)e) + " jsonArray: " + jsonArray));
            }
            targetList.add(item);
        }
        return targetList;
    }

    public static <T> Map<String, T> JSONObjectToMap(JSONObject jsonObject, Class<T> clazz) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (jsonObject == null) {
            return resultMap;
        }
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = null;
            try {
                if (clazz == String.class) {
                    value = clazz.cast(jsonObject.getString(key));
                } else if (clazz == Integer.class) {
                    value = clazz.cast(jsonObject.getInt(key));
                } else if (clazz == Double.class) {
                    value = clazz.cast(jsonObject.getDouble(key));
                } else {
                    LiteavLog.e((String)TAG, (String)("JSONObjectToMap, Unsupported type: " + clazz.getName()));
                }
                resultMap.put(key, value);
            }
            catch (JSONException e) {
                LiteavLog.e((String)TAG, (String)("JSONObjectToMap, error: " + (Object)((Object)e) + " jsonObject: " + jsonObject));
            }
        }
        return resultMap;
    }

    public static JSONArray StringToJSONArray(String jsonString) {
        try {
            return new JSONArray(jsonString);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)("StringToJSONArray failed, error: " + (Object)((Object)e)));
            return null;
        }
    }
}

