/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.impl.room;

import android.text.TextUtils;
import com.tencent.cloud.tuikit.engine.impl.pipelinebridge.TUIPipelineBridgeObserver;
import com.tencent.cloud.tuikit.engine.room.TUIRoomObserver;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class TUIRoomObserverProxy
extends TUIPipelineBridgeObserver {
    private static final String TAG = "TUIRoomObserverProxy";
    private List<TUIRoomObserver> mObserverList = new CopyOnWriteArrayList<TUIRoomObserver>();
    private HashMap<String, String> mFunctionMap = new HashMap();

    public TUIRoomObserverProxy() {
        this.registerEventHandler();
    }

    public void destroy() {
        this.mObserverList.clear();
        this.mFunctionMap.clear();
    }

    public void addObserver(TUIRoomObserver observer) {
        if (observer != null && !this.mObserverList.contains(observer)) {
            this.mObserverList.add(observer);
        }
    }

    public void removeObserver(TUIRoomObserver observer) {
        if (observer != null && this.mObserverList.contains(observer)) {
            this.mObserverList.remove(observer);
        }
    }

    private List<TUIRoomObserver> copyOnReadListeners() {
        CopyOnWriteArrayList<TUIRoomObserver> listenerArray = new CopyOnWriteArrayList<TUIRoomObserver>(this.mObserverList);
        return listenerArray;
    }

    private void bindEventHandler(String eventName, String handlerName) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)handlerName)) {
            return;
        }
        this.mFunctionMap.put(eventName, handlerName);
    }

    @Override
    public void onReceiveEventFromPipeline(String eventName, String jsonData) {
        for (Map.Entry<String, String> entry : this.mFunctionMap.entrySet()) {
            if (!TextUtils.equals((CharSequence)entry.getKey(), (CharSequence)eventName)) continue;
            String handlerName = entry.getValue();
            try {
                Method method = TUIRoomObserverProxy.class.getMethod(handlerName, String.class);
                method.invoke((Object)this, jsonData);
            }
            catch (Exception e) {}
        }
    }

    private void registerEventHandler() {
    }

    public void onRoomNameChangedHandler(String jsonData) {
    }
}

