/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.impl.room;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.extension.TUIConferenceInvitationManager;
import com.tencent.cloud.tuikit.engine.extension.TUIConferenceListManager;
import com.tencent.cloud.tuikit.engine.extension.TUILiveBattleManager;
import com.tencent.cloud.tuikit.engine.extension.TUILiveConnectionManager;
import com.tencent.cloud.tuikit.engine.extension.TUILiveLayoutManager;
import com.tencent.cloud.tuikit.engine.extension.TUIRoomDeviceManager;
import com.tencent.cloud.tuikit.engine.extension.internal.TUIConferenceInvitationManagerImpl;
import com.tencent.cloud.tuikit.engine.extension.internal.TUIConferenceListManagerImpl;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveConnectionManagerImpl;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveLayoutManagerImpl;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveListManagerImpl;
import com.tencent.cloud.tuikit.engine.extension.internal.TUIRoomDeviceManagerImpl;
import com.tencent.cloud.tuikit.engine.impl.pipelinebridge.TUIPipelineBridge;
import com.tencent.cloud.tuikit.engine.impl.pipelinebridge.TUIPipelineBridgeDefine;
import com.tencent.cloud.tuikit.engine.impl.utils.PathUtils;
import com.tencent.cloud.tuikit.engine.impl.utils.SoLoader;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.cloud.tuikit.engine.room.TUIRoomObserver;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="tuikit::engine")
public class TUIRoomEngineJni {
    private static final String TAG = "TUIRoomEngineJni";
    private long mNativeTUIRoomEngineJni;
    private TUIPipelineBridge mPipelineBridge;
    private List<TUIRoomObserver> mObserverList = new CopyOnWriteArrayList<TUIRoomObserver>();
    private TUIRoomDeviceManager mDeviceManager;
    private TUILiveConnectionManager mLiveConnectionManager;
    private TUILiveBattleManager mLiveBattleManager;
    private TUILiveLayoutManager mLiveLayoutManager;
    private TUIConferenceInvitationManager mConferenceInvitationManager;
    private TUIConferenceListManager mConferenceListManager;
    private TUILiveListManagerImpl mLiveListManager;

    public TUIRoomEngineJni(boolean createBySharedInstance) {
        this.mPipelineBridge = new TUIPipelineBridge(TUIPipelineBridgeDefine.PipelineType.Room, createBySharedInstance);
        this.mNativeTUIRoomEngineJni = TUIRoomEngineJni.nativeCreatePipeline(this, createBySharedInstance, this.mPipelineBridge.getNativePipelineBridge());
    }

    public void destroy() {
        if (this.mNativeTUIRoomEngineJni != 0L) {
            ((TUILiveBattleManagerImpl)this.getLiveBattleManager()).destroy();
            ((TUILiveConnectionManagerImpl)this.getLiveConnectionManager()).destroy();
            ((TUILiveLayoutManagerImpl)this.getLiveLayoutManager()).destroy();
            TUIRoomEngineJni.nativeDestroyPipeline(this.mNativeTUIRoomEngineJni);
            this.mNativeTUIRoomEngineJni = 0L;
        }
        this.mObserverList.clear();
        this.mPipelineBridge.destroy();
    }

    public TUIPipelineBridge getPipelineBridge() {
        return this.mPipelineBridge;
    }

    public static long getJObjectAddress(Object object) {
        return TUIRoomEngineJni.nativeGetJObjectAddress(object);
    }

    public static void freeJObjectByAddress(long address) {
        TUIRoomEngineJni.nativeFreeJObjectByAddress(address);
    }

    public static void login(Context context, int sdkAppId, String userId, String userSig, TUIRoomDefine.ActionCallback callback) {
        String initPath = PathUtils.getSDKInitPath(context);
        String logPath = PathUtils.getSDKLogPath(context);
        TUIRoomEngineJni.nativeLogin(sdkAppId, userId, userSig, initPath, logPath, new ActionCallback(callback));
    }

    public static void logout(TUIRoomDefine.ActionCallback callback) {
        TUIRoomEngineJni.nativeLogout(new ActionCallback(callback));
    }

    public static void setSelfInfo(String userName, String avatarUrl, TUIRoomDefine.ActionCallback callback) {
        TUIRoomEngineJni.nativeSetSelfInfo(userName, avatarUrl, new ActionCallback(callback));
    }

    public static TUIRoomDefine.LoginUserInfo getSelfInfo() {
        return TUIRoomEngineJni.nativeGetSelfInfo();
    }

    public static void setLoginInfo(TUIRoomDefine.LoginUserInfo userInfo, TUIRoomDefine.ActionCallback callback) {
        TUIRoomEngineJni.nativeSetLoginInfo(new LoginUserInfo(userInfo), new ActionCallback(callback));
    }

    public static void callExperimentalAPI(String jsonStr) {
        TUIRoomEngineJni.nativeCallExperimentalAPI(jsonStr);
    }

    public void addObserver(TUIRoomObserver observer) {
        if (observer != null && !this.mObserverList.contains(observer)) {
            this.mObserverList.add(observer);
        }
    }

    public void removeObserver(TUIRoomObserver observer) {
        if (observer != null && this.mObserverList.contains(observer)) {
            this.mObserverList.remove(observer);
        }
    }

    public void createRoom(TUIRoomDefine.RoomInfo roomInfo, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeCreateRoom(this.mNativeTUIRoomEngineJni, new RoomInfo(roomInfo), new ActionCallback(callback));
    }

    public TRTCCloud getTRTCCloud() {
        if (!this.checkPipeline()) {
            return null;
        }
        return TUIRoomEngineJni.nativeGetTRTCCloud(this.mNativeTUIRoomEngineJni);
    }

    public void destroyRoom(TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeDestroyRoom(this.mNativeTUIRoomEngineJni, new ActionCallback(callback));
    }

    public void enterRoom(String roomId, TUIRoomDefine.RoomType roomType, TUIRoomDefine.EnterRoomOptions options, TUIRoomDefine.GetRoomInfoCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeEnterRoom(this.mNativeTUIRoomEngineJni, roomId, roomType.getValue(), new EnterRoomOptions(options), new GetRoomInfoCallback(callback));
    }

    public void exitRoom(boolean isSyncWaiting, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeExitRoom(this.mNativeTUIRoomEngineJni, isSyncWaiting, new ActionCallback(callback));
    }

    public void fetchRoomInfo(TUIRoomDefine.GetRoomInfoCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeFetchRoomInfo(this.mNativeTUIRoomEngineJni, new GetRoomInfoCallback(callback));
    }

    public void fetchRoomInfo(String roomId, TUIRoomDefine.RoomType roomType, TUIRoomDefine.GetRoomInfoCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeFetchRoomInfoById(this.mNativeTUIRoomEngineJni, roomId, roomType.getValue(), new GetRoomInfoCallback(callback));
    }

    public void updateRoomNameByAdmin(String roomName, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeUpdateRoomNameByAdmin(this.mNativeTUIRoomEngineJni, roomName, new ActionCallback(callback));
    }

    public void updateRoomSeatModeByAdmin(TUIRoomDefine.SeatMode SeatMode2, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeUpdateRoomSeatModeByAdmin(this.mNativeTUIRoomEngineJni, SeatMode2.getValue(), new ActionCallback(callback));
    }

    public void updateRoomPasswordByAdmin(String password, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeUpdateRoomPasswordByAdmin(this.mNativeTUIRoomEngineJni, password, new ActionCallback(callback));
    }

    public void getRoomMetadata(List<String> keys, TUIRoomDefine.GetRoomMetadataCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        if (keys == null) {
            keys = new ArrayList<String>();
        }
        TUIRoomEngineJni.nativeGetRoomMetadata(this.mNativeTUIRoomEngineJni, keys.toArray(new String[0]), new GetRoomMetadataCallback(callback));
    }

    public void setRoomMetadataByAdmin(HashMap<String, String> metadata, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(metadata);
            TUIRoomEngineJni.nativeSetRoomMetadataByAdmin(this.mNativeTUIRoomEngineJni, jsonObject.toString(), new ActionCallback(callback));
        }
        catch (NullPointerException e) {
            LiteavLog.e((String)TAG, (String)"setRoomMetadataByAdmin error:");
            callback.onError(TUICommonDefine.Error.FAILED, "the requested key cannot be empty");
        }
    }

    public void setLocalVideoView(TUIRoomDefine.VideoStreamType streamType, TXCloudVideoView view) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeSetLocalVideoViewDeprecated(this.mNativeTUIRoomEngineJni, streamType.getValue(), view);
    }

    public void setLocalVideoView(TXCloudVideoView view) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeSetLocalVideoView(this.mNativeTUIRoomEngineJni, view);
    }

    public void openLocalCamera(int cameraId, TUIRoomDefine.VideoQuality videoQuality, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeOpenLocalCamera(this.mNativeTUIRoomEngineJni, cameraId, videoQuality.getValue(), new ActionCallback(callback));
    }

    public void closeLocalCamera() {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeCloseLocalCamera(this.mNativeTUIRoomEngineJni);
    }

    public void updateVideoQuality(TUIRoomDefine.VideoQuality videoQuality) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeUpdateVideoQuality(this.mNativeTUIRoomEngineJni, videoQuality.getValue());
    }

    public void updateVideoQualityEx(TUIRoomDefine.VideoStreamType streamType, TUIRoomDefine.RoomVideoEncoderParams params) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeUpdateVideoQualityEx(this.mNativeTUIRoomEngineJni, streamType.getValue(), new VideoEncoderParams(params));
    }

    public void setVideoResolutionMode(TUIRoomDefine.VideoStreamType streamType, TUIRoomDefine.ResolutionMode resolutionMode) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeSetVideoResolutionMode(this.mNativeTUIRoomEngineJni, streamType.getValue(), resolutionMode.getValue());
    }

    public void enableGravitySensor(boolean enable) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeEnableGravitySensor(this.mNativeTUIRoomEngineJni, enable);
    }

    public void openLocalMicrophone(TUIRoomDefine.AudioQuality audioQuality, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeOpenLocalMicrophone(this.mNativeTUIRoomEngineJni, audioQuality.getValue(), new ActionCallback(callback));
    }

    public void closeLocalMicrophone() {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeCloseLocalMicrophone(this.mNativeTUIRoomEngineJni);
    }

    public void updateAudioQuality(TUIRoomDefine.AudioQuality audioQuality) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeUpdateAudioQuality(this.mNativeTUIRoomEngineJni, audioQuality.getValue());
    }

    public void startScreenSharing() {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeStartScreenSharing(this.mNativeTUIRoomEngineJni);
    }

    public void stopScreenSharing() {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeStopScreenSharing(this.mNativeTUIRoomEngineJni);
    }

    public void startPushLocalVideo() {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeStartPushLocalVideo(this.mNativeTUIRoomEngineJni);
    }

    public void stopPushLocalVideo() {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeStopPushLocalVideo(this.mNativeTUIRoomEngineJni);
    }

    public void muteLocalAudio() {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeMuteLocalAudio(this.mNativeTUIRoomEngineJni);
    }

    public void unmuteLocalAudio(TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeUnmuteLocalAudio(this.mNativeTUIRoomEngineJni, new ActionCallback(callback));
    }

    public void enableSystemAudioSharing(boolean enable) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeEnableSystemAudioSharing(this.mNativeTUIRoomEngineJni, enable);
    }

    public void setRemoteVideoView(String userId, TUIRoomDefine.VideoStreamType streamType, TXCloudVideoView view) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeSetRemoteVideoView(this.mNativeTUIRoomEngineJni, userId, streamType.getValue(), view);
    }

    public void startPlayRemoteVideo(String userId, TUIRoomDefine.VideoStreamType streamType, TUIRoomDefine.PlayCallback callback) {
        if (!this.checkPipeline(userId, callback)) {
            return;
        }
        TUIRoomEngineJni.nativeStartPlayRemoteVideo(this.mNativeTUIRoomEngineJni, userId, streamType.getValue(), new PlayCallback(callback));
    }

    public void stopPlayRemoteVideo(String userId, TUIRoomDefine.VideoStreamType streamType) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeStopPlayRemoteVideo(this.mNativeTUIRoomEngineJni, userId, streamType.getValue());
    }

    public void muteRemoteAudioStream(String userId, boolean isMute) {
        if (!this.checkPipeline()) {
            return;
        }
        TUIRoomEngineJni.nativeMuteRemoteAudioStream(this.mNativeTUIRoomEngineJni, userId, isMute);
    }

    public void setCustomInfoForUser(String userId, HashMap<String, byte[]> customInfo, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeSetCustomInfoForUser(this.mNativeTUIRoomEngineJni, userId, customInfo, new ActionCallback(callback));
    }

    public void getUserList(long nextSequence, TUIRoomDefine.GetUserListCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeGetUserList(this.mNativeTUIRoomEngineJni, nextSequence, new GetUserListJniCallback(callback));
    }

    public void getUserInfo(String userId, TUIRoomDefine.GetUserInfoCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeGetUserInfo(this.mNativeTUIRoomEngineJni, userId, new GetUserInfoCallback(callback));
    }

    public void changeUserRole(String userId, TUIRoomDefine.Role role, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeChangeUserRole(this.mNativeTUIRoomEngineJni, userId, role.getValue(), new ActionCallback(callback));
    }

    public void changeUserNameCard(String userId, String nameCard, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeChangeUserNameCard(this.mNativeTUIRoomEngineJni, userId, nameCard, new ActionCallback(callback));
    }

    public void kickRemoteUserOutOfRoom(String userId, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeKickRemoteUserOutOfRoom(this.mNativeTUIRoomEngineJni, userId, new ActionCallback(callback));
    }

    public void addCategoryTagForUsers(int tag, List<String> userList, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        String[] userArray = userList.toArray(new String[userList.size()]);
        TUIRoomEngineJni.nativeAddCategoryTagForUsers(this.mNativeTUIRoomEngineJni, tag, userArray, new ActionCallback(callback));
    }

    public void removeCategoryTagForUsers(int tag, List<String> userList, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        String[] userArray = userList.toArray(new String[userList.size()]);
        TUIRoomEngineJni.nativeRemoveCategoryTagForUsers(this.mNativeTUIRoomEngineJni, tag, userArray, new ActionCallback(callback));
    }

    public void getUserListByTag(int tag, long nextSequence, TUIRoomDefine.GetUserListCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeGetUserListByTag(this.mNativeTUIRoomEngineJni, tag, nextSequence, new GetUserListJniCallback(callback));
    }

    public void disableDeviceForAllUserByAdmin(boolean disable, TUIRoomDefine.MediaDevice mediaDevice, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeDisableDeviceForAllUserByAdmin(this.mNativeTUIRoomEngineJni, disable, mediaDevice.getValue(), new ActionCallback(callback));
    }

    public void closeRemoteDeviceByAdmin(String userId, TUIRoomDefine.MediaDevice mediaDevice, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeCloseRemoteDeviceByAdmin(this.mNativeTUIRoomEngineJni, userId, mediaDevice.getValue(), new ActionCallback(callback));
    }

    public TUIRoomDefine.Request openRemoteDeviceByAdmin(String userId, TUIRoomDefine.MediaDevice mediaDevice, int timeout, TUIRoomDefine.RequestCallback callback) {
        if (!this.checkPipeline(callback)) {
            return new TUIRoomDefine.Request();
        }
        return TUIRoomEngineJni.nativeOpenRemoteDeviceByAdmin(this.mNativeTUIRoomEngineJni, userId, mediaDevice.getValue(), timeout, new RequestCallback(callback));
    }

    public TUIRoomDefine.Request applyToAdminToOpenLocalDevice(TUIRoomDefine.MediaDevice mediaDevice, int timeout, TUIRoomDefine.RequestCallback callback) {
        if (!this.checkPipeline(callback)) {
            return new TUIRoomDefine.Request();
        }
        return TUIRoomEngineJni.nativeApplyToAdminToOpenLocalDevice(this.mNativeTUIRoomEngineJni, mediaDevice.getValue(), timeout, new RequestCallback(callback));
    }

    public void getSeatList(TUIRoomDefine.GetSeatListCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeGetSeatList(this.mNativeTUIRoomEngineJni, new GetSeatListJniCallback(callback));
    }

    public void getSeatApplicationList(TUIRoomDefine.RequestListCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeGetSeatApplicationList(this.mNativeTUIRoomEngineJni, new RequestListCallback(callback));
    }

    public TUIRoomDefine.Request takeSeat(int seatIndex, int timeout, TUIRoomDefine.RequestCallback callback) {
        if (!this.checkPipeline(callback)) {
            return new TUIRoomDefine.Request();
        }
        return TUIRoomEngineJni.nativeTakeSeat(this.mNativeTUIRoomEngineJni, seatIndex, timeout, new RequestCallback(callback));
    }

    public void leaveSeat(TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeLeaveSeat(this.mNativeTUIRoomEngineJni, new ActionCallback(callback));
    }

    public void moveToSeat(int targetSeatIndex, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeMoveToSeat(this.mNativeTUIRoomEngineJni, targetSeatIndex, new ActionCallback(callback));
    }

    public void lockSeatByAdmin(int seatIndex, TUIRoomDefine.SeatLockParams lockParams, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeLockSeatByAdmin(this.mNativeTUIRoomEngineJni, seatIndex, new SeatLockParams(lockParams), new ActionCallback(callback));
    }

    public TUIRoomDefine.Request takeUserOnSeatByAdmin(int seatIndex, String userId, int timeout, TUIRoomDefine.RequestCallback callback) {
        if (!this.checkPipeline(callback)) {
            return new TUIRoomDefine.Request();
        }
        return TUIRoomEngineJni.nativeTakeUserOnSeatByAdmin(this.mNativeTUIRoomEngineJni, seatIndex, userId, timeout, new RequestCallback(callback));
    }

    public void kickUserOffSeatByAdmin(int seatIndex, String userId, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeKickUserOffSeatByAdmin(this.mNativeTUIRoomEngineJni, seatIndex, userId, new ActionCallback(callback));
    }

    public void cancelRequest(String requestId, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeCancelRequest(this.mNativeTUIRoomEngineJni, requestId, new ActionCallback(callback));
    }

    public void responseRemoteRequest(String requestId, boolean agree, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeResponseRemoteRequest(this.mNativeTUIRoomEngineJni, requestId, agree, new ActionCallback(callback));
    }

    public void disableSendingMessageByAdmin(boolean disable, String userId, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeDisableSendingMessageByAdmin(this.mNativeTUIRoomEngineJni, disable, userId, new ActionCallback(callback));
    }

    public void disableSendingMessageForAllUser(boolean disable, TUIRoomDefine.ActionCallback callback) {
        if (!this.checkPipeline(callback)) {
            return;
        }
        TUIRoomEngineJni.nativeDisableSendingMessageForAllUser(this.mNativeTUIRoomEngineJni, disable, new ActionCallback(callback));
    }

    public TUIRoomDeviceManager getMediaDeviceManager() {
        if (this.mDeviceManager == null) {
            this.mDeviceManager = new TUIRoomDeviceManagerImpl(TUIRoomEngineJni.nativeGetMediaDeviceManager(this.mNativeTUIRoomEngineJni));
        }
        return this.mDeviceManager;
    }

    public TUILiveConnectionManager getLiveConnectionManager() {
        if (this.mLiveConnectionManager == null) {
            this.mLiveConnectionManager = new TUILiveConnectionManagerImpl(TUIRoomEngineJni.nativeGetLiveConnectionManager(this.mNativeTUIRoomEngineJni));
        }
        return this.mLiveConnectionManager;
    }

    public TUILiveBattleManager getLiveBattleManager() {
        if (this.mLiveBattleManager == null) {
            this.mLiveBattleManager = new TUILiveBattleManagerImpl(TUIRoomEngineJni.nativeGetLiveBattleManager(this.mNativeTUIRoomEngineJni));
        }
        return this.mLiveBattleManager;
    }

    public TUILiveLayoutManager getLiveLayoutManager() {
        if (this.mLiveLayoutManager == null) {
            this.mLiveLayoutManager = new TUILiveLayoutManagerImpl(TUIRoomEngineJni.nativeGetLiveLayoutManager(this.mNativeTUIRoomEngineJni));
        }
        return this.mLiveLayoutManager;
    }

    public TUILiveListManagerImpl getLiveListManager() {
        if (this.mLiveListManager == null) {
            this.mLiveListManager = new TUILiveListManagerImpl(this, TUIRoomEngineJni.nativeGetLiveListManager(this.mNativeTUIRoomEngineJni));
        }
        return this.mLiveListManager;
    }

    public TUIConferenceInvitationManager getConferenceInvitationManager() {
        if (this.mConferenceInvitationManager == null) {
            this.mConferenceInvitationManager = new TUIConferenceInvitationManagerImpl(TUIRoomEngineJni.nativeGetConferenceInvitationManager(this.mNativeTUIRoomEngineJni));
        }
        return this.mConferenceInvitationManager;
    }

    public TUIConferenceListManager getConferenceListManager() {
        if (this.mConferenceListManager == null) {
            this.mConferenceListManager = new TUIConferenceListManagerImpl(TUIRoomEngineJni.nativeGetConferenceListManager(this.mNativeTUIRoomEngineJni));
        }
        return this.mConferenceListManager;
    }

    private static native long nativeGetExtension(long var0, int var2);

    private static native long nativeGetMediaDeviceManager(long var0);

    private static native long nativeGetLiveConnectionManager(long var0);

    private static native long nativeGetLiveBattleManager(long var0);

    private static native long nativeGetLiveLayoutManager(long var0);

    private static native long nativeGetLiveListManager(long var0);

    private static native long nativeGetConferenceInvitationManager(long var0);

    private static native long nativeGetConferenceListManager(long var0);

    private static native long nativeCreatePipeline(TUIRoomEngineJni var0, boolean var1, long var2);

    private static native void nativeDestroyPipeline(long var0);

    private static native long nativeGetJObjectAddress(Object var0);

    private static native void nativeFreeJObjectByAddress(long var0);

    private static native void nativeLogin(int var0, String var1, String var2, String var3, String var4, ActionCallback var5);

    private static native void nativeLogout(ActionCallback var0);

    private static native void nativeSetSelfInfo(String var0, String var1, ActionCallback var2);

    private static native TUIRoomDefine.LoginUserInfo nativeGetSelfInfo();

    private static native void nativeSetLoginInfo(LoginUserInfo var0, ActionCallback var1);

    private static native void nativeCreateRoom(long var0, RoomInfo var2, ActionCallback var3);

    private static native TRTCCloud nativeGetTRTCCloud(long var0);

    private static native void nativeDestroyRoom(long var0, ActionCallback var2);

    private static native void nativeEnterRoom(long var0, String var2, int var3, EnterRoomOptions var4, GetRoomInfoCallback var5);

    private static native void nativeExitRoom(long var0, boolean var2, ActionCallback var3);

    private static native void nativeFetchRoomInfo(long var0, GetRoomInfoCallback var2);

    private static native void nativeFetchRoomInfoById(long var0, String var2, int var3, GetRoomInfoCallback var4);

    private static native void nativeUpdateRoomNameByAdmin(long var0, String var2, ActionCallback var3);

    private static native void nativeUpdateRoomSeatModeByAdmin(long var0, int var2, ActionCallback var3);

    private static native void nativeUpdateRoomPasswordByAdmin(long var0, String var2, ActionCallback var3);

    private static native void nativeGetRoomMetadata(long var0, String[] var2, GetRoomMetadataCallback var3);

    private static native void nativeSetRoomMetadataByAdmin(long var0, String var2, ActionCallback var3);

    private static native void nativeSetLocalVideoViewDeprecated(long var0, int var2, TXCloudVideoView var3);

    private static native void nativeSetLocalVideoView(long var0, TXCloudVideoView var2);

    private static native void nativeSetRemoteVideoView(long var0, String var2, int var3, TXCloudVideoView var4);

    private static native void nativeOpenLocalCamera(long var0, int var2, int var3, ActionCallback var4);

    private static native void nativeCloseLocalCamera(long var0);

    private static native void nativeUpdateVideoQuality(long var0, int var2);

    private static native void nativeUpdateVideoQualityEx(long var0, int var2, VideoEncoderParams var3);

    private static native void nativeSetVideoResolutionMode(long var0, int var2, int var3);

    private static native void nativeEnableGravitySensor(long var0, boolean var2);

    private static native void nativeOpenLocalMicrophone(long var0, int var2, ActionCallback var3);

    private static native void nativeCloseLocalMicrophone(long var0);

    private static native void nativeUpdateAudioQuality(long var0, int var2);

    private static native void nativeStartScreenSharing(long var0);

    private static native void nativeStopScreenSharing(long var0);

    private static native void nativeStartPushLocalVideo(long var0);

    private static native void nativeStopPushLocalVideo(long var0);

    private static native void nativeMuteLocalAudio(long var0);

    private static native void nativeUnmuteLocalAudio(long var0, ActionCallback var2);

    private static native void nativeStartPlayRemoteVideo(long var0, String var2, int var3, PlayCallback var4);

    private static native void nativeStopPlayRemoteVideo(long var0, String var2, int var3);

    private static native void nativeMuteRemoteAudioStream(long var0, String var2, boolean var3);

    private static native void nativeEnableSystemAudioSharing(long var0, boolean var2);

    private static native void nativeSetCustomInfoForUser(long var0, String var2, HashMap<String, byte[]> var3, ActionCallback var4);

    private static native void nativeGetUserList(long var0, long var2, GetUserListJniCallback var4);

    private static native void nativeGetUserInfo(long var0, String var2, GetUserInfoCallback var3);

    private static native void nativeChangeUserNameCard(long var0, String var2, String var3, ActionCallback var4);

    private static native void nativeChangeUserRole(long var0, String var2, int var3, ActionCallback var4);

    private static native void nativeKickRemoteUserOutOfRoom(long var0, String var2, ActionCallback var3);

    private static native void nativeAddCategoryTagForUsers(long var0, int var2, String[] var3, ActionCallback var4);

    private static native void nativeRemoveCategoryTagForUsers(long var0, int var2, String[] var3, ActionCallback var4);

    private static native void nativeGetUserListByTag(long var0, int var2, long var3, GetUserListJniCallback var5);

    private static native void nativeDisableDeviceForAllUserByAdmin(long var0, boolean var2, int var3, ActionCallback var4);

    private static native void nativeCloseRemoteDeviceByAdmin(long var0, String var2, int var3, ActionCallback var4);

    private static native TUIRoomDefine.Request nativeOpenRemoteDeviceByAdmin(long var0, String var2, int var3, int var4, RequestCallback var5);

    private static native TUIRoomDefine.Request nativeApplyToAdminToOpenLocalDevice(long var0, int var2, int var3, RequestCallback var4);

    private static native void nativeGetSeatList(long var0, GetSeatListJniCallback var2);

    private static native void nativeGetSeatApplicationList(long var0, RequestListCallback var2);

    private static native void nativeLockSeatByAdmin(long var0, int var2, SeatLockParams var3, ActionCallback var4);

    private static native TUIRoomDefine.Request nativeTakeSeat(long var0, int var2, int var3, RequestCallback var4);

    private static native void nativeLeaveSeat(long var0, ActionCallback var2);

    private static native void nativeMoveToSeat(long var0, int var2, ActionCallback var3);

    public static native TUIRoomDefine.Request nativeTakeUserOnSeatByAdmin(long var0, int var2, String var3, int var4, RequestCallback var5);

    public static native void nativeKickUserOffSeatByAdmin(long var0, int var2, String var3, ActionCallback var4);

    private static native void nativeCancelRequest(long var0, String var2, ActionCallback var3);

    private static native void nativeResponseRemoteRequest(long var0, String var2, boolean var3, ActionCallback var4);

    private static native void nativeDisableSendingMessageByAdmin(long var0, boolean var2, String var3, ActionCallback var4);

    private static native void nativeDisableSendingMessageForAllUser(long var0, boolean var2, ActionCallback var3);

    private static native void nativeCallExperimentalAPI(String var0);

    @CalledByNative
    void onError(int errorCode, String message) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onError(TUICommonDefine.Error.fromInt(errorCode), message);
        }
    }

    @CalledByNative
    void onKickedOutOfRoom(String roomId, TUIRoomDefine.KickedOutOfRoomReason reason, String message) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onKickedOutOfRoom(roomId, reason, message);
        }
    }

    @CalledByNative
    void onKickedOffLine(String message) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onKickedOffLine(message);
        }
    }

    @CalledByNative
    void onUserSigExpired() {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onUserSigExpired();
        }
    }

    @CalledByNative
    void onRoomDismissed(String roomId, int reason) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRoomDismissed(roomId, TUIRoomDefine.RoomDismissedReason.fromInt(reason));
        }
    }

    @CalledByNative
    void onRoomNameChanged(String roomId, String roomName) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRoomNameChanged(roomId, roomName);
        }
    }

    @CalledByNative
    void onRoomMetadataChanged(String key, String value) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRoomMetadataChanged(key, value);
        }
    }

    @CalledByNative
    void onAllUserMicrophoneDisableChanged(String roomId, boolean isDisable) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onAllUserMicrophoneDisableChanged(roomId, isDisable);
        }
    }

    @CalledByNative
    void onAllUserCameraDisableChanged(String roomId, boolean isDisable) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onAllUserCameraDisableChanged(roomId, isDisable);
        }
    }

    @CalledByNative
    void onScreenShareForAllUserDisableChanged(String roomId, boolean isDisable) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onScreenShareForAllUserDisableChanged(roomId, isDisable);
        }
    }

    @CalledByNative
    void onSendMessageForAllUserDisableChanged(String roomId, boolean isDisable) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onSendMessageForAllUserDisableChanged(roomId, isDisable);
        }
    }

    @CalledByNative
    void onRoomSeatModeChanged(String roomId, TUIRoomDefine.SeatMode seatMode) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRoomSeatModeChanged(roomId, seatMode);
        }
    }

    @CalledByNative
    void onRoomUserCountChanged(String roomId, int userCount) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRoomUserCountChanged(roomId, userCount);
        }
    }

    @CalledByNative
    void onRemoteUserEnterRoom(String roomId, TUIRoomDefine.UserInfo userInfo) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRemoteUserEnterRoom(roomId, userInfo);
        }
    }

    @CalledByNative
    void onRemoteUserLeaveRoom(String roomId, TUIRoomDefine.UserInfo userInfo) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRemoteUserLeaveRoom(roomId, userInfo);
        }
    }

    @CalledByNative
    void onUserInfoChanged(TUIRoomDefine.UserInfo userInfo, int modifyFlag) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            ArrayList<TUIRoomDefine.UserInfoModifyFlag> modifyFlagList = new ArrayList<TUIRoomDefine.UserInfoModifyFlag>();
            if ((modifyFlag & TUIRoomDefine.UserInfoModifyFlag.USER_ROLE.getValue()) != 0) {
                modifyFlagList.add(TUIRoomDefine.UserInfoModifyFlag.USER_ROLE);
            }
            if ((modifyFlag & TUIRoomDefine.UserInfoModifyFlag.NAME_CARD.getValue()) != 0) {
                modifyFlagList.add(TUIRoomDefine.UserInfoModifyFlag.NAME_CARD);
            }
            observer.onUserInfoChanged(userInfo, modifyFlagList);
        }
    }

    @CalledByNative
    void onUserVideoStateChanged(String userId, TUIRoomDefine.VideoStreamType streamType, boolean hasVideo, TUIRoomDefine.ChangeReason reason) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onUserVideoStateChanged(userId, streamType, hasVideo, reason);
        }
    }

    @CalledByNative
    void onUserAudioStateChanged(String useId, boolean hasAudio, TUIRoomDefine.ChangeReason reason) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onUserAudioStateChanged(useId, hasAudio, reason);
        }
    }

    @CalledByNative
    void onUserVoiceVolumeChanged(Map<String, Integer> volumeMap) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onUserVoiceVolumeChanged(volumeMap);
        }
    }

    @CalledByNative
    void onSendMessageForUserDisableChanged(String roomId, String userId, boolean isDisable) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onSendMessageForUserDisableChanged(roomId, userId, isDisable);
        }
    }

    @CalledByNative
    void onUserNetworkQualityChanged(Map<String, TUICommonDefine.NetworkInfo> networkMap) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onUserNetworkQualityChanged(networkMap);
        }
    }

    @CalledByNative
    void onUserScreenCaptureStopped(int reason) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onUserScreenCaptureStopped(reason);
        }
    }

    @CalledByNative
    void onSeatListChanged(List<TUIRoomDefine.SeatInfo> seatList, List<TUIRoomDefine.SeatInfo> userSeatedList, List<TUIRoomDefine.SeatInfo> userLeftList) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onSeatListChanged(seatList, userSeatedList, userLeftList);
        }
    }

    @CalledByNative
    void onRequestReceived(TUIRoomDefine.Request request) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRequestReceived(request);
        }
    }

    @CalledByNative
    void onRequestCancelled(TUIRoomDefine.Request request, TUIRoomDefine.UserInfo userInfo) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRequestCancelled(request, userInfo);
        }
    }

    @CalledByNative
    void onRequestProcessed(TUIRoomDefine.Request request, TUIRoomDefine.UserInfo userInfo) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onRequestProcessed(request, userInfo);
        }
    }

    @CalledByNative
    void onKickedOffSeat(int seatIndex, TUIRoomDefine.UserInfo operateUser) {
        for (TUIRoomObserver observer : this.copyOnReadListeners()) {
            observer.onKickedOffSeat(seatIndex, operateUser);
        }
    }

    @CalledByNative
    public static TUIRoomDefine.RoomInfo createRoomInfo(String ownerId, String ownerName, String ownerAvatarUrl, long createTime, int memberCount, String roomId, int roomType, String name, boolean isCameraDisableForAllUser, boolean isMicrophoneDisableForAllUser, boolean isScreenShareDisableForAllUser, boolean isMessageDisableForAllUser, boolean isSeatEnabled, int seatMode, int maxSeatCount, String password) {
        TUIRoomDefine.RoomInfo roomInfo = new TUIRoomDefine.RoomInfo();
        roomInfo.roomId = roomId;
        roomInfo.roomType = TUIRoomDefine.RoomType.fromInt(roomType);
        roomInfo.name = name;
        roomInfo.isCameraDisableForAllUser = isCameraDisableForAllUser;
        roomInfo.isMicrophoneDisableForAllUser = isMicrophoneDisableForAllUser;
        roomInfo.isScreenShareDisableForAllUser = isScreenShareDisableForAllUser;
        roomInfo.isMessageDisableForAllUser = isMessageDisableForAllUser;
        roomInfo.isSeatEnabled = isSeatEnabled;
        roomInfo.seatMode = TUIRoomDefine.SeatMode.fromInt(seatMode);
        roomInfo.maxSeatCount = maxSeatCount;
        roomInfo.ownerId = ownerId;
        roomInfo.ownerName = ownerName;
        roomInfo.ownerAvatarUrl = ownerAvatarUrl;
        roomInfo.memberCount = memberCount;
        roomInfo.createTime = createTime;
        roomInfo.password = password;
        return roomInfo;
    }

    @CalledByNative
    TUIRoomDefine.SeatMode createSeatMode(int seatMode) {
        return TUIRoomDefine.SeatMode.fromInt(seatMode);
    }

    @CalledByNative
    TUIRoomDefine.VideoStreamType createVideoStreamType(int streamType) {
        return TUIRoomDefine.VideoStreamType.fromInt(streamType);
    }

    @CalledByNative
    TUIRoomDefine.ChangeReason createChangeReason(int reason) {
        return TUIRoomDefine.ChangeReason.fromInt(reason);
    }

    @CalledByNative
    TUIRoomDefine.KickedOutOfRoomReason createKickedOutOfRoomReason(int reason) {
        return TUIRoomDefine.KickedOutOfRoomReason.fromInt(reason);
    }

    @CalledByNative
    public static HashMap createVolumeMap(String[] keyArray, int[] values) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < keyArray.length; ++i) {
            map.put(keyArray[i], values[i]);
        }
        return map;
    }

    @CalledByNative
    public static HashMap createNetWorkMap(String[] keyArray, String[] userIdArray, int[] qualityArray, int[] upLossArray, int[] downLossArray, int[] delayArray) {
        HashMap<String, TUICommonDefine.NetworkInfo> map = new HashMap<String, TUICommonDefine.NetworkInfo>();
        for (int i = 0; i < keyArray.length; ++i) {
            TUICommonDefine.NetworkInfo network = new TUICommonDefine.NetworkInfo();
            network.userId = userIdArray[i];
            network.quality = TUICommonDefine.NetworkQuality.fromInt(qualityArray[i]);
            network.upLoss = upLossArray[i];
            network.downLoss = downLossArray[i];
            network.delay = delayArray[i];
            map.put(keyArray[i], network);
        }
        return map;
    }

    @CalledByNative
    public static ArrayList createSeatInfoList(int[] indexArray, String[] userIdArray, String[] userNameArray, String[] nameCardArray, String[] avatarUrlArray, boolean[] lockedArray, boolean[] videoMutedArray, boolean[] audioMutedArray) {
        ArrayList<TUIRoomDefine.SeatInfo> list = new ArrayList<TUIRoomDefine.SeatInfo>();
        for (int i = 0; i < indexArray.length; ++i) {
            TUIRoomDefine.SeatInfo seatInfo = new TUIRoomDefine.SeatInfo();
            seatInfo.index = indexArray[i];
            seatInfo.userId = userIdArray[i];
            seatInfo.userName = userNameArray[i];
            seatInfo.nameCard = nameCardArray[i];
            seatInfo.avatarUrl = avatarUrlArray[i];
            seatInfo.isLocked = lockedArray[i];
            seatInfo.isVideoLocked = videoMutedArray[i];
            seatInfo.isAudioLocked = audioMutedArray[i];
            list.add(seatInfo);
        }
        return list;
    }

    @CalledByNative
    public static ArrayList createRequestList(int[] requestActionArray, int[] timestampArray, String[] requestIdArray, String[] userIdArray, String[] userNameArray, String[] avatarUrlArray, String[] contentArray) {
        ArrayList<TUIRoomDefine.Request> list = new ArrayList<TUIRoomDefine.Request>();
        for (int i = 0; i < requestActionArray.length; ++i) {
            TUIRoomDefine.Request request = new TUIRoomDefine.Request();
            request.requestAction = TUIRoomDefine.RequestAction.fromInt(requestActionArray[i]);
            request.timestamp = timestampArray[i];
            request.requestId = requestIdArray[i];
            request.userId = userIdArray[i];
            request.userName = userNameArray[i];
            request.avatarUrl = avatarUrlArray[i];
            request.content = contentArray[i];
            list.add(request);
        }
        return list;
    }

    @CalledByNative
    public static void insertUserInfo(ArrayList<TUIRoomDefine.UserInfo> list, TUIRoomDefine.UserInfo userInfo) {
        list.add(userInfo);
    }

    @CalledByNative
    public static ArrayList<TUIRoomDefine.UserInfo> createUserInfoList() {
        ArrayList<TUIRoomDefine.UserInfo> list = new ArrayList<TUIRoomDefine.UserInfo>();
        return list;
    }

    @CalledByNative
    public static HashMap createCustomInfo() {
        HashMap map = new HashMap();
        return map;
    }

    @CalledByNative
    public static void insertCustomInfo(HashMap<String, byte[]> map, String key, byte[] value) {
        map.put(key, value);
    }

    @CalledByNative
    public static String[] getMapKeys(Map<String, byte[]> map) {
        String[] keys = new String[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            keys[i++] = key;
        }
        return keys;
    }

    @CalledByNative
    public static byte[] getMapValue(HashMap<String, byte[]> map, String key) {
        return map.get(key);
    }

    private List<TUIRoomObserver> copyOnReadListeners() {
        CopyOnWriteArrayList<TUIRoomObserver> listenerArray = new CopyOnWriteArrayList<TUIRoomObserver>(this.mObserverList);
        return listenerArray;
    }

    private boolean checkPipeline() {
        return this.mNativeTUIRoomEngineJni != 0L;
    }

    private boolean checkPipeline(TUIRoomDefine.ActionCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(TUIRoomDefine.GetRoomInfoCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(TUIRoomDefine.GetRoomMetadataCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(TUIRoomDefine.RequestListCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(TUIRoomDefine.GetUserInfoCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(TUIRoomDefine.GetUserListCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(TUIRoomDefine.GetSeatListCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(TUIRoomDefine.RequestCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onError("", "", TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private boolean checkPipeline(String userId, TUIRoomDefine.PlayCallback callback) {
        if (this.mNativeTUIRoomEngineJni == 0L) {
            if (callback != null) {
                callback.onPlayError(userId, TUICommonDefine.Error.FAILED, "roomEngine is destroyed");
            }
            return false;
        }
        return true;
    }

    private static HashMap<String, String> jsonStringToMap(String jsonString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return map;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)jsonObject.get(key);
                map.put(key, value);
            }
        }
        catch (JSONException jsonException) {
            LiteavLog.e((String)TAG, (String)("jsonStringToMap error:" + jsonException.getMessage()));
        }
        return map;
    }

    static {
        SoLoader.loadAllLibraries();
    }

    static class PlayCallback {
        private TUIRoomDefine.PlayCallback mCallback;

        public PlayCallback(TUIRoomDefine.PlayCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="PlayCallback")
        void onPlaying(String userId) {
            if (this.mCallback != null) {
                this.mCallback.onPlaying(userId);
            }
        }

        @CalledByNative(value="PlayCallback")
        void onLoading(String userId) {
            if (this.mCallback != null) {
                this.mCallback.onLoading(userId);
            }
        }

        @CalledByNative(value="PlayCallback")
        void onPlayError(String userId, int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onPlayError(userId, TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class RequestCallback {
        private TUIRoomDefine.RequestCallback mCallback;

        public RequestCallback(TUIRoomDefine.RequestCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="RequestCallback")
        void onAccepted(String requestId, String userId) {
            if (this.mCallback != null) {
                this.mCallback.onAccepted(requestId, userId);
            }
        }

        @CalledByNative(value="RequestCallback")
        void onRejected(String requestId, String userId, String message) {
            if (this.mCallback != null) {
                this.mCallback.onRejected(requestId, userId, message);
            }
        }

        @CalledByNative(value="RequestCallback")
        void onTimeout(String requestId, String userId) {
            if (this.mCallback != null) {
                this.mCallback.onTimeout(requestId, userId);
            }
        }

        @CalledByNative(value="RequestCallback")
        void onCancelled(String requestId, String userId) {
            if (this.mCallback != null) {
                this.mCallback.onCancelled(requestId, userId);
            }
        }

        @CalledByNative(value="RequestCallback")
        void onError(String requestId, String userId, int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(requestId, userId, TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class RequestListCallback {
        private TUIRoomDefine.RequestListCallback mCallback;

        public RequestListCallback(TUIRoomDefine.RequestListCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="RequestListCallback")
        public void onSuccess(List<TUIRoomDefine.Request> list) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(list);
            }
        }

        @CalledByNative(value="RequestListCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class GetSeatListJniCallback {
        private TUIRoomDefine.GetSeatListCallback mCallback;

        public GetSeatListJniCallback(TUIRoomDefine.GetSeatListCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="GetSeatListJniCallback")
        public void onSuccess(List<TUIRoomDefine.SeatInfo> list) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(list);
            }
        }

        @CalledByNative(value="GetSeatListJniCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class GetUserListJniCallback {
        private TUIRoomDefine.GetUserListCallback mCallback;

        public GetUserListJniCallback(TUIRoomDefine.GetUserListCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="GetUserListJniCallback")
        public void onSuccess(TUIRoomDefine.UserListResult result) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(result);
            }
        }

        @CalledByNative(value="GetUserListJniCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class GetUserInfoCallback {
        private TUIRoomDefine.GetUserInfoCallback mCallback;

        public GetUserInfoCallback(TUIRoomDefine.GetUserInfoCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="GetUserInfoCallback")
        public void onSuccess(TUIRoomDefine.UserInfo userInfo) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(userInfo);
            }
        }

        @CalledByNative(value="GetUserInfoCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class GetRoomMetadataCallback {
        private final TUIRoomDefine.GetRoomMetadataCallback mCallback;

        public GetRoomMetadataCallback(TUIRoomDefine.GetRoomMetadataCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="GetRoomMetadataCallback")
        void onSuccess(String metadataJson) {
            HashMap map = TUIRoomEngineJni.jsonStringToMap(metadataJson);
            if (this.mCallback != null) {
                this.mCallback.onSuccess(map);
            }
        }

        @CalledByNative(value="GetRoomMetadataCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class GetRoomInfoCallback {
        private TUIRoomDefine.GetRoomInfoCallback mCallback;

        public GetRoomInfoCallback(TUIRoomDefine.GetRoomInfoCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="GetRoomInfoCallback")
        void onSuccess(TUIRoomDefine.RoomInfo roomInfo) {
            if (this.mCallback != null) {
                this.mCallback.onSuccess(roomInfo);
            }
        }

        @CalledByNative(value="GetRoomInfoCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class ActionCallback {
        private TUIRoomDefine.ActionCallback mCallback;

        public ActionCallback(TUIRoomDefine.ActionCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ActionCallback")
        public void onSuccess() {
            if (this.mCallback != null) {
                this.mCallback.onSuccess();
            }
        }

        @CalledByNative(value="ActionCallback")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    static class LoginUserInfo {
        private TUIRoomDefine.LoginUserInfo mUserInfo;

        public LoginUserInfo(TUIRoomDefine.LoginUserInfo userInfo) {
            this.mUserInfo = userInfo;
        }

        @CalledByNative(value="LoginUserInfo")
        public static TUIRoomDefine.LoginUserInfo createLoginUserInfo(String userId, String userName, String userAvatarURL, HashMap<String, byte[]> customInfo) {
            TUIRoomDefine.LoginUserInfo userInfo = new TUIRoomDefine.LoginUserInfo();
            userInfo.userId = userId;
            userInfo.userName = userName;
            userInfo.avatarUrl = userAvatarURL;
            userInfo.customInfo = customInfo;
            return userInfo;
        }

        @CalledByNative(value="LoginUserInfo")
        public String getUserId() {
            return this.mUserInfo.userId;
        }

        @CalledByNative(value="LoginUserInfo")
        public String getUserName() {
            return this.mUserInfo.userName;
        }

        @CalledByNative(value="LoginUserInfo")
        public String getAvatarUrl() {
            return this.mUserInfo.avatarUrl;
        }

        @CalledByNative(value="LoginUserInfo")
        public HashMap getCustomInfo() {
            return this.mUserInfo.customInfo;
        }
    }

    static class Request {
        private TUIRoomDefine.Request mRequest;

        public Request(TUIRoomDefine.Request request) {
            this.mRequest = request;
        }

        @CalledByNative(value="Request")
        public static TUIRoomDefine.Request createRequest(int requestAction, long timestamp, String requestId, String userId, String userName, String nameCard, String avatarUrl, String content) {
            TUIRoomDefine.Request request = new TUIRoomDefine.Request();
            request.requestAction = TUIRoomDefine.RequestAction.fromInt(requestAction);
            request.timestamp = timestamp;
            request.requestId = requestId;
            request.userId = userId;
            request.userName = userName;
            request.nameCard = nameCard;
            request.avatarUrl = avatarUrl;
            request.content = content;
            return request;
        }
    }

    static class UserListResult {
        private TUIRoomDefine.UserListResult mUserListResult;

        public UserListResult(TUIRoomDefine.UserListResult userListResult) {
            this.mUserListResult = userListResult;
        }

        @CalledByNative(value="UserListResult")
        public static TUIRoomDefine.UserListResult createUserListResult(long nextSequence, List<TUIRoomDefine.UserInfo> userInfoList) {
            TUIRoomDefine.UserListResult userListResult = new TUIRoomDefine.UserListResult();
            userListResult.nextSequence = nextSequence;
            userListResult.userInfoList = userInfoList;
            return userListResult;
        }
    }

    static class EnterRoomOptions {
        private TUIRoomDefine.EnterRoomOptions mOptions;

        EnterRoomOptions(TUIRoomDefine.EnterRoomOptions options) {
            this.mOptions = options;
        }

        @CalledByNative(value="EnterRoomOptions")
        public String getPassword() {
            return this.mOptions.password;
        }
    }

    static class UserInfo {
        private TUIRoomDefine.UserInfo mUserInfo;

        public UserInfo(TUIRoomDefine.UserInfo userInfo) {
            this.mUserInfo = userInfo;
        }

        @CalledByNative(value="UserInfo")
        public static TUIRoomDefine.UserInfo createUserInfo(String userId, String userName, String nameCard, String avatarUrl, int role, boolean hasAudioStream, boolean hasVideoStream, boolean hasScreenStream, boolean isMessageDisabled, HashMap<String, byte[]> customInfo) {
            TUIRoomDefine.UserInfo userInfo = new TUIRoomDefine.UserInfo();
            userInfo.userId = userId;
            userInfo.userName = userName;
            userInfo.nameCard = nameCard;
            userInfo.avatarUrl = avatarUrl;
            userInfo.userRole = TUIRoomDefine.Role.fromInt(role);
            userInfo.hasAudioStream = hasAudioStream;
            userInfo.hasVideoStream = hasVideoStream;
            userInfo.hasScreenStream = hasScreenStream;
            userInfo.isMessageDisabled = isMessageDisabled;
            userInfo.roomCustomInfo = customInfo;
            return userInfo;
        }
    }

    static class RoomInfo {
        private TUIRoomDefine.RoomInfo mRoomInfo;

        public RoomInfo(TUIRoomDefine.RoomInfo roomInfo) {
            this.mRoomInfo = roomInfo;
        }

        @CalledByNative(value="RoomInfo")
        public String getRoomId() {
            return this.mRoomInfo.roomId;
        }

        @CalledByNative(value="RoomInfo")
        public int getRoomType() {
            return this.mRoomInfo.roomType.getValue();
        }

        @CalledByNative(value="RoomInfo")
        public String getName() {
            return this.mRoomInfo.name;
        }

        @CalledByNative(value="RoomInfo")
        public boolean isCameraDisableForAllUser() {
            return this.mRoomInfo.isCameraDisableForAllUser;
        }

        @CalledByNative(value="RoomInfo")
        public boolean isMicrophoneDisableForAllUser() {
            return this.mRoomInfo.isMicrophoneDisableForAllUser;
        }

        @CalledByNative(value="RoomInfo")
        public boolean isScreenShareDisableForAllUser() {
            return this.mRoomInfo.isScreenShareDisableForAllUser;
        }

        @CalledByNative(value="RoomInfo")
        public boolean isMessageDisableForAllUser() {
            return this.mRoomInfo.isMessageDisableForAllUser;
        }

        @CalledByNative(value="RoomInfo")
        public boolean isSeatEnabled() {
            return this.mRoomInfo.isSeatEnabled;
        }

        @CalledByNative(value="RoomInfo")
        public int getSeatMode() {
            return this.mRoomInfo.seatMode.getValue();
        }

        @CalledByNative(value="RoomInfo")
        public int getMaxSeatCount() {
            return this.mRoomInfo.maxSeatCount;
        }

        @CalledByNative(value="RoomInfo")
        public String getPassword() {
            return this.mRoomInfo.password;
        }
    }

    static class VideoEncoderParams {
        private TUIRoomDefine.RoomVideoEncoderParams mVideoEncoderParams;

        public VideoEncoderParams(TUIRoomDefine.RoomVideoEncoderParams videoEncoderParams) {
            this.mVideoEncoderParams = videoEncoderParams;
        }

        @CalledByNative(value="VideoEncoderParams")
        public int getBitrate() {
            return this.mVideoEncoderParams.bitrate;
        }

        @CalledByNative(value="VideoEncoderParams")
        public int getFps() {
            return this.mVideoEncoderParams.fps;
        }

        @CalledByNative(value="VideoEncoderParams")
        public int getVideoResolution() {
            return this.mVideoEncoderParams.videoResolution.getValue();
        }

        @CalledByNative(value="VideoEncoderParams")
        public int getResMode() {
            return this.mVideoEncoderParams.resolutionMode.getValue();
        }
    }

    static class SeatLockParams {
        private TUIRoomDefine.SeatLockParams mLockParams;

        public SeatLockParams(TUIRoomDefine.SeatLockParams lockParams) {
            this.mLockParams = lockParams;
        }

        @CalledByNative(value="SeatLockParams")
        public boolean isSeatLock() {
            return this.mLockParams.lockSeat;
        }

        @CalledByNative(value="SeatLockParams")
        public boolean isAudioLock() {
            return this.mLockParams.lockAudio;
        }

        @CalledByNative(value="SeatLockParams")
        public boolean isVideoLock() {
            return this.mLockParams.lockVideo;
        }
    }
}

