/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension.internal;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.extension.TUILiveBattleManager;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$1;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$2;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$3;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$4;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$5;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$6;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$7;
import com.tencent.cloud.tuikit.engine.extension.internal.TUILiveBattleManagerImpl$$Lambda$8;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@JNINamespace(value="tuikit::extension")
public final class TUILiveBattleManagerImpl
extends TUILiveBattleManager {
    private static final String TAG = "TUILiveBattleManagerImpl";
    private long mNativeLiveBattleManagerJni;
    private final List<TUILiveBattleManager.Observer> mObserverList = new CopyOnWriteArrayList<TUILiveBattleManager.Observer>();
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());

    public TUILiveBattleManagerImpl(long nativeLiveBattleManagerJni) {
        this.mNativeLiveBattleManagerJni = nativeLiveBattleManagerJni;
        if (this.mNativeLiveBattleManagerJni != 0L) {
            TUILiveBattleManagerImpl.nativeSetObserver(this.mNativeLiveBattleManagerJni, this);
        }
    }

    @Override
    public void addObserver(TUILiveBattleManager.Observer observer) {
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$1.lambdaFactory$(this, observer));
    }

    @Override
    public void removeObserver(TUILiveBattleManager.Observer observer) {
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$2.lambdaFactory$(this, observer));
    }

    @Override
    public void requestBattle(TUILiveBattleManager.BattleConfig config, List<String> userIdList, int timeout, TUILiveBattleManager.BattleRequestCallback callback) {
        if (userIdList == null) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.INVALID_PARAMETER, "userIdList is null");
            }
            return;
        }
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$3.lambdaFactory$(this, config, userIdList, timeout, callback));
    }

    @Override
    public void cancelBattleRequest(String battleId, List<String> userIdList, TUIRoomDefine.ActionCallback callback) {
        if (userIdList == null) {
            if (callback != null) {
                callback.onError(TUICommonDefine.Error.INVALID_PARAMETER, "userIdList is null");
            }
            return;
        }
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$4.lambdaFactory$(this, battleId, userIdList, callback));
    }

    @Override
    public void acceptBattle(String battleId, TUIRoomDefine.ActionCallback callback) {
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$5.lambdaFactory$(this, battleId, callback));
    }

    @Override
    public void rejectBattle(String battleId, TUIRoomDefine.ActionCallback callback) {
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$6.lambdaFactory$(this, battleId, callback));
    }

    @Override
    public void exitBattle(String battleId, TUIRoomDefine.ActionCallback callback) {
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$7.lambdaFactory$(this, battleId, callback));
    }

    public void destroy() {
        this.runOnMainThread(TUILiveBattleManagerImpl$$Lambda$8.lambdaFactory$(this));
    }

    private static native void nativeSetObserver(long var0, Object var2);

    private static native void nativeRequestBattle(long var0, int var2, boolean var3, String var4, String[] var5, int var6, BattleRequestCallbackJni var7);

    private static native void nativeCancelBattleRequest(long var0, String var2, String[] var3, ActionCallbackJni var4);

    private static native void nativeAcceptBattle(long var0, String var2, ActionCallbackJni var3);

    private static native void nativeRejectBattle(long var0, String var2, ActionCallbackJni var3);

    private static native void nativeExitBattle(long var0, String var2, ActionCallbackJni var3);

    @CalledByNative
    private void onBattleStarted(String battleInfoStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleInfo battleInfo = TUILiveBattleManagerImpl.convertJsonToBattleInfo(battleInfoStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleStarted(battleInfo);
        }
    }

    @CalledByNative
    private void onBattleEnded(String battleInfoStr, int stopReason) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleInfo battleInfo = TUILiveBattleManagerImpl.convertJsonToBattleInfo(battleInfoStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleEnded(battleInfo, TUILiveBattleManager.BattleStoppedReason.fromInt(stopReason));
        }
    }

    @CalledByNative
    private void onUserJoinBattle(String battleId, String battleUserStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleUser battleUser = TUILiveBattleManagerImpl.convertJsonToBattleUser(battleUserStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onUserJoinBattle(battleId, battleUser);
        }
    }

    @CalledByNative
    private void onUserExitBattle(String battleId, String battleUserStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleUser battleUser = TUILiveBattleManagerImpl.convertJsonToBattleUser(battleUserStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onUserExitBattle(battleId, battleUser);
        }
    }

    @CalledByNative
    private void onBattleScoreChanged(String battleId, String battleUserListStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        List<TUILiveBattleManager.BattleUser> battleUser = TUILiveBattleManagerImpl.convertJsonToBattleUserList(battleUserListStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleScoreChanged(battleId, battleUser);
        }
    }

    @CalledByNative
    private void onBattleRequestReceived(String battleInfoStr, String inviterStr, String inviteeStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleInfo battleInfo = TUILiveBattleManagerImpl.convertJsonToBattleInfo(battleInfoStr);
        TUILiveBattleManager.BattleUser inviter = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviterStr);
        TUILiveBattleManager.BattleUser invitee = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviteeStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleRequestReceived(battleInfo, inviter, invitee);
        }
    }

    @CalledByNative
    private void onBattleRequestCancelled(String battleInfoStr, String inviterStr, String inviteeStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleInfo battleInfo = TUILiveBattleManagerImpl.convertJsonToBattleInfo(battleInfoStr);
        TUILiveBattleManager.BattleUser inviter = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviterStr);
        TUILiveBattleManager.BattleUser invitee = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviteeStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleRequestCancelled(battleInfo, inviter, invitee);
        }
    }

    @CalledByNative
    private void onBattleRequestTimeout(String battleInfoStr, String inviterStr, String inviteeStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleInfo battleInfo = TUILiveBattleManagerImpl.convertJsonToBattleInfo(battleInfoStr);
        TUILiveBattleManager.BattleUser inviter = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviterStr);
        TUILiveBattleManager.BattleUser invitee = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviteeStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleRequestTimeout(battleInfo, inviter, invitee);
        }
    }

    @CalledByNative
    private void onBattleRequestAccept(String battleInfoStr, String inviterStr, String inviteeStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleInfo battleInfo = TUILiveBattleManagerImpl.convertJsonToBattleInfo(battleInfoStr);
        TUILiveBattleManager.BattleUser inviter = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviterStr);
        TUILiveBattleManager.BattleUser invitee = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviteeStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleRequestAccept(battleInfo, inviter, invitee);
        }
    }

    @CalledByNative
    private void onBattleRequestReject(String battleInfoStr, String inviterStr, String inviteeStr) {
        List<TUILiveBattleManager.Observer> observers = this.copyOnReadListeners();
        if (observers.isEmpty()) {
            return;
        }
        TUILiveBattleManager.BattleInfo battleInfo = TUILiveBattleManagerImpl.convertJsonToBattleInfo(battleInfoStr);
        TUILiveBattleManager.BattleUser inviter = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviterStr);
        TUILiveBattleManager.BattleUser invitee = TUILiveBattleManagerImpl.convertJsonToBattleUser(inviteeStr);
        for (TUILiveBattleManager.Observer observer : observers) {
            observer.onBattleRequestReject(battleInfo, inviter, invitee);
        }
    }

    private void runOnMainThread(Runnable runnable) {
        this.mMainHandler.post(runnable);
    }

    private List<TUILiveBattleManager.Observer> copyOnReadListeners() {
        return new CopyOnWriteArrayList<TUILiveBattleManager.Observer>(this.mObserverList);
    }

    private static List<TUILiveBattleManager.BattleUser> convertJsonToBattleUserList(String jsonStr) {
        ArrayList<TUILiveBattleManager.BattleUser> battleUserList = new ArrayList<TUILiveBattleManager.BattleUser>();
        if (jsonStr != null) {
            try {
                JSONArray jsonArray = new JSONArray(jsonStr);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    TUILiveBattleManager.BattleUser user = TUILiveBattleManagerImpl.convertJsonToBattleUser(jsonArray.getString(i));
                    if (user == null) continue;
                    battleUserList.add(user);
                }
            }
            catch (JSONException e) {
                LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            }
        }
        return battleUserList;
    }

    private static TUILiveBattleManager.BattleUser convertJsonToBattleUser(String jsonStr) {
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            return TUILiveBattleManagerImpl.convertJsonToBattleUser(jsonObject);
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            return null;
        }
    }

    private static TUILiveBattleManager.BattleUser convertJsonToBattleUser(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        TUILiveBattleManager.BattleUser user = new TUILiveBattleManager.BattleUser();
        try {
            user.userId = jsonObject.getString("userId");
            user.userName = jsonObject.getString("userName");
            user.avatarUrl = jsonObject.getString("avatarUrl");
            user.roomId = jsonObject.getString("roomId");
            user.score = jsonObject.getInt("score");
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            return null;
        }
        return user;
    }

    private static TUILiveBattleManager.BattleInfo convertJsonToBattleInfo(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        TUILiveBattleManager.BattleInfo info = new TUILiveBattleManager.BattleInfo();
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            info.config = new TUILiveBattleManager.BattleConfig();
            info.config.extensionInfo = jsonObject.getString("extensionInfo");
            info.config.needResponse = jsonObject.getBoolean("needResponse");
            info.config.duration = jsonObject.getInt("duration");
            info.battleId = jsonObject.getString("battleId");
            info.startTime = jsonObject.getInt("startTime");
            info.endTime = jsonObject.getInt("endTime");
            info.inviter = TUILiveBattleManagerImpl.convertJsonToBattleUser(jsonObject.getString("fromUser"));
            info.inviteeList = new ArrayList<TUILiveBattleManager.BattleUser>();
            JSONArray toUserArray = jsonObject.getJSONArray("toUserList");
            for (int i = 0; i < toUserArray.length(); ++i) {
                TUILiveBattleManager.BattleUser user = TUILiveBattleManagerImpl.convertJsonToBattleUser(toUserArray.getString(i));
                if (user == null) continue;
                info.inviteeList.add(user);
            }
        }
        catch (JSONException e) {
            LiteavLog.e((String)TAG, (String)e.getLocalizedMessage());
            return null;
        }
        return info;
    }

    static /* synthetic */ void lambda$destroy$7(TUILiveBattleManagerImpl this_) {
        this_.mObserverList.clear();
        this_.mNativeLiveBattleManagerJni = 0L;
    }

    static /* synthetic */ void lambda$exitBattle$6(TUILiveBattleManagerImpl this_, String battleId, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveBattleManagerJni != 0L) {
            TUILiveBattleManagerImpl.nativeExitBattle(this_.mNativeLiveBattleManagerJni, battleId, new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$rejectBattle$5(TUILiveBattleManagerImpl this_, String battleId, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveBattleManagerJni != 0L) {
            TUILiveBattleManagerImpl.nativeRejectBattle(this_.mNativeLiveBattleManagerJni, battleId, new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$acceptBattle$4(TUILiveBattleManagerImpl this_, String battleId, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveBattleManagerJni != 0L) {
            TUILiveBattleManagerImpl.nativeAcceptBattle(this_.mNativeLiveBattleManagerJni, battleId, new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$cancelBattleRequest$3(TUILiveBattleManagerImpl this_, String battleId, List userIdList, TUIRoomDefine.ActionCallback callback) {
        if (this_.mNativeLiveBattleManagerJni != 0L) {
            TUILiveBattleManagerImpl.nativeCancelBattleRequest(this_.mNativeLiveBattleManagerJni, battleId, userIdList.toArray(new String[0]), new ActionCallbackJni(callback));
        }
    }

    static /* synthetic */ void lambda$requestBattle$2(TUILiveBattleManagerImpl this_, TUILiveBattleManager.BattleConfig config, List userIdList, int timeout, TUILiveBattleManager.BattleRequestCallback callback) {
        if (this_.mNativeLiveBattleManagerJni != 0L) {
            TUILiveBattleManagerImpl.nativeRequestBattle(this_.mNativeLiveBattleManagerJni, config.duration, config.needResponse, config.extensionInfo, userIdList.toArray(new String[0]), timeout, new BattleRequestCallbackJni(config, callback));
        }
    }

    static /* synthetic */ void lambda$removeObserver$1(TUILiveBattleManagerImpl this_, TUILiveBattleManager.Observer observer) {
        this_.mObserverList.remove(observer);
    }

    static /* synthetic */ void lambda$addObserver$0(TUILiveBattleManagerImpl this_, TUILiveBattleManager.Observer observer) {
        if (!this_.mObserverList.contains(observer)) {
            this_.mObserverList.add(observer);
        }
    }

    private static class ActionCallbackJni {
        private final TUIRoomDefine.ActionCallback mCallback;

        public ActionCallbackJni(TUIRoomDefine.ActionCallback callback) {
            this.mCallback = callback;
        }

        @CalledByNative(value="ActionCallbackJni")
        public void onSuccess() {
            if (this.mCallback != null) {
                this.mCallback.onSuccess();
            }
        }

        @CalledByNative(value="ActionCallbackJni")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }

    private static final class BattleRequestCallbackJni {
        private final TUILiveBattleManager.BattleRequestCallback mCallback;
        private final TUILiveBattleManager.BattleConfig battleConfig;

        public BattleRequestCallbackJni(TUILiveBattleManager.BattleConfig config, TUILiveBattleManager.BattleRequestCallback callback) {
            this.battleConfig = config;
            this.mCallback = callback;
        }

        @CalledByNative(value="BattleRequestCallbackJni")
        public void onSuccess(String jsonStr) {
            if (this.mCallback != null) {
                HashMap<String, TUILiveBattleManager.BattleCode> resultMap = new HashMap<String, TUILiveBattleManager.BattleCode>();
                String battleId = "";
                try {
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    battleId = jsonObject.getString("battleId");
                    JSONArray resultJson = jsonObject.getJSONArray("resultList");
                    for (int i = 0; i < resultJson.length(); ++i) {
                        JSONObject resultObject = resultJson.getJSONObject(i);
                        String userId = resultObject.getString("userId");
                        int errorCode = resultObject.getInt("errorCode");
                        TUILiveBattleManager.BattleCode code = TUILiveBattleManager.BattleCode.fromInt(errorCode);
                        resultMap.put(userId, code);
                    }
                }
                catch (JSONException e) {
                    LiteavLog.e((String)TUILiveBattleManagerImpl.TAG, (String)e.getLocalizedMessage());
                }
                TUILiveBattleManager.BattleInfo battleInfo = new TUILiveBattleManager.BattleInfo();
                battleInfo.battleId = battleId;
                battleInfo.config = this.battleConfig;
                this.mCallback.onSuccess(battleInfo, resultMap);
            }
        }

        @CalledByNative(value="BattleRequestCallbackJni")
        public void onError(int code, String message) {
            if (this.mCallback != null) {
                this.mCallback.onError(TUICommonDefine.Error.fromInt(code), message);
            }
        }
    }
}

