/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.common.TUIVideoView;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import java.util.List;

public abstract class TUILiveListManager {
    public abstract void addObserver(Observer var1);

    public abstract void removeObserver(Observer var1);

    public abstract void setLiveInfo(LiveInfo var1, List<LiveModifyFlag> var2, TUIRoomDefine.ActionCallback var3);

    public abstract void getLiveInfo(String var1, LiveInfoCallback var2);

    public abstract void fetchLiveList(String var1, int var2, LiveInfoListCallback var3);

    public abstract void startPreloadVideoStream(String var1, boolean var2, TUIVideoView var3, TUIRoomDefine.PlayCallback var4);

    public abstract void stopPreloadVideoStream(String var1);

    public static abstract class Observer {
        public void onLiveInfoChanged(LiveInfo liveInfo, List<LiveModifyFlag> modifyFlagList) {
        }
    }

    public static interface LiveInfoListCallback {
        public void onSuccess(LiveInfoListResult var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static interface LiveInfoCallback {
        public void onSuccess(LiveInfo var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static class LiveInfoListResult {
        public String cursor;
        public List<LiveInfo> liveInfoList;
    }

    public static class LiveInfo {
        public TUIRoomDefine.RoomInfo roomInfo;
        public String coverUrl;
        public String backgroundUrl;
        public List<Integer> categoryList;
        public boolean isPublicVisible;
        public int activityStatus;
        public int viewCount;
    }

    public static enum LiveModifyFlag {
        NONE(0),
        ACTIVITY_STATUS(256),
        COVER_URL(512),
        CATEGORY(1024),
        PUBLISH(8192),
        BACKGROUND_URL(262144);

        int mValue;

        private LiveModifyFlag(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static LiveModifyFlag fromInt(int value) {
            for (LiveModifyFlag flag : LiveModifyFlag.values()) {
                if (flag.mValue != value) continue;
                return flag;
            }
            return NONE;
        }
    }
}

