/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import java.util.List;
import java.util.Map;

public abstract class TUILiveConnectionManager {
    public abstract void addObserver(Observer var1);

    public abstract void removeObserver(Observer var1);

    public abstract void requestConnection(List<String> var1, int var2, String var3, ConnectionRequestCallback var4);

    public abstract void cancelConnectionRequest(List<String> var1, TUIRoomDefine.ActionCallback var2);

    public abstract void acceptConnection(String var1, TUIRoomDefine.ActionCallback var2);

    public abstract void rejectConnection(String var1, TUIRoomDefine.ActionCallback var2);

    public abstract void disconnect(TUIRoomDefine.ActionCallback var1);

    public static abstract class Observer {
        public void onConnectionUserListChanged(List<ConnectionUser> connectedList, List<ConnectionUser> joinedList, List<ConnectionUser> leavedList) {
        }

        public void onConnectionRequestReceived(ConnectionUser inviter, List<ConnectionUser> inviteeList, String extensionInfo) {
        }

        public void onConnectionRequestCancelled(ConnectionUser inviter) {
        }

        public void onConnectionRequestAccept(ConnectionUser invitee) {
        }

        public void onConnectionRequestReject(ConnectionUser invitee) {
        }

        public void onConnectionRequestTimeout(ConnectionUser inviter, ConnectionUser invitee) {
        }
    }

    public static interface ConnectionRequestCallback {
        public void onSuccess(Map<String, ConnectionCode> var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static enum ConnectionCode {
        UNKNOWN(-1),
        SUCCESS(0),
        ROOM_NOT_EXISTS(1),
        CONNECTING(2),
        CONNECTING_OTHER_ROOM(3),
        CONNECTION_FULL(4),
        RETRY(5);

        int mValue;

        private ConnectionCode(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static ConnectionCode fromInt(int value) {
            for (ConnectionCode code : ConnectionCode.values()) {
                if (code.mValue != value) continue;
                return code;
            }
            return SUCCESS;
        }
    }

    public static class ConnectionUser {
        public String roomId;
        public String userId;
        public String userName;
        public String avatarUrl;
        public long joinConnectionTime;
    }
}

