/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.extension;

import com.tencent.cloud.tuikit.engine.common.TUICommonDefine;
import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import java.util.List;
import java.util.Map;

public abstract class TUIConferenceInvitationManager {
    public abstract void addObserver(Observer var1);

    public abstract void removeObserver(Observer var1);

    public abstract void inviteUsers(String var1, List<String> var2, int var3, String var4, InviteUsersCallback var5);

    public abstract void cancelInvitation(String var1, List<String> var2, TUIRoomDefine.ActionCallback var3);

    public abstract void accept(String var1, TUIRoomDefine.ActionCallback var2);

    public abstract void reject(String var1, RejectedReason var2, TUIRoomDefine.ActionCallback var3);

    public abstract void getInvitationList(String var1, String var2, int var3, GetInvitationListCallback var4);

    public static abstract class Observer {
        public void onReceiveInvitation(TUIRoomDefine.RoomInfo roomInfo, Invitation invitation, String extensionInfo) {
        }

        public void onInvitationHandledByOtherDevice(TUIRoomDefine.RoomInfo roomInfo, boolean accepted) {
        }

        public void onInvitationCancelled(TUIRoomDefine.RoomInfo roomInfo, Invitation invitation) {
        }

        public void onInvitationAccepted(TUIRoomDefine.RoomInfo roomInfo, Invitation invitation) {
        }

        public void onInvitationRejected(TUIRoomDefine.RoomInfo roomInfo, Invitation invitation, RejectedReason reason) {
        }

        public void onInvitationTimeout(TUIRoomDefine.RoomInfo roomInfo, Invitation invitation) {
        }

        public void onInvitationRevokedByAdmin(TUIRoomDefine.RoomInfo roomInfo, Invitation invitation, TUIRoomDefine.UserInfo admin) {
        }

        public void onInvitationAdded(String roomId, Invitation invitation) {
        }

        public void onInvitationRemoved(String roomId, Invitation invitation) {
        }

        public void onInvitationStatusChanged(String roomId, Invitation invitation) {
        }
    }

    public static interface GetInvitationListCallback {
        public void onSuccess(InvitationListResult var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static class InvitationListResult {
        public String cursor;
        public List<Invitation> invitationList;
    }

    public static interface InviteUsersCallback {
        public void onSuccess(Map<String, InvitationCode> var1);

        public void onError(TUICommonDefine.Error var1, String var2);
    }

    public static class Invitation {
        public InvitationStatus status = InvitationStatus.NONE;
        public TUIRoomDefine.UserInfo invitee;
        public TUIRoomDefine.UserInfo inviter;
    }

    public static enum RejectedReason {
        REJECT_TO_ENTER(0),
        IN_OTHER_CONFERENCE(1);

        int mValue;

        private RejectedReason(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static RejectedReason fromInt(int value) {
            for (RejectedReason reason : RejectedReason.values()) {
                if (reason.mValue != value) continue;
                return reason;
            }
            return REJECT_TO_ENTER;
        }
    }

    public static enum InvitationCode {
        SUCCESS(0),
        ALREADY_IN_INVITATION_LIST(1),
        ALREADY_IN_CONFERENCE(2);

        int mValue;

        private InvitationCode(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static InvitationCode fromInt(int value) {
            for (InvitationCode status : InvitationCode.values()) {
                if (status.mValue != value) continue;
                return status;
            }
            return SUCCESS;
        }
    }

    public static enum InvitationStatus {
        NONE(0),
        PENDING(1),
        TIMEOUT(2),
        ACCEPTED(3),
        REJECTED(4);

        int mValue;

        private InvitationStatus(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static InvitationStatus fromInt(int value) {
            for (InvitationStatus status : InvitationStatus.values()) {
                if (status.mValue != value) continue;
                return status;
            }
            return NONE;
        }
    }
}

