/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.common.internal;

import com.tencent.cloud.tuikit.engine.room.TUIRoomDefine;
import com.tencent.liteav.base.util.LiteavLog;
import org.json.JSONException;
import org.json.JSONObject;

public class TUIDefineConvert {
    private static final String TAG = "TUIDefineConvert";

    public static TUIRoomDefine.UserInfo convertJSONToUserInfo(JSONObject jsonObject) {
        TUIRoomDefine.UserInfo userInfo = new TUIRoomDefine.UserInfo();
        try {
            userInfo.userId = jsonObject.getString("userId");
            userInfo.userName = jsonObject.getString("userName");
            userInfo.nameCard = jsonObject.getString("nameCard");
            userInfo.avatarUrl = jsonObject.getString("avatarUrl");
            userInfo.userRole = TUIRoomDefine.Role.fromInt(jsonObject.getInt("userRole"));
            userInfo.hasAudioStream = jsonObject.getBoolean("hasAudioStream");
            userInfo.hasVideoStream = jsonObject.getBoolean("hasVideoStream");
            userInfo.hasScreenStream = jsonObject.getBoolean("hasScreenStream");
            userInfo.isMessageDisabled = jsonObject.getBoolean("isMessageDisabled");
        }
        catch (JSONException jsonException) {
            LiteavLog.e((String)TAG, (String)("convertJSONToUserInfo error:" + jsonException.getMessage()));
        }
        return userInfo;
    }

    public static TUIRoomDefine.UserInfo convertStringToUserInfo(String jsonStr) {
        TUIRoomDefine.UserInfo userInfo;
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            userInfo = TUIDefineConvert.convertJSONToUserInfo(jsonObject);
        }
        catch (JSONException jsonException) {
            LiteavLog.e((String)TAG, (String)("convertStringToUserInfo error:" + jsonException.getMessage()));
            userInfo = new TUIRoomDefine.UserInfo();
        }
        return userInfo;
    }

    public static TUIRoomDefine.RoomInfo convertJSONToRoomInfo(JSONObject object) {
        TUIRoomDefine.RoomInfo roomInfo = new TUIRoomDefine.RoomInfo();
        try {
            roomInfo.roomId = object.getString("roomId");
            roomInfo.ownerId = object.getString("ownerId");
            roomInfo.ownerName = object.getString("ownerName");
            roomInfo.ownerAvatarUrl = object.getString("ownerAvatarUrl");
            roomInfo.roomType = TUIRoomDefine.RoomType.fromInt(object.getInt("roomType"));
            roomInfo.name = object.getString("roomName");
            roomInfo.isCameraDisableForAllUser = object.getBoolean("cameraDisable");
            roomInfo.isMicrophoneDisableForAllUser = object.getBoolean("microphoneDisable");
            roomInfo.isScreenShareDisableForAllUser = object.getBoolean("screenShareDisable");
            roomInfo.isMessageDisableForAllUser = object.getBoolean("messageDisable");
            roomInfo.isSeatEnabled = object.getBoolean("isSeatEnabled");
            roomInfo.seatMode = TUIRoomDefine.SeatMode.fromInt(object.getInt("seatMode"));
            roomInfo.maxSeatCount = object.getInt("maxSeatCount");
            roomInfo.password = object.optString("password");
            roomInfo.createTime = object.getLong("createTime") * 1000L;
            roomInfo.memberCount = object.getInt("roomMemberCount");
        }
        catch (JSONException jsonException) {
            LiteavLog.e((String)TAG, (String)("convertJSONToRoomInfo error:" + jsonException.getMessage()));
        }
        return roomInfo;
    }

    public static TUIRoomDefine.RoomInfo convertStringToRoomInfo(String jsonStr) {
        TUIRoomDefine.RoomInfo roomInfo;
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            roomInfo = TUIDefineConvert.convertJSONToRoomInfo(jsonObject);
        }
        catch (JSONException jsonException) {
            LiteavLog.e((String)TAG, (String)("convertStringToRoomInfo error:" + jsonException.getMessage()));
            roomInfo = new TUIRoomDefine.RoomInfo();
        }
        return roomInfo;
    }
}

