/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.tuikit.engine.base;

import android.os.Handler;
import android.os.Looper;
import com.tencent.cloud.tuikit.engine.base.TimerJava$$Lambda$1;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.util.HashMap;
import java.util.Map;

@JNINamespace(value="tuikit::engine::basic")
public class TimerJava {
    private static long MSG_START_TASK = 1000L;
    private long mNativeTimer;
    private Handler mHandler;
    private Map<Integer, TimerRunnable> mTimerTaskMap;

    @CalledByNative
    public TimerJava(long nativeTimer) {
        this.mNativeTimer = nativeTimer;
        this.mTimerTaskMap = new HashMap<Integer, TimerRunnable>();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @CalledByNative
    public boolean startTimerTask(int timerId, long interval) {
        if (this.isHasTask(timerId)) {
            return false;
        }
        TimerRunnable timerRunnable = new TimerRunnable(timerId, interval);
        this.mTimerTaskMap.put(timerId, timerRunnable);
        this.mHandler.post((Runnable)timerRunnable);
        return true;
    }

    @CalledByNative
    public void postDelayTask(int timerId, long timeout) {
        this.mHandler.postDelayed(TimerJava$$Lambda$1.lambdaFactory$(this, timerId), timeout);
    }

    @CalledByNative
    public void stopTimerTask(int timerId) {
        if (this.isHasTask(timerId)) {
            TimerRunnable timerRunnable = this.mTimerTaskMap.get(timerId);
            this.mHandler.removeCallbacks((Runnable)timerRunnable);
            this.mTimerTaskMap.remove(timerId);
        }
    }

    @CalledByNative
    public void destroy() {
        this.mTimerTaskMap.clear();
        this.mNativeTimer = 0L;
    }

    private void onTask(int timerId) {
        TimerJava.nativeOnTask(this.mNativeTimer, timerId);
    }

    private void onDelayTask(int timerId) {
        TimerJava.nativeOnDelayTask(this.mNativeTimer, timerId);
    }

    private boolean isInit() {
        return this.mNativeTimer != 0L;
    }

    private boolean isHasTask(int timerId) {
        if (!this.isInit()) {
            return false;
        }
        if (this.mTimerTaskMap != null) {
            return this.mTimerTaskMap.containsKey(timerId);
        }
        return false;
    }

    private static native void nativeOnTask(long var0, int var2);

    private static native void nativeOnDelayTask(long var0, int var2);

    static /* synthetic */ void lambda$postDelayTask$0(TimerJava this_, int timerId) {
        this_.onDelayTask(timerId);
    }

    private class TimerRunnable
    implements Runnable {
        private int mTimerId;
        private long mInterval;

        public TimerRunnable(int timerId, long interval) {
            this.mTimerId = timerId;
            this.mInterval = interval;
        }

        @Override
        public void run() {
            if (TimerJava.this.isHasTask(this.mTimerId)) {
                TimerJava.this.onTask(this.mTimerId);
                TimerJava.this.mHandler.postDelayed((Runnable)this, this.mInterval);
            }
        }
    }
}

