/*
 * Decompiled with CFR 0.152.
 */
package io.trino.web.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Resources;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class WebUiResources {
    private static final String DEFAULT_MEDIA_TYPE = "application/octet-stream";

    private WebUiResources() {
    }

    public static Response webUiResource(String path) throws IOException {
        if (!WebUiResources.isCanonical(path)) {
            throw new NotFoundException();
        }
        try {
            URL resource = Resources.getResource(WebUiResources.class, (String)path);
            return Response.ok((Object)resource.openStream(), (String)WebUiResources.mediaType(resource.toString())).build();
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException();
        }
    }

    public static String readWebUiResource(String path) throws IOException {
        return Resources.toString((URL)Resources.getResource(WebUiResources.class, (String)path), (Charset)StandardCharsets.UTF_8);
    }

    public static boolean isCanonical(String fullPath) {
        try {
            return new URI(fullPath).normalize().getPath().equals(fullPath);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @VisibleForTesting
    static String mediaType(String filename) {
        String extension;
        int dotPosition = filename.lastIndexOf(46);
        if (dotPosition == -1) {
            return DEFAULT_MEDIA_TYPE;
        }
        return switch (extension = filename.substring(dotPosition + 1).toLowerCase(Locale.ENGLISH)) {
            case "apng" -> "image/apng";
            case "asc", "txt" -> "text/plain";
            case "bmp" -> "image/bmp";
            case "css" -> "text/css";
            case "html" -> "text/html";
            case "ico" -> "image/x-icon";
            case "gif" -> "image/gif";
            case "jpg", "jpeg" -> "image/jpeg";
            case "js" -> "application/javascript";
            case "json" -> "application/json";
            case "md", "markdown" -> "text/markdown";
            case "png" -> "image/png";
            case "svg" -> "image/svg+xml";
            case "toml" -> "application/toml";
            case "ttf" -> "font/ttf";
            case "webp" -> "image/webp";
            case "woff" -> "font/woff";
            case "woff2" -> "font/woff2";
            case "yaml", "yml" -> "application/yaml";
            default -> DEFAULT_MEDIA_TYPE;
        };
    }
}

