/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftTypeUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public final class TrinoThriftInteger
implements TrinoThriftColumnData {
    private final boolean[] nulls;
    private final int[] ints;

    @ThriftConstructor
    public TrinoThriftInteger(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="ints") @Nullable int[] ints) {
        Preconditions.checkArgument((boolean)TrinoThriftInteger.sameSizeIfPresent(nulls, ints), (Object)"nulls and values must be of the same size");
        this.nulls = nulls;
        this.ints = ints;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getInts() {
        return this.ints;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((boolean)IntegerType.INTEGER.equals((Object)desiredType), (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return new IntArrayBlock(numberOfRecords, Optional.ofNullable(this.nulls), this.ints == null ? new int[numberOfRecords] : this.ints);
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.ints != null) {
            return this.ints.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftInteger other = (TrinoThriftInteger)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.ints, other.ints);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.ints));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static TrinoThriftBlock fromBlock(Block block) {
        return TrinoThriftTypeUtils.fromIntBasedBlock(block, (Type)IntegerType.INTEGER, (nulls, ints) -> TrinoThriftBlock.integerData(new TrinoThriftInteger((boolean[])nulls, (int[])ints)));
    }

    public static TrinoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        return TrinoThriftTypeUtils.fromIntBasedColumn(recordSet, columnIndex, totalRecords, (nulls, ints) -> TrinoThriftBlock.integerData(new TrinoThriftInteger((boolean[])nulls, (int[])ints)));
    }

    private static boolean sameSizeIfPresent(boolean[] nulls, int[] ints) {
        return nulls == null || ints == null || nulls.length == ints.length;
    }
}

