/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TemporaryRelation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;

public class TestTable
implements TemporaryRelation {
    protected final SqlExecutor sqlExecutor;
    protected final String tableDefinition;
    protected final String name;

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, @Language(value="SQL") String tableDefinition) {
        this(sqlExecutor, namePrefix, tableDefinition, (List<String>)ImmutableList.of());
    }

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, @Language(value="SQL") String tableDefinition, List<String> rowsToInsert) {
        this.sqlExecutor = Objects.requireNonNull(sqlExecutor, "sqlExecutor is null");
        this.name = Objects.requireNonNull(namePrefix, "namePrefix is null") + TestingNames.randomNameSuffix();
        this.tableDefinition = Objects.requireNonNull(tableDefinition, "tableDefinition is null");
        this.createAndInsert(rowsToInsert);
    }

    protected void createAndInsert(List<String> rowsToInsert) {
        this.sqlExecutor.execute(String.format("CREATE TABLE %s %s", this.name, this.tableDefinition));
        try {
            if (!rowsToInsert.isEmpty()) {
                if (this.sqlExecutor.supportsMultiRowInsert()) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = this.name;
                    String string = "(%s)";
                    objectArray[1] = rowsToInsert.stream().map(arg_0 -> TestTable.lambda$createAndInsert$0("(%s)", arg_0)).collect(Collectors.joining(", "));
                    this.sqlExecutor.execute(String.format("INSERT INTO %s VALUES %s", objectArray));
                } else {
                    for (String row : rowsToInsert) {
                        this.sqlExecutor.execute(String.format("INSERT INTO %s VALUES (%s)", this.name, row));
                    }
                }
            }
        }
        catch (Exception e) {
            TestTable ignored = this;
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static TestTable fromColumns(SqlExecutor sqlExecutor, String namePrefix, Map<String, List<String>> columns) {
        return TestTable.fromColumns(sqlExecutor, namePrefix, columns, (String column) -> {
            throw new IllegalArgumentException(String.format("Some values missing for column '%s'", column));
        });
    }

    public static TestTable fromColumns(SqlExecutor sqlExecutor, String namePrefix, Map<String, List<String>> columns, String defaultValue) {
        return TestTable.fromColumns(sqlExecutor, namePrefix, columns, (String column) -> defaultValue);
    }

    private static TestTable fromColumns(SqlExecutor sqlExecutor, String namePrefix, Map<String, List<String>> columns, Function<String, String> defaultValueSupplier) {
        int rowsCount = columns.values().stream().mapToInt(List::size).max().orElseThrow(() -> new IllegalArgumentException("please, give me at least one column to work with"));
        return TestTable.fromColumnValueProviders(sqlExecutor, namePrefix, rowsCount, (Map)columns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> index -> {
            if (index < ((List)entry.getValue()).size()) {
                return (String)((List)entry.getValue()).get((int)index);
            }
            return (String)defaultValueSupplier.apply((String)entry.getKey());
        })));
    }

    public static TestTable fromColumnValueProviders(SqlExecutor sqlExecutor, String namePrefix, int rowsCount, Map<String, Function<Integer, String>> columnsValueProviders) {
        String tableDefinition = "(" + String.join((CharSequence)",", columnsValueProviders.keySet()) + ")";
        ImmutableList.Builder rows = ImmutableList.builder();
        for (int rowId = 0; rowId < rowsCount; ++rowId) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            for (Function<Integer, String> columnValues : columnsValueProviders.values()) {
                rowValues.add((Object)columnValues.apply(rowId));
            }
            rows.add((Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)rowValues.build()));
        }
        return new TestTable(sqlExecutor, namePrefix, tableDefinition, (List<String>)rows.build());
    }

    @Override
    public void close() {
        this.sqlExecutor.execute("DROP TABLE " + this.name);
    }

    private static /* synthetic */ String lambda$createAndInsert$0(String rec$, Object xva$0) {
        return "(%s)".formatted(xva$0);
    }
}

