/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.log.Logger;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;

public class WebUiPreviewQueryRunner {
    private WebUiPreviewQueryRunner() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) throws Exception {
        DistributedQueryRunner queryRunner = ((Builder)((Builder)((Builder)((Builder)((Builder)WebUiPreviewQueryRunner.builder().addCoordinatorProperty("web-ui.preview.enabled", "true")).addCoordinatorProperty("http-server.http.port", "8080")).addCoordinatorProperty("web-ui.authentication.type", "fixed")).addCoordinatorProperty("web-ui.user", "webapp-preview-user")).withProtocolSpooling("json")).build();
        Logger log = Logger.get(WebUiPreviewQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        log.info("\n====\nPreview UI %s/ui/preview\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static final class Builder
    extends DistributedQueryRunner.Builder<Builder> {
        private Map<String, String> connectorProperties = ImmutableMap.of();

        private Builder() {
            super(TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build());
        }

        @CanIgnoreReturnValue
        public Builder withConnectorProperties(Map<String, String> connectorProperties) {
            this.connectorProperties = ImmutableMap.copyOf(connectorProperties);
            return this;
        }

        @Override
        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                queryRunner.createCatalog("tpch", "tpch", this.connectorProperties);
                return queryRunner;
            }
            catch (Exception e) {
                queryRunner.close();
                throw e;
            }
        }
    }
}

