/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.node.NodeInfo;
import io.airlift.tracing.TracingModule;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class TestingTelemetry {
    private final Tracer tracer;
    private final InMemorySpanExporter spanExporter;
    private final ReentrantLock lock = new ReentrantLock();

    private TestingTelemetry(final String name) {
        this.spanExporter = InMemorySpanExporter.create();
        this.tracer = (Tracer)new Bootstrap(new Module[]{new AbstractConfigurationAwareModule(this){
            final /* synthetic */ TestingTelemetry this$0;
            {
                this.this$0 = this$0;
            }

            protected void setup(Binder binder) {
                this.install((Module)new TracingModule(name, "test-version"));
                Multibinder.newSetBinder((Binder)binder, SpanProcessor.class).addBinding().toInstance((Object)SimpleSpanProcessor.create((SpanExporter)this.this$0.spanExporter));
                binder.bind(NodeInfo.class).toInstance((Object)new NodeInfo("development"));
            }
        }}).initialize().getInstance(Tracer.class);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public <R extends Exception> List<SpanData> captureSpans(CheckedRunnable<R> runnable) throws R {
        this.lock.lock();
        this.spanExporter.reset();
        runnable.run();
        ImmutableList spans = ImmutableList.copyOf((Collection)this.spanExporter.getFinishedSpanItems());
        this.spanExporter.reset();
        this.lock.unlock();
        return spans;
    }

    public void reset() {
        this.spanExporter.reset();
    }

    public static <E extends Exception> void withTracing(Span span, CheckedRunnable<E> supplier) throws E {
        try (Scope scope = span.makeCurrent();){
            supplier.run();
        }
        catch (Throwable t) {
            span.setStatus(StatusCode.ERROR, t.getMessage());
            span.recordException(t, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw t;
        }
        finally {
            span.end();
        }
    }

    public static TestingTelemetry create(String name) {
        return new TestingTelemetry(name);
    }

    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }
}

