/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.ClientSelectedRole;
import io.trino.client.ClientSession;
import io.trino.client.Column;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.security.AccessControl;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.QueryId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.session.ResourceEstimates;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.testing.QueryFailedException;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.ResultsSession;
import io.trino.testing.TestingStatementClientFactory;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import org.intellij.lang.annotations.Language;

public abstract class AbstractTestingTrinoClient<T>
implements Closeable {
    private final TestingTrinoServer trinoServer;
    private final Session defaultSession;
    private final OkHttpClient httpClient;
    private final TestingStatementClientFactory statementClientFactory;

    protected AbstractTestingTrinoClient(TestingTrinoServer trinoServer, Session defaultSession) {
        this(trinoServer, TestingStatementClientFactory.DEFAULT_STATEMENT_FACTORY, defaultSession, new OkHttpClient());
    }

    protected AbstractTestingTrinoClient(TestingTrinoServer trinoServer, TestingStatementClientFactory statementClientFactory, Session defaultSession) {
        this(trinoServer, statementClientFactory, defaultSession, new OkHttpClient());
    }

    protected AbstractTestingTrinoClient(TestingTrinoServer trinoServer, Session defaultSession, OkHttpClient httpClient) {
        this(trinoServer, TestingStatementClientFactory.DEFAULT_STATEMENT_FACTORY, defaultSession, httpClient);
    }

    protected AbstractTestingTrinoClient(TestingTrinoServer trinoServer, TestingStatementClientFactory statementClientFactory, Session defaultSession, OkHttpClient httpClient) {
        this.trinoServer = Objects.requireNonNull(trinoServer, "trinoServer is null");
        this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.statementClientFactory = Objects.requireNonNull(statementClientFactory, "statementClientFactory is null");
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    protected abstract ResultsSession<T> getResultSession(Session var1);

    public ResultWithQueryId<T> execute(@Language(value="SQL") String sql) throws QueryFailedException {
        return this.execute(this.defaultSession, sql);
    }

    public ResultWithQueryId<T> execute(Session session, @Language(value="SQL") String sql) throws QueryFailedException {
        ResultsSession<T> resultsSession = this.getResultSession(session);
        ClientSession clientSession = AbstractTestingTrinoClient.toClientSession(session, this.trinoServer.getBaseUrl(), new Duration(2.0, TimeUnit.MINUTES));
        try (StatementClient client = this.statementClientFactory.create(this.httpClient, session, clientSession, sql);){
            while (client.isRunning()) {
                resultsSession.addResults(client.currentStatusInfo(), client.currentRows());
                client.advance();
            }
            Preconditions.checkState((boolean)client.isFinished());
            QueryStatusInfo results = client.finalStatusInfo();
            QueryId queryId = new QueryId(results.getId());
            if (results.getError() == null) {
                if (results.getUpdateType() != null) {
                    resultsSession.setUpdateType(results.getUpdateType());
                }
                if (results.getUpdateCount() != null) {
                    resultsSession.setUpdateCount(results.getUpdateCount());
                }
                resultsSession.setWarnings(results.getWarnings());
                resultsSession.setStatementStats(results.getStats());
                T result = resultsSession.build(client.getSetSessionProperties(), client.getResetSessionProperties());
                ResultWithQueryId<T> resultWithQueryId = new ResultWithQueryId<T>(queryId, result);
                return resultWithQueryId;
            }
            if (results.getError().getFailureInfo() != null) {
                RuntimeException remoteException = results.getError().getFailureInfo().toException();
                throw new QueryFailedException(queryId, Optional.ofNullable(remoteException.getMessage()).orElseGet(remoteException::toString), (Throwable)remoteException);
            }
            throw new QueryFailedException(queryId, "Query failed: " + results.getError().getMessage());
        }
    }

    private static ClientSession toClientSession(Session session, URI server, Duration clientRequestTimeout) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(session.getSystemProperties());
        for (Map.Entry catalogAndConnectorProperties : session.getCatalogProperties().entrySet()) {
            for (Map.Entry connectorProperties : ((Map)catalogAndConnectorProperties.getValue()).entrySet()) {
                String catalogName = (String)catalogAndConnectorProperties.getKey();
                properties.put((Object)(catalogName + "." + (String)connectorProperties.getKey()), (Object)((String)connectorProperties.getValue()));
            }
        }
        ImmutableMap.Builder resourceEstimates = ImmutableMap.builder();
        ResourceEstimates estimates = session.getResourceEstimates();
        estimates.getExecutionTime().ifPresent(e -> resourceEstimates.put((Object)"EXECUTION_TIME", (Object)e.toString()));
        estimates.getCpuTime().ifPresent(e -> resourceEstimates.put((Object)"CPU_TIME", (Object)e.toString()));
        estimates.getPeakMemoryBytes().ifPresent(e -> resourceEstimates.put((Object)"PEAK_MEMORY", (Object)e.toString()));
        return ClientSession.builder().server(server).user(Optional.of(session.getIdentity().getUser())).source(session.getSource().orElse("test")).traceToken(session.getTraceToken()).clientTags(session.getClientTags()).clientInfo((String)session.getClientInfo().orElse(null)).catalog((String)session.getCatalog().orElse(null)).schema((String)session.getSchema().orElse(null)).path(Splitter.on((String)",").splitToList((CharSequence)session.getPath().getRawPath())).timeZone(session.getTimeZoneKey().getZoneId()).locale(session.getLocale()).resourceEstimates((Map)resourceEstimates.buildOrThrow()).properties((Map)properties.buildOrThrow()).preparedStatements(session.getPreparedStatements()).roles(AbstractTestingTrinoClient.getRoles(session)).credentials(session.getIdentity().getExtraCredentials()).transactionId((String)session.getTransactionId().map(Object::toString).orElse(null)).clientRequestTimeout(clientRequestTimeout).compressionDisabled(true).build();
    }

    private static Map<String, ClientSelectedRole> getRoles(Session session) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        session.getIdentity().getEnabledRoles().forEach(role -> builder.put((Object)"system", (Object)AbstractTestingTrinoClient.toClientSelectedRole(new SelectedRole(SelectedRole.Type.ROLE, Optional.of(role)))));
        session.getIdentity().getCatalogRoles().forEach((key, value) -> builder.put(key, (Object)AbstractTestingTrinoClient.toClientSelectedRole(value)));
        return builder.buildOrThrow();
    }

    private static ClientSelectedRole toClientSelectedRole(SelectedRole value) {
        return new ClientSelectedRole(ClientSelectedRole.Type.valueOf((String)value.getType().toString()), value.getRole());
    }

    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        return this.inTransaction(session, transactionSession -> this.trinoServer.getPlannerContext().getMetadata().listTables(transactionSession, new QualifiedTablePrefix(catalog, schema)));
    }

    public boolean tableExists(Session session, String table) {
        return this.inTransaction(session, transactionSession -> MetadataUtil.tableExists((Metadata)this.trinoServer.getPlannerContext().getMetadata(), (Session)transactionSession, (String)table));
    }

    private <V> V inTransaction(Session session, Function<Session, V> callback) {
        return (V)TransactionBuilder.transaction((TransactionManager)this.trinoServer.getTransactionManager(), (Metadata)this.trinoServer.getPlannerContext().getMetadata(), (AccessControl)this.trinoServer.getAccessControl()).readOnly().singleStatement().execute(session, callback);
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public TestingTrinoServer getServer() {
        return this.trinoServer;
    }

    protected List<Type> getTypes(List<Column> columns) {
        return (List)columns.stream().map(Column::getType).map(arg_0 -> ((TypeManager)this.trinoServer.getPlannerContext().getTypeManager()).fromSqlType(arg_0)).collect(ImmutableList.toImmutableList());
    }

    protected List<String> getNames(List<Column> columns) {
        return (List)columns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
    }
}

