/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.cost.StatsAndCosts;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.security.Identity;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import io.trino.tpch.TpchTable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ThrowingConsumer;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class BaseConnectorTest
extends AbstractTestQueries {
    private static final Logger log = Logger.get(BaseConnectorTest.class);
    protected static final List<TpchTable<?>> REQUIRED_TPCH_TABLES = ImmutableSet.builder().addAll(AbstractTestQueries.REQUIRED_TPCH_TABLES).add((Object)TpchTable.CUSTOMER).build().asList();
    private final ConcurrentMap<String, Function<ConnectorSession, List<String>>> mockTableListings = new ConcurrentHashMap<String, Function<ConnectorSession, List<String>>>();

    @BeforeAll
    public void initMockCatalog() {
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.installPlugin((Plugin)this.buildMockConnectorPlugin());
        queryRunner.createCatalog("mock_dynamic_listing", "mock", Map.of());
    }

    protected MockConnectorPlugin buildMockConnectorPlugin() {
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.copyOf(this.mockTableListings.keySet())).withListTables((session, schemaName) -> (List)((Function)Verify.verifyNotNull((Object)((Function)this.mockTableListings.get(schemaName)), (String)"No listing function registered for [%s]", (Object[])new Object[]{schemaName})).apply(session)).build();
        return new MockConnectorPlugin((ConnectorFactory)connectorFactory);
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    @Override
    @Test
    public void ensureTestNamingConvention() {
        Assertions.assertThat((String)this.getClass().getName()).endsWith((CharSequence)"ConnectorTest");
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testShowCreateSchema() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).isEqualTo(String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test_schema_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            this.assertQueryFails(this.createSchemaSql(schemaName), "This connector does not support creating schemas");
            return;
        }
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{schemaName});
        this.assertUpdate(this.createSchemaSql(schemaName));
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).startsWith((CharSequence)String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
        this.assertQueryFails(this.createSchemaSql(schemaName), String.format("line 1:1: Schema '.*\\.%s' already exists", schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
        this.assertQueryFails("DROP SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' does not exist", schemaName));
    }

    @Test
    public void testDropNonEmptySchemaWithTable() {
        String schemaName = "test_drop_non_empty_schema_table_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("CREATE TABLE " + schemaName + ".t(x int)");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + schemaName + ".t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testDropNonEmptySchemaWithView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        String schemaName = "test_drop_non_empty_schema_view_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("CREATE VIEW " + schemaName + ".v_t  AS SELECT 123 x");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP VIEW IF EXISTS " + schemaName + ".v_t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testDropNonEmptySchemaWithMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        String schemaName = "test_drop_non_empty_schema_mv_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("CREATE MATERIALIZED VIEW " + schemaName + ".mv_t  AS SELECT 123 x");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW IF EXISTS " + schemaName + ".mv_t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testColumnsInReverseOrder() {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM orders");
    }

    @Test
    public void testCharVarcharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS char(3))),    (3, CAST('   ' AS char(3))),   (6, CAST('x  ' AS char(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(2))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(4))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))", "VALUES (6, 'x  ')");
        }
    }

    @Test
    public void testVarcharCharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_varchar_char", "(k, v) AS VALUES   (-1, CAST(NULL AS varchar(3))),    (0, CAST('' AS varchar(3))),   (1, CAST(' ' AS varchar(3))),    (2, CAST('  ' AS varchar(3))),    (3, CAST('   ' AS varchar(3))),   (4, CAST('x' AS varchar(3))),   (5, CAST('x ' AS varchar(3))),   (6, CAST('x  ' AS varchar(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS char(2))", "VALUES (0, ''), (1, ' '), (2, '  '), (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS char(2))", "VALUES (4, 'x'), (5, 'x '), (6, 'x  ')");
        }
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(orderkey) FROM orders");
        this.assertQuery("SELECT sum(totalprice) FROM orders");
        this.assertQuery("SELECT max(comment) FROM nation");
        this.assertQuery("SELECT count(*) FROM orders");
        this.assertQuery("SELECT count(*) FROM orders WHERE orderkey > 10");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders LIMIT 10)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders WHERE orderkey > 10 LIMIT 10)");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation");
        this.assertQuery("SELECT regionkey FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT regionkey, nationkey FROM nation GROUP BY GROUPING SETS ((regionkey), (nationkey))", "SELECT NULL, nationkey FROM nation UNION ALL SELECT DISTINCT regionkey, NULL FROM nation");
        this.assertQuery("SELECT regionkey, nationkey, count(*) FROM nation GROUP BY GROUPING SETS ((), (regionkey), (nationkey), (regionkey, nationkey))", "SELECT NULL, NULL, count(*) FROM nation UNION ALL SELECT NULL, nationkey, 1 FROM nation UNION ALL SELECT regionkey, NULL, count(*) FROM nation GROUP BY regionkey UNION ALL SELECT regionkey, nationkey, 1 FROM nation");
        this.assertQuery("SELECT count(regionkey) FROM nation");
        this.assertQuery("SELECT count(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT min(regionkey), max(regionkey) FROM nation");
        this.assertQuery("SELECT min(DISTINCT regionkey), max(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, min(regionkey), min(name), max(regionkey), max(name) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, sum(regionkey) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT avg(nationkey) FROM nation", "SELECT avg(CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT avg(DISTINCT nationkey) FROM nation", "SELECT avg(DISTINCT CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey", "SELECT regionkey, avg(CAST(nationkey AS double)) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT -13 FROM (SELECT count(*) FROM nation)", "VALUES -13");
        this.assertQuery("SELECT count(*) FROM (SELECT count(*) FROM nation UNION ALL SELECT count(*) FROM region)", "VALUES 2");
        this.assertQuery("SELECT count(*) FROM nation HAVING count(*) = 25");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY regionkey HAVING count(*) = 5");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY GROUPING SETS ((), (regionkey)) HAVING count(*) IN (5, 25)", "(SELECT NULL, count(*) FROM nation) UNION ALL (SELECT regionkey, count(*) FROM nation GROUP BY regionkey)");
    }

    @Test
    public void testExactPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32", "VALUES (1301)");
    }

    @Test
    public void testInListPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IN (10, 11, 20, 21)");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392, 7), (1301, 32), (670, 33)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392), (1301), (670)");
    }

    @Test
    public void testIsNullPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IS NULL");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10 OR orderkey IS NULL");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301)");
    }

    @Test
    public void testLikePredicate() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L__'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L__'");
    }

    @Test
    public void testMultipleRangesPredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testRangePredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testDateYearOfEraPredicate() {
        this.assertQuery("SELECT orderdate FROM orders WHERE orderdate = DATE '1997-09-14'", "VALUES DATE '1997-09-14'");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderdate = DATE '-1996-09-14'");
    }

    @Test
    public void testPredicateReflectedInExplain() {
        this.assertExplain("EXPLAIN SELECT name FROM nation WHERE nationkey = 42", "(predicate|filterPredicate|constraint).{0,10}(nationkey|NATIONKEY)");
    }

    @Test
    public void testSortItemsReflectedInExplain() {
        String expectedPattern = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN) ? "sortOrder=\\[(?i:nationkey):.* DESC NULLS LAST] limit=5" : "\\[count = 5, orderBy = \\[(?i:nationkey) DESC NULLS LAST]]";
        this.assertExplain("EXPLAIN SELECT name FROM nation ORDER BY nationkey DESC NULLS LAST LIMIT 5", expectedPattern);
    }

    @Test
    public void testVarcharCastToDateInPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "varchar_as_date_pred", "(a varchar)", List.of("'999-09-09'", "'1005-09-09'", "'2005-06-06'", "'2005-06-6'", "'2005-6-06'", "'2005-6-6'", "' 2005-06-06'", "'2005-06-06 '", "' +2005-06-06'", "'02005-06-06'", "'2005-09-06'", "'2005-09-6'", "'2005-9-06'", "'2005-9-6'", "' 2005-09-06'", "'2005-09-06 '", "' +2005-09-06'", "'02005-09-06'", "'2005-09-09'", "'2005-09-9'", "'2005-9-09'", "'2005-9-9'", "' 2005-09-09'", "'2005-09-09 '", "' +2005-09-09'", "'02005-09-09'", "'2005-09-10'", "'2005-9-10'", "' 2005-09-10'", "'2005-09-10 '", "' +2005-09-10'", "'02005-09-10'", "'2005-09-20'", "'2005-9-20'", "' 2005-09-20'", "'2005-09-20 '", "' +2005-09-20'", "'02005-09-20'", "'9999-09-09'", "'99999-09-09'"));){
            for (String date : List.of("2005-09-06", "2005-09-09", "2005-09-10")) {
                for (String operator : List.of("=", "<=", "<", ">", ">=", "!=", "IS DISTINCT FROM", "IS NOT DISTINCT FROM")) {
                    ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a FROM %s WHERE CAST(a AS date) %s DATE '%s'".formatted(table.getName(), operator, date)))).hasCorrectResultsRegardlessOfPushdown();
                }
            }
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "varchar_as_date_pred", "(a varchar)", List.of("'2005-06-bad-date'", "'2005-09-10'"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a FROM %s WHERE CAST(a AS date) < DATE '2005-09-10'".formatted(table.getName())))).failure().hasMessage("Value cannot be cast to date: 2005-06-bad-date");
            BaseConnectorTest.verifyResultOrFailure(this.query("SELECT a FROM %s WHERE CAST(a AS date) = DATE '2005-09-10'".formatted(table.getName())), queryAssert -> queryAssert.skippingTypesCheck().matches("VALUES '2005-09-10'"), failureAssert -> failureAssert.hasMessage("Value cannot be cast to date: 2005-06-bad-date"));
            BaseConnectorTest.verifyResultOrFailure(this.query("SELECT a FROM %s WHERE CAST(a AS date) != DATE '2005-9-1'".formatted(table.getName())), queryAssert -> queryAssert.skippingTypesCheck().matches("VALUES '2005-09-10'"), failureAssert -> failureAssert.hasMessage("Value cannot be cast to date: 2005-06-bad-date"));
            BaseConnectorTest.verifyResultOrFailure(this.query("SELECT a FROM %s WHERE CAST(a AS date) > DATE '2022-08-10'".formatted(table.getName())), queryAssert -> queryAssert.skippingTypesCheck().returnsEmptyResult(), failureAssert -> failureAssert.hasMessage("Value cannot be cast to date: 2005-06-bad-date"));
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "varchar_as_date_pred", "(a varchar)", List.of("'2005-09-10'"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a FROM %s WHERE CAST(a AS date) != DATE '2005-09-01'".formatted(table.getName())))).skippingTypesCheck().matches("VALUES '2005-09-10'");
        }
        finally {
            table.close();
        }
    }

    private static void verifyResultOrFailure(AssertProvider<QueryAssertions.QueryAssert> queryAssertProvider, Consumer<QueryAssertions.QueryAssert> verifyResults, Consumer<TrinoExceptionAssert> verifyFailure) {
        Objects.requireNonNull(verifyResults, "verifyResults is null");
        Objects.requireNonNull(verifyFailure, "verifyFailure is null");
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat(queryAssertProvider);
        try {
            QueryAssertions.ResultAssert resultAssert = queryAssert.result();
        }
        catch (Throwable t) {
            verifyFailure.accept(queryAssert.failure());
            return;
        }
        verifyResults.accept(queryAssert);
    }

    @Test
    public void testConcurrentScans() {
        String unionMultipleTimes = String.join((CharSequence)" UNION ALL ", Collections.nCopies(25, "SELECT * FROM orders"));
        this.assertQuery("SELECT sum(if(rand() >= 0, orderkey)) FROM (" + unionMultipleTimes + ")", "VALUES 11246812500");
    }

    @Test
    public void testSelectAll() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test
    public void testSelectInTransaction() {
        this.inTransaction(session -> {
            this.assertQuery((Session)session, "SELECT nationkey, name, regionkey FROM nation");
            this.assertQuery((Session)session, "SELECT regionkey, name FROM region");
            this.assertQuery((Session)session, "SELECT nationkey, name, regionkey FROM nation");
        });
    }

    @Test
    public void testSelectVersionOfNonExistentTable() {
        String tableName = "foo_" + TestingNames.randomNameSuffix();
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2021-03-01 00:00:01'"))).failure().hasMessageMatching("line 1:15: Table '%s.%s.%s' does not exist|This connector does not support versioned tables".formatted(catalog, schema, tableName));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF 'version1'"))).failure().hasMessageMatching("line 1:15: Table '%s.%s.%s' does not exist|This connector does not support versioned tables".formatted(catalog, schema, tableName));
    }

    @Test
    public void testTrySelectTableVersion() {
        this.testTrySelectTableVersion("SELECT * FROM nation FOR TIMESTAMP AS OF DATE '2005-09-10'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR TIMESTAMP AS OF TIMESTAMP '2005-09-10 13:00:00'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR TIMESTAMP AS OF TIMESTAMP '2005-09-10 13:00:00 Europe/Warsaw'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TINYINT '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF SMALLINT '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF 123");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF BIGINT '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF REAL '123.123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF DOUBLE '123.123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF DECIMAL '123.123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF CHAR 'abc'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF CAST('abc' AS varchar(5))");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF CAST('abc' AS varchar)");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF DATE '2005-09-10'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TIME '13:00:00'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TIMESTAMP '2005-09-10 13:00:00'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TIMESTAMP '2005-09-10 13:00:00 Europe/Warsaw'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF JSON '{}'");
    }

    private void testTrySelectTableVersion(@Language(value="SQL") String query) {
        try {
            this.computeActual(query);
        }
        catch (Exception somewhatExpected) {
            this.verifyVersionedQueryFailurePermissible(QueryAssertions.getTrinoExceptionCause(somewhatExpected));
        }
    }

    protected void verifyVersionedQueryFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessageContaining("This connector does not support versioned tables");
    }

    @Test
    public void testJoinWithEmptySides() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            Session session = this.noJoinReordering(joinDistributionType);
            this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
            this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
            this.assertQuery(session, "SELECT count(*) FROM region JOIN nation ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
            this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
        }
    }

    @Test
    public void testJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("ignore_stats_calculator_failures", "false").build();
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey WHERE n.name = 'ARGENTINA'");
        this.assertQuery(session, "SELECT c.name, n.name, n.count, r.name FROM (SELECT name, regionkey, nationkey, count(*) count FROM nation GROUP BY name, regionkey, nationkey) n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
    }

    @Test
    public void testDescribeTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE orders"))).result().matches(this.getDescribeOrdersResult());
    }

    protected MaterializedResult getDescribeOrdersResult() {
        return MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
    }

    @Test
    public void testShowInformationSchemaTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES FROM information_schema"))).skippingTypesCheck().containsAll("VALUES 'applicable_roles', 'columns', 'enabled_roles', 'roles', 'schemata', 'table_privileges', 'tables', 'views'");
    }

    @Test
    public void testView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            this.assertQueryFails("CREATE VIEW nation_v AS SELECT * FROM nation", "This connector does not support creating views");
            return;
        }
        String query = "SELECT orderkey, orderstatus, (totalprice / 2) half FROM orders";
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String testView = "test_view_" + TestingNames.randomNameSuffix();
        String testViewWithComment = "test_view_with_comment_" + TestingNames.randomNameSuffix();
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{testView});
        this.assertUpdate("CREATE VIEW " + testView + " AS SELECT 123 x");
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{testView});
        this.assertUpdate("CREATE OR REPLACE VIEW " + testView + " AS " + query);
        this.assertUpdate("CREATE VIEW " + testViewWithComment + " COMMENT 'orders' AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testViewWithComment + " COMMENT 'orders' AS " + query);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE VIEW " + testViewWithComment))).contains(new CharSequence[]{"COMMENT 'orders'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', null), ('" + testViewWithComment + "', 'orders')");
        this.assertQuery("SELECT * FROM " + testView, query);
        this.assertQuery("SELECT * FROM " + testViewWithComment, query);
        this.assertQuery("SELECT * FROM " + testView + " a JOIN " + testView + " b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM " + testView, query);
        String name = String.format("%s.%s." + testView, catalogName, schemaName);
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertUpdate("DROP VIEW " + testViewWithComment);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, regexp_replace(view_definition, '\\s', '') FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', '" + query.replaceAll("\\s", "") + "')");
        this.assertQuery("SELECT table_name, regexp_replace(view_definition, '\\s', '') FROM information_schema.views WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'", "VALUES ('" + testView + "', '" + query.replaceAll("\\s", "") + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + testView + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', 'VIEW')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'", "VALUES ('" + testView + "', 'VIEW')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + schemaName + "', '" + testView + "', 'VIEW')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + catalogName + "' AND table_schem = '" + schemaName + "' AND table_name = '" + testView + "'", "VALUES ('" + schemaName + "', '" + testView + "', 'VIEW')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + testView))).result().projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'orderkey', 'orderstatus', 'half'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + testView))).result().projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'orderkey', 'orderstatus', 'half'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + testView + "') CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + testView + "') CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + testView + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + schemaName + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + testView + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        this.assertUpdate("DROP VIEW " + testView);
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{testView});
    }

    @Test
    public void testCreateViewSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String viewName = "test_view_create_no_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertQueryFails(String.format("CREATE VIEW %s.%s AS SELECT 1 AS c1", schemaName, viewName), String.format("Schema %s not found", schemaName));
            this.assertQueryFails(String.format("CREATE OR REPLACE VIEW %s.%s AS SELECT 1 AS c1", schemaName, viewName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP VIEW IF EXISTS %s.%s", schemaName, viewName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP VIEW IF EXISTS %s.%s", schemaName, viewName));
    }

    @Test
    public void testViewCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String upperCaseView = "test_view_uppercase_" + TestingNames.randomNameSuffix();
        String mixedCaseView = "test_view_mixedcase_" + TestingNames.randomNameSuffix();
        this.computeActual("CREATE VIEW " + upperCaseView + " AS SELECT X FROM (SELECT 123 X)");
        this.computeActual("CREATE VIEW " + mixedCaseView + " AS SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertQuery("SELECT * FROM " + upperCaseView, "SELECT X FROM (SELECT 123 X)");
        this.assertQuery("SELECT * FROM " + mixedCaseView, "SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertUpdate("DROP VIEW " + upperCaseView);
        this.assertUpdate("DROP VIEW " + mixedCaseView);
    }

    @Test
    public void testMaterializedView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW nation_mv AS SELECT * FROM nation", "This connector does not support creating materialized views");
            return;
        }
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String otherSchema = "other_schema" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(otherSchema));
        QualifiedObjectName view = new QualifiedObjectName(catalog, schema, "test_materialized_view_" + TestingNames.randomNameSuffix());
        QualifiedObjectName otherView = new QualifiedObjectName(catalog, otherSchema, "test_materialized_view_" + TestingNames.randomNameSuffix());
        QualifiedObjectName viewWithComment = new QualifiedObjectName(catalog, schema, "test_materialized_view_with_comment_" + TestingNames.randomNameSuffix());
        this.createTestingMaterializedView(view, Optional.empty());
        this.createTestingMaterializedView(otherView, Optional.of("sarcastic comment"));
        this.createTestingMaterializedView(viewWithComment, Optional.of("mv_comment"));
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + String.valueOf(viewWithComment)))).contains(new CharSequence[]{"COMMENT 'mv_comment'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + view.catalogName() + "' AND schema_name = '" + view.schemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.objectName() + "', null), ('" + viewWithComment.objectName() + "', 'mv_comment')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + String.valueOf(view)))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + String.valueOf(viewWithComment)))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + view.objectName() + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.schemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.objectName() + "', 'BASE TABLE')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.schemaName() + "' and table_name = '" + view.objectName() + "'", "VALUES ('" + view.objectName() + "', 'BASE TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + view.schemaName() + "', '" + view.objectName() + "', 'TABLE')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + view.catalogName() + "' AND table_schem = '" + view.schemaName() + "' AND table_name = '" + view.objectName() + "'", "VALUES ('" + view.schemaName() + "', '" + view.objectName() + "', 'TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + view.objectName()))).result().projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + view.objectName()))).result().projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.schemaName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.objectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.schemaName() + "' and table_name = '" + view.objectName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.objectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        Assertions.assertThat((Collection)this.computeActual("SELECT table_name FROM information_schema.views WHERE table_schema = '" + view.schemaName() + "'").getOnlyColumnAsSet()).doesNotContain(new Object[]{view.objectName()});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + view.schemaName() + "' AND table_name = '" + view.objectName() + "'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT name FROM system.metadata.materialized_views WHERE catalog_name = '" + catalog + "' AND schema_name = '" + view.schemaName() + "'"))).containsAll("VALUES VARCHAR '" + view.objectName() + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.schemaName() + "', '" + view.objectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + view.schemaName() + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.schemaName() + "', '" + view.objectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + view.objectName() + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.schemaName() + "', '" + view.objectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + view.objectName()))).matches((CharSequence)("(?s)CREATE MATERIALIZED VIEW \\Q" + String.valueOf(view) + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP MATERIALIZED VIEW " + String.valueOf(viewWithComment));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.catalogName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRows(view, otherView));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + otherView.catalogName() + "'", "schema_name = '" + otherView.schemaName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(otherView, "sarcastic comment"));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.catalogName() + "'", "schema_name = '" + view.schemaName() + "'", "name = '" + view.objectName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("schema_name LIKE '%" + view.schemaName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("name LIKE '%" + view.objectName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, "REFRESH MATERIALIZED VIEW " + String.valueOf(view)))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
        this.assertUpdate("DROP MATERIALIZED VIEW " + String.valueOf(view));
        this.assertUpdate("DROP MATERIALIZED VIEW " + String.valueOf(otherView));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + view.objectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + otherView.objectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + viewWithComment.objectName() + "'"));
        this.assertUpdate("DROP SCHEMA " + otherSchema);
    }

    @Test
    public void testMaterializedViewAllTypes() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String viewName = "test_mv_all_types_" + TestingNames.randomNameSuffix();
        String values = "SELECT\n    true a_boolean,\n    TINYINT '67' a_tinyint,\n    SMALLINT '35' a_smallint,\n    INTEGER '-1546831166' an_integer,\n    1544323431676534245 a_bigint,\n    REAL '12345.67' a_real,\n    DOUBLE '12345.678901234' a_double,\n    CAST('1234567.8901' AS decimal(11, 4)) a_short_decimal,\n    CAST('1234567890123456789.0123456' AS decimal(26, 7)) a_long_decimal,\n    CHAR 'few chars  ' a_char,\n    CAST('some string' AS varchar(33)) a_bounded_varchar,\n    CAST('some longer string' AS varchar) an_unbounded_varchar,\n    X'65683F' a_varbinary,\n    DATE '2005-09-10' a_date,\n    TIME '13:00:00' a_time_seconds,\n    TIME '13:00:00.123' a_time_millis,\n    TIME '13:00:00.123456' a_time_micros,\n    TIME '13:00:00.123456789' a_time_nanos,\n    TIME '13:00:00 +02:00' a_time_tz__seconds,\n    TIME '13:00:00.123 +02:00' a_time_tz__millis,\n    TIME '13:00:00.123456 +02:00' a_time_tz__micros,\n    TIME '13:00:00.123456789 +02:00' a_time_tz__nanos,\n    TIMESTAMP '2005-09-10 13:00:00' a_timestamp_seconds,\n    TIMESTAMP '2005-09-10 13:00:00.123' a_timestamp_millis,\n    TIMESTAMP '2005-09-10 13:00:00.123456' a_timestamp_micros,\n    TIMESTAMP '2005-09-10 13:00:00.123456789' a_timestamp_nanos,\n    TIMESTAMP '2005-09-10 13:00:00 Europe/Warsaw' a_timestamp_tz_seconds,\n    TIMESTAMP '2005-09-10 13:00:00.123 Europe/Warsaw' a_timestamp_tz_millis,\n    TIMESTAMP '2005-09-10 13:00:00.123456 Europe/Warsaw' a_timestamp_tz_micros,\n    TIMESTAMP '2005-09-10 13:00:00.123456789 Europe/Warsaw' a_timestamp_tz_nanos,\n    UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59' a_uuid,\n    ARRAY[TIMESTAMP '2005-09-10 13:00:00.123456789'] an_array_of_timestamp_nanos,\n    map(ARRAY['key'], ARRAY[TIMESTAMP '2005-09-10 13:00:00.123456789']) a_map_with_timestamp_nanos,\n    CAST(ROW(TIMESTAMP '2005-09-10 13:00:00.123456789') AS ROW(key timestamp(9))) a_row_with_timestamp_nanos,\n  'a dummy' a_dummy";
        this.assertUpdate("CREATE MATERIALIZED VIEW %s AS %s".formatted(viewName, values));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + viewName))).matches(values);
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + viewName))).matches(values);
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    @Test
    public void testMaterializedViewGracePeriod() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String viewName = "test_mv_grace_period_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW_GRACE_PERIOD)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW " + viewName + " GRACE PERIOD INTERVAL '1' HOUR AS SELECT * FROM nation", "line 1:1: Catalog '%s' does support not GRACE PERIOD".formatted(catalog));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_base_table", "AS TABLE region");){
            Session defaultSession = this.getSession();
            Session futureSession = Session.builder((Session)defaultSession).setSystemProperty("testing_session_time", Instant.now().plus(1L, ChronoUnit.DAYS).toString()).build();
            PlanMatchPattern readFromBaseTables = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ProjectNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)table.getName())})})})})});
            PlanMatchPattern readFromStorageTable = PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " GRACE PERIOD INTERVAL '1' HOUR AS SELECT DISTINCT regionkey, format('%s', name) name FROM " + table.getName());
            String initialResults = "SELECT DISTINCT regionkey, CAST(name AS varchar) FROM region";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.STALE);
            Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 5L);
            ZonedDateTime afterRefresh = ZonedDateTime.now();
            boolean supportsFresh = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MATERIALIZED_VIEW_FRESHNESS_FROM_BASE_TABLES);
            if (supportsFresh) {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.FRESH);
                Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            } else {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
                ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(supportsFresh ? readFromStorageTable : readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeModification = ZonedDateTime.now();
            this.assertUpdate("INSERT INTO " + table.getName() + " (regionkey, name) VALUES (42, 'foo new region')", 1L);
            ZonedDateTime afterModification = ZonedDateTime.now();
            String updatedResults = initialResults + " UNION ALL VALUES (42, 'foo new region')";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)(supportsFresh ? MaterializedViewFreshness.Freshness.STALE : MaterializedViewFreshness.Freshness.UNKNOWN));
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(supportsFresh ? beforeModification : beforeRefresh, supportsFresh ? afterModification : afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(updatedResults);
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 6L);
            if (supportsFresh) {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.FRESH);
                Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            } else {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(supportsFresh ? readFromStorageTable : readFromBaseTables).matches(updatedResults);
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        }
    }

    @Test
    public void testFederatedMaterializedView() {
        String viewName = "test_federated_mv_" + TestingNames.randomNameSuffix();
        String mockSchemaForListing = "mock_schema_for_listing_" + TestingNames.randomNameSuffix();
        String query = "SELECT table_name, count(*) AS c FROM mock_dynamic_listing.information_schema.tables WHERE table_schema = '" + mockSchemaForListing + "' GROUP BY table_name";
        String create = "CREATE MATERIALIZED VIEW " + viewName + " AS " + query;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_FEDERATED_MATERIALIZED_VIEW)) {
            this.assertQueryFails(create, "This connector does not support creating materialized views");
            return;
        }
        Session defaultSession = this.getSession();
        Session futureSession = Session.builder((Session)defaultSession).setSystemProperty("testing_session_time", Instant.now().plus(1L, ChronoUnit.DAYS).toString()).build();
        PlanMatchPattern readFromBaseTables = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"tables")})})})})});
        PlanMatchPattern readFromStorageTable = PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
        AtomicReference<List<String>> mockListing = new AtomicReference<List<String>>(List.of("first_table"));
        String initialResults = "VALUES (VARCHAR 'first_table', BIGINT '1')";
        this.withMockTableListing(mockSchemaForListing, connectorSession -> List.copyOf((Collection)mockListing.get()), () -> {
            this.assertUpdate(create);
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.STALE);
            Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
            ZonedDateTime afterRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            mockListing.set(List.of("first_table", "second_table"));
            String updatedResults = "VALUES (VARCHAR 'first_table', BIGINT '1'), ('second_table', 1)";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ZonedDateTime beforeSecondRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 2L);
            ZonedDateTime afterSecondRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeSecondRefresh, afterSecondRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        });
    }

    @Test
    public void testFederatedMaterializedViewWithGracePeriod() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_FEDERATED_MATERIALIZED_VIEW));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String viewName = "test_federated_mv_grace_period_" + TestingNames.randomNameSuffix();
        String mockSchemaForListing = "mock_schema_for_listing_" + TestingNames.randomNameSuffix();
        String query = "SELECT table_name, count(*) AS c FROM mock_dynamic_listing.information_schema.tables WHERE table_schema = '" + mockSchemaForListing + "' GROUP BY table_name";
        Session defaultSession = this.getSession();
        Session futureSession = Session.builder((Session)defaultSession).setSystemProperty("testing_session_time", Instant.now().plus(1L, ChronoUnit.DAYS).toString()).build();
        PlanMatchPattern readFromBaseTables = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"tables")})})})})});
        PlanMatchPattern readFromStorageTable = PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
        AtomicReference<List<String>> mockListing = new AtomicReference<List<String>>(List.of("first_table"));
        String initialResults = "VALUES (VARCHAR 'first_table', BIGINT '1')";
        this.withMockTableListing(mockSchemaForListing, connectorSession -> List.copyOf((Collection)mockListing.get()), () -> {
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " GRACE PERIOD INTERVAL '1' HOUR  AS " + query);
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.STALE);
            Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
            ZonedDateTime afterRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            mockListing.set(List.of("first_table", "second_table"));
            String updatedResults = "VALUES (VARCHAR 'first_table', BIGINT '1'), ('second_table', 1)";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(updatedResults);
            ZonedDateTime beforeSecondRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 2L);
            ZonedDateTime afterSecondRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeSecondRefresh, afterSecondRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(updatedResults);
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        });
    }

    @Test
    public void testMaterializedViewBaseTableGone() {
        this.testMaterializedViewBaseTableGone(true);
        this.testMaterializedViewBaseTableGone(false);
    }

    private void testMaterializedViewBaseTableGone(boolean initialized) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String viewName = "mv_base_table_missing_" + TestingNames.randomNameSuffix();
        String baseTable = "mv_base_table_missing_the_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + baseTable + " AS SELECT 1 a", 1L);
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM " + baseTable);
        if (initialized) {
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        }
        this.assertUpdate("DROP TABLE " + baseTable);
        this.assertQueryFails("TABLE " + viewName, "line 1:1: Failed analyzing stored view '%1$s\\.%2$s\\.%3$s': line 3:3: Table '%1$s\\.%2$s\\.%4$s' does not exist".formatted(catalog, schema, viewName, baseTable));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    private MaterializedViewFreshness.Freshness getMaterializedViewFreshness(String materializedViewName) {
        String freshness = (String)this.computeScalar("SELECT freshness FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + materializedViewName + "'");
        return MaterializedViewFreshness.Freshness.valueOf((String)freshness);
    }

    private Optional<ZonedDateTime> getMaterializedViewLastFreshTime(String materializedViewName) {
        ZonedDateTime lastFreshTime = (ZonedDateTime)this.computeScalar("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + materializedViewName + "'");
        return Optional.ofNullable(lastFreshTime);
    }

    @Test
    public void testColumnCommentMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String viewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_MATERIALIZED_VIEW_COLUMN)) {
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM nation");
            this.assertQueryFails("COMMENT ON COLUMN " + viewName + ".regionkey IS 'new region key comment'", "This connector does not support setting materialized view column comments");
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
            return;
        }
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM nation");
        try {
            this.assertUpdate("COMMENT ON COLUMN " + viewName + ".name IS 'new comment'");
            Assertions.assertThat((String)this.getColumnComment(viewName, "name")).isEqualTo("new comment");
            this.assertUpdate("COMMENT ON COLUMN " + viewName + ".name IS NULL");
            Assertions.assertThat((String)this.getColumnComment(viewName, "name")).isEqualTo(null);
            this.assertUpdate("COMMENT ON COLUMN " + viewName + ".name IS 'updated comment'");
            Assertions.assertThat((String)this.getColumnComment(viewName, "name")).isEqualTo("updated comment");
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 25L);
            Assertions.assertThat((String)this.getColumnComment(viewName, "name")).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON COLUMN " + viewName + ".name IS ''");
            Assertions.assertThat((String)this.getColumnComment(viewName, "name")).isEmpty();
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        }
    }

    @Test
    public void testCompatibleTypeChangeForView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String tableName = "test_table_" + TestingNames.randomNameSuffix();
        String viewName = "test_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abcdefg' a", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT a FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abcdefg'");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abc' a", 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abc'");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCompatibleTypeChangeForView2() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String tableName = "test_table_" + TestingNames.randomNameSuffix();
        String viewName = "test_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '1' v", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT INTEGER '1' v", 1L);
        this.assertQuery("SELECT * FROM " + viewName + " WHERE v = 1", "VALUES 1");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testViewMetadata() {
        this.testViewMetadata("", "DEFINER");
        this.testViewMetadata(" SECURITY DEFINER", "DEFINER");
        this.testViewMetadata(" SECURITY INVOKER", "INVOKER");
    }

    private void testViewMetadata(String securityClauseInCreate, String securityClauseInShowCreate) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String viewName = "meta_test_view_" + TestingNames.randomNameSuffix();
        String query = "SELECT BIGINT '123' x, 'foo' y";
        this.assertUpdate("CREATE VIEW " + viewName + securityClauseInCreate + " AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{viewName, "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{viewName, this.formatSqlText(query)}).build();
        QueryAssertions.assertContains(actual, expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + viewName))).result().matches(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", "", ""}).row(new Object[]{"y", "varchar(3)", "", ""}).build());
        String expectedSql = this.formatSqlText(String.format("CREATE VIEW %s.%s.%s SECURITY %s AS %s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName, securityClauseInShowCreate, query)).trim();
        actual = this.computeActual("SHOW CREATE VIEW " + viewName);
        Assertions.assertThat((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet())).isEqualTo((Object)expectedSql);
        actual = this.computeActual(String.format("SHOW CREATE VIEW %s.%s.%s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName));
        Assertions.assertThat((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet())).isEqualTo((Object)expectedSql);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testShowCreateView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String viewName = "test_show_create_view" + TestingNames.randomNameSuffix();
        this.assertUpdate("DROP VIEW IF EXISTS " + viewName);
        String ddl = String.format("CREATE VIEW %s.%s.%s SECURITY DEFINER AS\nSELECT *\nFROM\n  (\n VALUES \n     ROW (1, 'one')\n   , ROW (2, 't')\n)  t (col1, col2)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName);
        this.assertUpdate(ddl);
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE VIEW " + viewName)).isEqualTo((Object)ddl);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testRenameMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String schema = "rename_mv_test_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getSession()).setSchema(schema).build();
        this.assertUpdate(this.createSchemaSql(schema));
        QualifiedObjectName originalMaterializedView = new QualifiedObjectName((String)session.getCatalog().orElseThrow(), (String)session.getSchema().orElseThrow(), "test_materialized_view_rename_" + TestingNames.randomNameSuffix());
        this.createTestingMaterializedView(originalMaterializedView, Optional.empty());
        String renamedMaterializedView = "test_materialized_view_rename_new_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW)) {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + String.valueOf(originalMaterializedView) + " RENAME TO " + renamedMaterializedView, "This connector does not support renaming materialized views");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + String.valueOf(originalMaterializedView));
            return;
        }
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + String.valueOf(originalMaterializedView) + " RENAME TO " + renamedMaterializedView);
        this.assertTestingMaterializedViewQuery(schema, renamedMaterializedView);
        this.assertQuery(session, "SELECT catalog_name, schema_name FROM system.metadata.materialized_views WHERE name = '" + renamedMaterializedView + "'", String.format("VALUES ('%s', '%s')", originalMaterializedView.catalogName(), originalMaterializedView.schemaName()));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.objectName() + "'"));
        String testExistsMaterializedViewName = "test_materialized_view_rename_exists_" + TestingNames.randomNameSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW IF EXISTS " + renamedMaterializedView + " RENAME TO " + testExistsMaterializedViewName);
        this.assertTestingMaterializedViewQuery(schema, testExistsMaterializedViewName);
        String uppercaseName = "TEST_MATERIALIZED_VIEW_RENAME_UPPERCASE_" + TestingNames.randomNameSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + testExistsMaterializedViewName + " RENAME TO " + uppercaseName);
        this.assertTestingMaterializedViewQuery(schema, uppercaseName.toLowerCase(Locale.ENGLISH));
        String otherSchema = "rename_mv_other_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(otherSchema));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW_ACROSS_SCHEMAS)) {
            this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.objectName());
            this.assertTestingMaterializedViewQuery(otherSchema, originalMaterializedView.objectName());
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + otherSchema + "." + originalMaterializedView.objectName());
        } else {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.objectName(), "Materialized View rename across schemas is not supported");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + uppercaseName);
        }
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(session, originalMaterializedView.toString())).isFalse();
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(session, renamedMaterializedView)).isFalse();
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(session, testExistsMaterializedViewName)).isFalse();
        this.assertUpdate(session, "ALTER TABLE IF EXISTS " + String.valueOf(originalMaterializedView) + " RENAME TO " + renamedMaterializedView);
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.objectName() + "'"));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + renamedMaterializedView + "'"));
    }

    private void assertTestingMaterializedViewQuery(String schema, String materializedViewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + schema + "." + materializedViewName))).skippingTypesCheck().matches("SELECT * FROM nation");
    }

    private void createTestingMaterializedView(QualifiedObjectName view, Optional<String> comment) {
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s %s AS SELECT * FROM nation", view, comment.map(c -> String.format("COMMENT '%s'", c)).orElse("")));
    }

    private String getTestingMaterializedViewsResultRow(QualifiedObjectName materializedView, String comment) {
        return String.format("VALUES ('%s', '%s', '%s', '%s', 'SELECT *\nFROM\n  nation\n')", materializedView.catalogName(), materializedView.schemaName(), materializedView.objectName(), comment);
    }

    private String getTestingMaterializedViewsResultRows(QualifiedObjectName materializedView, QualifiedObjectName otherMaterializedView) {
        String viewDefinitionSql = "SELECT *\nFROM\n  nation\n";
        return String.format("VALUES ('%s', '%s', '%s', '', '%s'),('%s', '%s', '%s', 'sarcastic comment', '%s')", materializedView.catalogName(), materializedView.schemaName(), materializedView.objectName(), viewDefinitionSql, otherMaterializedView.catalogName(), otherMaterializedView.schemaName(), otherMaterializedView.objectName(), viewDefinitionSql);
    }

    private String listMaterializedViewsSql(String ... filterClauses) {
        StringBuilder sql = new StringBuilder("SELECT   catalog_name,   schema_name,   name,   comment,   definition FROM system.metadata.materialized_views WHERE true");
        for (String filterClause : filterClauses) {
            sql.append(" AND ").append(filterClause);
        }
        return sql.toString();
    }

    @Test
    public void testViewAndMaterializedViewTogether() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String regularViewName = "test_views_together_normal_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW " + regularViewName + " AS SELECT * FROM region");
        String materializedViewName = "test_views_together_materialized_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + materializedViewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "' AND table_name IN ('" + regularViewName + "', '" + materializedViewName + "')"))).matches("VALUES VARCHAR '" + regularViewName + "'");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.computeActual("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'").getOnlyColumnAsSet()).contains(new Object[]{regularViewName})).doesNotContain(new Object[]{materializedViewName});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.computeActual("SELECT name FROM system.metadata.materialized_views WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'").getOnlyColumnAsSet()).doesNotContain(new Object[]{regularViewName})).contains(new Object[]{materializedViewName});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + regularViewName))).containsAll("SELECT * FROM region");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + materializedViewName))).containsAll("SELECT * FROM nation");
        this.assertUpdate("DROP VIEW " + regularViewName);
        this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk UNION ALL SELECT sum(orderkey), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW COLUMNS FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN ANALYZE SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW FUNCTIONS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW TABLES", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SCHEMAS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW CATALOGS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SESSION", new String[0]);
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders WHERE orderkey < 0", new String[0]);
    }

    @Test
    public void testTableSampleSystem() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult randomSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (50)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        Assertions.assertThat((int)emptySample.getMaterializedRows().size()).isEqualTo(0);
        Assertions.assertThat((all.getMaterializedRows().size() >= randomSample.getMaterializedRows().size() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testTableSampleWithFiltering() {
        MaterializedResult emptySample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (99) WHERE orderkey BETWEEN 0 AND 0");
        MaterializedResult halfSample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (50) WHERE orderkey BETWEEN 0 AND 9999999999");
        MaterializedResult all = this.computeActual("SELECT orderkey, orderdate FROM orders");
        Assertions.assertThat((int)emptySample.getMaterializedRows().size()).isEqualTo(0);
        Assertions.assertThat((all.getMaterializedRows().size() >= halfSample.getMaterializedRows().size() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testShowCreateTable() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE orders")).isEqualTo((Object)String.format("CREATE TABLE %s.%s.orders (\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)", catalog, schema));
    }

    @Test
    public void testSelectInformationSchemaTables() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll("^.", "_");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "' AND table_name = 'orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schema + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = '" + catalog + "' AND table_schema LIKE '" + schema + "' AND table_name LIKE '%orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.tables WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll(".$", "_");
        String ordersTableWithColumns = this.getOrdersTableWithColumns();
        this.assertQuery("SELECT table_schema FROM information_schema.columns WHERE table_schema = '" + schema + "' GROUP BY table_schema", "VALUES '" + schema + "'");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE table_name = 'orders' GROUP BY table_name", "VALUES 'orders'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'orders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name LIKE '%rders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '_rder_'", ordersTableWithColumns);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '%orders%'"))).skippingTypesCheck().containsAll(ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns");
        this.assertQuery("SELECT DISTINCT table_name, column_name FROM information_schema.columns WHERE table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "'");
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_name LIKE '%'");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.columns WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Language(value="SQL")
    protected String getOrdersTableWithColumns() {
        return "VALUES\n('orders', 'orderkey'),\n('orders', 'custkey'),\n('orders', 'orderstatus'),\n('orders', 'totalprice'),\n('orders', 'orderdate'),\n('orders', 'orderpriority'),\n('orders', 'clerk'),\n('orders', 'shippriority'),\n('orders', 'comment')\n";
    }

    @Test
    public void testShowCreateInformationSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW CREATE SCHEMA information_schema"))).skippingTypesCheck().matches(String.format("VALUES 'CREATE SCHEMA %s.information_schema'", this.getSession().getCatalog().orElseThrow()));
    }

    @Test
    public void testShowCreateInformationSchemaTable() {
        this.assertQueryFails("SHOW CREATE VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a view");
        this.assertQueryFails("SHOW CREATE MATERIALIZED VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a materialized view");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE information_schema.schemata"))).isEqualTo("CREATE TABLE " + (String)this.getSession().getCatalog().orElseThrow() + ".information_schema.schemata (\n   catalog_name varchar,\n   schema_name varchar\n)");
    }

    @Test
    public void testRollback() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        String table = "test_rollback_" + TestingNames.randomNameSuffix();
        this.computeActual(String.format("CREATE TABLE %s (x int)", table));
        Assertions.assertThatThrownBy(() -> this.inTransaction(session -> {
            this.assertUpdate((Session)session, String.format("INSERT INTO %s VALUES (42)", table), 1L);
            throw new RollbackException();
        })).isInstanceOf(RollbackException.class);
        this.assertQuery(String.format("SELECT count(*) FROM %s", table), "SELECT 0");
    }

    @Test
    public void testWriteNotAllowedInTransaction() {
        BaseConnectorTest.skipTestUnless(!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA, "CREATE SCHEMA write_not_allowed");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "CREATE TABLE write_not_allowed (x int)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "DROP TABLE region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA, "CREATE TABLE write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, "CREATE VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, "CREATE MATERIALIZED VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE, "ALTER TABLE region RENAME TO region_name");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_INSERT, "INSERT INTO region (regionkey) VALUES (123)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_DELETE, "DELETE FROM region WHERE regionkey = 123");
    }

    protected void assertWriteNotAllowedInTransaction(TestingConnectorBehavior behavior, @Language(value="SQL") String sql) {
        if (this.hasBehavior(behavior)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, sql))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
    }

    @Test
    public void testRenameSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA)) {
            String schemaName = (String)this.getSession().getSchema().orElseThrow();
            this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", schemaName, schemaName + TestingNames.randomNameSuffix()), "This connector does not support renaming schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            Assumptions.abort((String)"Skipping as connector does not support CREATE SCHEMA");
        }
        String schemaName = "test_rename_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("ALTER SCHEMA " + schemaName + " RENAME TO " + schemaName + "_renamed");
            Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName + "_renamed"});
        }
        finally {
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName + "_renamed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropSchemaCascade() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_SCHEMA_CASCADE)) {
            String schemaName = "test_drop_schema_cascade_" + TestingNames.randomNameSuffix();
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertQueryFails("DROP SCHEMA " + schemaName + " CASCADE", "This connector does not support dropping schemas with CASCADE option");
            this.assertUpdate("DROP SCHEMA " + schemaName);
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) || this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW) || this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String schemaName = "test_drop_schema_cascade_" + TestingNames.randomNameSuffix();
        String tableName = "test_table" + TestingNames.randomNameSuffix();
        String viewName = "test_view" + TestingNames.randomNameSuffix();
        String materializedViewName = "test_materialized_view" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
                this.assertUpdate("CREATE TABLE " + schemaName + "." + tableName + "(a INT)");
            }
            if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
                this.assertUpdate("CREATE VIEW " + schemaName + "." + viewName + " AS SELECT 1 a");
            }
            if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
                this.assertUpdate("CREATE MATERIALIZED VIEW " + schemaName + "." + materializedViewName + " AS SELECT 1 a");
            }
            Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
            this.assertUpdate("DROP SCHEMA " + schemaName + " CASCADE");
            Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{schemaName});
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + schemaName + "." + tableName);
            this.assertUpdate("DROP VIEW IF EXISTS " + schemaName + "." + viewName);
            this.assertUpdate("DROP MATERIALIZED VIEW IF EXISTS " + schemaName + "." + materializedViewName);
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testAddColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation ADD COLUMN test_add_column bigint", "This connector does not support adding columns");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_column_", this.tableDefinitionForAddColumn());){
            tableName = table.getName();
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first'", 1L);
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN x bigint", ".* Column 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN X bigint", ".* Column 'X' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN q bad_type", ".* Unknown type 'bad_type' for column 'q'");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES ('first', NULL)");
            this.assertQuery("SELECT * FROM " + table.getName() + " WHERE a IS NULL", "VALUES ('first', NULL)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second', 'xxx'", 1L);
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', NULL), ('second', 'xxx')");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN b double");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'third', 'yyy', 33.3E0", 1L);
            this.assertQuery("SELECT x, a, b FROM " + table.getName(), "VALUES ('first', NULL, NULL), ('second', 'xxx', NULL), ('third', 'yyy', 33.3)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'fourth', 'zzz', 55.3E0, 'newColumn'", 1L);
            this.assertQuery("SELECT x, a, b, c FROM " + table.getName(), "VALUES ('first', NULL, NULL, NULL), ('second', 'xxx', NULL, NULL), ('third', 'yyy', 33.3, NULL), ('fourth', 'zzz', 55.3, 'newColumn')");
        }
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN x bigint");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN IF NOT EXISTS x bigint");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
    }

    protected String tableDefinitionForAddColumn() {
        return "(x VARCHAR)";
    }

    @Test
    public void testAddColumnWithComment() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_COMMENT)) {
            this.assertQueryFails("ALTER TABLE nation ADD COLUMN test_add_col_desc bigint COMMENT 'test column comment'", "This connector does not support adding columns with comments");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_col_desc_", "(a_varchar varchar)");){
            String tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN b_varchar varchar COMMENT 'test new column comment'");
            Assertions.assertThat((String)this.getColumnComment(tableName, "b_varchar")).isEqualTo("test new column comment");
            this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN empty_comment varchar COMMENT ''");
            Assertions.assertThat((String)this.getColumnComment(tableName, "empty_comment")).isEqualTo("");
        }
    }

    @Test
    public void testAddNotNullColumnToEmptyTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_nn_to_empty", "(a_varchar varchar)");){
            String tableName = table.getName();
            String addNonNullColumn = "ALTER TABLE " + tableName + " ADD COLUMN b_varchar varchar NOT NULL";
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_NOT_NULL_CONSTRAINT)) {
                this.assertQueryFails(addNonNullColumn, this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT) ? "This connector does not support adding not null columns" : ".* Catalog '.*' does not support NOT NULL for column '.*'");
                return;
            }
            this.assertUpdate(addNonNullColumn);
            Assertions.assertThat((boolean)this.columnIsNullable(tableName, "b_varchar")).isFalse();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a', 'b')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).skippingTypesCheck().matches("VALUES ('a', 'b')");
        }
    }

    @Test
    public void testAddNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_NOT_NULL_CONSTRAINT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_nn_col", "(a_varchar varchar)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a')", 1L);
            boolean success = false;
            try {
                this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN b_varchar varchar NOT NULL");
                success = true;
            }
            catch (Throwable e) {
                this.verifyAddNotNullColumnToNonEmptyTableFailurePermissible(e);
            }
            if (success) {
                throw new AssertionError((Object)"Should fail to add not null column without a default value to a non-empty table");
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).skippingTypesCheck().matches("VALUES 'a'");
        }
    }

    protected boolean columnIsNullable(String tableName, String columnName) {
        String isNullable = (String)this.computeScalar("SELECT is_nullable FROM information_schema.columns WHERE table_schema = '" + (String)this.getSession().getSchema().orElseThrow() + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'");
        return switch (Objects.requireNonNull(isNullable, "isNullable is null")) {
            case "YES" -> true;
            case "NO" -> false;
            default -> throw new IllegalStateException("Unrecognized is_nullable value: " + isNullable);
        };
    }

    protected void verifyAddNotNullColumnToNonEmptyTableFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected failure when adding not null column", e);
    }

    @Test
    public void testAddRowField() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_FIELD)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_field_", "AS SELECT CAST(row(1) AS row(x integer)) AS col");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.y integer", "This connector does not support adding fields");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_field_", "AS SELECT CAST(row(1, row(10)) AS row(a integer, b row(x integer))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, b row(x integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.c integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, b row(x integer), c integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10), NULL) AS row(a integer, b row(x integer), c integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.b.y integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, b row(x integer, y integer), c integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10, NULL), NULL) AS row(a integer, b row(x integer, y integer), c integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS col.a varchar");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS col.b.x varchar");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, b row(x integer, y integer), c integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.a varchar", ".* Field 'a' already exists");
        }
    }

    @Test
    public void testAddRowFieldInArray() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_FIELD_IN_ARRAY)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_field_in_array_", "AS SELECT CAST(array[row(1)] AS array(row(x integer))) AS col");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.y integer", ".*does not support.*");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_field_in_array_", "AS SELECT CAST(array[row(1, row(10), array[row(11)])] AS array(row(a integer, b row(x integer), c array(row(v integer))))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, b row(x integer), c array(row(v integer))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.d integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, b row(x integer), c array(row(v integer)), d integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1, row(10), array[row(11)], NULL)] AS array(row(a integer, b row(x integer), c array(row(v integer)), d integer)))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.b.y integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, b row(x integer, y integer), c array(row(v integer)), d integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1, row(10, NULL), array[row(11)], NULL)] AS array(row(a integer, b row(x integer, y integer), c array(row(v integer)), d integer)))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.c.element.w integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, b row(x integer, y integer), c array(row(v integer, w integer)), d integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1, row(10, NULL), array[row(11, NULL)], NULL)] AS array(row(a integer, b row(x integer, y integer), c array(row(v integer, w integer)), d integer)))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.c.element.blah integer", "\\QARRAY type should be denoted by 'element' in the path; found 'c'");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS col.element.a varchar");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS col.element.b.x varchar");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS col.element.c.element.w varchar");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, b row(x integer, y integer), c array(row(v integer, w integer)), d integer))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.a varchar", ".* Field 'a' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.b.x varchar", ".* Field 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.c.element.w varchar", ".* Field 'w' already exists");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_field_in_array_nested_", "AS SELECT CAST(array[array[row(1, row(10), array[row(11)])]] AS array(array(row(a integer, b row(x integer), c array(row(v integer)))))) AS col");
        try {
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(a integer, b row(x integer), c array(row(v integer)))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.element.d integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(a integer, b row(x integer), c array(row(v integer)), d integer)))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[array[row(1, row(10), array[row(11)], NULL)]] AS array(array(row(a integer, b row(x integer), c array(row(v integer)), d integer))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.element.b.y integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(a integer, b row(x integer, y integer), c array(row(v integer)), d integer)))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[array[row(1, row(10, NULL), array[row(11)], NULL)]] AS array(array(row(a integer, b row(x integer, y integer), c array(row(v integer)), d integer))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col.element.element.c.element.w integer");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(a integer, b row(x integer, y integer), c array(row(v integer, w integer)), d integer)))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[array[row(1, row(10, NULL), array[row(11, NULL)], NULL)]] AS array(array(row(a integer, b row(x integer, y integer), c array(row(v integer, w integer)), d integer))))");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testDropColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation DROP COLUMN nationkey", "This connector does not support dropping columns");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_column_", "AS SELECT 123 x, 456 y, 111 a");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN x");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS y");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
            this.assertQueryFails("SELECT x FROM " + tableName, ".* Column 'x' cannot be resolved");
            this.assertQueryFails("SELECT y FROM " + tableName, ".* Column 'y' cannot be resolved");
            this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN a", ".* Cannot drop the only column in a table");
        }
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN notExistColumn");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
    }

    @Test
    public void testDropRowField() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
                return;
            }
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_field_", "AS SELECT CAST(row(1, 2) AS row(x integer, y integer)) AS col");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.x", "This connector does not support dropping fields");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_field_", "AS SELECT CAST(row(1, 2, row(10, 20)) AS row(a integer, b integer, c row(x integer, y integer))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, b integer, c row(x integer, y integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.b");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, c row(x integer, y integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10, 20)) AS row(a integer, c row(x integer, y integer)))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.c.y");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, c row(x integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10)) AS row(a integer, c row(x integer)))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.c.x", ".* Cannot drop the only field in a row type");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.c.non_existing", "\\Qline 1:1: Cannot resolve field 'non_existing' within row(x integer) type when dropping [c, non_existing] in row(a integer, c row(x integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.c");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1) AS row(a integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN IF EXISTS non_existing.a");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN IF EXISTS col.non_existing");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer)");
        }
    }

    @Test
    public void testDropRowFieldInArray() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD_IN_ARRAY)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
                return;
            }
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_field_in_array_", "AS SELECT CAST(array[row(1, 2)] AS array(row(x integer, y integer))) AS col");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.x", ".*does not support.*");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_field_in_array_", "AS SELECT CAST(array[row(1, 2, row(10, 20), array[row(30, 40)])] AS array(row(a integer, b integer, c row(x integer, y integer), d array(row(v integer, w integer))))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, b integer, c row(x integer, y integer), d array(row(v integer, w integer))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.b");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, c row(x integer, y integer), d array(row(v integer, w integer))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1, row(10, 20), array[row(30, 40)])] AS array(row(a integer, c row(x integer, y integer), d array(row(v integer, w integer)))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.c.y");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, c row(x integer), d array(row(v integer, w integer))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1, row(10), array[row(30, 40)])] AS array(row(a integer, c row(x integer), d array(row(v integer, w integer)))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.d.element.v");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, c row(x integer), d array(row(w integer))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1, row(10), array[row(40)])] AS array(row(a integer, c row(x integer), d array(row(w integer)))))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.c.x", ".* Cannot drop the only field in a row type");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.d.element.w", ".* Cannot drop the only field in a row type");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.c.non_existing", "\\Qline 1:1: Cannot resolve field 'non_existing' within row(x integer) type when dropping [element, c, non_existing] in array(row(a integer, c row(x integer), d array(row(w integer))))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.d.element.non_existing", "\\Qline 1:1: Cannot resolve field 'non_existing' within row(w integer) type when dropping [element, d, element, non_existing] in array(row(a integer, c row(x integer), d array(row(w integer))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.c");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer, d array(row(w integer))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1, array[row(40)])] AS array(row(a integer, d array(row(w integer)))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.d");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[row(1)] AS array(row(a integer)))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.a", "\\QARRAY type should be denoted by 'element' in the path; found 'a'");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN IF EXISTS non_existing.a");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN IF EXISTS col.element.non_existing");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(a integer))");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_field_in_array_nested_", "AS SELECT CAST(array[array[row(1, 2, row(10, 20), array[row(30, 40)])]] AS array(array(row(a integer, b integer, c row(x integer, y integer), d array(row(v integer, w integer)))))) AS col");
        try {
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.element", "\\Qline 1:1: Field path [element, element] does not point to row field");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.element.d.element", "\\Qline 1:1: Field path [element, element, d, element] does not point to row field");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.element.b");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(a integer, c row(x integer, y integer), d array(row(v integer, w integer)))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[array[row(1, row(10, 20), array[row(30, 40)])]] AS array(array(row(a integer, c row(x integer, y integer), d array(row(v integer, w integer))))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.element.c.y");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(a integer, c row(x integer), d array(row(v integer, w integer)))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[array[row(1, row(10), array[row(30, 40)])]] AS array(array(row(a integer, c row(x integer), d array(row(v integer, w integer))))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.element.element.d.element.v");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(a integer, c row(x integer), d array(row(w integer)))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(array[array[row(1, row(10), array[row(40)])]] AS array(array(row(a integer, c row(x integer), d array(row(w integer))))))");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testDropRowFieldWhenDuplicates() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_duplicated_field_", "AS SELECT CAST(row(1, 2, 3) AS row(a integer, a integer, b integer)) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, a integer, b integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.a", "\\QField path [a] within row(a integer, a integer, b integer) is ambiguous");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, a integer, b integer)");
        }
    }

    @Test
    public void testDropRowFieldCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_row_field_case_sensitivity_", "AS SELECT CAST(row(1, 2) AS row(lower integer, \"UPPER\" integer)) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(lower integer, UPPER integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.LOWER", "\\Qline 1:1: Cannot resolve field 'LOWER' within row(lower integer, UPPER integer) type when dropping [LOWER] in row(lower integer, UPPER integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.upper", "\\Qline 1:1: Cannot resolve field 'upper' within row(lower integer, UPPER integer) type when dropping [upper] in row(lower integer, UPPER integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.\"UPPER\"");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(lower integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1) AS row(lower integer))");
        }
    }

    @Test
    public void testDropAmbiguousRowFieldCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_row_field_case_sensitivity_", "AS SELECT CAST(row(1, 2, 3, 4, 5) AS\nrow(\"sOME_FIELd\" integer, \"some_field\" integer, \"SomE_Field\" integer, \"SOME_FIELD\" integer, \"sOME_FieLd\" integer)) AS col\n");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(sOME_FIELd integer, some_field integer, SomE_Field integer, SOME_FIELD integer, sOME_FieLd integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.some_field");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(sOME_FIELd integer, SomE_Field integer, SOME_FIELD integer, sOME_FieLd integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.\"SomE_Field\"");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(sOME_FIELd integer, SOME_FIELD integer, sOME_FieLd integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.\"SOME_FIELD\"");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(sOME_FIELd integer, sOME_FieLd integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, 5) AS row(\"sOME_FIELd\" integer, \"sOME_FieLd\" integer))");
        }
    }

    @Test
    public void testDropAndAddColumnWithSameName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_add_column", "AS SELECT 1 x, 2 y, 3 z");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN y");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 3)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN y int");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 3, NULL)");
        }
    }

    @Test
    public void testRenameColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation RENAME COLUMN nationkey TO test_rename_column", "This connector does not support renaming columns");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_rename_column_", "AS SELECT 'some value' x");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO before_y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS before_y TO y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
            this.assertQuery("SELECT y FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN y TO Z");
            this.assertQuery("SELECT z FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS z TO a");
            this.assertQuery("SELECT a FROM " + tableName, "VALUES 'some value'");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES 'some value'");
        }
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN columnNotExists TO y");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
    }

    @Test
    public void testRenameColumnWithComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_rename_column_", "(col INT COMMENT 'test column comment')");){
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "col")).isEqualTo("test column comment");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN col TO renamed_col");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "renamed_col")).isEqualTo("test column comment");
        }
    }

    @Test
    public void testRenameRowField() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_FIELD)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_rename_field_", "AS SELECT CAST(row(1) AS row(x integer)) AS col");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " RENAME COLUMN col.x TO x_renamed", "This connector does not support renaming fields");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_field_", "AS SELECT CAST(row(1, row(10)) AS row(a integer, b row(x integer))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a integer, b row(x integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN col.a TO a_renamed");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a_renamed integer, b row(x integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10)) AS row(a_renamed integer, b row(x integer)))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN col.b.x TO x_renamed");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a_renamed integer, b row(x_renamed integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10)) AS row(a_renamed integer, b row(x_renamed integer)))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN IF EXISTS col.a_missing TO a_missing_renamed");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN IF EXISTS col.b.x_missing TO x_missing_renamed");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(a_renamed integer, b row(x_renamed integer))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " RENAME COLUMN col.a_renamed TO a_renamed", ".* Field 'a_renamed' already exists");
        }
    }

    @Test
    public void testRenameRowFieldCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_FIELD));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_row_field_case_sensitivity_", "AS SELECT CAST(row(1, 2) AS row(lower integer, \"UPPER\" integer)) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(lower integer, UPPER integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " RENAME COLUMN col.lower TO UPPER", ".* Field 'upper' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " RENAME COLUMN col.lower TO upper", ".* Field 'upper' already exists");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN col.lower TO LOWER_RENAMED");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(lower_renamed integer, UPPER integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN col.\"UPPER\" TO upper_renamed");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(lower_renamed integer, upper_renamed integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, 2) AS row(lower_renamed integer, upper_renamed integer))");
        }
    }

    @Test
    public void testSetColumnType() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE)) {
            this.assertQueryFails("ALTER TABLE nation ALTER COLUMN nationkey SET DATA TYPE bigint", "This connector does not support setting column types");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_", "AS SELECT CAST(123 AS integer) AS col");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("bigint");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("VALUES bigint '123'");
        }
    }

    @Test
    public void testSetColumnTypes() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        for (SetColumnTypeSetup setup : this.setColumnTypesDataProvider()) {
            TestTable table;
            try {
                table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_", " AS SELECT CAST(" + setup.sourceValueLiteral + " AS " + setup.sourceColumnType + ") AS col");
            }
            catch (Exception e) {
                this.verifyUnsupportedTypeException(e, setup.sourceColumnType);
                continue;
            }
            TestTable testTable = table;
            try {
                Runnable setColumnType = () -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE " + setup.newColumnType);
                if (setup.unsupportedType) {
                    Assertions.assertThatThrownBy(setColumnType::run).satisfies(new ThrowingConsumer[]{this::verifySetColumnTypeFailurePermissible});
                    return;
                }
                setColumnType.run();
                Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo(setup.newColumnType);
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("SELECT " + setup.newValueLiteral);
            }
            finally {
                if (testTable == null) continue;
                testTable.close();
            }
        }
    }

    private List<SetColumnTypeSetup> setColumnTypesDataProvider() {
        return this.setColumnTypeSetupData().stream().map(this::filterSetColumnTypesDataProvider).flatMap(Optional::stream).collect(Collectors.toList());
    }

    protected Optional<SetColumnTypeSetup> filterSetColumnTypesDataProvider(SetColumnTypeSetup setup) {
        return Optional.of(setup);
    }

    private List<SetColumnTypeSetup> setColumnTypeSetupData() {
        return ImmutableList.builder().add((Object)new SetColumnTypeSetup("tinyint", "TINYINT '127'", "smallint")).add((Object)new SetColumnTypeSetup("tinyint", "TINYINT '126'", "integer")).add((Object)new SetColumnTypeSetup("tinyint", "TINYINT '125'", "bigint")).add((Object)new SetColumnTypeSetup("smallint", "SMALLINT '32767'", "integer")).add((Object)new SetColumnTypeSetup("smallint", "SMALLINT '32766'", "bigint")).add((Object)new SetColumnTypeSetup("integer", "2147483647", "bigint")).add((Object)new SetColumnTypeSetup("bigint", "BIGINT '-2147483648'", "integer")).add((Object)new SetColumnTypeSetup("bigint", "BIGINT '-32768'", "smallint")).add((Object)new SetColumnTypeSetup("bigint", "BIGINT '-128'", "tinyint")).add((Object)new SetColumnTypeSetup("real", "REAL '10.3'", "double")).add((Object)new SetColumnTypeSetup("real", "REAL 'NaN'", "double")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.345", "decimal(10,3)")).add((Object)new SetColumnTypeSetup("decimal(28,3)", "12.345", "decimal(38,3)")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.345", "decimal(38,3)")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.340", "decimal(5,2)")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.349", "decimal(5,2)")).add((Object)new SetColumnTypeSetup("time(3)", "TIME '15:03:00.123'", "time(6)")).add((Object)new SetColumnTypeSetup("time(6)", "TIME '15:03:00.123000'", "time(3)")).add((Object)new SetColumnTypeSetup("time(6)", "TIME '15:03:00.123999'", "time(3)")).add((Object)new SetColumnTypeSetup("timestamp(3)", "TIMESTAMP '2020-02-12 15:03:00.123'", "timestamp(6)")).add((Object)new SetColumnTypeSetup("timestamp(6)", "TIMESTAMP '2020-02-12 15:03:00.123000'", "timestamp(3)")).add((Object)new SetColumnTypeSetup("timestamp(6)", "TIMESTAMP '2020-02-12 15:03:00.123999'", "timestamp(3)")).add((Object)new SetColumnTypeSetup("timestamp(3) with time zone", "TIMESTAMP '2020-02-12 15:03:00.123 +01:00'", "timestamp(6) with time zone")).add((Object)new SetColumnTypeSetup("varchar(100)", "'shorten-varchar'", "varchar(50)")).add((Object)new SetColumnTypeSetup("char(25)", "'shorten-char'", "char(20)")).add((Object)new SetColumnTypeSetup("char(20)", "'char-to-varchar'", "varchar")).add((Object)new SetColumnTypeSetup("varchar", "'varchar-to-char'", "char(20)")).add((Object)new SetColumnTypeSetup("array(integer)", "array[1]", "array(bigint)")).add((Object)new SetColumnTypeSetup("row(x integer)", "row(1)", "row(x bigint)")).add((Object)new SetColumnTypeSetup("row(x integer)", "row(1)", "row(y integer)", "cast(row(NULL) as row(x integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(x integer, z integer)", "cast(row(1, NULL) as row(x integer, z integer))")).add((Object)new SetColumnTypeSetup("row(x integer)", "row(1)", "row(x integer, y integer)", "cast(row(1, NULL) as row(x integer, y integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(x integer)", "cast(row(1) as row(x integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(y integer, x integer)", "cast(row(2, 1) as row(y integer, x integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(z integer, y integer, x integer)", "cast(row(null, 2, 1) as row(z integer, y integer, x integer))")).add((Object)new SetColumnTypeSetup("row(x row(nested integer))", "row(row(1))", "row(x row(nested bigint))", "cast(row(row(1)) as row(x row(nested bigint)))")).add((Object)new SetColumnTypeSetup("row(x row(a integer, b integer))", "row(row(1, 2))", "row(x row(b integer, a integer))", "cast(row(row(2, 1)) as row(x row(b integer, a integer)))")).build();
    }

    @Test
    public void testSetColumnTypeWithNotNull() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_null_", "(col int NOT NULL)");){
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isFalse();
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint");
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isFalse();
        }
    }

    @Test
    public void testSetColumnTypeWithComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_comment_", "(col int COMMENT 'test comment')");){
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "col")).isEqualTo("test comment");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "col")).isEqualTo("test comment");
        }
    }

    @Test
    public void testSetColumnTypeWithDefaultColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        try (TestTable table = this.createTableWithDefaultColumns();){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col_default SET DATA TYPE bigint");
            this.assertUpdate("INSERT INTO " + table.getName() + " (col_required, col_required2) VALUES (1, 10)", 1L);
            this.assertQuery("SELECT col_default FROM " + table.getName(), "VALUES 43");
        }
    }

    @Test
    public void testSetColumnIncompatibleType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_invalid_column_type_", "AS SELECT 'test' AS col");){
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE integer")).satisfies(new ThrowingConsumer[]{this::verifySetColumnTypeFailurePermissible});
        }
    }

    @Test
    public void testSetColumnOutOfRangeType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_invalid_range_", "AS SELECT CAST(9223372036854775807 AS bigint) AS col");){
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE integer")).satisfies(new ThrowingConsumer[]{this::verifySetColumnTypeFailurePermissible});
        }
    }

    protected void verifySetColumnTypeFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected set column type failure", e);
    }

    @Test
    public void testSetFieldType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_", "(col row(field int))");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " ALTER COLUMN col.field SET DATA TYPE bigint", "This connector does not support setting field types");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_", "AS SELECT CAST(row(123) AS row(field integer)) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(field integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.field SET DATA TYPE bigint");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(field bigint)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("SELECT row(bigint '123')");
        }
    }

    @Test
    public void testSetFieldTypes() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        for (SetColumnTypeSetup setup : this.setFieldTypesDataProvider()) {
            TestTable table;
            try {
                table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_", " AS SELECT CAST(row(" + setup.sourceValueLiteral + ") AS row(field " + setup.sourceColumnType + ")) AS col");
            }
            catch (Exception e) {
                this.verifyUnsupportedTypeException(e, setup.sourceColumnType);
                continue;
            }
            TestTable testTable = table;
            try {
                Runnable setFieldType = () -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.field SET DATA TYPE " + setup.newColumnType);
                if (setup.unsupportedType) {
                    Assertions.assertThatThrownBy(setFieldType::run).satisfies(new ThrowingConsumer[]{this::verifySetFieldTypeFailurePermissible});
                    return;
                }
                setFieldType.run();
                Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(field " + setup.newColumnType + ")");
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("SELECT row(" + setup.newValueLiteral + ")");
            }
            finally {
                if (testTable == null) continue;
                testTable.close();
            }
        }
    }

    public List<SetColumnTypeSetup> setFieldTypesDataProvider() {
        return this.setColumnTypeSetupData().stream().map(this::filterSetFieldTypesDataProvider).flatMap(Optional::stream).collect(Collectors.toList());
    }

    protected Optional<SetColumnTypeSetup> filterSetFieldTypesDataProvider(SetColumnTypeSetup setup) {
        return Optional.of(setup);
    }

    @Test
    public void testSetFieldTypeCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_case_", " AS SELECT CAST(row(1) AS row(\"UPPER\" integer)) col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(UPPER integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.upper SET DATA TYPE bigint");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("row(UPPER bigint)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1) AS row(UPPER bigint))");
        }
    }

    @Test
    public void testSetFieldTypeWithNotNull() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_null_", "(col row(field int) NOT NULL)");){
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isFalse();
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.field SET DATA TYPE bigint");
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isFalse();
        }
    }

    @Test
    public void testSetFieldTypeWithComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_comment_", "(col row(field int) COMMENT 'test comment')");){
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "col")).isEqualTo("test comment");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.field SET DATA TYPE bigint");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "col")).isEqualTo("test comment");
        }
    }

    @Test
    public void testSetFieldIncompatibleType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_invalid_field_type_", "(row_col row(field varchar), nested_col row(field row(nested int)))");){
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN row_col.field SET DATA TYPE row(nested integer)")).satisfies(new ThrowingConsumer[]{this::verifySetFieldTypeFailurePermissible});
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN row_col.field SET DATA TYPE integer")).satisfies(new ThrowingConsumer[]{this::verifySetFieldTypeFailurePermissible});
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN nested_col.field SET DATA TYPE integer")).satisfies(new ThrowingConsumer[]{this::verifySetFieldTypeFailurePermissible});
        }
    }

    @Test
    public void testSetFieldOutOfRangeType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_invalid_range_", "AS SELECT CAST(row(9223372036854775807) AS row(field bigint)) AS col");){
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.field SET DATA TYPE integer")).satisfies(new ThrowingConsumer[]{this::verifySetFieldTypeFailurePermissible});
        }
    }

    @Test
    public void testSetFieldTypeInArray() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ARRAY) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE_IN_ARRAY)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_in_array_", "(col array(row(field int)))");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " ALTER COLUMN col.element.field SET DATA TYPE bigint", ".*does not support.*");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_in_array_", "AS SELECT CAST(array[row(123)] AS array(row(field integer))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(field integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.element.field SET DATA TYPE bigint");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(row(field bigint))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("SELECT array[row(bigint '123')]");
        }
    }

    @Test
    public void testSetFieldTypeInNestedArray() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_FIELD_TYPE_IN_ARRAY) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ARRAY) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_field_type_in_nested_array_", "AS SELECT CAST(array[array[row(array[row(123)])]] AS array(array(row(field array(row(a integer)))))) AS col");){
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(field array(row(a integer)))))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col.element.element.field.element.a SET DATA TYPE bigint");
            Assertions.assertThat((String)this.getColumnType(table.getName(), "col")).isEqualTo("array(array(row(field array(row(a bigint)))))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("SELECT array[array[row(array[row(bigint '123')])]]");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ALTER COLUMN col.element.element SET DATA TYPE bigint", "\\Qline 1:1: Field path [col, element, element] does not point to row field");
        }
    }

    protected void verifySetFieldTypeFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected set field type failure", e);
    }

    protected String getColumnType(String tableName, String columnName) {
        return (String)this.computeScalar(String.format("SELECT data_type FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = '%s' AND column_name = '%s'", tableName, columnName));
    }

    @Test
    public void testDropNotNullConstraint() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_NOT_NULL_CONSTRAINT)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_not_null_", "(col integer NOT NULL)");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " ALTER COLUMN col DROP NOT NULL", "This connector does not support dropping a not null constraint");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_not_null_", "(col integer NOT NULL)");){
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isFalse();
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col DROP NOT NULL");
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isTrue();
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES NULL", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES NULL");
        }
    }

    @Test
    public void testDropNotNullConstraintWithColumnComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_NOT_NULL_CONSTRAINT) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_not_null_", "(col integer NOT NULL COMMENT 'test comment')");){
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "col")).isEqualTo("test comment");
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isFalse();
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col DROP NOT NULL");
            Assertions.assertThat((boolean)this.columnIsNullable(table.getName(), "col")).isTrue();
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "col")).isEqualTo("test comment");
        }
    }

    @Test
    public void testCreateTable() {
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))", "This connector does not support creating tables");
            return;
        }
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{tableName});
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{tableName});
        this.assertTableColumnNames(tableName, "a", "b", "c");
        Assertions.assertThat((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName)).isNull();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{tableName});
        this.assertQueryFails("CREATE TABLE " + tableName + " (a bad_type)", ".* Unknown type 'bad_type' for column 'a'");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        tableName = "test_cr_not_exists_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b varchar(50), c double)");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " (d bigint, e varchar(50))");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        tableName = "test_create_orig_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
        this.assertTableColumnNames(tableName, "a", "b", "c");
        String tableNameLike = "test_create_like_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableNameLike + " (LIKE " + tableName + ", d bigint, e varchar(50))");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike)).isTrue();
        this.assertTableColumnNames(tableNameLike, "a", "b", "c", "d", "e");
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        this.assertUpdate("DROP TABLE " + tableNameLike);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike)).isFalse();
    }

    @Test
    public void testCreateSchemaWithNonLowercaseOwnerName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA));
        Session newSession = Session.builder((Session)this.getSession()).setIdentity(Identity.ofUser((String)"ADMIN")).build();
        String schemaName = "test_schema_create_uppercase_owner_name_" + TestingNames.randomNameSuffix();
        this.assertUpdate(newSession, this.createSchemaSql(schemaName));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(newSession, "SHOW SCHEMAS"))).skippingTypesCheck().containsAll(String.format("VALUES '%s'", schemaName));
        this.assertUpdate(newSession, "DROP SCHEMA " + schemaName);
    }

    @Test
    public void testCreateOrReplaceTableWhenTableDoesNotExist() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String table = "test_create_or_replace_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE)) {
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table + " (a bigint, b double, c varchar(50))", "This connector does not support replacing tables");
            return;
        }
        try {
            this.assertUpdate("CREATE OR REPLACE TABLE " + table + " (a bigint, b double, c varchar(50))");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateOrReplaceTableAsSelectWhenTableDoesNotExists() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String table = "test_create_or_replace_" + TestingNames.randomNameSuffix();
        String query = "SELECT nationkey, name, regionkey FROM nation";
        String rowCountQuery = "SELECT count(*) FROM nation";
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE)) {
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table + " AS " + query, "This connector does not support replacing tables");
            return;
        }
        try {
            this.assertUpdate("CREATE OR REPLACE TABLE " + table + " AS " + query, rowCountQuery);
            this.assertQuery("SELECT * FROM " + table, query);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + table);
        }
    }

    @Test
    public void testCreateOrReplaceTableWhenTableAlreadyExistsSameSchema() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE)) {
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_or_replace_", "AS SELECT CAST(1 AS BIGINT) AS nationkey, 'test' AS name, CAST(2 AS BIGINT) AS regionkey FROM nation LIMIT 1");){
            String query = "SELECT nationkey, name, regionkey FROM nation";
            String rowCountQuery = "SELECT count(*) FROM nation";
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS " + query, rowCountQuery);
            this.assertQuery("SELECT * FROM " + table.getName(), query);
        }
    }

    @Test
    public void testCreateOrReplaceTableWhenTableAlreadyExistsSameSchemaNoData() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE)) {
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_or_replace_", " AS SELECT nationkey, name, regionkey FROM nation");){
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT nationkey, name, regionkey FROM nation WITH NO DATA", 0L);
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
        }
    }

    @Test
    public void testCreateOrReplaceTableWithNewColumnNames() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE)) {
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_or_replace_", " AS SELECT nationkey, name, regionkey FROM nation");){
            this.assertTableColumnNames(table.getName(), "nationkey", "name", "regionkey");
            String query = "SELECT nationkey AS nationkey_new, name AS name_new_2, regionkey AS region_key_new FROM nation";
            String rowCountQuery = "SELECT count(*) FROM nation";
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS " + query, rowCountQuery);
            this.assertTableColumnNames(table.getName(), "nationkey_new", "name_new_2", "region_key_new");
            this.assertQuery("SELECT * FROM " + table.getName(), query);
        }
    }

    @Test
    public void testCreateOrReplaceTableWithDifferentDataType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE)) {
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_or_replace_", " AS SELECT nationkey, name FROM nation");){
            String query = "SELECT name AS nationkey, nationkey AS name FROM nation";
            String rowCountQuery = "SELECT count(*) FROM nation";
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS " + query, rowCountQuery);
            this.assertQuery(this.getSession(), "SELECT * FROM " + table.getName(), query);
        }
    }

    @Test
    public void testCreateSchemaWithLongName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA));
        String baseSchemaName = "test_create_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxSchemaNameLength().orElse(65541);
        String validSchemaName = baseSchemaName + "z".repeat(maxLength - baseSchemaName.length());
        this.assertUpdate(this.createSchemaSql(validSchemaName));
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{validSchemaName});
        this.assertUpdate("DROP SCHEMA " + validSchemaName);
        if (this.maxSchemaNameLength().isEmpty()) {
            return;
        }
        String invalidSchemaName = validSchemaName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate(this.createSchemaSql(invalidSchemaName))).satisfies(new ThrowingConsumer[]{this::verifySchemaNameLengthFailurePermissible});
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{invalidSchemaName});
    }

    @Test
    public void testRenameSchemaToLongName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA));
        String sourceSchemaName = "test_rename_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(sourceSchemaName));
        String baseSchemaName = "test_rename_target_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxSchemaNameLength().orElse(65541);
        String validTargetSchemaName = baseSchemaName + "z".repeat(maxLength - baseSchemaName.length());
        this.assertUpdate("ALTER SCHEMA " + sourceSchemaName + " RENAME TO " + validTargetSchemaName);
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{validTargetSchemaName});
        this.assertUpdate("DROP SCHEMA " + validTargetSchemaName);
        if (this.maxSchemaNameLength().isEmpty()) {
            return;
        }
        this.assertUpdate(this.createSchemaSql(sourceSchemaName));
        String invalidTargetSchemaName = validTargetSchemaName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER SCHEMA " + sourceSchemaName + " RENAME TO " + invalidTargetSchemaName)).satisfies(new ThrowingConsumer[]{this::verifySchemaNameLengthFailurePermissible});
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{invalidTargetSchemaName});
    }

    protected OptionalInt maxSchemaNameLength() {
        return OptionalInt.empty();
    }

    protected void verifySchemaNameLengthFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected schema name length failure", e);
    }

    @Test
    public void testCreateTableWithLongTableName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String baseTableName = "test_create_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxTableNameLength().orElse(65541);
        String validTableName = baseTableName + "z".repeat(maxLength - baseTableName.length());
        this.assertUpdate("CREATE TABLE " + validTableName + " (a bigint)");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), validTableName)).isTrue();
        this.assertUpdate("DROP TABLE " + validTableName);
        if (this.maxTableNameLength().isEmpty()) {
            return;
        }
        String invalidTableName = validTableName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE " + invalidTableName + " (a bigint)")).satisfies(new ThrowingConsumer[]{this::verifyTableNameLengthFailurePermissible});
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), validTableName)).isFalse();
    }

    @Test
    public void testRenameTableToLongTableName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE));
        String sourceTableName = "test_rename_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTableName + " AS SELECT 123 x", 1L);
        String baseTableName = "test_rename_target_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxTableRenameLength().orElse(65541);
        String validTargetTableName = baseTableName + "z".repeat(maxLength - baseTableName.length());
        this.assertUpdate("ALTER TABLE " + sourceTableName + " RENAME TO " + validTargetTableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), validTargetTableName)).isTrue();
        this.assertQuery("SELECT x FROM " + validTargetTableName, "VALUES 123");
        this.assertUpdate("DROP TABLE " + validTargetTableName);
        if (this.maxTableRenameLength().isEmpty()) {
            return;
        }
        this.assertUpdate("CREATE TABLE " + sourceTableName + " AS SELECT 123 x", 1L);
        String invalidTargetTableName = validTargetTableName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + sourceTableName + " RENAME TO " + invalidTargetTableName)).satisfies(new ThrowingConsumer[]{this::verifyTableNameLengthFailurePermissible});
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), invalidTargetTableName)).isFalse();
        this.assertUpdate("DROP TABLE " + sourceTableName);
    }

    protected OptionalInt maxTableNameLength() {
        return OptionalInt.empty();
    }

    protected OptionalInt maxTableRenameLength() {
        return this.maxTableNameLength();
    }

    protected void verifyTableNameLengthFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected table name length failure", e);
    }

    @Test
    public void testCreateTableWithLongColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_long_column" + TestingNames.randomNameSuffix();
        String baseColumnName = "col";
        int maxLength = this.maxColumnNameLength().orElse(65541);
        String validColumnName = baseColumnName + "z".repeat(maxLength - baseColumnName.length());
        this.assertUpdate("CREATE TABLE " + tableName + " (" + validColumnName + " bigint)");
        Assertions.assertThat((boolean)this.columnExists(tableName, validColumnName)).isTrue();
        this.assertUpdate("DROP TABLE " + tableName);
        if (this.maxColumnNameLength().isEmpty()) {
            return;
        }
        String invalidColumnName = validColumnName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE " + tableName + " (" + invalidColumnName + " bigint)")).satisfies(new ThrowingConsumer[]{this::verifyColumnNameLengthFailurePermissible});
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
    }

    @Test
    public void testAlterTableAddLongColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN));
        String tableName = "test_long_column" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String baseColumnName = "col";
        int maxLength = this.maxColumnNameLength().orElse(65541);
        String validTargetColumnName = baseColumnName + "z".repeat(maxLength - baseColumnName.length());
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + validTargetColumnName + " int");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
        this.assertQuery("SELECT x FROM " + tableName, "VALUES 123");
        this.assertUpdate("DROP TABLE " + tableName);
        if (this.maxColumnNameLength().isEmpty()) {
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String invalidTargetColumnName = validTargetColumnName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + invalidTargetColumnName + " int")).satisfies(new ThrowingConsumer[]{this::verifyColumnNameLengthFailurePermissible});
        this.assertQuery("SELECT x FROM " + tableName, "VALUES 123");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAlterTableRenameColumnToLongName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN));
        String tableName = "test_long_column" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String baseColumnName = "col";
        int maxLength = this.maxColumnNameLength().orElse(65541);
        String validTargetColumnName = baseColumnName + "z".repeat(maxLength - baseColumnName.length());
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO " + validTargetColumnName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 456", 1L);
        this.assertQuery("SELECT " + validTargetColumnName + " FROM " + tableName, "VALUES 123, 456");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW STATS FOR " + tableName))).succeeds();
        this.assertUpdate("DROP TABLE " + tableName);
        if (this.maxColumnNameLength().isEmpty()) {
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String invalidTargetTableName = validTargetColumnName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO " + invalidTargetTableName)).satisfies(new ThrowingConsumer[]{this::verifyColumnNameLengthFailurePermissible});
        this.assertQuery("SELECT x FROM " + tableName, "VALUES 123");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected boolean columnExists(String tableName, String columnName) {
        MaterializedResult materializedResult = this.computeActual(String.format("SELECT 1 FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = '%s'", this.getSession().getSchema().orElseThrow(), tableName, columnName));
        return materializedResult.getRowCount() == 1;
    }

    protected OptionalInt maxColumnNameLength() {
        return OptionalInt.empty();
    }

    protected void verifyColumnNameLengthFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected column name length failure", e);
    }

    @Test
    public void testCreateTableWithTableComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint) COMMENT 'test comment'", "This connector does not support creating tables with table comment");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint) COMMENT 'test comment'");
        Assertions.assertThat((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName)).isEqualTo("test comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableWithColumnComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint COMMENT 'test comment')", "This connector does not support creating tables with column comment");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint COMMENT 'test comment')");
        Assertions.assertThat((String)this.getColumnComment(tableName, "a")).isEqualTo("test comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String tableName = "test_create_no_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertQueryFails(String.format("CREATE TABLE %s.%s (a bigint)", schemaName, tableName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
    }

    @Test
    public void testCreateTableAsSelect() {
        String tableName = "test_ctas" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            this.assertQueryFails("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "This connector does not support creating tables with data");
            return;
        }
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertTableColumnNames(tableName, "name", "regionkey");
        Assertions.assertThat((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName)).isNull();
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE IF NOT EXISTS nation AS SELECT nationkey, regionkey FROM nation", 0L);
        this.assertTableColumnNames("nation", "nationkey", "name", "regionkey", "comment");
        this.assertCreateTableAsSelect("SELECT nationkey, name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertCreateTableAsSelect("SELECT mktsegment, sum(acctbal) x FROM customer GROUP BY mktsegment", "SELECT count(DISTINCT mktsegment) FROM customer");
        this.assertCreateTableAsSelect("SELECT count(*) x FROM nation JOIN region ON nation.regionkey = region.regionkey", "SELECT 1");
        this.assertCreateTableAsSelect("SELECT nationkey FROM nation ORDER BY nationkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("SELECT * FROM nation WITH DATA", "SELECT * FROM nation", "SELECT count(*) FROM nation");
        this.assertCreateTableAsSelect("SELECT * FROM nation WITH NO DATA", "SELECT * FROM nation LIMIT 0", "SELECT 0");
        this.assertCreateTableAsSelect("SELECT name, nationkey, regionkey FROM nation WHERE nationkey % 2 = 0 UNION ALL SELECT name, nationkey, regionkey FROM nation WHERE nationkey % 2 = 1", "SELECT name, nationkey, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "true").build(), "SELECT CAST(nationkey AS BIGINT) nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT count(*) + 1 FROM nation");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "false").build(), "SELECT CAST(nationkey AS BIGINT) nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT count(*) + 1 FROM nation");
        tableName = "test_ctas" + TestingNames.randomNameSuffix();
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT name FROM nation", new String[0]);
        this.assertQuery("SELECT * from " + tableName, "SELECT name FROM nation");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectWithTableComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String tableName = "test_ctas_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " COMMENT 'test comment' AS SELECT name FROM nation", "This connector does not support creating tables with table comment");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " COMMENT 'test comment' AS SELECT name FROM nation", 25L);
        Assertions.assertThat((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName)).isEqualTo("test comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String tableName = "test_ctas_no_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertQueryFails(String.format("CREATE TABLE %s.%s AS SELECT name FROM nation", schemaName, tableName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
    }

    @Test
    public void testCreateTableAsSelectWithUnicode() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        this.assertCreateTableAsSelect("SELECT '\u2603' unicode", "SELECT 1");
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, query, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, expectedQuery, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(Session session, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        String table = "test_ctas_" + TestingNames.randomNameSuffix();
        this.assertUpdate(session, "CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery(session, "SELECT * FROM " + table, expectedQuery);
        this.assertUpdate(session, "DROP TABLE " + table);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(session, table)).isFalse();
    }

    @Test
    public void testCreateTableAsSelectNegativeDate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String tableName = "negative_date_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NEGATIVE_DATE)) {
            this.assertQueryFails(String.format("CREATE TABLE %s AS SELECT DATE '-0001-01-01' AS dt", tableName), this.errorMessageForCreateTableAsSelectNegativeDate("-0001-01-01"));
            return;
        }
        try {
            this.assertUpdate(String.format("CREATE TABLE %s AS SELECT DATE '-0001-01-01' AS dt", tableName), 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES DATE '-0001-01-01'");
            this.assertQuery(String.format("SELECT * FROM %s WHERE dt = DATE '-0001-01-01'", tableName), "VALUES DATE '-0001-01-01'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForCreateTableAsSelectNegativeDate(String date) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testRenameTable() throws Exception {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_rename_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_new_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
            this.assertQueryFails("ALTER TABLE " + tableName + " RENAME TO " + renamedTable, "This connector does not support renaming tables");
            this.assertUpdate("DROP TABLE " + tableName);
            return;
        }
        try {
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + renamedTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + tableName);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        this.assertQuery("SELECT x FROM " + renamedTable, "VALUES 123");
        String testExistsTableName = "test_rename_exists_" + TestingNames.randomNameSuffix();
        this.assertUpdate("ALTER TABLE IF EXISTS " + renamedTable + " RENAME TO " + testExistsTableName);
        this.assertQuery("SELECT x FROM " + testExistsTableName, "VALUES 123");
        String uppercaseName = "TEST_RENAME_" + TestingNames.randomNameSuffix();
        this.assertUpdate("ALTER TABLE " + testExistsTableName + " RENAME TO " + uppercaseName);
        this.assertQuery("SELECT x FROM " + uppercaseName.toLowerCase(Locale.ENGLISH), "VALUES 123");
        this.assertUpdate("DROP TABLE " + uppercaseName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable)).isFalse();
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME TO " + renamedTable);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable)).isFalse();
    }

    @Test
    public void testRenameTableAcrossSchema() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
                Assumptions.abort((String)"Skipping since rename table is not supported at all");
            }
            this.assertQueryFails("ALTER TABLE nation RENAME TO other_schema.yyyy", "This connector does not support renaming tables across schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE SCHEMA, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_rename_old_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(schemaName));
        String renamedTable = "test_rename_new_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + schemaName + "." + renamedTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + tableName);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        this.assertQuery("SELECT x FROM " + schemaName + "." + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + schemaName + "." + renamedTable);
        this.assertUpdate("DROP SCHEMA " + schemaName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(Session.builder((Session)this.getSession()).setSchema(schemaName).build(), renamedTable)).isFalse();
    }

    @Test
    public void testRenameTableToUnqualifiedPreservesSchema() throws Exception {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE));
        String sourceSchemaName = "test_source_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(sourceSchemaName));
        String tableName = "test_rename_unqualified_name_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceSchemaName + "." + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_unqualified_name_new_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("ALTER TABLE " + sourceSchemaName + "." + tableName + " RENAME TO " + renamedTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + tableName);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        this.assertQuery("SELECT x FROM " + sourceSchemaName + "." + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + sourceSchemaName + "." + renamedTable);
        this.assertUpdate("DROP SCHEMA " + sourceSchemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE)) {
            this.assertQueryFails("COMMENT ON TABLE nation IS 'new comment'", "This connector does not support setting table comments");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_", "(a integer)");){
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo(null);
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("new comment");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + table.getName() + "', 'new comment')");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS NULL");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo(null);
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'updated comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS ''");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isIn(new Object[]{"", null});
        }
        String tableName = "test_comment_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key integer) COMMENT 'new table comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, tableName)).isEqualTo("new table comment");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    protected String getTableComment(String catalogName, String schemaName, String tableName) {
        String sql = String.format("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = '%s' AND schema_name = '%s' AND table_name = '%s'", catalogName, schemaName, tableName);
        return (String)this.computeScalar(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_VIEW)) {
            if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
                try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view", "SELECT * FROM region");){
                    this.assertQueryFails("COMMENT ON VIEW " + view.getName() + " IS 'new comment'", "This connector does not support setting view comments");
                }
                return;
            }
            Assumptions.abort((String)"Skipping as connector does not support CREATE VIEW");
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view", "SELECT * FROM region");){
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE VIEW " + view.getName()))).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo("new comment");
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS NULL");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo(null);
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS 'updated comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS ''");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo("");
        }
        String viewName = "test_comment_view" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE VIEW " + viewName + " COMMENT 'new view comment' AS SELECT * FROM region");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, viewName)).isEqualTo("new view comment");
        }
        finally {
            this.assertUpdate("DROP VIEW IF EXISTS " + viewName);
        }
    }

    @Test
    public void testCommentColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN)) {
            this.assertQueryFails("COMMENT ON COLUMN nation.nationkey IS 'new comment'", "This connector does not support setting column comments");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column_", "(a integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("new comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS NULL");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo(null);
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'updated comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS ''");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isIn(new Object[]{"", null});
        }
    }

    @Test
    public void testCommentColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN));
        for (String columnName : this.testColumnNameDataProvider()) {
            this.testCommentColumnName(columnName, BaseConnectorTest.requiresDelimiting(columnName));
        }
    }

    protected void testCommentColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column", "(" + nameInSql + " integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + "." + nameInSql + " IS 'test comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), columnName.replace("'", "''").toLowerCase(Locale.ENGLISH))).isEqualTo("test comment");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
    }

    @Test
    public void testCommentViewColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_VIEW_COLUMN)) {
            if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
                try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view_column", "SELECT * FROM region");){
                    this.assertQueryFails("COMMENT ON COLUMN " + view.getName() + ".regionkey IS 'new region key comment'", "This connector does not support setting view column comments");
                }
                return;
            }
            Assumptions.abort((String)"Skipping as connector does not support CREATE VIEW");
        }
        String viewColumnName = "regionkey";
        try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view_column", "SELECT * FROM region");){
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS 'new region key comment'");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo("new region key comment");
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS NULL");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo(null);
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS 'updated region key comment'");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo("updated region key comment");
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS ''");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo("");
        }
    }

    protected String getColumnComment(String tableName, String columnName) {
        return (String)this.computeScalar(String.format("SELECT comment FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = '%s'", this.getSession().getSchema().orElseThrow(), tableName, columnName));
    }

    @Test
    public void testInsert() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO nation(nationkey) VALUES (42)", "This connector does not support inserts");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            throw new AssertionError((Object)"Cannot test INSERT without CTAS, the test needs to be implemented in a connector-specific way");
        }
        String query = "SELECT name, nationkey, regionkey FROM nation";
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_", "AS " + query + " WITH NO DATA");){
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "SELECT 0");
            this.assertUpdate("INSERT INTO " + table.getName() + " " + query, 25L);
            this.assertQuery("SELECT * FROM " + table.getName(), query);
            this.assertUpdate("INSERT INTO " + table.getName() + " (nationkey) VALUES (-1)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (nationkey) VALUES (null)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (name) VALUES ('name-dummy-1')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (nationkey, name) VALUES (-2, 'name-dummy-2')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (name, nationkey) VALUES ('name-dummy-3', -3)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (regionkey) VALUES (1234)", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), query + " UNION ALL SELECT null, -1, null UNION ALL SELECT null, null, null UNION ALL SELECT 'name-dummy-1', null, null UNION ALL SELECT 'name-dummy-2', -2, null UNION ALL SELECT 'name-dummy-3', -3, null UNION ALL SELECT null, null, 1234");
            this.assertUpdate("INSERT INTO " + table.getName() + " (nationkey, name, regionkey) SELECT nationkey, name, regionkey FROM nation UNION ALL SELECT nationkey, name, regionkey FROM nation", 50L);
        }
    }

    @Test
    public void testInsertForDefaultColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        try (TestTable testTable = this.createTableWithDefaultColumns();){
            this.assertUpdate(String.format("INSERT INTO %s (col_required, col_required2) VALUES (1, 10)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (7, null, null, 8, 9)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s (col_required2, col_required) VALUES (12, 13)", testTable.getName()), 1L);
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (1, null, 43, 42, 10), (2, 3, 4, 5, 6), (7, null, null, 8, 9), (13, null, 43, 42, 12)");
        }
    }

    protected TestTable createTableWithDefaultColumns() {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testInsertUnicode() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5world\\7F16\\7801' ", 2L);
            Assertions.assertThat((Collection)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5world\u7f16\u7801"});
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'aa', 'b\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'aa', 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'aa'", "VALUES 'aa'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'ba'", "VALUES 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'ba'", "VALUES 'aa'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'ba'");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'a', '\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'a', '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'a'", "VALUES 'a'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'b'", "VALUES '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'b'", "VALUES 'a'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'b'");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testInsertHighestUnicodeCharacter() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' ", 2L);
            Assertions.assertThat((Collection)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"});
        }
    }

    @Test
    public void testInsertArray() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_insert_array_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ARRAY)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("CREATE TABLE " + tableName + " (a array(bigint))"))).failure().hasMessageMatching("[Uu]nsupported (column )?type: \\Qarray(bigint)");
            Assumptions.abort((String)"not supported");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_array_", "(a ARRAY<DOUBLE>, b ARRAY<BIGINT>)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " (a) VALUES (ARRAY[null])", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (a, b) VALUES (ARRAY[1.23E1], ARRAY[1.23E1])", 1L);
            this.assertQuery("SELECT a[1], b[1] FROM " + table.getName(), "VALUES (null, null), (12.3, 12)");
        }
    }

    @Test
    public void testInsertSameValues() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_same_values", "AS " + String.join((CharSequence)" UNION ALL ", Collections.nCopies(2, "SELECT * FROM region")));){
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 10");
        }
    }

    @Test
    public void testInsertNegativeDate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO orders (orderdate) VALUES (DATE '-0001-01-01')", "This connector does not support inserts");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT negative dates without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NEGATIVE_DATE)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_date", "(dt DATE)");){
                this.assertQueryFails(String.format("INSERT INTO %s VALUES (DATE '-0001-01-01')", table.getName()), this.errorMessageForInsertNegativeDate("-0001-01-01"));
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_date", "(dt DATE)");){
            this.assertUpdate(String.format("INSERT INTO %s VALUES (DATE '-0001-01-01')", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES DATE '-0001-01-01'");
            this.assertQuery(String.format("SELECT * FROM %s WHERE dt = DATE '-0001-01-01'", table.getName()), "VALUES DATE '-0001-01-01'");
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForInsertNegativeDate(String date) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testInsertIntoNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT)) {
            this.assertQueryFails("CREATE TABLE not_null_constraint (not_null_col INTEGER NOT NULL)", String.format("line 1:35: Catalog '%s' does not support non-null column for column name 'not_null_col'", this.getSession().getCatalog().orElseThrow()));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_not_null", "(nullable_col INTEGER, not_null_col INTEGER NOT NULL)");){
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (nullable_col) VALUES (1)", table.getName()), this.errorMessageForInsertIntoNotNullColumn("not_null_col"));
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (NULL, 3)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (TRY(5/0), 4)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col) VALUES (TRY(6/0))", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails(String.format("INSERT INTO %s (nullable_col) SELECT nationkey FROM nation", table.getName()), this.errorMessageForInsertIntoNotNullColumn("not_null_col"));
            this.assertUpdate(String.format("INSERT INTO %s (nullable_col) SELECT nationkey FROM nation WHERE regionkey < 0", table.getName()), 0L);
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "commuted_not_null", "(nullable_col BIGINT, not_null_col BIGINT NOT NULL)");
        try {
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (NULL, 3)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testUpdateNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT)) {
            this.assertQueryFails("CREATE TABLE not_null_constraint (not_null_col INTEGER NOT NULL)", String.format("line 1:35: Catalog '%s' does not support non-null column for column name 'not_null_col'", this.getSession().getCatalog().orElseThrow()));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "update_not_null", "(nullable_col INTEGER, not_null_col INTEGER NOT NULL)");){
            this.assertUpdate(String.format("INSERT INTO %s (nullable_col, not_null_col) VALUES (1, 10)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 10)");
            this.assertQueryFails("UPDATE " + table.getName() + " SET not_null_col = NULL WHERE nullable_col = 1", "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails("UPDATE " + table.getName() + " SET not_null_col = TRY(5/0) where nullable_col = 1", "NULL value not allowed for NOT NULL column: not_null_col");
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testInsertInTransaction() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_tx_insert", "(a bigint)");){
            String tableName = table.getName();
            this.inTransaction(session -> this.assertUpdate((Session)session, "INSERT INTO " + tableName + " VALUES 42", 1L));
            this.assertQuery("TABLE " + tableName, "VALUES 42");
        }
    }

    @Test
    public void testSelectAfterInsertInTransaction() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES)) {
            log.info("Connector does not support insert in transaction context, so nothing to test");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_select_", "AS SELECT nationkey, name, regionkey FROM nation WHERE nationkey = 1");){
            boolean commit;
            String tableName = table.getName();
            try {
                this.inTransaction(session -> {
                    this.assertQuery((Session)session, "TABLE " + tableName, "SELECT nationkey, name, regionkey FROM nation WHERE nationkey = 1");
                    this.assertUpdate((Session)session, "INSERT INTO " + tableName + "(nationkey, name, regionkey) SELECT nationkey, name, regionkey FROM nation WHERE nationkey = 2", 1L);
                    try {
                        this.assertQuery((Session)session, "TABLE " + tableName, "SELECT nationkey, name, regionkey FROM nation WHERE nationkey IN (1, 2)");
                    }
                    catch (Throwable e) {
                        this.verifySelectAfterInsertFailurePermissible(e);
                        throw new RollbackException();
                    }
                });
                commit = true;
            }
            catch (RollbackException rollbackException) {
                commit = false;
            }
            this.assertQuery("TABLE " + tableName, "SELECT nationkey, name, regionkey FROM nation WHERE nationkey IN " + (commit ? "(1, 2)" : "(1)"));
        }
    }

    protected void verifySelectAfterInsertFailurePermissible(Throwable e) {
        Fail.fail((String)"Unexpected failure", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 100");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 300");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 500");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey < 0", 0L);
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey > 5 AND orderkey < 4", 0L);
        }
        finally {
            table.close();
        }
        String tableName = "test_delete_" + TestingNames.randomNameSuffix();
        try {
            this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT CAST(orderstatus AS VARCHAR(15)) orderstatus FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE INSERT INTO " + tableName + " SELECT clerk FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders UNION ALL SELECT clerk FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE TRUE", new String[0]);
            this.assertQuery("SELECT COUNT(*) from " + tableName, "SELECT 0");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testDeleteWithLike() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_with_like_", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE name LIKE '%a%'", "VALUES 0");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE name LIKE '%A%'", "SELECT count(*) FROM nation WHERE name LIKE '%A%'");
        }
    }

    @Test
    public void testDeleteWithComplexPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_complex_", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE nationkey % 2 = 0", "SELECT count(*) FROM nation WHERE nationkey % 2 = 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE nationkey % 2 <> 0");
            this.assertUpdate("DELETE FROM " + table.getName(), "SELECT count(*) FROM nation WHERE nationkey % 2 <> 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders LIMIT 0");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE rand() < 0", 0L);
        }
    }

    @Test
    public void testDeleteWithSubquery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')", 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders ORDER BY orderkey LIMIT 1)", 1L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1 WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1)", "SELECT count(*) - 1 FROM orders");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_correlated_exists_subquery", "AS SELECT * FROM nation");
        try {
            this.assertUpdate(String.format("DELETE FROM %1$s WHERE EXISTS(SELECT regionkey FROM region WHERE regionkey = %1$s.regionkey AND name LIKE 'A%%')", table.getName()), 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_correlated_exists_subquery", "AS SELECT * FROM nation");
        try {
            this.assertUpdate(String.format("DELETE FROM %1$s WHERE regionkey IN (SELECT regionkey FROM region WHERE regionkey = %1$s.regionkey AND name LIKE 'A%%')", table.getName()), 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testExplainAnalyzeWithDeleteWithSubquery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        String tableName = "test_delete_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", 25L);
        this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%' LIMIT 1)", "SemiJoin.*");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWithSemiJoin() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')   AND regionkey IN (SELECT regionkey FROM region WHERE length(comment) < 50)", 10L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')   OR regionkey IN (SELECT regionkey FROM region WHERE length(comment) >= 50)");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + "\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM tpch.tiny.lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testDeleteWithVarcharPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_with_varchar_predicate_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE orderstatus <> 'O'");
        }
    }

    @Test
    public void verifySupportsDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_delete", "(regionkey int)");){
            this.assertQueryFails("DELETE FROM " + table.getName(), "This connector does not support modifying table rows");
        }
    }

    @Test
    public void verifySupportsRowLevelDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_row_level_delete", "(regionkey int)");){
            this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE regionkey = 2", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testDeleteAllDataFromTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_all_data", "AS SELECT * FROM region");){
            this.getQueryRunner().execute("DELETE FROM " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testRowLevelDelete() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_row_delete", "AS SELECT * FROM region");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey = 2", 1L);
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 4");
        }
    }

    @Test
    public void verifySupportsUpdateDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_update", "AS SELECT * FROM nation");){
            this.assertQueryFails("UPDATE " + table.getName() + " SET nationkey = 100 WHERE regionkey = 2", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void verifySupportsRowLevelUpdateDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_update", "AS SELECT * FROM nation");){
            this.assertQueryFails("UPDATE " + table.getName() + " SET nationkey = nationkey * 100 WHERE regionkey = 2", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testUpdate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_row_update", "AS SELECT * FROM nation");){
            this.assertUpdate("UPDATE " + table.getName() + " SET nationkey = 100 WHERE regionkey = 2", 5L);
            this.assertQuery("SELECT count(*) FROM " + table.getName() + " WHERE nationkey = 100", "VALUES 5");
        }
    }

    @Test
    public void testRowLevelUpdate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update", "AS TABLE tpch.tiny.nation");){
            String tableName = table.getName();
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = 100 + nationkey WHERE regionkey = 2", 5L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT IF(regionkey=2, nationkey + 100, nationkey) nationkey, name, regionkey, comment FROM tpch.tiny.nation");
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = nationkey * 2 WHERE regionkey IN (2,3)", 10L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT CASE regionkey WHEN 2 THEN 2*(nationkey+100) WHEN 3 THEN 2*nationkey ELSE nationkey END nationkey, name, regionkey, comment FROM tpch.tiny.nation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=4)
    @Timeout(value=60L)
    public void testUpdateRowConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_concurrent_update", IntStream.range(0, threads).mapToObj(i -> String.format("col%s integer", i)).collect(Collectors.joining(", ", "(", ")")));){
            String tableName = table.getName();
            this.assertUpdate(String.format("INSERT INTO %s VALUES (%s)", tableName, String.join((CharSequence)",", Collections.nCopies(threads, "0"))), 1L);
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    String columnName = "col" + threadNumber;
                    this.getQueryRunner().execute(String.format("UPDATE %s SET %s = %s + 1", tableName, columnName, columnName));
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentUpdateFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            })).collect(ImmutableList.toImmutableList());
            String expected = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).map(success -> success != false ? "1" : "0").collect(Collectors.joining(",", "VALUES (", ")"));
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).matches(expected);
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentUpdateFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent update failure", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=4)
    @Timeout(value=60L)
    public void testInsertRowConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = this.createTableWithOneIntegerColumn("test_insert");){
            String tableName = table.getName();
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (" + threadNumber + ")");
                    return OptionalInt.of(threadNumber);
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentInsertFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return OptionalInt.empty();
                }
            })).collect(ImmutableList.toImmutableList());
            List values = (List)futures.stream().map(future -> (OptionalInt)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(OptionalInt::isPresent).map(OptionalInt::getAsInt).collect(ImmutableList.toImmutableList());
            if (values.isEmpty()) {
                this.assertQueryReturnsEmptyResult("TABLE " + tableName);
            } else {
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(col AS INTEGER) FROM " + tableName))).matches(values.stream().map(value -> String.format("(%s)", value)).collect(Collectors.joining(",", "VALUES ", "")));
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentInsertFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent insert failure", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=4)
    @Timeout(value=60L)
    public void testAddColumnConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = this.createTableWithOneIntegerColumn("test_add_column");){
            String tableName = table.getName();
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(30L, TimeUnit.SECONDS);
                try {
                    String columnName = "col" + threadNumber;
                    this.getQueryRunner().execute("ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " integer");
                    return Optional.of(columnName);
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentAddColumnFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return Optional.empty();
                }
            })).collect(ImmutableList.toImmutableList());
            List addedColumns = (List)futures.stream().map(future -> (Optional)MoreFutures.tryGetFutureValue((Future)future, (int)30, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + tableName))).result().projected(new String[]{"Column"}).skippingTypesCheck().matches(Stream.concat(Stream.of("col"), addedColumns.stream()).map(value -> String.format("'%s'", value)).collect(Collectors.joining(",", "VALUES ", "")));
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentAddColumnFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent add column failure", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=4)
    @Timeout(value=60L)
    public void testCreateOrReplaceTableConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE)) {
            return;
        }
        int threads = 4;
        int numOfCreateOrReplaceStatements = 4;
        int numOfReads = 16;
        CyclicBarrier barrier = new CyclicBarrier(threads + 1);
        ExecutorService executor = Executors.newFixedThreadPool(threads + 1);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        try (TestTable table = this.createTableWithOneIntegerColumn("test_create_or_replace");){
            String tableName = table.getName();
            this.getQueryRunner().execute("CREATE OR REPLACE TABLE " + tableName + " AS SELECT 1 a");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).matches("VALUES 1");
            futures.add(executor.submit(() -> {
                barrier.await(30L, TimeUnit.SECONDS);
                IntStream.range(0, numOfCreateOrReplaceStatements).forEach(index -> {
                    try {
                        this.getQueryRunner().execute("CREATE OR REPLACE TABLE " + tableName + " AS SELECT * FROM (VALUES (1), (2)) AS t(a) ");
                    }
                    catch (Exception e) {
                        RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                        try {
                            throw new AssertionError("Unexpected concurrent CREATE OR REPLACE failure", trinoException);
                        }
                        catch (Throwable verifyFailure) {
                            if (verifyFailure != e) {
                                verifyFailure.addSuppressed(e);
                            }
                            throw verifyFailure;
                        }
                    }
                });
                return null;
            }));
            IntStream.range(0, threads).forEach(threadNumber -> futures.add(executor.submit(() -> {
                barrier.await(30L, TimeUnit.SECONDS);
                IntStream.range(0, numOfReads).forEach(readIndex -> {
                    try {
                        MaterializedResult result = this.computeActual("SELECT * FROM " + tableName);
                        if (result.getRowCount() == 1) {
                            QueryAssertions.assertEqualsIgnoreOrder(result.getMaterializedRows(), List.of(new MaterializedRow(List.of(Integer.valueOf(1)))));
                        } else {
                            QueryAssertions.assertEqualsIgnoreOrder(result.getMaterializedRows(), List.of(new MaterializedRow(List.of(Integer.valueOf(1))), new MaterializedRow(List.of(Integer.valueOf(2)))));
                        }
                    }
                    catch (Exception e) {
                        RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                        try {
                            throw new AssertionError("Unexpected concurrent CREATE OR REPLACE failure", trinoException);
                        }
                        catch (Throwable verifyFailure) {
                            if (verifyFailure != e) {
                                verifyFailure.addSuppressed(e);
                            }
                            throw verifyFailure;
                        }
                    }
                });
                return null;
            })));
            futures.forEach(Futures::getUnchecked);
            this.getQueryRunner().execute("CREATE OR REPLACE TABLE " + tableName + " AS SELECT * FROM (VALUES (1), (2), (3)) AS t(a)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).matches("VALUES 1, 2, 3");
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    protected TestTable createTableWithOneIntegerColumn(String namePrefix) {
        return new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), namePrefix, "(col integer)");
    }

    @Test
    public void testUpdateWithPredicates() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_with_predicates", "(a INT, b INT, c INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (11, 12, 13), (21, 22, 23)", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET a = a - 1 WHERE c = 3", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 13), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET c = c + 1 WHERE a = 11", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = b * 2 WHERE b = 22", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 44, 23)");
        }
    }

    @Test
    public void testUpdateRowType() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_with_predicates_on_row_types", "(int_t INT, row_t ROW(f1 INT, f2 INT))");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(2, 3)), (11, ROW(12, 13)), (21, ROW(22, 23))", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET int_t = int_t - 1 WHERE row_t.f2 = 3", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 13), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET row_t = ROW(row_t.f1, row_t.f2 + 1) WHERE int_t = 11", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET row_t = ROW(row_t.f1 * 2, row_t.f2) WHERE row_t.f1 = 22", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 44, 23)");
        }
    }

    @Test
    public void testPredicateOnRowTypeField() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_predicate_on_row_type_field", "(int_t INT, row_t row(varchar_t VARCHAR, int_t INT))");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, row('first', 1)), (20, row('second', 10)), (200, row('third', 100))", 3L);
            this.assertQuery("SELECT int_t FROM " + table.getName() + " WHERE row_t.int_t = 1", "VALUES 2");
            this.assertQuery("SELECT int_t FROM " + table.getName() + " WHERE row_t.int_t > 1", "VALUES 20, 200");
            this.assertQuery("SELECT int_t FROM " + table.getName() + " WHERE int_t = 2 AND row_t.int_t = 1", "VALUES 2");
        }
    }

    @Test
    public void testUpdateAllValues() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_all_columns", "(a INT, b INT, c INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (11, 12, 13), (21, 22, 23)", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET a = a + 1, b = b - 1, c = c * 2", 3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (2, 1, 6), (12, 11, 26), (22, 21, 46)");
        }
    }

    @Test
    public void testDropTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_drop_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(col bigint)");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
    }

    @Test
    public void testDropTableIfExists() {
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists")).isFalse();
        this.assertUpdate("DROP TABLE IF EXISTS test_drop_if_exists");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists")).isFalse();
    }

    @Test
    public void testTruncateTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TRUNCATE)) {
            this.assertQueryFails("TRUNCATE TABLE nation", "This connector does not support truncating tables");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_truncate", "AS SELECT * FROM region");){
            this.assertUpdate("TRUNCATE TABLE " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testQueryLoggingCount() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        QueryManager queryManager = this.getDistributedQueryRunner().getCoordinator().getQueryManager();
        this.executeExclusively(() -> {
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> Assertions.assertThat(queryManager.getQueries().stream().map(BasicQueryInfo::getQueryId).map(arg_0 -> ((QueryManager)queryManager).getFullQueryInfo(arg_0)).filter(info -> !info.isFinalQueryInfo()).collect(Collectors.toList())).isEqualTo((Object)ImmutableList.of()));
            DispatchManager dispatchManager = this.getQueryRunner().getCoordinator().getDispatchManager();
            long beforeCompletedQueriesCount = this.waitUntilStable(() -> dispatchManager.getStats().getCompletedQueries().getTotalCount(), new Duration(5.0, TimeUnit.SECONDS));
            long beforeSubmittedQueriesCount = dispatchManager.getStats().getSubmittedQueries().getTotalCount();
            String tableName = "test_logging_count" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE " + tableName + this.tableDefinitionForQueryLoggingCount());
            this.assertQueryReturnsEmptyResult("SELECT foo_1, foo_2_4 FROM " + tableName);
            this.assertUpdate("DROP TABLE " + tableName);
            this.assertQueryFails("SELECT * FROM " + tableName, ".*Table .* does not exist");
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> Assertions.assertThat((long)(dispatchManager.getStats().getCompletedQueries().getTotalCount() - beforeCompletedQueriesCount)).isEqualTo(4L));
            Assertions.assertThat((long)(dispatchManager.getStats().getSubmittedQueries().getTotalCount() - beforeSubmittedQueriesCount)).isEqualTo(4L);
        });
    }

    @Language(value="SQL")
    protected String tableDefinitionForQueryLoggingCount() {
        return "(foo_1 int, foo_2_4 int)";
    }

    private <T> T waitUntilStable(Supplier<T> computation, Duration timeout) {
        T lastValue = computation.get();
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted() && Duration.nanosSince((long)start).compareTo(timeout) < 0) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            T currentValue = computation.get();
            if (currentValue.equals(lastValue)) {
                return currentValue;
            }
            lastValue = currentValue;
        }
        throw new UncheckedTimeoutException();
    }

    @Test
    public void testShowSchemasFromOther() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        Assertions.assertThat((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1"))).isTrue();
    }

    @Test
    public void testSymbolAliasing() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_symbol_aliasing" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrittenStats() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        String tableName = "test_written_stats_" + TestingNames.randomNameSuffix();
        try {
            String sql = "CREATE TABLE " + tableName + " AS SELECT * FROM nation";
            QueryRunner.MaterializedResultWithPlan result = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), sql);
            QueryInfo queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(result.queryId());
            Assertions.assertThat((long)queryInfo.getQueryStats().getOutputPositions()).isEqualTo(1L);
            Assertions.assertThat((long)queryInfo.getQueryStats().getWrittenPositions()).isEqualTo(25L);
            Assertions.assertThat((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0).isTrue();
            sql = "INSERT INTO " + tableName + " SELECT * FROM nation LIMIT 10";
            result = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), sql);
            queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(result.queryId());
            Assertions.assertThat((long)queryInfo.getQueryStats().getOutputPositions()).isEqualTo(1L);
            Assertions.assertThat((long)queryInfo.getQueryStats().getWrittenPositions()).isEqualTo(10L);
            Assertions.assertThat((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0).isTrue();
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testWrittenDataSize() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_REPORTING_WRITTEN_BYTES));
        String tableName = "write_stats_" + TestingNames.randomNameSuffix();
        try {
            String query = "CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation";
            this.assertQueryStats(this.getSession(), query, queryStats -> Assertions.assertThat((long)queryStats.getPhysicalWrittenDataSize().toBytes()).isPositive(), results -> {});
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testNoDataSystemTable() {
        this.assertQuerySucceeds("TABLE nation");
        this.assertQueryFails("TABLE \"nation$data\"", "line 1:1: Table '\\w+.\\w+.\"nation\\$data\"' does not exist");
    }

    @Test
    public void testColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        for (String columnName : this.testColumnNameDataProvider()) {
            this.testColumnName(columnName, BaseConnectorTest.requiresDelimiting(columnName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        String tableName = "tcn_" + nameInSql.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "") + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key varchar(50), " + nameInSql + " varchar(50))");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')", 3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')");
            this.assertQuery("SELECT " + nameInSql + " FROM " + tableName, "VALUES (NULL), ('abc'), ('xyz')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " IS NULL", "VALUES ('null value')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " = 'abc'", "VALUES ('sample value')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testAddAndDropColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN));
        for (String columnName : this.testColumnNameDataProvider()) {
            this.testAddAndDropColumnName(columnName, BaseConnectorTest.requiresDelimiting(columnName));
        }
    }

    protected void testAddAndDropColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        String tableName = "tcn_" + nameInSql.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "") + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createTableSqlForAddingAndDroppingColumn(tableName, nameInSql));
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertTableColumnNames(tableName, columnName.toLowerCase(Locale.ENGLISH), "value");
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN " + nameInSql);
        this.assertTableColumnNames(tableName, "value");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + nameInSql + " varchar(50)");
        this.assertTableColumnNames(tableName, "value", columnName.toLowerCase(Locale.ENGLISH));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected String createTableSqlForAddingAndDroppingColumn(String tableName, String columnNameInSql) {
        return "CREATE TABLE " + tableName + "(" + columnNameInSql + " varchar(50), value varchar(50))";
    }

    @Test
    public void testRenameColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN));
        for (String columnName : this.testColumnNameDataProvider()) {
            this.testRenameColumnName(columnName, BaseConnectorTest.requiresDelimiting(columnName));
        }
    }

    protected void testRenameColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        String tableName = "tcn_" + nameInSql.replaceAll("[^a-z0-9]", "") + TestingNames.randomNameSuffix();
        String sourceColumnName = "a;b$c";
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(\"" + sourceColumnName + "\" varchar(50))");
            this.assertTableColumnNames(tableName, sourceColumnName);
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN \"" + sourceColumnName + "\" TO " + nameInSql);
            this.assertTableColumnNames(tableName, columnName.toLowerCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private static String toColumnNameInSql(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        return nameInSql;
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return false;
    }

    protected static boolean requiresDelimiting(String identifierName) {
        return !identifierName.matches("[a-zA-Z][a-zA-Z0-9_]*");
    }

    public List<String> testColumnNameDataProvider() {
        return this.testColumnNameTestData().stream().map(this::filterColumnNameTestData).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<String> testColumnNameTestData() {
        return ImmutableList.builder().add((Object)"lowercase").add((Object)"UPPERCASE").add((Object)"MixedCase").add((Object)"an_underscore").add((Object)"a-hyphen-minus").add((Object)"a space").add((Object)"atrailingspace ").add((Object)" aleadingspace").add((Object)"a.dot").add((Object)"a,comma").add((Object)"a:colon").add((Object)"a;semicolon").add((Object)"an@at").add((Object)"a\"quote").add((Object)"an'apostrophe").add((Object)"a`backtick`").add((Object)"a/slash`").add((Object)"a\\backslash`").add((Object)"adigit0").add((Object)"0startwithdigit").add((Object)"\u30ab\u30e9\u30e0").build();
    }

    protected Optional<String> filterColumnNameTestData(String columnName) {
        return Optional.of(columnName);
    }

    protected String dataMappingTableName(String trinoTypeName) {
        return "test_data_mapping_smoke_" + trinoTypeName.replaceAll("[^a-zA-Z0-9]", "_") + TestingNames.randomNameSuffix();
    }

    @Test
    public void testCreateTableWithTableCommentSpecialCharacter() {
        this.testCreateTableWithTableCommentSpecialCharacter("a;semicolon");
        this.testCreateTableWithTableCommentSpecialCharacter("an@at");
        this.testCreateTableWithTableCommentSpecialCharacter("a\"quote");
        this.testCreateTableWithTableCommentSpecialCharacter("an'apostrophe");
        this.testCreateTableWithTableCommentSpecialCharacter("a`backtick`");
        this.testCreateTableWithTableCommentSpecialCharacter("a/slash");
        this.testCreateTableWithTableCommentSpecialCharacter("a\\backslash");
        this.testCreateTableWithTableCommentSpecialCharacter("a?question");
        this.testCreateTableWithTableCommentSpecialCharacter("[square bracket]");
    }

    protected void testCreateTableWithTableCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_", "(a bigint) COMMENT " + BaseConnectorTest.varcharLiteral(comment));){
            Assertions.assertThat((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), table.getName())).isEqualTo(comment);
        }
    }

    @Test
    public void testCreateTableAsSelectWithTableCommentSpecialCharacter() {
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("a;semicolon");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("an@at");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("a\"quote");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("an'apostrophe");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("a`backtick`");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("a/slash");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("a\\backslash");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("a?question");
        this.testCreateTableAsSelectWithTableCommentSpecialCharacter("[square bracket]");
    }

    private void testCreateTableAsSelectWithTableCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_", " COMMENT " + BaseConnectorTest.varcharLiteral(comment) + " AS SELECT 1 a");){
            Assertions.assertThat((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), table.getName())).isEqualTo(comment);
        }
    }

    @Test
    public void testCreateTableWithColumnCommentSpecialCharacter() {
        this.testCreateTableWithColumnCommentSpecialCharacter("a;semicolon");
        this.testCreateTableWithColumnCommentSpecialCharacter("an@at");
        this.testCreateTableWithColumnCommentSpecialCharacter("a\"quote");
        this.testCreateTableWithColumnCommentSpecialCharacter("an'apostrophe");
        this.testCreateTableWithColumnCommentSpecialCharacter("a`backtick`");
        this.testCreateTableWithColumnCommentSpecialCharacter("a/slash");
        this.testCreateTableWithColumnCommentSpecialCharacter("a\\backslash");
        this.testCreateTableWithColumnCommentSpecialCharacter("a?question");
        this.testCreateTableWithColumnCommentSpecialCharacter("[square bracket]");
    }

    private void testCreateTableWithColumnCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_", " (a bigint COMMENT " + BaseConnectorTest.varcharLiteral(comment) + ")");){
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo(comment);
        }
    }

    @Test
    public void testAddColumnWithCommentSpecialCharacter() {
        this.testAddColumnWithCommentSpecialCharacter("a;semicolon");
        this.testAddColumnWithCommentSpecialCharacter("an@at");
        this.testAddColumnWithCommentSpecialCharacter("a\"quote");
        this.testAddColumnWithCommentSpecialCharacter("an'apostrophe");
        this.testAddColumnWithCommentSpecialCharacter("a`backtick`");
        this.testAddColumnWithCommentSpecialCharacter("a/slash");
        this.testAddColumnWithCommentSpecialCharacter("a\\backslash");
        this.testAddColumnWithCommentSpecialCharacter("a?question");
        this.testAddColumnWithCommentSpecialCharacter("[square bracket]");
    }

    protected void testAddColumnWithCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_col_", "(a_varchar varchar)");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN b_varchar varchar COMMENT " + BaseConnectorTest.varcharLiteral(comment));
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "b_varchar")).isEqualTo(comment);
        }
    }

    @Test
    public void testCommentTableSpecialCharacter() {
        this.testCommentTableSpecialCharacter("a;semicolon");
        this.testCommentTableSpecialCharacter("an@at");
        this.testCommentTableSpecialCharacter("a\"quote");
        this.testCommentTableSpecialCharacter("an'apostrophe");
        this.testCommentTableSpecialCharacter("a`backtick`");
        this.testCommentTableSpecialCharacter("a/slash");
        this.testCommentTableSpecialCharacter("a\\backslash");
        this.testCommentTableSpecialCharacter("a?question");
        this.testCommentTableSpecialCharacter("[square bracket]");
    }

    private void testCommentTableSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_table_", "(a integer)");){
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS " + BaseConnectorTest.varcharLiteral(comment));
            Assertions.assertThat((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), table.getName())).isEqualTo(comment);
        }
    }

    @Test
    public void testCommentColumnSpecialCharacter() {
        this.testCommentColumnSpecialCharacter("a;semicolon");
        this.testCommentColumnSpecialCharacter("an@at");
        this.testCommentColumnSpecialCharacter("a\"quote");
        this.testCommentColumnSpecialCharacter("an'apostrophe");
        this.testCommentColumnSpecialCharacter("a`backtick`");
        this.testCommentColumnSpecialCharacter("a/slash");
        this.testCommentColumnSpecialCharacter("a\\backslash");
        this.testCommentColumnSpecialCharacter("a?question");
        this.testCommentColumnSpecialCharacter("[square bracket]");
    }

    private void testCommentColumnSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column_", "(a integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS " + BaseConnectorTest.varcharLiteral(comment));
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo(comment);
        }
    }

    protected static String varcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''") + "'";
    }

    @Test
    public void testDataMappingSmokeTest() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        for (DataMappingTestSetup dataMappingTestSetup : this.testDataMappingSmokeTestDataProvider()) {
            this.testDataMapping(dataMappingTestSetup);
        }
    }

    private void testDataMapping(DataMappingTestSetup dataMappingTestSetup) {
        String trinoTypeName = dataMappingTestSetup.getTrinoTypeName();
        String sampleValueLiteral = dataMappingTestSetup.getSampleValueLiteral();
        String highValueLiteral = dataMappingTestSetup.getHighValueLiteral();
        String tableName = this.dataMappingTableName(trinoTypeName);
        Runnable setup = () -> {
            String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(row_id AS varchar(50)) row_id, CAST(value AS " + trinoTypeName + ") value, CAST(value AS " + trinoTypeName + ") another_column FROM (VALUES   ('null value', NULL),   ('sample value', " + sampleValueLiteral + "),   ('high value', " + highValueLiteral + "))  t(row_id, value)";
            this.assertUpdate(createTable, 3L);
        };
        if (dataMappingTestSetup.isUnsupportedType()) {
            Assertions.assertThatThrownBy(setup::run).satisfies(new ThrowingConsumer[]{exception -> this.verifyUnsupportedTypeException((Throwable)exception, trinoTypeName)});
            return;
        }
        setup.run();
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + highValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value != " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value > " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + highValueLiteral, "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value = " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value != " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value > " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + highValueLiteral, "VALUES 'null value', 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value = " + sampleValueLiteral + " OR another_column = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    public final List<DataMappingTestSetup> testDataMappingSmokeTestDataProvider() {
        return this.testDataMappingSmokeTestData().stream().map(this::filterDataMappingSmokeTestData).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private List<DataMappingTestSetup> testDataMappingSmokeTestData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("boolean", "false", "true")).add((Object)new DataMappingTestSetup("tinyint", "37", "127")).add((Object)new DataMappingTestSetup("smallint", "32123", "32767")).add((Object)new DataMappingTestSetup("integer", "1274942432", "2147483647")).add((Object)new DataMappingTestSetup("bigint", "312739231274942432", "9223372036854775807")).add((Object)new DataMappingTestSetup("real", "REAL '567.123'", "REAL '999999.999'")).add((Object)new DataMappingTestSetup("double", "DOUBLE '1234567890123.123'", "DOUBLE '9999999999999.999'")).add((Object)new DataMappingTestSetup("decimal(5,3)", "12.345", "99.999")).add((Object)new DataMappingTestSetup("decimal(15,3)", "123456789012.345", "999999999999.99")).add((Object)new DataMappingTestSetup("date", "DATE '0001-01-01'", "DATE '1582-10-04'")).add((Object)new DataMappingTestSetup("date", "DATE '1582-10-05'", "DATE '1582-10-14'")).add((Object)new DataMappingTestSetup("date", "DATE '2020-02-12'", "DATE '9999-12-31'")).add((Object)new DataMappingTestSetup("time", "TIME '15:03:00'", "TIME '23:59:59.999'")).add((Object)new DataMappingTestSetup("time(6)", "TIME '15:03:00'", "TIME '23:59:59.999999'")).add((Object)new DataMappingTestSetup("timestamp", "TIMESTAMP '1969-12-31 15:03:00.123'", "TIMESTAMP '1969-12-31 17:03:00.456'")).add((Object)new DataMappingTestSetup("timestamp", "TIMESTAMP '2020-02-12 15:03:00'", "TIMESTAMP '2199-12-31 23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp(6)", "TIMESTAMP '1969-12-31 15:03:00.123456'", "TIMESTAMP '1969-12-31 17:03:00.123456'")).add((Object)new DataMappingTestSetup("timestamp(6)", "TIMESTAMP '2020-02-12 15:03:00'", "TIMESTAMP '2199-12-31 23:59:59.999999'")).add((Object)new DataMappingTestSetup("timestamp(3) with time zone", "TIMESTAMP '1969-12-31 15:03:00.123 +01:00'", "TIMESTAMP '1969-12-31 17:03:00.456 +01:00'")).add((Object)new DataMappingTestSetup("timestamp(3) with time zone", "TIMESTAMP '2020-02-12 15:03:00 +01:00'", "TIMESTAMP '9999-12-31 23:59:59.999 +12:00'")).add((Object)new DataMappingTestSetup("timestamp(6) with time zone", "TIMESTAMP '1969-12-31 15:03:00.123456 +01:00'", "TIMESTAMP '1969-12-31 17:03:00.123456 +01:00'")).add((Object)new DataMappingTestSetup("timestamp(6) with time zone", "TIMESTAMP '2020-02-12 15:03:00 +01:00'", "TIMESTAMP '9999-12-31 23:59:59.999999 +12:00'")).add((Object)new DataMappingTestSetup("char(3)", "'ab'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar(3)", "'de'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar", "'\u0142\u0105ka for the win'", "'\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b'")).add((Object)new DataMappingTestSetup("varchar", "'a \\backslash'", "'a a'")).add((Object)new DataMappingTestSetup("varchar", "'end backslash \\'", "'end backslash a'")).add((Object)new DataMappingTestSetup("varchar", "U&'a \\000a newline'", "'a a'")).add((Object)new DataMappingTestSetup("varbinary", "X'12ab3f'", "X'ffffffffffffffffffff'")).build();
    }

    protected Optional<DataMappingTestSetup> filterDataMappingSmokeTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    @Test
    public void testCaseSensitiveDataMapping() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        for (DataMappingTestSetup dataMappingTestSetup : this.testCaseSensitiveDataMappingProvider()) {
            this.testDataMapping(dataMappingTestSetup);
        }
    }

    private List<DataMappingTestSetup> testCaseSensitiveDataMappingProvider() {
        return this.testCaseSensitiveDataMappingData().stream().map(this::filterCaseSensitiveDataMappingTestData).flatMap(Optional::stream).collect(Collectors.toList());
    }

    protected Optional<DataMappingTestSetup> filterCaseSensitiveDataMappingTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    private List<DataMappingTestSetup> testCaseSensitiveDataMappingData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("char(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("char(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("char(1)", "'B'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'B'", "'a'")).build();
    }

    @Test
    public void testTimestampWithTimeZoneCastToDatePredicate() {
        TestTable table;
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try {
            table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "timestamptz_to_date", "(i, t) AS VALUES\n    ('UTC', TIMESTAMP '2005-09-10 00:12:34.000 UTC'),\n    ('Warsaw', TIMESTAMP '2005-09-10 00:12:34.000 Europe/Warsaw'),\n    ('Los Angeles', TIMESTAMP '2005-09-10 00:12:34.000 America/Los_Angeles')");
        }
        catch (QueryFailedException e) {
            this.verifyUnsupportedTypeException(e, "timestamp(3) with time zone");
            return;
        }
        try (TestTable testTable = table;){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT i FROM " + table.getName() + " WHERE CAST(t AS date) = DATE '2005-09-10'"))).hasCorrectResultsRegardlessOfPushdown().skippingTypesCheck().containsAll("VALUES 'UTC', 'Los Angeles'");
        }
    }

    @Test
    public void testTimestampWithTimeZoneCastToTimestampPredicate() {
        TestTable table;
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try {
            table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "timestamptz_to_ts", "(i, t) AS VALUES\n    ('UTC', TIMESTAMP '2005-09-10 13:00:00.000 UTC'),\n    ('Warsaw', TIMESTAMP '2005-09-10 13:00:00.000 Europe/Warsaw'),\n    ('Los Angeles', TIMESTAMP '2005-09-10 13:00:00.000 America/Los_Angeles')");
        }
        catch (QueryFailedException e) {
            this.verifyUnsupportedTypeException(e, "timestamp(3) with time zone");
            return;
        }
        try (TestTable testTable = table;){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT i FROM " + table.getName() + " WHERE CAST(t AS timestamp(0)) = TIMESTAMP '2005-09-10 13:00:00'"))).hasCorrectResultsRegardlessOfPushdown().skippingTypesCheck().containsAll("VALUES 'UTC'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPotentialDuplicateDereferencePushdown() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String tableName = "test_dup_deref_" + TestingNames.randomNameSuffix();
        String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(ROW('abc', 1) AS row(a varchar, b bigint)) r";
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
            try {
                this.assertUpdate(createTable);
            }
            catch (Exception expected) {
                this.verifyUnsupportedTypeException(expected, "row(a varchar, b bigint)");
                return;
            }
            this.assertUpdate("DROP TABLE " + tableName);
            Fail.fail((String)"Expected create table failure");
        }
        this.assertUpdate(createTable, 1L);
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r, r.b + 2 FROM " + tableName))).matches("SELECT CAST(ROW('abc', 1) AS ROW(a varchar, b bigint)), BIGINT '3'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r[2], r.b + 2 FROM " + tableName))).matches("VALUES (VARCHAR 'abc', BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[2], r.b + 2 FROM " + tableName))).matches("VALUES (BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r.b, r.b + 2 FROM " + tableName))).matches("VALUES (BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r, r.a LIKE '%c' FROM " + tableName))).matches("SELECT CAST(ROW('abc', 1) AS ROW(a varchar, b bigint)), true");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r[2], r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', BIGINT '1', true)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', true)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r.a, r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', true)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testMergeDeleteWithCTAS() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String target = "merge_target_with_ctas_" + TestingNames.randomNameSuffix();
        String source = "merge_source_with_ctas_" + TestingNames.randomNameSuffix();
        String createTableSql = "CREATE TABLE %s AS\nSELECT * FROM (\n        VALUES\n        (1, 'a', 'aa'),\n        (2, 'b', 'bb'),\n        (3, 'c', 'cc'),\n        (4, 'd', 'dd')\n) AS t (id, name, value)\n";
        this.assertUpdate(createTableSql.formatted(target), 4L);
        this.assertUpdate(createTableSql.formatted(source), 4L);
        this.assertQuery("SELECT COUNT(*) FROM " + target, "VALUES 4");
        this.assertUpdate("DELETE FROM %s WHERE id IN (SELECT id FROM %s WHERE id > 2)".formatted(target, source), 2L);
        this.assertQuery("SELECT * FROM " + target, "VALUES (1, 'a', 'aa'), (2, 'b', 'bb')");
        this.assertUpdate("MERGE INTO %s t USING %s s ON (t.id = s.id) WHEN MATCHED AND s.id > 1 THEN DELETE".formatted(target, source), 1L);
        this.assertQuery("SELECT * FROM " + target, "VALUES (1, 'a', 'aa')");
        this.assertUpdate("DROP TABLE " + target);
        this.assertUpdate("DROP TABLE " + source);
    }

    protected String createTableForWrites(String createTable) {
        return createTable;
    }

    @Test
    public void testMergeLarge() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        String tableName = "test_merge_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (orderkey BIGINT, custkey BIGINT, totalprice DOUBLE)", tableName)));
        this.assertUpdate(String.format("INSERT INTO %s SELECT orderkey, custkey, totalprice FROM tpch.sf1.orders", tableName), (Long)this.computeScalar("SELECT count(*) FROM tpch.sf1.orders"));
        String mergeSql = "MERGE INTO " + tableName + " t USING (SELECT * FROM tpch.sf1.orders) s ON (t.orderkey = s.orderkey)\nWHEN MATCHED AND mod(s.orderkey, 3) = 0 THEN UPDATE SET totalprice = t.totalprice + s.totalprice\nWHEN MATCHED AND mod(s.orderkey, 3) = 1 THEN DELETE";
        this.assertUpdate(mergeSql, 1000000L);
        this.assertQuery("SELECT count(*) FROM " + tableName + " WHERE mod(orderkey, 3) = 1", "SELECT 0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT count(*), sum(cast(totalprice AS decimal(18,2))) FROM " + tableName + " WHERE mod(orderkey, 3) = 2"))).matches("SELECT count(*), sum(cast(totalprice AS decimal(18,2))) FROM tpch.sf1.orders WHERE mod(orderkey, 3) = 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT count(*), sum(cast(totalprice AS decimal(18,2))) FROM " + tableName + " WHERE mod(orderkey, 3) = 0"))).matches("SELECT count(*), sum(cast(totalprice AS decimal(18,2)) * 2) FROM tpch.sf1.orders WHERE mod(orderkey, 3) = 0");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMergeSimpleSelect() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_simple_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_simple_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Ed', 7, 'Etherville'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeFruits() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_various_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_various_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')", targetTable), 3L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Craig', 'candles'), ('Len', 'limes'), ('Joe', 'jellybeans')", sourceTable), 3L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.purchase = s.purchase)", targetTable, sourceTable) + "    WHEN MATCHED AND s.purchase = 'limes' THEN DELETE    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_', s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchase) VALUES(s.customer, s.purchase)", 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave', 'dates'), ('Carol_Craig', 'candles'), ('Joe', 'jellybeans')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleOperations() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        int targetCustomerCount = 32;
        String targetTable = "merge_multiple_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, zipcode INT, spouse VARCHAR, address VARCHAR)", targetTable)));
        String originalInsertFirstHalf = IntStream.range(1, targetCustomerCount / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 1000, 91000, intValue, intValue)).collect(Collectors.joining(", "));
        String originalInsertSecondHalf = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 2000, 92000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, zipcode, spouse, address) VALUES %s, %s", targetTable, originalInsertFirstHalf, originalInsertSecondHalf), targetCustomerCount - 1);
        String firstMergeSource = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 83000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchases, zipcode, spouse, address)", targetTable, firstMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED THEN UPDATE SET purchases = s.purchases, zipcode = s.zipcode, spouse = s.spouse, address = s.address", targetCustomerCount / 2);
        this.assertQuery("SELECT customer, purchases, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s", originalInsertFirstHalf, firstMergeSource));
        String nextInsert = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, zipcode, spouse, address) VALUES %s", targetTable, nextInsert), targetCustomerCount / 2);
        String secondMergeSource = IntStream.range(1, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchases, zipcode, spouse, address)", targetTable, secondMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED AND t.zipcode = 91000 THEN DELETE    WHEN MATCHED AND s.zipcode = 85000 THEN UPDATE SET zipcode = 60000    WHEN MATCHED THEN UPDATE SET zipcode = s.zipcode, spouse = s.spouse, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, zipcode, spouse, address) VALUES(s.customer, s.purchases, s.zipcode, s.spouse, s.address)", targetCustomerCount * 3 / 2 - 1);
        String updatedBeginning = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 60000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedMiddle = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedEnd = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT customer, purchases, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s, %s", updatedBeginning, updatedMiddle, updatedEnd));
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeSimpleQuery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_query_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING ", targetTable) + "(VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')) AS s(customer, purchases, address) ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllInserts() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_inserts_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena')", targetTable), 2L);
        this.assertUpdate(String.format("MERGE INTO %s t USING ", targetTable) + "(VALUES ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire')) AS s(customer, purchases, address) ON (t.customer = s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", 2L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeFalseJoinCondition() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_join_false_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena')", targetTable), 2L);
        this.assertUpdate("MERGE INTO %s t USING (VALUES ('Carol', 9, 'Centreville')) AS s(customer, purchases, address)\n  ON (FALSE)\n    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville')");
        this.assertUpdate("MERGE INTO %s t USING (VALUES ('Dave', 22, 'Darbyshire')) AS s(customer, purchases, address)\n  ON (t.customer != t.customer)\n    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("MERGE INTO %s t USING (VALUES ('Ed', 7, 'Etherville')) AS s(customer, purchases, address)\n  ON (23 - (12 + 10) > 1)\n    WHEN MATCHED THEN UPDATE SET customer = concat(s.customer, '_fooled_you')\n    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllColumnsUpdated() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_all_columns_updated_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_all_columns_updated_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Devon'), ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Darbyshire'), ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Ed', 7, 'Etherville')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_updated'), purchases = s.purchases + t.purchases, address = s.address", 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave_updated', 22, 'Darbyshire'), ('Aaron_updated', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Carol_updated', 12, 'Centreville')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllMatchesDeleted() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_all_matches_deleted_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_all_matches_deleted_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN DELETE", 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Bill', 7, 'Buena')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleRowsMatchFails() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_multiple_fail_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_multiple_fail_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Antioch')", targetTable), 2L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (1, 'Aaron', 6, 'Adelphi'), (2, 'Aaron', 8, 'Ashland')", sourceTable), 2L);
        this.assertQueryFails(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET address = s.address", "One MERGE target table row matched more than one source row");
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Adelphi' THEN UPDATE SET address = s.address", 1L);
        this.assertQuery("SELECT customer, purchases, address FROM " + targetTable, "VALUES ('Aaron', 5, 'Adelphi'), ('Bill', 7, 'Antioch')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeQueryWithStrangeCapitalization() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_strange_capitalization_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING ", targetTable.toUpperCase(Locale.ENGLISH)) + "(VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')) AS s(customer, purchases, address)ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purCHases = s.PurchaseS + t.pUrchases, aDDress = s.addrESs    WHEN NOT MATCHED THEN INSERT (CUSTOMER, purchases, addRESS) VALUES(s.custoMer, s.Purchases, s.ADDress)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithoutTablesAliases() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "test_without_aliases_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "test_without_aliases_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s USING %s", targetTable, sourceTable) + String.format(" ON (%s.customer = %s.customer)", targetTable, sourceTable) + String.format("    WHEN MATCHED AND %s.address = 'Centreville' THEN DELETE", sourceTable) + String.format("    WHEN MATCHED THEN UPDATE SET purchases = %s.pURCHases + %s.pUrchases, aDDress = %s.addrESs", sourceTable, targetTable, sourceTable) + String.format("    WHEN NOT MATCHED THEN INSERT (cusTomer, purchases, addRESS) VALUES(%s.custoMer, %s.Purchases, %s.ADDress)", sourceTable, sourceTable, sourceTable), 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithUnpredictablePredicates() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_predicates_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_predicates_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (1, 'Aaron', 5, 'Antioch'), (2, 'Bill', 7, 'Buena'), (3, 'Carol', 3, 'Cambridge'), (4, 'Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (5, 'Aaron', 6, 'Arches'), (6, 'Carol', 9, 'Centreville'), (7, 'Dave', 11, 'Darbyshire'), (8, 'Ed', 7, 'Etherville')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer AND s.purchases < 10.2    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (id, customer, purchases, address) VALUES (s.id, s.customer, s.purchases, s.address)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (1, 'Aaron', 11, 'Arches'), (2, 'Bill', 7, 'Buena'), (7, 'Dave', 11, 'Darbyshire'), (4, 'Dave', 11, 'Devon'), (8, 'Ed', 7, 'Etherville')");
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer    WHEN MATCHED AND t.address <> 'Darbyshire' AND s.purchases * 2 > 20        THEN DELETE    WHEN MATCHED        THEN UPDATE SET purchases = s.purchases + t.purchases, address = concat(t.address, '/', s.address)    WHEN NOT MATCHED        THEN INSERT (id, customer, purchases, address) VALUES (s.id, s.customer, s.purchases, s.address)", 5L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (1, 'Aaron', 17, 'Arches/Arches'), (2, 'Bill', 7, 'Buena'), (6, 'Carol', 9, 'Centreville'), (7, 'Dave', 22, 'Darbyshire/Darbyshire'), (8, 'Ed', 14, 'Etherville/Etherville')");
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (9, 'Fred', 30, 'Franklin')", targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (1, 'Aaron', 17, 'Arches/Arches'), (2, 'Bill', 7, 'Buena'), (6, 'Carol', 9, 'Centreville'), (7, 'Dave', 22, 'Darbyshire/Darbyshire'), (8, 'Ed', 14, 'Etherville/Etherville'), (9, 'Fred', 30, 'Franklin')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithSimplifiedUnpredictablePredicates() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_predicates_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_predicates_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (1, 'Dave', 11, 'Devon'), (2, 'Dave', 11, 'Darbyshire')", targetTable), 2L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Darbyshire')", sourceTable), 1L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer    WHEN MATCHED AND t.address <> 'Darbyshire' AND s.purchases * 2 > 20        THEN DELETE", 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (2, 'Dave', 11, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeCasts() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_cast_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_cast_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (col1 INT, col2 DOUBLE, col3 INT, col4 BIGINT, col5 REAL, col6 DOUBLE)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (1, 2, 3, 4, 5, 6)", targetTable), 1L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (col1 BIGINT, col2 REAL, col3 DOUBLE, col4 INT, col5 INT, col6 REAL)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6, 7)", sourceTable), 1L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + "    ON (t.col1 + 1 = s.col1)    WHEN MATCHED THEN UPDATE SET col1 = s.col1, col2 = s.col2, col3 = s.col3, col4 = s.col4, col5 = s.col5, col6 = s.col6", 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (2, 3.0, 4, 5, 6.0, 7.0)");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeSubqueries() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_nation_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_nation_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (nation_name, region_name) VALUES ('FRANCE', 'EUROPE'), ('ALGERIA', 'AFRICA'), ('GERMANY', 'EUROPE')", targetTable), 3L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s VALUES ('ALGERIA', 'AFRICA'), ('FRANCE', 'EUROPE'), ('EGYPT', 'MIDDLE EAST'), ('RUSSIA', 'EUROPE')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + "    ON (t.nation_name = s.nation_name)    WHEN MATCHED AND t.nation_name > (SELECT name FROM tpch.tiny.region WHERE name = t.region_name AND name LIKE ('A%'))        THEN DELETE    WHEN NOT MATCHED AND s.region_name = 'EUROPE'        THEN INSERT VALUES(s.nation_name, (SELECT 'EUROPE'))", 2L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('FRANCE', 'EUROPE'), ('GERMANY', 'EUROPE'), ('RUSSIA', 'EUROPE')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeNonNullableColumns() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        String targetTable = "merge_non_nullable_target_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR NOT NULL)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (nation_name, region_name) VALUES ('FRANCE', 'EUROPE'), ('ALGERIA', 'AFRICA'), ('GERMANY', 'EUROPE')", targetTable), 3L);
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t\n", targetTable) + " USING (VALUES ('ALGERIA', 'AFRICA')) s(nation_name, region_name)\n ON (t.nation_name = s.nation_name)\n WHEN MATCHED THEN UPDATE SET region_name = NULL")).hasMessage("NULL value not allowed for NOT NULL column: region_name");
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t\n", targetTable) + " USING (VALUES ('IMAGINARIA', 'AFRICA')) s(nation_name, region_name)\n ON (t.nation_name = s.nation_name)\n WHEN NOT MATCHED THEN INSERT (nation_name, region_name) VALUES ('IMAGINARIA', NULL)")).hasMessage("NULL value not allowed for NOT NULL column: region_name");
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t\n", targetTable) + " USING (VALUES ('IMAGINARIA', 'AFRICA')) s(nation_name, region_name)\n ON (t.nation_name = s.nation_name)\n WHEN NOT MATCHED THEN INSERT (nation_name) VALUES ('IMAGINARIA')")).hasMessage("NULL value not allowed for NOT NULL column: region_name");
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t\n", targetTable) + " USING (VALUES ('ALGERIA', 'AFRICA')) s(nation_name, region_name)\n ON (t.nation_name = s.nation_name)\n WHEN MATCHED THEN UPDATE SET region_name = CAST(TRY(5/0) AS VARCHAR)")).hasMessage("NULL value not allowed for NOT NULL column: region_name");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllColumnsReversed() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        String targetTable = "merge_update_columns_reversed_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites("CREATE TABLE " + targetTable + " (a, b, c) AS VALUES (1, 2, 3)"), 1L);
        this.assertUpdate("MERGE INTO %s t USING (VALUES(1)) AS s(a) ON (t.a = s.a)\n    WHEN MATCHED THEN UPDATE\n        SET c = 100, b = 42, a = 0\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (0, 42, 100)");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    private void verifyUnsupportedTypeException(Throwable exception, String trinoTypeName) {
        String typeNameBase = trinoTypeName.replaceFirst("\\(.*", "");
        String expectedMessagePart = String.format("(%1$s.*not (yet )?supported)|((?i)unsupported.*%1$s)|((?i)not supported.*%1$s)", Pattern.quote(typeNameBase));
        Assertions.assertThat((Throwable)exception).hasMessageFindingMatch(expectedMessagePart).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Throwable)QueryAssertions.getTrinoExceptionCause(e)).hasMessageFindingMatch(expectedMessagePart)});
    }

    @Test
    public void testMaterializedViewColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        for (String columnName : this.testColumnNameDataProvider()) {
            this.testMaterializedViewColumnName(columnName, BaseConnectorTest.requiresDelimiting(columnName));
        }
    }

    private void testMaterializedViewColumnName(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String viewName = "tcn_" + ((String)nameInSql).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_") + "_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT 'sample value' key, 'abc' " + (String)nameInSql);
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES ('sample value', 'abc')");
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    @Test
    public void testCreateFunction() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_FUNCTION)) {
            String catalog = (String)this.getQueryRunner().getDefaultSession().getCatalog().orElseThrow();
            String schema = (String)this.getQueryRunner().getDefaultSession().getSchema().orElseThrow();
            this.assertQueryFails("CREATE FUNCTION " + catalog + "." + schema + ".test_create_function" + TestingNames.randomNameSuffix() + "(x integer) RETURNS bigint COMMENT 't42' RETURN x * 42", "This connector does not support creating functions");
            return;
        }
        String name = "test_" + TestingNames.randomNameSuffix();
        String name2 = "test_" + TestingNames.randomNameSuffix();
        String name3 = "test_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("SHOW CREATE FUNCTION " + name, "line 1:1: Function not found");
        this.assertUpdate("CREATE FUNCTION " + name + "(x integer) RETURNS bigint COMMENT 't42' RETURN x * 42");
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQueryFails("SELECT " + name + "(2.9)", ".*Unexpected parameters.*");
        this.assertUpdate("CREATE FUNCTION " + name + "(x double) RETURNS double COMMENT 't88' RETURN x * 8.8");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW FUNCTIONS"))).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name, "bigint", "integer", "scalar", true, "t42"}).row(new Object[]{name, "double", "double", "scalar", true, "t88"}).build());
        String integerFunctionSql = "CREATE FUNCTION %s(x integer)\nRETURNS bigint\nCOMMENT 't42'\nRETURN (x * 42)\n".strip().formatted(name);
        String doubleFunctionSql = "CREATE FUNCTION %s(x double)\nRETURNS double\nCOMMENT 't88'\nRETURN (x * DECIMAL '8.8')\n".strip().formatted(name);
        Assertions.assertThat((Collection)this.computeActual("SHOW CREATE FUNCTION " + name).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{integerFunctionSql, doubleFunctionSql});
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertQueryFails("CREATE FUNCTION " + name + "(x int) RETURNS bigint RETURN x", "line 1:1: Function already exists");
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertUpdate("CREATE OR REPLACE FUNCTION " + name + "(x bigint) RETURNS bigint RETURN x * 23");
        this.assertUpdate("CREATE FUNCTION " + name2 + "(s varchar) RETURNS varchar RETURN 'Hello ' || s");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW FUNCTIONS"))).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name, "bigint", "integer", "scalar", true, "t42"}).row(new Object[]{name, "bigint", "bigint", "scalar", true, ""}).row(new Object[]{name, "double", "double", "scalar", true, "t88"}).row(new Object[]{name2, "varchar", "varchar", "scalar", true, ""}).build());
        String bigintFunctionSql = "CREATE FUNCTION %s(x bigint)\nRETURNS bigint\nRETURN (x * 23)\n".strip().formatted(name);
        Assertions.assertThat((Collection)this.computeActual("SHOW CREATE FUNCTION " + name).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{integerFunctionSql, doubleFunctionSql, bigintFunctionSql});
        this.assertQuery("SELECT " + name + "(99)", "SELECT 4158");
        this.assertQuery("SELECT " + name + "(cast(99 as bigint))", "SELECT 2277");
        this.assertQuery("SELECT " + name + "(2.9)", "SELECT 25.52");
        this.assertQuery("SELECT " + name2 + "('world')", "SELECT 'Hello world'");
        this.assertQuery("SELECT sum(" + name + "(orderkey)) FROM orders", "SELECT sum(orderkey * 23) FROM orders");
        this.assertUpdate("CREATE FUNCTION " + name3 + "() RETURNS double NOT DETERMINISTIC RETURN random()");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW FUNCTIONS"))).result().skippingTypesCheck().containsAll(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name3, "double", "", "scalar", false, ""}).build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW FUNCTIONS FROM " + String.valueOf(this.computeScalar("SELECT current_path"))))).result().skippingTypesCheck().matches(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[0]).row(new Object[]{name, "bigint", "integer", "scalar", true, "t42"}).row(new Object[]{name, "bigint", "bigint", "scalar", true, ""}).row(new Object[]{name, "double", "double", "scalar", true, "t88"}).row(new Object[]{name2, "varchar", "varchar", "scalar", true, ""}).row(new Object[]{name3, "double", "", "scalar", false, ""}).build());
        Assertions.assertThat((Object)this.computeActual("SHOW CREATE FUNCTION " + name3).getOnlyValue()).isEqualTo((Object)"CREATE FUNCTION %s()\nRETURNS double\nNOT DETERMINISTIC\nRETURN random()\n".strip().formatted(name3));
        this.assertQueryFails("DROP FUNCTION " + name + "(varchar)", "line 1:1: Function not found");
        this.assertUpdate("DROP FUNCTION " + name + "(z bigint)");
        this.assertUpdate("DROP FUNCTION " + name + "(double)");
        this.assertQueryFails("DROP FUNCTION " + name + "(bigint)", "line 1:1: Function not found");
        this.assertUpdate("DROP FUNCTION IF EXISTS " + name + "(bigint)");
        this.assertUpdate("DROP FUNCTION " + name + "(int)");
        this.assertUpdate("DROP FUNCTION " + name2 + "(varchar)");
        this.assertQueryFails("DROP FUNCTION " + name2 + "(varchar)", "line 1:1: Function not found");
        this.assertUpdate("DROP FUNCTION " + name3 + "()");
        this.assertQueryFails("DROP FUNCTION " + name3 + "()", "line 1:1: Function not found");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW FUNCTIONS FROM " + String.valueOf(this.computeScalar("SELECT current_path"))))).returnsEmptyResult();
        String myAbs = "my_abs_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE FUNCTION " + myAbs + "(x integer) RETURNS integer RETURN abs(x)");
        this.assertQuery("WITH FUNCTION abs(x integer) RETURNS integer RETURN x * 2 SELECT " + myAbs + "(-33)", "SELECT 33");
        this.assertQuery("SELECT " + myAbs + "(-33)", "SELECT 33");
        String wrapMyAbs = "wrap_my_abs_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE FUNCTION " + wrapMyAbs + "(x integer) RETURNS integer RETURN " + myAbs + "(x)");
        this.assertQuery("WITH FUNCTION " + myAbs + "(x integer) RETURNS integer RETURN x * 2 SELECT " + wrapMyAbs + "(-33)", "SELECT 33");
        this.assertQuery("SELECT " + wrapMyAbs + "(-33)", "SELECT 33");
        this.assertUpdate("DROP FUNCTION " + myAbs + "(integer)");
        this.assertUpdate("DROP FUNCTION " + wrapMyAbs + "(integer)");
        String recursive1 = "recursive1_" + TestingNames.randomNameSuffix();
        String recursive2 = "recursive2_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE FUNCTION " + recursive1 + "(x integer) RETURNS integer RETURN x");
        this.assertUpdate("CREATE FUNCTION " + recursive2 + "(x integer) RETURNS integer RETURN " + recursive1 + "(x)");
        this.assertUpdate("CREATE OR REPLACE FUNCTION " + recursive1 + "(x integer) RETURNS integer RETURN " + recursive2 + "(x)");
        this.assertQueryFails("SELECT " + recursive1 + "(42)", "Recursive language functions are not supported: " + recursive1 + "\\(integer\\):integer");
        this.assertQueryFails("SELECT " + recursive2 + "(42)", "Recursive language functions are not supported: " + recursive2 + "\\(integer\\):integer");
        this.assertUpdate("DROP FUNCTION " + recursive1 + "(integer)");
        this.assertUpdate("DROP FUNCTION " + recursive2 + "(integer)");
        String wrappingFunction = "wrapping_" + TestingNames.randomNameSuffix();
        String wrappedFunction = "wrapped_" + TestingNames.randomNameSuffix();
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("CREATE FUNCTION " + wrappingFunction + "() RETURNS integer RETURN " + wrappedFunction + "()"))).failure().hasMessage("line 1:62: Function '" + wrappedFunction + "' not registered")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
        this.assertUpdate("CREATE FUNCTION " + wrappedFunction + "() RETURNS integer RETURN 42");
        this.assertUpdate("CREATE FUNCTION " + wrappingFunction + "() RETURNS integer RETURN " + wrappedFunction + "()");
        this.assertQuery("SELECT " + wrappingFunction + "()", "SELECT 42");
        this.assertUpdate("DROP FUNCTION " + wrappedFunction + "()");
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT " + wrappingFunction + "()"))).failure().hasMessage("line 1:8: Function '" + wrappedFunction + "' not registered")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
    }

    @Test
    public void testProjectionPushdown() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_projection_pushdown_", "(id BIGINT, root ROW(f1 BIGINT, f2 BIGINT))", (List<String>)ImmutableList.of((Object)"(1, ROW(1, 2))", (Object)"(2, NULl)", (Object)"(3, ROW(NULL, 4))"));){
            String selectQuery = "SELECT id, root.f1 FROM " + testTable.getName();
            String expectedResult = "VALUES (BIGINT '1', BIGINT '1'), (BIGINT '2', NULL), (BIGINT '3', NULL)";
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DEREFERENCE_PUSHDOWN)) {
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(selectQuery))).matches(expectedResult).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            } else {
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(selectQuery))).matches(expectedResult).isFullyPushedDown();
                Session sessionWithoutPushdown = this.sessionWithProjectionPushdownDisabled(this.getSession());
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(sessionWithoutPushdown, selectQuery))).matches(expectedResult).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
            }
        }
    }

    @Test
    public void testProjectionWithCaseSensitiveField() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DEREFERENCE_PUSHDOWN));
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_projection_with_case_sensitive_field_", "(id INT, a ROW(\"UPPER_CASE\" INT, \"lower_case\" INT, \"MiXeD_cAsE\" INT))", (List<String>)ImmutableList.of((Object)"(1, ROW(2, 3, 4))", (Object)"(5, ROW(6, 7, 8))"));){
            String expected = "VALUES (2, 3, 4), (6, 7, 8)";
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a.UPPER_CASE, a.lower_case, a.MiXeD_cAsE FROM " + testTable.getName()))).matches(expected).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a.upper_case, a.lower_case, a.mixed_case FROM " + testTable.getName()))).matches(expected).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a.UPPER_CASE, a.LOWER_CASE, a.MIXED_CASE FROM " + testTable.getName()))).matches(expected).isFullyPushedDown();
        }
    }

    @Test
    public void testProjectionPushdownMultipleRows() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DEREFERENCE_PUSHDOWN));
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_projection_pushdown_multiple_rows_", "(id INT, nested1 ROW(child1 INT, child2 VARCHAR, child3 INT), nested2 ROW(child1 DOUBLE, child2 BOOLEAN, child3 DATE))", (List<String>)ImmutableList.of((Object)"(1, ROW(10, 'a', 100), ROW(10.10, true, DATE '2023-04-19'))", (Object)"(2, ROW(20, 'b', 200), ROW(20.20, false, DATE '1990-04-20'))", (Object)"(4, ROW(40, NULL, 400), NULL)", (Object)"(5, NULL, ROW(NULL, true, NULL))"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT id, nested1.child1 FROM " + testTable.getName()))).matches("VALUES (1, 10), (2, 20), (4, 40), (5, NULL)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT nested2.child3, id FROM " + testTable.getName()))).matches("VALUES (DATE '2023-04-19', 1), (DATE '1990-04-20', 2), (NULL, 4), (NULL, 5)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT nested2.child1, id, nested1.child2 FROM " + testTable.getName()))).skippingTypesCheck().matches("VALUES (DOUBLE '10.10', 1, 'a'), (DOUBLE '20.20', 2, 'b'), (NULL, 4, NULL), (NULL, 5, NULL)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT nested1.child3, id, nested1.child2 FROM " + testTable.getName()))).skippingTypesCheck().matches("VALUES (100, 1, 'a'), (200, 2, 'b'), (400, 4, NULL), (NULL, 5, NULL)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT nested2.child2, nested2.child3, id FROM " + testTable.getName()))).matches("VALUES (true, DATE '2023-04-19' , 1), (false, DATE '1990-04-20', 2), (NULL, NULL, 4), (true, NULL, 5)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT id, nested2.child1, nested1.child3, nested2.child2, nested1.child1 FROM " + testTable.getName()))).matches("VALUES (1, DOUBLE '10.10', 100, true, 10), (2, DOUBLE '20.20', 200, false, 20), (4, NULL, 400, NULL, 40), (5, NULL, NULL, true, NULL)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT nested2.child2, nested1.child3 FROM " + testTable.getName()))).matches("VALUES (true, 100), (false, 200), (NULL, 400), (true, NULL)").isFullyPushedDown();
        }
    }

    @Test
    public void testProjectionPushdownWithHighlyNestedData() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DEREFERENCE_PUSHDOWN));
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_highly_nested_data_", "(id INT, row1_t ROW(f1 INT, f2 INT, row2_t ROW (f1 INT, f2 INT, row3_t ROW(f1 INT, f2 INT))))", (List<String>)ImmutableList.of((Object)"(1, ROW(2, 3, ROW(4, 5, ROW(6, 7))))", (Object)"(11, ROW(12, 13, ROW(14, 15, ROW(16, 17))))", (Object)"(21, ROW(22, 23, ROW(24, 25, ROW(26, 27))))"));){
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f2 FROM " + testTable.getName(), "VALUES (1, 7), (11, 17), (21, 27)");
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f2, CAST(row1_t AS JSON) FROM " + testTable.getName(), "VALUES (1, 7, '{\"f1\":2,\"f2\":3,\"row2_t\":{\"f1\":4,\"f2\":5,\"row3_t\":{\"f1\":6,\"f2\":7}}}'), (11, 17, '{\"f1\":12,\"f2\":13,\"row2_t\":{\"f1\":14,\"f2\":15,\"row3_t\":{\"f1\":16,\"f2\":17}}}'), (21, 27, '{\"f1\":22,\"f2\":23,\"row2_t\":{\"f1\":24,\"f2\":25,\"row3_t\":{\"f1\":26,\"f2\":27}}}')");
            this.assertQuery("SELECT id, CAST(row1_t.row2_t.row3_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 = 27", "VALUES (21, '{\"f1\":26,\"f2\":27}')");
            this.assertQuery("SELECT id, CAST(row1_t.row2_t.row3_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 > 20", "VALUES (21, '{\"f1\":26,\"f2\":27}')");
            this.assertQuery("SELECT id, CAST(row1_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 = 27", "VALUES (21, '{\"f1\":22,\"f2\":23,\"row2_t\":{\"f1\":24,\"f2\":25,\"row3_t\":{\"f1\":26,\"f2\":27}}}')");
            this.assertQuery("SELECT id, CAST(row1_t AS JSON) FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t.f2 > 20", "VALUES (21, '{\"f1\":22,\"f2\":23,\"row2_t\":{\"f1\":24,\"f2\":25,\"row3_t\":{\"f1\":26,\"f2\":27}}}')");
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f1 FROM " + testTable.getName() + " WHERE row1_t.row2_t.row3_t = ROW(16, 17)", "VALUES (11, 16)");
            this.assertQuery("SELECT id, row1_t.row2_t.row3_t.f1 FROM " + testTable.getName() + " WHERE row1_t = ROW(22, 23, ROW(24, 25, ROW(26, 27)))", "VALUES (21, 26)");
        }
    }

    @Test
    public void testProjectionPushdownReadsLessData() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DEREFERENCE_PUSHDOWN));
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_projection_pushdown_reads_less_data_", "AS SELECT val AS id, CAST(ROW(val + 1, val + 2) AS ROW(leaf1 BIGINT, leaf2 BIGINT)) AS root FROM UNNEST(SEQUENCE(1, 10)) AS t(val)");){
            MaterializedResult expectedResult = this.computeActual("SELECT val + 2 FROM UNNEST(SEQUENCE(1, 10)) AS t(val)");
            String selectQuery = "SELECT root.leaf2 FROM " + testTable.getName();
            Session sessionWithoutSmallFileThreshold = this.withoutSmallFileThreshold(this.getSession());
            Session sessionWithoutPushdown = this.sessionWithProjectionPushdownDisabled(sessionWithoutSmallFileThreshold);
            this.assertQueryStats(sessionWithoutSmallFileThreshold, selectQuery, statsWithPushdown -> {
                DataSize physicalInputDataSizeWithPushdown = statsWithPushdown.getPhysicalInputDataSize();
                DataSize processedDataSizeWithPushdown = statsWithPushdown.getProcessedInputDataSize();
                this.assertQueryStats(sessionWithoutPushdown, selectQuery, statsWithoutPushdown -> {
                    if (this.supportsPhysicalPushdown()) {
                        Assertions.assertThat((Comparable)statsWithoutPushdown.getPhysicalInputDataSize()).isGreaterThan((Comparable)physicalInputDataSizeWithPushdown);
                    } else {
                        Assertions.assertThat((Comparable)statsWithoutPushdown.getPhysicalInputDataSize()).isEqualTo((Object)physicalInputDataSizeWithPushdown);
                    }
                    Assertions.assertThat((Comparable)statsWithoutPushdown.getProcessedInputDataSize()).isGreaterThan((Comparable)processedDataSizeWithPushdown);
                }, results -> Assertions.assertThat((Collection)results.getOnlyColumnAsSet()).isEqualTo((Object)expectedResult.getOnlyColumnAsSet()));
            }, results -> Assertions.assertThat((Collection)results.getOnlyColumnAsSet()).isEqualTo((Object)expectedResult.getOnlyColumnAsSet()));
        }
    }

    @Test
    public void testProjectionPushdownPhysicalInputSize() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DEREFERENCE_PUSHDOWN));
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_projection_pushdown_physical_input_size_", "AS SELECT val AS id, CAST(ROW(val + 1, val + 2) AS ROW(leaf1 BIGINT, leaf2 BIGINT)) AS root FROM UNNEST(SEQUENCE(1, 10)) AS t(val)");){
            Session sessionWithoutSmallFileThreshold = this.withoutSmallFileThreshold(this.getSession());
            this.assertQueryStats(sessionWithoutSmallFileThreshold, "SELECT root FROM " + testTable.getName(), statsWithSelectRootField -> this.assertQueryStats(sessionWithoutSmallFileThreshold, "SELECT root.leaf1 FROM " + testTable.getName(), statsWithSelectLeafField -> {
                if (this.supportsPhysicalPushdown()) {
                    Assertions.assertThat((Comparable)statsWithSelectLeafField.getPhysicalInputDataSize()).isLessThan((Comparable)statsWithSelectRootField.getPhysicalInputDataSize());
                } else {
                    Assertions.assertThat((Comparable)statsWithSelectLeafField.getPhysicalInputDataSize()).isEqualTo((Object)statsWithSelectRootField.getPhysicalInputDataSize());
                }
            }, results -> Assertions.assertThat((Collection)results.getOnlyColumnAsSet()).isEqualTo((Object)this.computeActual("SELECT val + 1 FROM UNNEST(SEQUENCE(1, 10)) AS t(val)").getOnlyColumnAsSet())), results -> Assertions.assertThat((Collection)results.getOnlyColumnAsSet()).isEqualTo((Object)this.computeActual("SELECT ROW(val + 1, val + 2) FROM UNNEST(SEQUENCE(1, 10)) AS t(val)").getOnlyColumnAsSet()));
            this.assertQueryStats(sessionWithoutSmallFileThreshold, "SELECT root FROM " + testTable.getName(), statsWithSelectRootField -> this.assertQueryStats(sessionWithoutSmallFileThreshold, "SELECT root, root.leaf1 FROM " + testTable.getName(), statsWithSelectRootAndLeafField -> Assertions.assertThat((Comparable)statsWithSelectRootAndLeafField.getPhysicalInputDataSize()).isEqualTo((Object)statsWithSelectRootField.getPhysicalInputDataSize()), results -> QueryAssertions.assertEqualsIgnoreOrder(results.getMaterializedRows(), this.computeActual("SELECT ROW(val + 1, val + 2), val + 1 FROM UNNEST(SEQUENCE(1, 10)) AS t(val)").getMaterializedRows())), results -> Assertions.assertThat((Collection)results.getOnlyColumnAsSet()).isEqualTo((Object)this.computeActual("SELECT ROW(val + 1, val + 2) FROM UNNEST(SEQUENCE(1, 10)) AS t(val)").getOnlyColumnAsSet()));
        }
    }

    protected static void skipTestUnless(boolean requirement) {
        if (!requirement) {
            Assumptions.abort((String)"requirement not met");
        }
    }

    protected Consumer<Plan> assertPartialLimitWithPreSortedInputsCount(Session session, int expectedCount) {
        return plan -> {
            int actualCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof LimitNode && ((LimitNode)node).isPartial() && ((LimitNode)node).requiresPreSortedInputs()).findAll().size();
            if (actualCount != expectedCount) {
                Metadata metadata = this.getDistributedQueryRunner().getPlannerContext().getMetadata();
                FunctionManager functionManager = this.getDistributedQueryRunner().getPlannerContext().getFunctionManager();
                String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (Metadata)metadata, (FunctionManager)functionManager, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
                throw new AssertionError((Object)String.format("Expected [\n%s\n] partial limit but found [\n%s\n] partial limit. Actual plan is [\n\n%s\n]", expectedCount, actualCount, formattedPlan));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withMockTableListing(String forSchema, Function<ConnectorSession, List<String>> listing, Runnable closure) {
        Objects.requireNonNull(forSchema, "forSchema is null");
        Objects.requireNonNull(listing, "listing is null");
        Preconditions.checkState((this.mockTableListings.putIfAbsent(forSchema, listing) == null ? 1 : 0) != 0, (String)"Listing function already registered for [%s]", (Object)forSchema);
        try {
            closure.run();
        }
        finally {
            this.mockTableListings.remove(forSchema, listing);
        }
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA " + schemaName;
    }

    protected boolean supportsPhysicalPushdown() {
        return true;
    }

    protected Session sessionWithProjectionPushdownDisabled(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "projection_pushdown_enabled", "false").build();
    }

    protected Session withoutSmallFileThreshold(Session session) {
        throw new UnsupportedOperationException();
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }

    public record SetColumnTypeSetup(String sourceColumnType, String sourceValueLiteral, String newColumnType, String newValueLiteral, boolean unsupportedType) {
        public SetColumnTypeSetup(String sourceColumnType, String sourceValueLiteral, String newColumnType) {
            this(sourceColumnType, sourceValueLiteral, newColumnType, "CAST(CAST(%s AS %s) AS %s)".formatted(sourceValueLiteral, sourceColumnType, newColumnType));
        }

        public SetColumnTypeSetup(String sourceColumnType, String sourceValueLiteral, String newColumnType, String newValueLiteral) {
            this(sourceColumnType, sourceValueLiteral, newColumnType, newValueLiteral, false);
        }

        public SetColumnTypeSetup {
            Objects.requireNonNull(sourceColumnType, "sourceColumnType is null");
            Objects.requireNonNull(sourceValueLiteral, "sourceValueLiteral is null");
            Objects.requireNonNull(newColumnType, "newColumnType is null");
            Objects.requireNonNull(newValueLiteral, "newValueLiteral is null");
        }

        public SetColumnTypeSetup withNewColumnType(String newColumnType) {
            Preconditions.checkState((!this.unsupportedType ? 1 : 0) != 0);
            return new SetColumnTypeSetup(this.sourceColumnType, this.sourceValueLiteral, newColumnType);
        }

        public SetColumnTypeSetup withNewValueLiteral(String newValueLiteral) {
            Preconditions.checkState((!this.unsupportedType ? 1 : 0) != 0);
            return new SetColumnTypeSetup(this.sourceColumnType, this.sourceValueLiteral, this.newColumnType, newValueLiteral, this.unsupportedType);
        }

        public SetColumnTypeSetup asUnsupported() {
            return new SetColumnTypeSetup(this.sourceColumnType, this.sourceValueLiteral, this.newColumnType, this.newValueLiteral, true);
        }
    }

    protected static final class DataMappingTestSetup {
        private final String trinoTypeName;
        private final String sampleValueLiteral;
        private final String highValueLiteral;
        private final boolean unsupportedType;

        public DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral) {
            this(trinoTypeName, sampleValueLiteral, highValueLiteral, false);
        }

        private DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral, boolean unsupportedType) {
            this.trinoTypeName = Objects.requireNonNull(trinoTypeName, "trinoTypeName is null");
            this.sampleValueLiteral = Objects.requireNonNull(sampleValueLiteral, "sampleValueLiteral is null");
            this.highValueLiteral = Objects.requireNonNull(highValueLiteral, "highValueLiteral is null");
            this.unsupportedType = unsupportedType;
        }

        public String getTrinoTypeName() {
            return this.trinoTypeName;
        }

        public String getSampleValueLiteral() {
            return this.sampleValueLiteral;
        }

        public String getHighValueLiteral() {
            return this.highValueLiteral;
        }

        public boolean isUnsupportedType() {
            return this.unsupportedType;
        }

        public DataMappingTestSetup asUnsupported() {
            return new DataMappingTestSetup(this.trinoTypeName, this.sampleValueLiteral, this.highValueLiteral, true);
        }

        public String toString() {
            return this.trinoTypeName + (this.unsupportedType ? "!" : "") + ":" + this.sampleValueLiteral.replaceAll("[^a-zA-Z0-9_-]", "");
        }
    }
}

