/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.datatype;

import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.function.Function;

public class DataType<T> {
    private final String insertType;
    private final Type trinoResultType;
    private final Function<T, String> toLiteral;
    private final Function<T, String> toTrinoLiteral;
    private final Function<T, ?> toTrinoQueryResult;

    public static DataType<Boolean> booleanDataType() {
        return DataType.dataType("boolean", (Type)BooleanType.BOOLEAN);
    }

    public static DataType<Integer> integerDataType() {
        return DataType.dataType("integer", (Type)IntegerType.INTEGER);
    }

    public static DataType<Float> realDataType() {
        return DataType.dataType("real", (Type)RealType.REAL, value -> {
            if (Float.isFinite(value.floatValue())) {
                return value.toString();
            }
            if (Float.isNaN(value.floatValue())) {
                return "nan()";
            }
            return String.format("%sinfinity()", value.floatValue() > 0.0f ? "+" : "-");
        });
    }

    public static DataType<Double> doubleDataType() {
        return DataType.dataType("double", (Type)DoubleType.DOUBLE, value -> {
            if (Double.isFinite(value)) {
                return value.toString();
            }
            if (Double.isNaN(value)) {
                return "nan()";
            }
            return String.format("%sinfinity()", value > 0.0 ? "+" : "-");
        });
    }

    public static DataType<BigDecimal> decimalDataType(int precision, int scale) {
        String databaseType = String.format("decimal(%s, %s)", precision, scale);
        return DataType.dataType(databaseType, (Type)DecimalType.createDecimalType((int)precision, (int)scale), bigDecimal -> String.format("CAST('%s' AS %s)", bigDecimal, databaseType), bigDecimal -> bigDecimal.setScale(scale, RoundingMode.UNNECESSARY));
    }

    public static DataType<LocalDate> dateDataType() {
        return DataType.dataType("date", (Type)DateType.DATE, DateTimeFormatter.ofPattern("'DATE '''uuuu-MM-dd''")::format);
    }

    public static DataType<LocalTime> timeDataType(int precision) {
        DateTimeFormatterBuilder format = new DateTimeFormatterBuilder().appendPattern("'TIME '''").appendPattern("HH:mm:ss");
        if (precision != 0) {
            format.appendFraction(ChronoField.NANO_OF_SECOND, precision, precision, true);
        }
        format.appendPattern("''");
        return DataType.dataType(String.format("time(%s)", precision), (Type)TimeType.createTimeType((int)precision), format.toFormatter()::format);
    }

    @Deprecated
    public static DataType<LocalDateTime> timestampDataType() {
        return DataType.dataType("timestamp", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss.SSS''")::format);
    }

    public static DataType<LocalDateTime> timestampDataType(int precision) {
        DateTimeFormatterBuilder format = new DateTimeFormatterBuilder().appendPattern("'TIMESTAMP '''").appendPattern("uuuu-MM-dd HH:mm:ss");
        if (precision != 0) {
            format.appendFraction(ChronoField.NANO_OF_SECOND, precision, precision, true);
        }
        format.appendPattern("''");
        return DataType.dataType(String.format("timestamp(%s)", precision), (Type)TimestampType.createTimestampType((int)precision), format.toFormatter()::format);
    }

    public static DataType<ZonedDateTime> timestampWithTimeZoneDataType(int precision) {
        DateTimeFormatterBuilder format = new DateTimeFormatterBuilder().appendPattern("'TIMESTAMP '''").appendPattern("uuuu-MM-dd HH:mm:ss");
        if (precision != 0) {
            format.appendFraction(ChronoField.NANO_OF_SECOND, precision, precision, true);
        }
        format.appendPattern(" VV").appendPattern("''");
        return DataType.dataType(String.format("timestamp(%s) with time zone", precision), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), format.toFormatter()::format);
    }

    private static <T> DataType<T> dataType(String insertType, Type trinoResultType) {
        return new DataType<Object>(insertType, trinoResultType, Object::toString, Object::toString, Function.identity());
    }

    public static <T> DataType<T> dataType(String insertType, Type trinoResultType, Function<T, String> toLiteral) {
        return new DataType<T>(insertType, trinoResultType, toLiteral, toLiteral, Function.identity());
    }

    @Deprecated
    public static <T> DataType<T> dataType(String insertType, Type trinoResultType, Function<T, String> toLiteral, Function<T, ?> toTrinoQueryResult) {
        return new DataType<T>(insertType, trinoResultType, toLiteral, toLiteral, toTrinoQueryResult);
    }

    @Deprecated
    public static <T> DataType<T> dataType(String insertType, Type trinoResultType, Function<T, String> toLiteral, Function<T, String> toTrinoLiteral, Function<T, ?> toTrinoQueryResult) {
        return new DataType<T>(insertType, trinoResultType, toLiteral, toTrinoLiteral, toTrinoQueryResult);
    }

    private DataType(String insertType, Type trinoResultType, Function<T, String> toLiteral, Function<T, String> toTrinoLiteral, Function<T, ?> toTrinoQueryResult) {
        this.insertType = insertType;
        this.trinoResultType = trinoResultType;
        this.toLiteral = toLiteral;
        this.toTrinoLiteral = toTrinoLiteral;
        this.toTrinoQueryResult = toTrinoQueryResult;
    }

    public String toLiteral(T inputValue) {
        if (inputValue == null) {
            return "NULL";
        }
        return this.toLiteral.apply(inputValue);
    }

    public String toTrinoLiteral(T inputValue) {
        if (inputValue == null) {
            return "NULL";
        }
        return this.toTrinoLiteral.apply(inputValue);
    }

    public Object toTrinoQueryResult(T inputValue) {
        if (inputValue == null) {
            return null;
        }
        return this.toTrinoQueryResult.apply(inputValue);
    }

    public String getInsertType() {
        return this.insertType;
    }

    public Type getTrinoResultType() {
        return this.trinoResultType;
    }
}

