/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.datatype;

import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.datatype.DataType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class DataTypeTestToSqlDataTypeTestConverter {
    private StringBuilder output = new StringBuilder();

    public static DataTypeTestToSqlDataTypeTestConverter create() {
        return new DataTypeTestToSqlDataTypeTestConverter();
    }

    private DataTypeTestToSqlDataTypeTestConverter() {
        this.output.append("SqlDataTypeTest.create()\n");
    }

    public <T> DataTypeTestToSqlDataTypeTestConverter addRoundTrip(DataType<T> dataType, T value) {
        this.output.append(String.format(" .addRoundTrip(%s, %s, %s, %s)", DataTypeTestToSqlDataTypeTestConverter.toJavaLiteral(dataType.getInsertType()), DataTypeTestToSqlDataTypeTestConverter.toJavaLiteral(dataType.toLiteral(value)), this.typeConstructor(dataType.getTrinoResultType()), DataTypeTestToSqlDataTypeTestConverter.toJavaLiteral(dataType.toTrinoLiteral(value))));
        Object expected = dataType.toTrinoQueryResult(value);
        if (expected != value) {
            this.output.append(String.format(" // TODO non-identity toTrinoQueryResult function was used: %s vs %s", value, expected));
        }
        this.output.append("\n");
        return this;
    }

    private String typeConstructor(Type type) {
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return String.format("createDecimalType(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return String.format("createCharType(%s)", charType.getLength());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return "createUnboundedVarcharType()";
            }
            return String.format("createVarcharType(%s)", varcharType.getBoundedLength());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            return String.format("createTimeType(%s)", timeType.getPrecision());
        }
        if (type instanceof TimeWithTimeZoneType) {
            TimeWithTimeZoneType timeWithTimeZoneType = (TimeWithTimeZoneType)type;
            return String.format("createTimeWithTimeZoneType(%s)", timeWithTimeZoneType.getPrecision());
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return String.format("createTimestampType(%s)", timestampType.getPrecision());
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            return String.format("createTimestampWithTimeZoneType(%s)", timestampWithTimeZoneType.getPrecision());
        }
        try {
            for (Field field : type.getClass().getFields()) {
                if (!field.getName().matches("^[A-Z_]+$") || !Modifier.isStatic(field.getModifiers()) || field.get(null) != type) continue;
                return field.getName();
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return type.getDisplayName();
    }

    public DataTypeTestToSqlDataTypeTestConverter execute(Object ... args) {
        this.output.append(" .execute( ... ) // TODO\n");
        throw new RuntimeException("Code replacement:\n" + String.valueOf(this.output));
    }

    private static String toJavaLiteral(String value) {
        if (value.contains("\\") || value.contains("\"") || value.contains("\n")) {
            throw new IllegalArgumentException(String.format("Unsupported value: [%s]", value));
        }
        return String.format("\"%s\"", value);
    }
}

