/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.datatype;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.datatype.ColumnSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.sql.TemporaryRelation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;

public final class SqlDataTypeTest {
    private final List<TestCase> testCases = new ArrayList<TestCase>();

    public static SqlDataTypeTest create() {
        return new SqlDataTypeTest();
    }

    private SqlDataTypeTest() {
    }

    public SqlDataTypeTest addRoundTrip(String literal) {
        return this.addRoundTrip(literal, literal);
    }

    public SqlDataTypeTest addRoundTrip(String inputLiteral, String expectedLiteral) {
        this.testCases.add(new TestCase(Optional.empty(), Optional.empty(), inputLiteral, Optional.empty(), expectedLiteral));
        return this;
    }

    public SqlDataTypeTest addRoundTrip(String inputType, String literal, Type expectedType) {
        return this.addRoundTrip(inputType, literal, expectedType, literal);
    }

    public SqlDataTypeTest addRoundTrip(String inputType, String inputLiteral, Type expectedType, String expectedLiteral) {
        this.addRoundTrip(Optional.empty(), inputType, inputLiteral, expectedType, expectedLiteral);
        return this;
    }

    public SqlDataTypeTest addRoundTrip(String columnName, String inputType, String inputLiteral, Type expectedType, String expectedLiteral) {
        this.addRoundTrip(Optional.of(columnName), inputType, inputLiteral, expectedType, expectedLiteral);
        return this;
    }

    public SqlDataTypeTest addRoundTrip(Optional<String> columnName, String inputType, String inputLiteral, Type expectedType, String expectedLiteral) {
        this.testCases.add(new TestCase(columnName, Optional.of(inputType), inputLiteral, Optional.of(expectedType), expectedLiteral));
        return this;
    }

    public SqlDataTypeTest execute(QueryRunner queryRunner, DataSetup dataSetup) {
        return this.execute(queryRunner, queryRunner.getDefaultSession(), dataSetup);
    }

    public SqlDataTypeTest execute(QueryRunner queryRunner, Session session, DataSetup dataSetup) {
        Preconditions.checkState((!this.testCases.isEmpty() ? 1 : 0) != 0, (Object)"No test cases");
        try (TemporaryRelation temporaryRelation = dataSetup.setupTemporaryRelation(Collections.unmodifiableList(this.testCases));){
            this.verifySelect(queryRunner, session, temporaryRelation);
            this.verifyPredicate(queryRunner, session, temporaryRelation);
        }
        return this;
    }

    private void verifySelect(QueryRunner queryRunner, Session session, TemporaryRelation temporaryRelation) {
        QueryAssertions queryAssertions = new QueryAssertions(queryRunner);
        QueryAssertions.QueryAssert assertion = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)queryAssertions.query(session, "SELECT * FROM " + temporaryRelation.getName()));
        MaterializedResult expected = queryRunner.execute(session, this.testCases.stream().map(TestCase::getExpectedLiteral).collect(Collectors.joining(",", "VALUES ROW(", ")")));
        for (int column = 0; column < this.testCases.size(); ++column) {
            TestCase testCase = this.testCases.get(column);
            if (!testCase.getExpectedType().isPresent()) continue;
            Type expectedType = testCase.getExpectedType().get();
            assertion.outputHasType(column, expectedType);
            ((ObjectAssert)((ListAssert)Assertions.assertThat((List)expected.getTypes()).as(String.format("Expected literal type at column %d (check consistency of expected type and expected literal)", column + 1), new Object[0])).element(column)).isEqualTo((Object)expectedType);
        }
        assertion.matches(expected);
    }

    private void verifyPredicate(QueryRunner queryRunner, Session session, TemporaryRelation temporaryRelation) {
        String queryWithAll = "SELECT 'all found' FROM " + temporaryRelation.getName() + " WHERE " + IntStream.range(0, this.testCases.size()).mapToObj(this::getPredicate).collect(Collectors.joining(" AND "));
        MaterializedResult result = queryRunner.execute(session, queryWithAll);
        if (result.getOnlyColumnAsSet().equals(Set.of("all found"))) {
            return;
        }
        QueryAssertions queryAssertions = new QueryAssertions(queryRunner);
        for (int column = 0; column < this.testCases.size(); ++column) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)queryAssertions.query(session, "SELECT 'found' FROM " + temporaryRelation.getName() + " WHERE " + this.getPredicate(column)))).matches("VALUES 'found'");
        }
    }

    private String getPredicate(int column) {
        String columnName = this.testCases.get(column).getColumnName().orElseGet(() -> "col_" + column);
        return String.format("%s IS NOT DISTINCT FROM %s", columnName, this.testCases.get(column).getExpectedLiteral());
    }

    private static class TestCase
    implements ColumnSetup {
        private final Optional<String> columnName;
        private final Optional<String> declaredType;
        private final String inputLiteral;
        private final Optional<Type> expectedType;
        private final String expectedLiteral;

        public TestCase(Optional<String> columnName, Optional<String> declaredType, String inputLiteral, Optional<Type> expectedType, String expectedLiteral) {
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
            this.declaredType = Objects.requireNonNull(declaredType, "declaredType is null");
            this.expectedType = Objects.requireNonNull(expectedType, "expectedType is null");
            this.inputLiteral = Objects.requireNonNull(inputLiteral, "inputLiteral is null");
            this.expectedLiteral = Objects.requireNonNull(expectedLiteral, "expectedLiteral is null");
        }

        @Override
        public Optional<String> getDeclaredType() {
            return this.declaredType;
        }

        @Override
        public String getInputLiteral() {
            return this.inputLiteral;
        }

        public Optional<Type> getExpectedType() {
            return this.expectedType;
        }

        public String getExpectedLiteral() {
            return this.expectedLiteral;
        }

        public Optional<String> getColumnName() {
            return this.columnName;
        }
    }
}

