/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.StageStats;
import io.trino.client.StatementStats;
import io.trino.execution.FailureInjector;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.base.TemporaryTables;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedResultWithQueryId;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.Percentage;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseFailureRecoveryTest
extends AbstractTestQueryFramework {
    private static final Duration MAX_ERROR_DURATION = new Duration(5.0, TimeUnit.SECONDS);
    private static final Duration REQUEST_TIMEOUT = new Duration(5.0, TimeUnit.SECONDS);
    private static final int DEFAULT_MAX_PARALLEL_TEST_CONCURRENCY = 4;
    private final RetryPolicy retryPolicy;
    private final Semaphore parallelTestsSemaphore;

    protected BaseFailureRecoveryTest(RetryPolicy retryPolicy) {
        this(retryPolicy, 4);
    }

    protected BaseFailureRecoveryTest(RetryPolicy retryPolicy, int maxParallelTestConcurrency) {
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
        this.parallelTestsSemaphore = new Semaphore(maxParallelTestConcurrency);
    }

    protected RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    protected final QueryRunner createQueryRunner() throws Exception {
        return this.createQueryRunner((List<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.ORDERS, (Object)TpchTable.CUSTOMER, (Object)TpchTable.SUPPLIER), (Map<String, String>)ImmutableMap.builder().put((Object)"query.remote-task.max-error-duration", (Object)MAX_ERROR_DURATION.toString()).put((Object)"exchange.max-error-duration", (Object)MAX_ERROR_DURATION.toString()).put((Object)"retry-policy", (Object)this.retryPolicy.toString()).put((Object)"retry-initial-delay", (Object)"0s").put((Object)"query-retry-attempts", (Object)"1").put((Object)"failure-injection.request-timeout", (Object)new Duration((double)(REQUEST_TIMEOUT.toMillis() * 2L), TimeUnit.MILLISECONDS).toString()).put((Object)"exchange.http-client.idle-timeout", (Object)REQUEST_TIMEOUT.toString()).put((Object)"fault-tolerant-execution-max-partition-count", (Object)"5").put((Object)"exchange.deduplication-buffer-size", (Object)"1kB").put((Object)"fault-tolerant-execution-task-memory", (Object)"1GB").buildOrThrow(), (Map<String, String>)ImmutableMap.of((Object)"scheduler.http-client.idle-timeout", (Object)REQUEST_TIMEOUT.toString()));
    }

    protected abstract QueryRunner createQueryRunner(List<TpchTable<?>> var1, Map<String, String> var2, Map<String, String> var3) throws Exception;

    protected abstract boolean areWriteRetriesSupported();

    protected void testSelect(String query) {
        this.testSelect(query, Optional.empty());
    }

    protected void testSelect(String query, Optional<Session> session) {
        this.testSelect(query, session, queryId -> {});
    }

    protected void testSelect(String query, Optional<Session> session, Consumer<QueryId> queryAssertion) {
        this.assertThatQuery(query).withSession(session).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(BaseFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully(queryAssertion);
        this.assertThatQuery(query).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(BaseFailureRecoveryTest.distributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("Encountered too many errors talking to a worker node")).finishesSuccessfully();
        this.assertThatQuery(query).withSession(session).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully(queryAssertion);
        this.assertThatQuery(query).withSession(session).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.EXTERNAL)).at(BaseFailureRecoveryTest.distributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully(queryAssertion);
        if (this.getRetryPolicy() == RetryPolicy.QUERY) {
            this.assertThatQuery(query).withSession(session).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(BaseFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully(queryAssertion);
            this.assertThatQuery(query).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(BaseFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully();
        }
    }

    @DataProvider(name="parallelTests", parallel=true)
    public Object[][] parallelTests() {
        return new Object[][]{this.parallelTest("testCreateTable", this::testCreateTable), this.parallelTest("testInsert", this::testInsert), this.parallelTest("testDelete", this::testDelete), this.parallelTest("testDeleteWithSubquery", this::testDeleteWithSubquery), this.parallelTest("testUpdate", this::testUpdate), this.parallelTest("testUpdateWithSubquery", this::testUpdateWithSubquery), this.parallelTest("testMerge", this::testMerge), this.parallelTest("testRefreshMaterializedView", this::testRefreshMaterializedView), this.parallelTest("testAnalyzeTable", this::testAnalyzeTable), this.parallelTest("testExplainAnalyze", this::testExplainAnalyze), this.parallelTest("testRequestTimeouts", this::testRequestTimeouts)};
    }

    @Test(dataProvider="parallelTests")
    public final void testParallel(Runnable runnable) {
        try {
            this.parallelTestsSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        try {
            runnable.run();
        }
        finally {
            this.parallelTestsSemaphore.release();
        }
    }

    protected void testCreateTable() {
        this.testTableModification(Optional.empty(), "CREATE TABLE <table> AS SELECT * FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testInsert() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders WITH NO DATA"), "INSERT INTO <table> SELECT * FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testDelete() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "DELETE FROM <table> WHERE orderkey = 1", Optional.of("DROP TABLE <table>"));
    }

    protected void testDeleteWithSubquery() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "DELETE FROM <table> WHERE custkey IN (SELECT custkey FROM customer WHERE nationkey = 1)", Optional.of("DROP TABLE <table>"));
    }

    protected void testUpdate() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "UPDATE <table> SET shippriority = 101 WHERE custkey = 1", Optional.of("DROP TABLE <table>"));
    }

    protected void testUpdateWithSubquery() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "UPDATE <table> SET shippriority = 101 WHERE custkey = (SELECT min(custkey) FROM customer)", Optional.of("DROP TABLE <table>"));
    }

    protected void testAnalyzeTable() {
        this.testNonSelect(Optional.empty(), Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "ANALYZE <table>", Optional.of("DROP TABLE <table>"), false);
    }

    protected void testMerge() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "MERGE INTO <table> t\nUSING (SELECT orderkey, 'X' clerk FROM <table>) s\nON t.orderkey = s.orderkey\nWHEN MATCHED AND s.orderkey > 1000\n    THEN UPDATE SET clerk = t.clerk || s.clerk\nWHEN MATCHED AND s.orderkey <= 1000\n    THEN DELETE\n", Optional.of("DROP TABLE <table>"));
    }

    protected void testRefreshMaterializedView() {
        this.testTableModification(Optional.of("CREATE MATERIALIZED VIEW <table> AS SELECT * FROM orders"), "REFRESH MATERIALIZED VIEW <table>", Optional.of("DROP MATERIALIZED VIEW <table>"));
    }

    protected void testExplainAnalyze() {
        this.testSelect("EXPLAIN ANALYZE SELECT orderStatus, count(*) FROM orders GROUP BY orderStatus");
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders WITH NO DATA"), "EXPLAIN ANALYZE INSERT INTO <table> SELECT * FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testRequestTimeouts() {
        if (this.areWriteRetriesSupported()) {
            this.assertThatQuery("INSERT INTO <table> SELECT * FROM orders").withSetupQuery(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders WITH NO DATA")).withCleanupQuery(Optional.of("DROP TABLE <table>")).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(BaseFailureRecoveryTest.leafStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfullyWithoutTaskFailures();
        }
    }

    protected void testTableModification(Optional<String> setupQuery, String query, Optional<String> cleanupQuery) {
        this.testTableModification(Optional.empty(), setupQuery, query, cleanupQuery);
    }

    protected void testTableModification(Optional<Session> session, Optional<String> setupQuery, String query, Optional<String> cleanupQuery) {
        this.testNonSelect(session, setupQuery, query, cleanupQuery, true);
    }

    protected void testNonSelect(Optional<Session> session, Optional<String> setupQuery, String query, Optional<String> cleanupQuery, boolean writesData) {
        if (writesData && !this.areWriteRetriesSupported()) {
            this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).failsDespiteRetries(failure -> failure.hasMessageMatching("This connector does not support query retries")).cleansUpTemporaryTables();
            return;
        }
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseFailureRecoveryTest.boundaryCoordinatorStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).cleansUpTemporaryTables();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseFailureRecoveryTest.rootStage()).failsAlways(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).cleansUpTemporaryTables();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(BaseFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("This error is injected by the failure injection service")).finishesSuccessfully().cleansUpTemporaryTables();
        this.assertThatQuery(query).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(BaseFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageContaining("Encountered too many errors talking to a worker node")).finishesSuccessfully().cleansUpTemporaryTables();
        if (this.getRetryPolicy() == RetryPolicy.QUERY) {
            this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(BaseFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Error 500 Internal Server Error|Error closing remote buffer, expected 204 got 500")).finishesSuccessfully().cleansUpTemporaryTables();
            this.assertThatQuery(query).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(BaseFailureRecoveryTest.boundaryDistributedStage()).failsWithoutRetries(failure -> failure.hasMessageFindingMatch("Encountered too many errors talking to a worker node|Error closing remote buffer")).finishesSuccessfully().cleansUpTemporaryTables();
        }
    }

    protected FailureRecoveryAssert assertThatQuery(String query) {
        return new FailureRecoveryAssert(query);
    }

    protected void checkTemporaryTables(Set<String> queryIds) {
        HashMap<String, Set> remainingTemporaryTables = new HashMap<String, Set>();
        HashMap<String, Set> assertionErrorMessages = new HashMap<String, Set>();
        for (String queryId : queryIds) {
            String temporaryTablePrefix = TemporaryTables.temporaryTableNamePrefix((String)queryId);
            MaterializedResult temporaryTablesResult = this.getQueryRunner().execute("SHOW TABLES LIKE '%s%%' ESCAPE '\\'".formatted(temporaryTablePrefix.replace("_", "\\_")));
            for (MaterializedRow temporaryTableRow : temporaryTablesResult.getMaterializedRows()) {
                String temporaryTableName = (String)temporaryTableRow.getField(0);
                try {
                    Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("SELECT 1 FROM %s WHERE 1 = 0".formatted(temporaryTableName))).hasMessageContaining(".%s' does not exist", new Object[]{temporaryTableName});
                }
                catch (AssertionError e) {
                    remainingTemporaryTables.computeIfAbsent(queryId, ignored -> new HashSet()).add(temporaryTableName);
                    assertionErrorMessages.computeIfAbsent(queryId, ignored -> new HashSet()).add(((Throwable)((Object)e)).getMessage());
                }
            }
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)remainingTemporaryTables.isEmpty()).as("There should be no remaining tmp_trino tables that are queryable. They are:\n%s", new Object[]{remainingTemporaryTables.entrySet().stream().map(entry -> "\tFor queryId [%s] (prefix [%s]) remaining tables: [%s]\n\t\tWith errors: [%s]".formatted(entry.getKey(), TemporaryTables.temporaryTableNamePrefix((String)((String)entry.getKey())), Joiner.on((String)",").join((Iterable)entry.getValue()), Joiner.on((String)"],\n[").join((Iterable)assertionErrorMessages.get(entry.getKey())).replace("\n", "\n\t\t\t"))).collect(Collectors.joining("\n"))})).isTrue();
    }

    protected static Function<MaterializedResult, Integer> rootStage() {
        return result -> Integer.parseInt(BaseFailureRecoveryTest.getRootStage(result).getStageId());
    }

    protected static Function<MaterializedResult, Integer> boundaryCoordinatorStage() {
        return result -> BaseFailureRecoveryTest.findStageId(result, stage -> stage.isCoordinatorOnly() && stage.getSubStages().stream().noneMatch(StageStats::isCoordinatorOnly));
    }

    protected static Function<MaterializedResult, Integer> boundaryDistributedStage() {
        return result -> {
            StageStats rootStage = BaseFailureRecoveryTest.getRootStage(result);
            if (!rootStage.isCoordinatorOnly()) {
                return Integer.parseInt(rootStage.getStageId());
            }
            StageStats boundaryCoordinatorStage = BaseFailureRecoveryTest.findStage(result, stage -> stage.isCoordinatorOnly() && stage.getSubStages().stream().noneMatch(StageStats::isCoordinatorOnly));
            StageStats boundaryDistributedStage = (StageStats)boundaryCoordinatorStage.getSubStages().get(ThreadLocalRandom.current().nextInt(boundaryCoordinatorStage.getSubStages().size()));
            return Integer.parseInt(boundaryDistributedStage.getStageId());
        };
    }

    protected static Function<MaterializedResult, Integer> intermediateDistributedStage() {
        return result -> BaseFailureRecoveryTest.findStageId(result, stage -> !stage.isCoordinatorOnly() && !stage.getSubStages().isEmpty());
    }

    protected static Function<MaterializedResult, Integer> distributedStage() {
        return result -> BaseFailureRecoveryTest.findStageId(result, stage -> !stage.isCoordinatorOnly());
    }

    protected static Function<MaterializedResult, Integer> leafStage() {
        return result -> BaseFailureRecoveryTest.findStageId(result, stage -> stage.getSubStages().isEmpty());
    }

    private static int findStageId(MaterializedResult result, Predicate<StageStats> predicate) {
        return Integer.parseInt(BaseFailureRecoveryTest.findStage(result, predicate).getStageId());
    }

    private static StageStats findStage(MaterializedResult result, Predicate<StageStats> predicate) {
        List stages = (List)Streams.stream((Iterable)Traverser.forTree(StageStats::getSubStages).breadthFirst((Object)BaseFailureRecoveryTest.getRootStage(result))).filter(predicate).collect(ImmutableList.toImmutableList());
        if (stages.isEmpty()) {
            throw new IllegalArgumentException("stage not found");
        }
        return (StageStats)stages.get(ThreadLocalRandom.current().nextInt(stages.size()));
    }

    private static StageStats getStageStats(MaterializedResult result, int stageId) {
        return Streams.stream((Iterable)Traverser.forTree(StageStats::getSubStages).breadthFirst((Object)BaseFailureRecoveryTest.getRootStage(result))).filter(stageStats -> Integer.parseInt(stageStats.getStageId()) == stageId).findFirst().orElseThrow(() -> new IllegalArgumentException("stage stats not found: " + stageId));
    }

    private static StageStats getRootStage(MaterializedResult result) {
        StatementStats statementStats = (StatementStats)result.getStatementStats().orElseThrow(() -> new IllegalArgumentException("statement stats is not present"));
        return Objects.requireNonNull(statementStats.getRootStage(), "root stage is null");
    }

    protected Object[] parallelTest(String name, Runnable runnable) {
        return new Object[]{new ParallelTestRunnable(name, runnable)};
    }

    protected Object[][] moreParallelTests(Object[][] some, Object[] ... more) {
        Object[][] result = (Object[][])Arrays.copyOf(some, some.length + more.length);
        System.arraycopy(more, 0, result, some.length, more.length);
        return result;
    }

    protected class FailureRecoveryAssert {
        private final String query;
        private Session session;
        private Optional<Function<MaterializedResult, Integer>> stageSelector;
        private Optional<FailureInjector.InjectedFailureType> failureType;
        private Optional<ErrorType> errorType;
        private Optional<String> setup;
        private Optional<String> cleanup;
        private Set<String> queryIds;

        public FailureRecoveryAssert(String query) {
            this.session = BaseFailureRecoveryTest.this.getQueryRunner().getDefaultSession();
            this.stageSelector = Optional.empty();
            this.failureType = Optional.empty();
            this.errorType = Optional.empty();
            this.setup = Optional.empty();
            this.cleanup = Optional.empty();
            this.queryIds = new HashSet<String>();
            this.query = Objects.requireNonNull(query, "query is null");
        }

        public FailureRecoveryAssert withSession(Optional<Session> session) {
            Objects.requireNonNull(session, "session is null");
            session.ifPresent(value -> {
                this.session = value;
            });
            return this;
        }

        public FailureRecoveryAssert withSetupQuery(Optional<String> query) {
            this.setup = Objects.requireNonNull(query, "query is null");
            return this;
        }

        public FailureRecoveryAssert withCleanupQuery(Optional<String> query) {
            this.cleanup = Objects.requireNonNull(query, "query is null");
            return this;
        }

        public FailureRecoveryAssert experiencing(FailureInjector.InjectedFailureType failureType) {
            return this.experiencing(failureType, Optional.empty());
        }

        public FailureRecoveryAssert experiencing(FailureInjector.InjectedFailureType failureType, Optional<ErrorType> errorType) {
            this.failureType = Optional.of(Objects.requireNonNull(failureType, "failureType is null"));
            this.errorType = Objects.requireNonNull(errorType, "errorType is null");
            if (failureType == FailureInjector.InjectedFailureType.TASK_FAILURE) {
                Preconditions.checkArgument((boolean)errorType.isPresent(), (Object)"error type must be present when injection type is task failure");
            } else {
                Preconditions.checkArgument((boolean)errorType.isEmpty(), (Object)"error type must not be present when injection type is not task failure");
            }
            return this;
        }

        public FailureRecoveryAssert at(Function<MaterializedResult, Integer> stageSelector) {
            this.stageSelector = Optional.of(Objects.requireNonNull(stageSelector, "stageSelector is null"));
            return this;
        }

        private ExecutionResult executeExpected() {
            return this.execute(this.noRetries(this.session), this.query, Optional.empty());
        }

        private ExecutionResult executeActual(OptionalInt failureStageId) {
            return this.executeActual(this.session, failureStageId);
        }

        private ExecutionResult executeActualNoRetries(OptionalInt failureStageId) {
            return this.executeActual(this.noRetries(this.session), failureStageId);
        }

        private ExecutionResult executeActual(Session session, OptionalInt failureStageId) {
            String token = UUID.randomUUID().toString();
            if (this.failureType.isPresent()) {
                BaseFailureRecoveryTest.this.getQueryRunner().injectTaskFailure(token, failureStageId.orElseThrow(() -> new IllegalArgumentException("failure stageId not provided")), 0, 0, this.failureType.get(), this.errorType);
                return this.execute(session, this.query, Optional.of(token));
            }
            return this.execute(session, this.query, Optional.of(token));
        }

        private ExecutionResult execute(Session session, String query, Optional<String> traceToken) {
            Optional<MaterializedResult> updatedTableStatistics;
            Optional<MaterializedResult> updatedTableContent;
            RuntimeException failure;
            MaterializedResultWithQueryId resultWithQueryId;
            block10: {
                String queryId;
                String tableName;
                block9: {
                    tableName = "table_" + TestingNames.randomNameSuffix();
                    this.setup.ifPresent(sql -> BaseFailureRecoveryTest.this.getQueryRunner().execute(this.noRetries(session), this.resolveTableName((String)sql, tableName)));
                    resultWithQueryId = null;
                    failure = null;
                    queryId = null;
                    try {
                        resultWithQueryId = BaseFailureRecoveryTest.this.getDistributedQueryRunner().executeWithQueryId(this.withTraceToken(session, traceToken), this.resolveTableName(query, tableName));
                        queryId = resultWithQueryId.getQueryId().getId();
                    }
                    catch (RuntimeException e) {
                        failure = e;
                        if (!(e instanceof QueryFailedException)) break block9;
                        queryId = ((QueryFailedException)e).getQueryId().getId();
                    }
                }
                if (queryId != null) {
                    this.queryIds.add(queryId);
                }
                MaterializedResult result = resultWithQueryId == null ? null : resultWithQueryId.getResult();
                updatedTableContent = Optional.empty();
                if (result != null && result.getUpdateCount().isPresent()) {
                    updatedTableContent = Optional.of(BaseFailureRecoveryTest.this.getQueryRunner().execute(this.noRetries(session), "SELECT * FROM " + tableName));
                }
                updatedTableStatistics = Optional.empty();
                if (result != null && result.getUpdateType().isPresent() && ((String)result.getUpdateType().get()).equals("ANALYZE")) {
                    updatedTableStatistics = Optional.of(BaseFailureRecoveryTest.this.getQueryRunner().execute(this.noRetries(session), "SHOW STATS FOR " + tableName));
                }
                try {
                    this.cleanup.ifPresent(sql -> BaseFailureRecoveryTest.this.getQueryRunner().execute(this.noRetries(session), this.resolveTableName((String)sql, tableName)));
                }
                catch (RuntimeException e) {
                    if (failure == null) {
                        failure = e;
                    }
                    if (failure == e) break block10;
                    failure.addSuppressed(e);
                }
            }
            if (failure != null) {
                throw failure;
            }
            return new ExecutionResult(resultWithQueryId, updatedTableContent, updatedTableStatistics);
        }

        public void isCoordinatorOnly() {
            this.verifyFailureTypeAndStageSelector();
            ExecutionResult result = this.executeExpected();
            StageStats rootStage = ((StatementStats)result.getQueryResult().getStatementStats().get()).getRootStage();
            List subStages = rootStage.getSubStages();
            Assertions.assertThat((boolean)rootStage.isCoordinatorOnly()).isTrue();
            Assertions.assertThat((List)subStages).isEmpty();
        }

        public FailureRecoveryAssert cleansUpTemporaryTables() {
            BaseFailureRecoveryTest.this.checkTemporaryTables(this.queryIds);
            return this;
        }

        public FailureRecoveryAssert finishesSuccessfully() {
            return this.finishesSuccessfully(queryId -> {});
        }

        public FailureRecoveryAssert finishesSuccessfullyWithoutTaskFailures() {
            return this.finishesSuccessfully(queryId -> {}, false);
        }

        private FailureRecoveryAssert finishesSuccessfully(Consumer<QueryId> queryAssertion) {
            return this.finishesSuccessfully(queryAssertion, true);
        }

        public FailureRecoveryAssert finishesSuccessfully(Consumer<QueryId> queryAssertion, boolean expectTaskFailures) {
            this.verifyFailureTypeAndStageSelector();
            ExecutionResult expected = this.executeExpected();
            MaterializedResult expectedQueryResult = expected.getQueryResult();
            OptionalInt failureStageId = this.getFailureStageId(() -> expectedQueryResult);
            ExecutionResult actual = this.executeActual(failureStageId);
            int failedTasksCount = BaseFailureRecoveryTest.getStageStats(actual.getQueryResult(), failureStageId.getAsInt()).getFailedTasks();
            if (expectTaskFailures) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)failedTasksCount).withFailMessage("expected some task failures", new Object[0])).isGreaterThan(0);
            } else {
                ((AbstractIntegerAssert)Assertions.assertThat((int)failedTasksCount).withFailMessage("expected no task failures; got %s", new Object[]{failedTasksCount})).isEqualTo(0);
            }
            MaterializedResult actualQueryResult = actual.getQueryResult();
            boolean isAnalyze = expectedQueryResult.getUpdateType().isPresent() && ((String)expectedQueryResult.getUpdateType().get()).equals("ANALYZE");
            boolean isUpdate = expectedQueryResult.getUpdateCount().isPresent();
            boolean isExplain = this.query.trim().toUpperCase(Locale.ENGLISH).startsWith("EXPLAIN");
            if (isAnalyze) {
                Assert.assertEquals((Object)actualQueryResult.getUpdateCount(), (Object)expectedQueryResult.getUpdateCount());
                Assertions.assertThat(expected.getUpdatedTableStatistics()).isPresent();
                Assertions.assertThat(actual.getUpdatedTableStatistics()).isPresent();
                MaterializedResult expectedUpdatedTableStatisticsResult = expected.getUpdatedTableStatistics().get();
                MaterializedResult actualUpdatedTableStatisticsResult = actual.getUpdatedTableStatistics().get();
                Assert.assertEquals((Collection)actualUpdatedTableStatisticsResult.getTypes(), (Collection)expectedUpdatedTableStatisticsResult.getTypes(), (String)"Column types");
                Assert.assertEquals((Collection)actualUpdatedTableStatisticsResult.getColumnNames(), (Collection)expectedUpdatedTableStatisticsResult.getColumnNames(), (String)"Column names");
                Map expectedUpdatedTableStatistics = expectedUpdatedTableStatisticsResult.getMaterializedRows().stream().collect(Collectors.toMap(row -> (String)row.getField(0), Functions.identity()));
                Map actualUpdatedTableStatistics = actualUpdatedTableStatisticsResult.getMaterializedRows().stream().collect(Collectors.toMap(row -> (String)row.getField(0), Functions.identity()));
                Assert.assertEquals(actualUpdatedTableStatistics.keySet(), expectedUpdatedTableStatistics.keySet(), (String)"Table columns");
                expectedUpdatedTableStatistics.forEach((key, expectedRow) -> {
                    MaterializedRow actualRow = (MaterializedRow)actualUpdatedTableStatistics.get(key);
                    Assert.assertEquals((int)actualRow.getFieldCount(), (int)expectedRow.getFieldCount(), (String)"Unexpected layout of stats");
                    block7: for (int statsColumnIndex = 0; statsColumnIndex < expectedRow.getFieldCount(); ++statsColumnIndex) {
                        String statsColumnName = (String)actualUpdatedTableStatisticsResult.getColumnNames().get(statsColumnIndex);
                        String testedFieldDescription = "Field %d '%s' in %s".formatted(statsColumnIndex, statsColumnName, actualRow);
                        Object expectedValue = expectedRow.getField(statsColumnIndex);
                        Object actualValue = actualRow.getField(statsColumnIndex);
                        if (expectedValue == null) {
                            ((ObjectAssert)Assertions.assertThat((Object)actualValue).as(testedFieldDescription, new Object[0])).isNull();
                            continue;
                        }
                        switch (statsColumnName) {
                            case "data_size": 
                            case "distinct_values_count": {
                                ((AbstractDoubleAssert)Assertions.assertThat((double)((Double)actualValue)).as(testedFieldDescription, new Object[0])).isCloseTo(((Double)expectedValue).doubleValue(), Percentage.withPercentage((double)5.0));
                                continue block7;
                            }
                            default: {
                                ((ObjectAssert)Assertions.assertThat((Object)actualValue).as(testedFieldDescription, new Object[0])).isEqualTo(expectedValue);
                            }
                        }
                    }
                });
            } else if (isUpdate) {
                Assert.assertEquals((Object)actualQueryResult.getUpdateCount(), (Object)expectedQueryResult.getUpdateCount());
                Assertions.assertThat(expected.getUpdatedTableContent()).isPresent();
                Assertions.assertThat(actual.getUpdatedTableContent()).isPresent();
                MaterializedResult expectedUpdatedTableContent = expected.getUpdatedTableContent().get();
                MaterializedResult actualUpdatedTableContent = actual.getUpdatedTableContent().get();
                QueryAssertions.assertEqualsIgnoreOrder(actualUpdatedTableContent, expectedUpdatedTableContent, "For query: \n " + this.query);
            } else if (isExplain) {
                Assert.assertEquals((int)actualQueryResult.getRowCount(), (int)expectedQueryResult.getRowCount());
            } else {
                QueryAssertions.assertEqualsIgnoreOrder(actualQueryResult, expectedQueryResult, "For query: \n " + this.query);
            }
            queryAssertion.accept(actual.getQueryId());
            return this;
        }

        public FailureRecoveryAssert failsAlways(Consumer<AbstractThrowableAssert<?, ? extends Throwable>> failureAssertion) {
            this.failsWithoutRetries(failureAssertion);
            this.failsDespiteRetries(failureAssertion);
            return this;
        }

        public FailureRecoveryAssert failsWithoutRetries(Consumer<AbstractThrowableAssert<?, ? extends Throwable>> failureAssertion) {
            this.verifyFailureTypeAndStageSelector();
            OptionalInt failureStageId = this.getFailureStageId(() -> this.executeExpected().getQueryResult());
            failureAssertion.accept(Assertions.assertThatThrownBy(() -> this.executeActualNoRetries(failureStageId)));
            return this;
        }

        public FailureRecoveryAssert failsDespiteRetries(Consumer<AbstractThrowableAssert<?, ? extends Throwable>> failureAssertion) {
            this.verifyFailureTypeAndStageSelector();
            OptionalInt failureStageId = this.getFailureStageId(() -> this.executeExpected().getQueryResult());
            failureAssertion.accept(Assertions.assertThatThrownBy(() -> this.executeActual(failureStageId)));
            return this;
        }

        private void verifyFailureTypeAndStageSelector() {
            ((AbstractBooleanAssert)Assertions.assertThat((this.failureType.isPresent() == this.stageSelector.isPresent() ? 1 : 0) != 0).withFailMessage("Either both or none of failureType and stageSelector must be set", new Object[0])).isTrue();
        }

        private OptionalInt getFailureStageId(Supplier<MaterializedResult> expectedQueryResult) {
            if (this.stageSelector.isEmpty()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.stageSelector.get().apply(expectedQueryResult.get()));
        }

        private String resolveTableName(String query, String tableName) {
            return query.replaceAll("<table>", tableName);
        }

        private Session noRetries(Session session) {
            return Session.builder((Session)session).setSystemProperty("retry_policy", "NONE").build();
        }

        private Session withTraceToken(Session session, Optional<String> traceToken) {
            return Session.builder((Session)session).setTraceToken(traceToken).build();
        }
    }

    private record ParallelTestRunnable(String name, Runnable runnable) implements Runnable
    {
        ParallelTestRunnable {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(runnable, "runnable is null");
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }

    private static class ExecutionResult {
        private final MaterializedResult queryResult;
        private final QueryId queryId;
        private final Optional<MaterializedResult> updatedTableContent;
        private final Optional<MaterializedResult> updatedTableStatistics;

        private ExecutionResult(MaterializedResultWithQueryId resultWithQueryId, Optional<MaterializedResult> updatedTableContent, Optional<MaterializedResult> updatedTableStatistics) {
            Objects.requireNonNull(resultWithQueryId, "resultWithQueryId is null");
            this.queryResult = resultWithQueryId.getResult();
            this.queryId = resultWithQueryId.getQueryId();
            this.updatedTableContent = Objects.requireNonNull(updatedTableContent, "updatedTableContent is null");
            this.updatedTableStatistics = Objects.requireNonNull(updatedTableStatistics, "updatedTableStatistics is null");
        }

        public MaterializedResult getQueryResult() {
            return this.queryResult;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public Optional<MaterializedResult> getUpdatedTableContent() {
            return this.updatedTableContent;
        }

        public Optional<MaterializedResult> getUpdatedTableStatistics() {
            return this.updatedTableStatistics;
        }
    }
}

