/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.spi.security.Identity;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

public abstract class BaseConnectorSmokeTest
extends AbstractTestQueryFramework {
    protected static final List<TpchTable<?>> REQUIRED_TPCH_TABLES = ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.REGION);

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA " + schemaName;
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Override
    @Test
    public void ensureTestNamingConvention() {
        Assertions.assertThat((String)this.getClass().getName()).endsWith((CharSequence)"ConnectorSmokeTest");
    }

    @Test
    public void testSelect() {
        this.assertQuery("SELECT name FROM region");
    }

    @Test
    public void testPredicate() {
        this.assertQuery("SELECT name, regionkey FROM nation WHERE nationkey = 10");
        this.assertQuery("SELECT name, regionkey FROM nation WHERE nationkey BETWEEN 5 AND 15");
        this.assertQuery("SELECT name, regionkey FROM nation WHERE name = 'EGYPT'");
    }

    @Test
    public void testLimit() {
        this.assertQuery("SELECT name FROM region LIMIT 5");
    }

    @Test
    public void testTopN() {
        this.assertQuery("SELECT regionkey FROM nation ORDER BY name LIMIT 3");
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(nationkey) FROM nation GROUP BY regionkey");
    }

    @Test
    public void testHaving() {
        this.assertQuery("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 58", "VALUES (4, 58)");
    }

    @Test
    public void testJoin() {
        this.assertQuery("SELECT n.name, r.name FROM nation n JOIN region r on n.regionkey = r.regionkey");
    }

    @Test
    public void testCreateTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            this.assertQueryFails("CREATE TABLE xxxx (a bigint, b double)", "This connector does not support creating tables");
            return;
        }
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " " + this.getCreateTableDefaultDefinition());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + tableName))).returnsEmptyResult();
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected String getCreateTableDefaultDefinition() {
        return "(a bigint, b double)";
    }

    protected String expectedValues(String values) {
        return String.format("SELECT CAST(a AS bigint), CAST(b AS double) FROM (VALUES %s) AS t (a, b)", values);
    }

    @Test
    public void testCreateTableAsSelect() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            this.assertQueryFails("CREATE TABLE xxxx AS SELECT BIGINT '42' a, DOUBLE '-38.5' b", "This connector does not support creating tables with data");
            return;
        }
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + tableName))).matches("VALUES (BIGINT '42', -385e-1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsert() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO region (regionkey) VALUES (42)", "This connector does not support inserts");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_", this.getCreateTableDefaultDefinition());){
            this.assertUpdate("INSERT INTO " + table.getName() + " (a, b) VALUES (42, -38.5), (13, 99.9)", 2L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + table.getName()))).matches(this.expectedValues("(42, -38.5), (13, 99.9)"));
        }
    }

    @Test
    public void verifySupportsDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE)) {
            return;
        }
        BaseConnectorSmokeTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_delete", "AS SELECT * FROM region");){
            this.assertQueryFails("DELETE FROM " + table.getName(), "This connector does not support modifying table rows");
        }
    }

    @Test
    public void verifySupportsRowLevelDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE)) {
            return;
        }
        BaseConnectorSmokeTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_row_level_delete", "AS SELECT * FROM region");){
            this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE regionkey = 2", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testDeleteAllDataFromTable() {
        BaseConnectorSmokeTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_all_data", "AS SELECT * FROM region");){
            this.getQueryRunner().execute("DELETE FROM " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testRowLevelDelete() {
        BaseConnectorSmokeTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_row_delete", "AS SELECT * FROM region");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey = 2", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName() + " WHERE regionkey = 2"))).returnsEmptyResult();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT cast(regionkey AS integer) FROM " + table.getName()))).skippingTypesCheck().matches("VALUES 0, 1, 3, 4");
        }
    }

    @Test
    public void testUpdate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            throw new AssertionError((Object)"Cannot test UPDATE without INSERT");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_", this.getCreateTableDefaultDefinition());){
            this.assertUpdate("INSERT INTO " + table.getName() + " (a, b) SELECT regionkey, regionkey * 2.5 FROM region", "SELECT count(*) FROM region");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + table.getName()))).matches(this.expectedValues("(0, 0.0), (1, 2.5), (2, 5.0), (3, 7.5), (4, 10.0)"));
            this.assertUpdate("UPDATE " + table.getName() + " SET b = b + 1.2 WHERE a % 2 = 0", 3L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + table.getName()))).matches(this.expectedValues("(0, 1.2), (1, 2.5), (2, 6.2), (3, 7.5), (4, 11.2)"));
        }
    }

    @Test
    public void testMerge() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE)) {
            this.assertQueryFails("MERGE INTO nation n USING nation s ON (n.nationkey = s.nationkey) WHEN MATCHED AND n.regionkey < 1 THEN UPDATE SET nationkey = 5", "This connector does not support modifying table rows");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            throw new AssertionError((Object)"Cannot test MERGE without INSERT");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_merge_", this.getCreateTableDefaultDefinition());){
            this.assertUpdate("INSERT INTO " + table.getName() + " (a, b) SELECT regionkey, regionkey * 2.5 FROM region", "SELECT count(*) FROM region");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + table.getName()))).matches(this.expectedValues("(0, 0.0), (1, 2.5), (2, 5.0), (3, 7.5), (4, 10.0)"));
            this.assertUpdate("MERGE INTO " + table.getName() + " t USING (VALUES (0, 1.3), (2, 2.9), (3, 0.0), (4, -5.0), (5, 5.7)) AS s (a, b) ON (t.a = s.a) WHEN MATCHED AND s.b > 0 THEN UPDATE SET b = t.b + s.b WHEN MATCHED AND s.b = 0 THEN DELETE WHEN NOT MATCHED THEN INSERT VALUES (s.a, s.b)", 4L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + table.getName()))).matches(this.expectedValues("(0, 1.3), (1, 2.5), (2, 7.9), (4, 10.0), (5, 5.7)"));
        }
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test_schema_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            this.assertQueryFails(this.createSchemaSql(schemaName), "This connector does not support creating schemas");
            return;
        }
        this.assertUpdate(this.createSchemaSql(schemaName));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW SCHEMAS"))).skippingTypesCheck().containsAll(String.format("VALUES '%s', '%s'", this.getSession().getSchema().orElseThrow(), schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testCreateSchemaWithNonLowercaseOwnerName() {
        BaseConnectorSmokeTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA));
        Session newSession = Session.builder((Session)this.getSession()).setIdentity(Identity.ofUser((String)"ADMIN")).build();
        String schemaName = "test_schema_create_uppercase_owner_name_" + TestingNames.randomNameSuffix();
        this.assertUpdate(newSession, this.createSchemaSql(schemaName));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(newSession, "SHOW SCHEMAS"))).skippingTypesCheck().containsAll(String.format("VALUES '%s'", schemaName));
        this.assertUpdate(newSession, "DROP SCHEMA " + schemaName);
    }

    @Test
    public void testRenameSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA)) {
            String schemaName = (String)this.getSession().getSchema().orElseThrow();
            this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", schemaName, schemaName + TestingNames.randomNameSuffix()), "This connector does not support renaming schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new SkipException("Skipping as connector does not support CREATE SCHEMA");
        }
        String schemaName = "test_rename_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            this.assertUpdate("ALTER SCHEMA " + schemaName + " RENAME TO " + schemaName + "_renamed");
        }
        finally {
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName + "_renamed");
        }
    }

    @Test
    public void testRenameTable() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
            this.assertQueryFails("ALTER TABLE nation RENAME TO yyyy", "This connector does not support renaming tables");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String oldTable = "test_rename_old_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + oldTable + " " + this.getCreateTableDefaultDefinition());
        String newTable = "test_rename_new_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + oldTable);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + oldTable + "'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + newTable))).returnsEmptyResult();
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertUpdate("INSERT INTO " + newTable + " (a, b) VALUES (42, -38.5)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + newTable))).matches("VALUES (BIGINT '42', -385e-1)");
        }
        this.assertUpdate("DROP TABLE " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + newTable + "'"))).returnsEmptyResult();
    }

    @Test
    public void testRenameTableAcrossSchemas() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
                throw new SkipException("Skipping since rename table is not supported at all");
            }
            this.assertQueryFails("ALTER TABLE nation RENAME TO other_schema.yyyy", "This connector does not support renaming tables across schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE SCHEMA, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String oldTable = "test_rename_old_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + oldTable + " " + this.getCreateTableDefaultDefinition());
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(schemaName));
        String newTable = schemaName + ".test_rename_new_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + oldTable);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + oldTable + "'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + newTable))).returnsEmptyResult();
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertUpdate("INSERT INTO " + newTable + " (a, b) VALUES (42, -38.5)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + newTable))).matches("VALUES (BIGINT '42', -385e-1)");
        }
        this.assertUpdate("DROP TABLE " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + newTable + "'"))).returnsEmptyResult();
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testShowInformationSchemaTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES FROM information_schema"))).skippingTypesCheck().containsAll("VALUES 'applicable_roles', 'columns', 'enabled_roles', 'roles', 'schemata', 'table_privileges', 'tables', 'views'");
    }

    @Test
    public void testSelectInformationSchemaTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().orElseThrow())))).skippingTypesCheck().containsAll("VALUES 'nation', 'region'");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(String.format("SELECT column_name FROM information_schema.columns WHERE table_schema = '%s' AND table_name = 'region'", this.getSession().getSchema().orElseThrow())))).skippingTypesCheck().matches("VALUES 'regionkey', 'name', 'comment'");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).matches((CharSequence)String.format("CREATE TABLE %s.%s.region \\(\n   regionkey (bigint|decimal\\(19, 0\\)),\n   name varchar(\\(\\d+\\))?,\n   comment varchar(\\(\\d+\\))?\n\\)", Pattern.quote((String)this.getSession().getCatalog().orElseThrow()), Pattern.quote((String)this.getSession().getSchema().orElseThrow())));
    }

    @Test
    public void testView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            this.assertQueryFails("CREATE VIEW nation_v AS SELECT * FROM nation", "This connector does not support creating views");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String viewName = "test_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewName))).skippingTypesCheck().matches("SELECT * FROM nation");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE VIEW " + viewName))).matches((CharSequence)("(?s)CREATE VIEW \\Q" + catalogName + "." + schemaName + "." + viewName + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP  VIEW " + viewName);
    }

    @Test
    public void testMaterializedView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW nation_mv AS SELECT * FROM nation", "This connector does not support creating materialized views");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String viewName = "test_materialized_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewName))).skippingTypesCheck().matches("SELECT * FROM nation");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + viewName))).matches((CharSequence)("(?s)CREATE MATERIALIZED VIEW \\Q" + catalogName + "." + schemaName + "." + viewName + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }
}

