/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import java.util.Objects;
import java.util.function.Predicate;

public enum TestingConnectorBehavior {
    SUPPORTS_ARRAY,
    SUPPORTS_ROW_TYPE,
    SUPPORTS_PREDICATE_PUSHDOWN,
    SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN(SUPPORTS_PREDICATE_PUSHDOWN),
    SUPPORTS_PREDICATE_ARITHMETIC_EXPRESSION_PUSHDOWN(SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN),
    SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN_WITH_LIKE(SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN),
    SUPPORTS_DYNAMIC_FILTER_PUSHDOWN(false),
    SUPPORTS_LIMIT_PUSHDOWN,
    SUPPORTS_TOPN_PUSHDOWN,
    SUPPORTS_TOPN_PUSHDOWN_WITH_VARCHAR(fallback -> fallback.test(SUPPORTS_TOPN_PUSHDOWN) && fallback.test(SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY)),
    SUPPORTS_AGGREGATION_PUSHDOWN,
    SUPPORTS_AGGREGATION_PUSHDOWN_STDDEV(false),
    SUPPORTS_AGGREGATION_PUSHDOWN_VARIANCE(false),
    SUPPORTS_AGGREGATION_PUSHDOWN_COVARIANCE(false),
    SUPPORTS_AGGREGATION_PUSHDOWN_CORRELATION(false),
    SUPPORTS_AGGREGATION_PUSHDOWN_REGRESSION(false),
    SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT(false),
    SUPPORTS_JOIN_PUSHDOWN(false),
    SUPPORTS_JOIN_PUSHDOWN_WITH_FULL_JOIN(SUPPORTS_JOIN_PUSHDOWN),
    SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM(SUPPORTS_JOIN_PUSHDOWN),
    SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY(fallback -> fallback.test(SUPPORTS_JOIN_PUSHDOWN) && fallback.test(SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY)),
    SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_INEQUALITY(fallback -> fallback.test(SUPPORTS_JOIN_PUSHDOWN) && fallback.test(SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY)),
    SUPPORTS_CREATE_SCHEMA,
    SUPPORTS_RENAME_SCHEMA(SUPPORTS_CREATE_SCHEMA),
    SUPPORTS_CREATE_TABLE,
    SUPPORTS_CREATE_TABLE_WITH_DATA(SUPPORTS_CREATE_TABLE),
    SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT(SUPPORTS_CREATE_TABLE),
    SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT(SUPPORTS_CREATE_TABLE),
    SUPPORTS_RENAME_TABLE,
    SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS(SUPPORTS_RENAME_TABLE),
    SUPPORTS_ADD_COLUMN,
    SUPPORTS_ADD_COLUMN_WITH_COMMENT(SUPPORTS_ADD_COLUMN),
    SUPPORTS_DROP_COLUMN(SUPPORTS_ADD_COLUMN),
    SUPPORTS_DROP_FIELD(fallback -> fallback.test(SUPPORTS_DROP_COLUMN) && fallback.test(SUPPORTS_ROW_TYPE)),
    SUPPORTS_RENAME_COLUMN,
    SUPPORTS_SET_COLUMN_TYPE,
    SUPPORTS_COMMENT_ON_TABLE,
    SUPPORTS_COMMENT_ON_VIEW(false),
    SUPPORTS_COMMENT_ON_COLUMN,
    SUPPORTS_COMMENT_ON_VIEW_COLUMN(false),
    SUPPORTS_CREATE_VIEW(false),
    SUPPORTS_CREATE_MATERIALIZED_VIEW(false),
    SUPPORTS_CREATE_FEDERATED_MATERIALIZED_VIEW(SUPPORTS_CREATE_MATERIALIZED_VIEW),
    SUPPORTS_RENAME_MATERIALIZED_VIEW(SUPPORTS_CREATE_MATERIALIZED_VIEW),
    SUPPORTS_RENAME_MATERIALIZED_VIEW_ACROSS_SCHEMAS(SUPPORTS_RENAME_MATERIALIZED_VIEW),
    SUPPORTS_INSERT,
    SUPPORTS_NOT_NULL_CONSTRAINT(SUPPORTS_CREATE_TABLE),
    SUPPORTS_DELETE(false),
    SUPPORTS_ROW_LEVEL_DELETE(SUPPORTS_DELETE),
    SUPPORTS_UPDATE(false),
    SUPPORTS_MERGE(false),
    SUPPORTS_TRUNCATE(false),
    SUPPORTS_NEGATIVE_DATE,
    SUPPORTS_CANCELLATION(false),
    SUPPORTS_MULTI_STATEMENT_WRITES(false);

    private final Predicate<Predicate<TestingConnectorBehavior>> hasBehaviorByDefault;

    private TestingConnectorBehavior() {
        this(true);
    }

    private TestingConnectorBehavior(boolean hasBehaviorByDefault) {
        this((Predicate<TestingConnectorBehavior> fallback) -> hasBehaviorByDefault);
    }

    private TestingConnectorBehavior(TestingConnectorBehavior defaultBehaviorSource) {
        this((Predicate<TestingConnectorBehavior> fallback) -> fallback.test(defaultBehaviorSource));
    }

    private TestingConnectorBehavior(Predicate<Predicate<TestingConnectorBehavior>> hasBehaviorByDefault) {
        this.hasBehaviorByDefault = Objects.requireNonNull(hasBehaviorByDefault, "hasBehaviorByDefault is null");
    }

    boolean hasBehaviorByDefault(Predicate<TestingConnectorBehavior> fallback) {
        return this.hasBehaviorByDefault.test(fallback);
    }
}

