/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.statistics;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.testing.QueryRunner;
import io.trino.testing.statistics.Metric;
import io.trino.testing.statistics.MetricComparator;
import io.trino.testing.statistics.MetricComparison;
import io.trino.testing.statistics.MetricComparisonStrategies;
import io.trino.testing.statistics.MetricComparisonStrategy;
import io.trino.testing.statistics.Metrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

public class StatisticsAssertion
implements AutoCloseable {
    private final QueryRunner runner;

    public StatisticsAssertion(QueryRunner runner) {
        this.runner = Objects.requireNonNull(runner, "runner is null");
    }

    @Override
    public void close() {
        this.runner.close();
    }

    public void check(@Language(value="SQL") String query, Consumer<Checks> checksBuilderConsumer) {
        Checks checks = new Checks();
        checksBuilderConsumer.accept(checks);
        checks.run(query, this.runner);
    }

    public static class Checks {
        private final List<MetricsCheck> checks = new ArrayList<MetricsCheck>();

        public Checks verifyExactColumnStatistics(String columnName) {
            this.verifyColumnStatistics(columnName, MetricComparisonStrategies.noError());
            return this;
        }

        public Checks verifyColumnStatistics(String columnName, MetricComparisonStrategy strategy) {
            this.estimate(Metrics.nullsFraction(columnName), strategy);
            this.estimate(Metrics.distinctValuesCount(columnName), strategy);
            this.estimate(Metrics.lowValue(columnName), strategy);
            this.estimate(Metrics.highValue(columnName), strategy);
            return this;
        }

        public Checks verifyCharacterColumnStatistics(String columnName, MetricComparisonStrategy strategy) {
            this.estimate(Metrics.nullsFraction(columnName), strategy);
            this.estimate(Metrics.distinctValuesCount(columnName), strategy);
            return this;
        }

        public Checks verifyNoColumnStatistics(String columnName) {
            this.noEstimate(Metrics.nullsFraction(columnName));
            this.noEstimate(Metrics.distinctValuesCount(columnName));
            this.noEstimate(Metrics.lowValue(columnName));
            this.noEstimate(Metrics.highValue(columnName));
            return this;
        }

        public Checks estimate(Metric metric, MetricComparisonStrategy strategy) {
            this.checks.add(new MetricsCheck(metric, strategy, MetricComparison.Result.MATCH));
            return this;
        }

        public Checks noEstimate(Metric metric) {
            this.checks.add(new MetricsCheck(metric, (actual, estimate) -> true, MetricComparison.Result.NO_ESTIMATE));
            return this;
        }

        void run(@Language(value="SQL") String query, QueryRunner runner) {
            List metrics = (List)this.checks.stream().map(check -> check.metric).collect(ImmutableList.toImmutableList());
            List<MetricComparison> metricComparisons = MetricComparator.getMetricComparisons(query, runner, metrics);
            Verify.verify((this.checks.size() == metricComparisons.size() ? 1 : 0) != 0);
            for (int i = 0; i < this.checks.size(); ++i) {
                MetricsCheck check2 = this.checks.get(i);
                MetricComparison metricComparison = metricComparisons.get(i);
                Assert.assertSame((Object)((Object)metricComparison.result(check2.strategy)), (Object)((Object)check2.expectedComparisonResult), (String)("Metric doesn't match: " + String.valueOf(metricComparison)));
            }
        }
    }

    private static class MetricsCheck {
        public final Metric metric;
        public final MetricComparisonStrategy strategy;
        public final MetricComparison.Result expectedComparisonResult;

        MetricsCheck(Metric metric, MetricComparisonStrategy strategy, MetricComparison.Result expectedComparisonResult) {
            this.metric = metric;
            this.strategy = strategy;
            this.expectedComparisonResult = expectedComparisonResult;
        }
    }
}

