/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.sql;

import io.trino.Session;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import java.util.Objects;

public class TrinoSqlExecutor
implements SqlExecutor {
    private final QueryRunner queryRunner;
    private final Session session;

    public TrinoSqlExecutor(QueryRunner queryRunner) {
        this(queryRunner, queryRunner.getDefaultSession());
    }

    public TrinoSqlExecutor(QueryRunner queryRunner, Session session) {
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public void execute(String sql) {
        try {
            this.queryRunner.execute(this.session, sql);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error executing sql:\n" + sql, e);
        }
    }
}

