/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.operator.scalar.JsonFunctions;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.plugin.tpch.TpchRecordSet;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.tpch.TpchTable;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.joda.time.DateTimeZone;

public class H2QueryRunner
implements Closeable {
    private final Handle handle = Jdbi.open((String)("jdbc:h2:mem:test" + System.nanoTime() + ThreadLocalRandom.current().nextLong()));

    public H2QueryRunner() {
        TpchMetadata tpchMetadata = new TpchMetadata();
        this.handle.execute("CREATE TABLE orders (\n  orderkey BIGINT PRIMARY KEY,\n  custkey BIGINT NOT NULL,\n  orderstatus CHAR(1) NOT NULL,\n  totalprice DOUBLE NOT NULL,\n  orderdate DATE NOT NULL,\n  orderpriority CHAR(15) NOT NULL,\n  clerk CHAR(15) NOT NULL,\n  shippriority INTEGER NOT NULL,\n  comment VARCHAR(79) NOT NULL\n)", new Object[0]);
        this.handle.execute("CREATE INDEX custkey_index ON orders (custkey)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.ORDERS);
        this.handle.execute("CREATE TABLE lineitem (\n  orderkey BIGINT,\n  partkey BIGINT NOT NULL,\n  suppkey BIGINT NOT NULL,\n  linenumber INTEGER,\n  quantity DOUBLE NOT NULL,\n  extendedprice DOUBLE NOT NULL,\n  discount DOUBLE NOT NULL,\n  tax DOUBLE NOT NULL,\n  returnflag CHAR(1) NOT NULL,\n  linestatus CHAR(1) NOT NULL,\n  shipdate DATE NOT NULL,\n  commitdate DATE NOT NULL,\n  receiptdate DATE NOT NULL,\n  shipinstruct VARCHAR(25) NOT NULL,\n  shipmode VARCHAR(10) NOT NULL,\n  comment VARCHAR(44) NOT NULL,\n  PRIMARY KEY (orderkey, linenumber))", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.LINE_ITEM);
        this.handle.execute("CREATE TABLE nation (\n  nationkey BIGINT PRIMARY KEY,\n  name VARCHAR(25) NOT NULL,\n  regionkey BIGINT NOT NULL,\n  comment VARCHAR(114) NOT NULL\n)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.NATION);
        this.handle.execute("CREATE TABLE region(\n  regionkey BIGINT PRIMARY KEY,\n  name VARCHAR(25) NOT NULL,\n  comment VARCHAR(115) NOT NULL\n)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.REGION);
        this.handle.execute("CREATE TABLE part(\n  partkey BIGINT PRIMARY KEY,\n  name VARCHAR(55) NOT NULL,\n  mfgr VARCHAR(25) NOT NULL,\n  brand VARCHAR(10) NOT NULL,\n  type VARCHAR(25) NOT NULL,\n  size INTEGER NOT NULL,\n  container VARCHAR(10) NOT NULL,\n  retailprice DOUBLE NOT NULL,\n  comment VARCHAR(23) NOT NULL\n)", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.PART);
        this.handle.execute("CREATE TABLE customer (\n  custkey BIGINT NOT NULL,\n  name VARCHAR(25) NOT NULL,\n  address VARCHAR(40) NOT NULL,\n  nationkey BIGINT NOT NULL,\n  phone VARCHAR(15) NOT NULL,\n  acctbal DOUBLE NOT NULL,\n  mktsegment VARCHAR(10) NOT NULL,\n  comment VARCHAR(117) NOT NULL,\n  PRIMARY KEY (custkey))", new Object[0]);
        this.insertRows(tpchMetadata, TpchTable.CUSTOMER);
    }

    private void insertRows(TpchMetadata tpchMetadata, TpchTable<?> tpchTable) {
        TpchTableHandle tableHandle = tpchMetadata.getTableHandle(null, new SchemaTableName("tiny", tpchTable.getTableName()));
        H2QueryRunner.insertRows(tpchMetadata.getTableMetadata(null, (ConnectorTableHandle)tableHandle), this.handle, (RecordSet)TpchRecordSet.createTpchRecordSet(tpchTable, (double)tableHandle.getScaleFactor()));
    }

    @Override
    public void close() {
        this.handle.close();
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        MaterializedResult materializedRows = new MaterializedResult(((Handle)((Handle)this.handle.setSqlParser((SqlParser)new RawSqlParser())).setTemplateEngine((template, context) -> template)).createQuery(sql).map(H2QueryRunner.rowMapper(resultTypes)).list(), resultTypes);
        return materializedRows;
    }

    private static RowMapper<MaterializedRow> rowMapper(List<? extends Type> types) {
        return (resultSet, context) -> {
            int count = resultSet.getMetaData().getColumnCount();
            Preconditions.checkArgument((types.size() == count ? 1 : 0) != 0, (String)"expected types count (%s) does not match actual column count (%s)", (int)types.size(), (int)count);
            ArrayList<Object> row = new ArrayList<Object>(count);
            for (int i = 1; i <= count; ++i) {
                Type type = (Type)types.get(i - 1);
                if (BooleanType.BOOLEAN.equals((Object)type)) {
                    boolean booleanValue = resultSet.getBoolean(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(booleanValue);
                    continue;
                }
                if (TinyintType.TINYINT.equals((Object)type)) {
                    byte byteValue = resultSet.getByte(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(byteValue);
                    continue;
                }
                if (SmallintType.SMALLINT.equals((Object)type)) {
                    short shortValue = resultSet.getShort(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(shortValue);
                    continue;
                }
                if (IntegerType.INTEGER.equals((Object)type)) {
                    int intValue = resultSet.getInt(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(intValue);
                    continue;
                }
                if (BigintType.BIGINT.equals((Object)type)) {
                    long longValue = resultSet.getLong(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(longValue);
                    continue;
                }
                if (RealType.REAL.equals((Object)type)) {
                    float floatValue = resultSet.getFloat(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(Float.valueOf(floatValue));
                    continue;
                }
                if (DoubleType.DOUBLE.equals((Object)type)) {
                    double doubleValue = resultSet.getDouble(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(doubleValue);
                    continue;
                }
                if (JsonType.JSON.equals((Object)type)) {
                    String stringValue = resultSet.getString(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(JsonFunctions.jsonParse((Slice)Slices.utf8Slice((String)stringValue)).toStringUtf8());
                    continue;
                }
                if (type instanceof VarcharType) {
                    String stringValue = resultSet.getString(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(stringValue);
                    continue;
                }
                if (type instanceof CharType) {
                    String stringValue = resultSet.getString(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(Chars.padSpaces((String)stringValue, (CharType)((CharType)type)));
                    continue;
                }
                if (VarbinaryType.VARBINARY.equals((Object)type)) {
                    byte[] bytes = resultSet.getBytes(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(bytes);
                    continue;
                }
                if (DateType.DATE.equals((Object)type)) {
                    LocalDate dateValue = resultSet.getObject(i, LocalDate.class);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(dateValue);
                    continue;
                }
                if (type instanceof TimeType) {
                    LocalTime timeValue = resultSet.getObject(i, LocalTime.class);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(timeValue);
                    continue;
                }
                if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type)) {
                    throw new UnsupportedOperationException("H2 does not support TIME WITH TIME ZONE");
                }
                if (type instanceof TimestampType) {
                    LocalDateTime timestampValue;
                    try {
                        timestampValue = resultSet.getObject(i, LocalDateTime.class);
                    }
                    catch (SQLException first) {
                        try {
                            timestampValue = Optional.ofNullable(resultSet.getObject(i, LocalDate.class)).map(LocalDate::atStartOfDay).orElse(null);
                        }
                        catch (RuntimeException e) {
                            first.addSuppressed(e);
                            throw first;
                        }
                    }
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(timestampValue);
                    continue;
                }
                if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
                    throw new UnsupportedOperationException();
                }
                if (UuidType.UUID.equals((Object)type)) {
                    UUID value = (UUID)resultSet.getObject(i);
                    row.add(value);
                    continue;
                }
                if (UnknownType.UNKNOWN.equals((Object)type)) {
                    Object objectValue = resultSet.getObject(i);
                    Preconditions.checkState((boolean)resultSet.wasNull(), (String)"Expected a null value, but got %s", (Object)objectValue);
                    row.add(null);
                    continue;
                }
                if (type instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)type;
                    BigDecimal decimalValue = resultSet.getBigDecimal(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(decimalValue.setScale(decimalType.getScale(), 4).round(new MathContext(decimalType.getPrecision())));
                    continue;
                }
                if (type instanceof ArrayType) {
                    Array array = resultSet.getArray(i);
                    if (resultSet.wasNull()) {
                        row.add(null);
                        continue;
                    }
                    row.add(Lists.newArrayList((Object[])((Object[])array.getArray())));
                    continue;
                }
                throw new AssertionError((Object)("unhandled type: " + String.valueOf(type)));
            }
            return new MaterializedRow(5, row);
        };
    }

    private static void insertRows(ConnectorTableMetadata tableMetadata, Handle handle, RecordSet data) {
        List columns = (List)tableMetadata.getColumns().stream().filter(columnMetadata -> !columnMetadata.isHidden()).collect(ImmutableList.toImmutableList());
        String vars = Joiner.on((char)',').join(Collections.nCopies(columns.size(), "?"));
        String sql = String.format("INSERT INTO %s VALUES (%s)", tableMetadata.getTable().getTableName(), vars);
        RecordCursor cursor = data.cursor();
        while (true) {
            PreparedBatch batch = handle.prepareBatch(sql);
            for (int row = 0; row < 1000; ++row) {
                if (!cursor.advanceNextPosition()) {
                    if (batch.size() > 0) {
                        batch.execute();
                    }
                    return;
                }
                for (int column = 0; column < columns.size(); ++column) {
                    Type type = ((ColumnMetadata)columns.get(column)).getType();
                    if (BooleanType.BOOLEAN.equals((Object)type)) {
                        batch.bind(column, cursor.getBoolean(column));
                        continue;
                    }
                    if (BigintType.BIGINT.equals((Object)type)) {
                        batch.bind(column, cursor.getLong(column));
                        continue;
                    }
                    if (IntegerType.INTEGER.equals((Object)type)) {
                        batch.bind(column, Math.toIntExact(cursor.getLong(column)));
                        continue;
                    }
                    if (DoubleType.DOUBLE.equals((Object)type)) {
                        batch.bind(column, cursor.getDouble(column));
                        continue;
                    }
                    if (type instanceof VarcharType) {
                        batch.bind(column, cursor.getSlice(column).toStringUtf8());
                        continue;
                    }
                    if (DateType.DATE.equals((Object)type)) {
                        long millisUtc = TimeUnit.DAYS.toMillis(cursor.getLong(column));
                        long localMillis = DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millisUtc);
                        batch.bind(column, new Date(localMillis));
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
                }
                batch.add();
            }
            batch.execute();
        }
    }

    private static class RawSqlParser
    implements SqlParser {
        private RawSqlParser() {
        }

        public ParsedSql parse(String sql, StatementContext ctx) {
            return ParsedSql.builder().append(sql).build();
        }

        public String nameParameter(String rawName, StatementContext ctx) {
            throw new UnsupportedOperationException();
        }
    }
}

