/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.MockConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CountingMockConnector {
    private final Object lock = new Object();
    private final List<SchemaTableName> tablesTestSchema1 = (List)IntStream.range(0, 1000).mapToObj(i -> new SchemaTableName("test_schema1", "test_table" + i)).collect(ImmutableList.toImmutableList());
    private final List<SchemaTableName> tablesTestSchema2 = (List)IntStream.range(0, 2000).mapToObj(i -> new SchemaTableName("test_schema2", "test_table" + i)).collect(ImmutableList.toImmutableList());
    private final Set<RoleGrant> roleGrants = (Set)IntStream.range(0, 100).mapToObj(i -> new RoleGrant(new TrinoPrincipal(PrincipalType.USER, "user" + String.valueOf(i == 0 ? "" : Integer.valueOf(i))), "role" + i / 2, false)).collect(ImmutableSet.toImmutableSet());
    private final AtomicLong listSchemasCallsCounter = new AtomicLong();
    private final AtomicLong listTablesCallsCounter = new AtomicLong();
    private final AtomicLong getTableHandleCallsCounter = new AtomicLong();
    private final AtomicLong getColumnsCallsCounter = new AtomicLong();
    private final ListRoleGrantsCounter listRoleGranstCounter = new ListRoleGrantsCounter();

    public Plugin getPlugin() {
        return new Plugin(){

            public Iterable<ConnectorFactory> getConnectorFactories() {
                return ImmutableList.of((Object)CountingMockConnector.this.getConnectorFactory());
            }
        };
    }

    public Stream<SchemaTableName> getAllTables() {
        return Stream.concat(this.tablesTestSchema1.stream(), this.tablesTestSchema2.stream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataCallsCount runCounting(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            this.listSchemasCallsCounter.set(0L);
            this.listTablesCallsCounter.set(0L);
            this.getTableHandleCallsCounter.set(0L);
            this.getColumnsCallsCounter.set(0L);
            this.listRoleGranstCounter.reset();
            runnable.run();
            return new MetadataCallsCount(this.listSchemasCallsCounter.get(), this.listTablesCallsCounter.get(), this.getTableHandleCallsCounter.get(), this.getColumnsCallsCounter.get(), this.listRoleGranstCounter.listRowGrantsCallsCounter.get(), this.listRoleGranstCounter.rolesPushedCounter.get(), this.listRoleGranstCounter.granteesPushedCounter.get(), this.listRoleGranstCounter.limitPushedCounter.get());
        }
    }

    private ConnectorFactory getConnectorFactory() {
        MockConnectorFactory mockConnectorFactory = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> {
            this.listSchemasCallsCounter.incrementAndGet();
            return ImmutableList.of((Object)"test_schema1", (Object)"test_schema2");
        }).withListTables((connectorSession, schemaName) -> {
            this.listTablesCallsCounter.incrementAndGet();
            if (schemaName.equals("test_schema1")) {
                return this.tablesTestSchema1;
            }
            if (schemaName.equals("test_schema2")) {
                return this.tablesTestSchema2;
            }
            return ImmutableList.of();
        }).withGetTableHandle((connectorSession, schemaTableName) -> {
            this.getTableHandleCallsCounter.incrementAndGet();
            return (ConnectorTableHandle)MockConnectorFactory.Builder.defaultGetTableHandle().apply(connectorSession, schemaTableName);
        }).withGetColumns(schemaTableName -> {
            this.getColumnsCallsCounter.incrementAndGet();
            return (List)MockConnectorFactory.Builder.defaultGetColumns().apply(schemaTableName);
        }).withListRoleGrants((connectorSession, roles, grantees, limit) -> {
            this.listRoleGranstCounter.incrementListRoleGrants(roles, grantees, limit);
            return this.roleGrants;
        }).build();
        return mockConnectorFactory;
    }

    public static class ListRoleGrantsCounter {
        private final AtomicLong listRowGrantsCallsCounter = new AtomicLong();
        private final AtomicLong rolesPushedCounter = new AtomicLong();
        private final AtomicLong granteesPushedCounter = new AtomicLong();
        private final AtomicLong limitPushedCounter = new AtomicLong();

        public void reset() {
            this.listRowGrantsCallsCounter.set(0L);
            this.rolesPushedCounter.set(0L);
            this.granteesPushedCounter.set(0L);
            this.limitPushedCounter.set(0L);
        }

        public void incrementListRoleGrants(Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
            this.listRowGrantsCallsCounter.incrementAndGet();
            roles.ifPresent(x -> this.rolesPushedCounter.incrementAndGet());
            grantees.ifPresent(x -> this.granteesPushedCounter.incrementAndGet());
            limit.ifPresent(x -> this.limitPushedCounter.incrementAndGet());
        }
    }

    public static final class MetadataCallsCount {
        private final long listSchemasCount;
        private final long listTablesCount;
        private final long getTableHandleCount;
        private final long getColumnsCount;
        private final long listRoleGrantsCount;
        private final long rolesPushedCount;
        private final long granteesPushedCount;
        private final long limitPushedCount;

        public MetadataCallsCount() {
            this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        public MetadataCallsCount(long listSchemasCount, long listTablesCount, long getTableHandleCount, long getColumnsCount, long listRoleGrantsCount, long rolesPushedCount, long granteesPushedCount, long limitPushedCount) {
            this.listSchemasCount = listSchemasCount;
            this.listTablesCount = listTablesCount;
            this.getTableHandleCount = getTableHandleCount;
            this.getColumnsCount = getColumnsCount;
            this.listRoleGrantsCount = listRoleGrantsCount;
            this.rolesPushedCount = rolesPushedCount;
            this.granteesPushedCount = granteesPushedCount;
            this.limitPushedCount = limitPushedCount;
        }

        public MetadataCallsCount withListSchemasCount(long listSchemasCount) {
            return new MetadataCallsCount(listSchemasCount, this.listTablesCount, this.getTableHandleCount, this.getColumnsCount, this.listRoleGrantsCount, this.rolesPushedCount, this.granteesPushedCount, this.limitPushedCount);
        }

        public MetadataCallsCount withListTablesCount(long listTablesCount) {
            return new MetadataCallsCount(this.listSchemasCount, listTablesCount, this.getTableHandleCount, this.getColumnsCount, this.listRoleGrantsCount, this.rolesPushedCount, this.granteesPushedCount, this.limitPushedCount);
        }

        public MetadataCallsCount withGetTableHandleCount(long getTableHandleCount) {
            return new MetadataCallsCount(this.listSchemasCount, this.listTablesCount, getTableHandleCount, this.getColumnsCount, this.listRoleGrantsCount, this.rolesPushedCount, this.granteesPushedCount, this.limitPushedCount);
        }

        public MetadataCallsCount withGetColumnsCount(long getColumnsCount) {
            return new MetadataCallsCount(this.listSchemasCount, this.listTablesCount, this.getTableHandleCount, getColumnsCount, this.listRoleGrantsCount, this.rolesPushedCount, this.granteesPushedCount, this.limitPushedCount);
        }

        public MetadataCallsCount withListRoleGrantsCount(long listRoleGrantsCount) {
            return new MetadataCallsCount(this.listSchemasCount, this.listTablesCount, this.getTableHandleCount, this.getColumnsCount, listRoleGrantsCount, this.rolesPushedCount, this.granteesPushedCount, this.limitPushedCount);
        }

        public MetadataCallsCount withRolesPushedCount(long rolesPushedCount) {
            return new MetadataCallsCount(this.listSchemasCount, this.listTablesCount, this.getTableHandleCount, this.getColumnsCount, this.listRoleGrantsCount, rolesPushedCount, this.granteesPushedCount, this.limitPushedCount);
        }

        public MetadataCallsCount withGranteesPushedCount(long granteesPushedCount) {
            return new MetadataCallsCount(this.listSchemasCount, this.listTablesCount, this.getTableHandleCount, this.getColumnsCount, this.listRoleGrantsCount, this.rolesPushedCount, granteesPushedCount, this.limitPushedCount);
        }

        public MetadataCallsCount withLimitPushedCount(long limitPushedCount) {
            return new MetadataCallsCount(this.listSchemasCount, this.listTablesCount, this.getTableHandleCount, this.getColumnsCount, this.listRoleGrantsCount, this.rolesPushedCount, this.granteesPushedCount, limitPushedCount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetadataCallsCount that = (MetadataCallsCount)o;
            return this.listSchemasCount == that.listSchemasCount && this.listTablesCount == that.listTablesCount && this.getTableHandleCount == that.getTableHandleCount && this.getColumnsCount == that.getColumnsCount && this.listRoleGrantsCount == that.listRoleGrantsCount && this.rolesPushedCount == that.rolesPushedCount && this.granteesPushedCount == that.granteesPushedCount && this.limitPushedCount == that.limitPushedCount;
        }

        public int hashCode() {
            return Objects.hash(this.listSchemasCount, this.listTablesCount, this.getTableHandleCount, this.getColumnsCount, this.listRoleGrantsCount, this.rolesPushedCount, this.granteesPushedCount, this.limitPushedCount);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("listSchemasCount", this.listSchemasCount).add("listTablesCount", this.listTablesCount).add("getTableHandleCount", this.getTableHandleCount).add("getColumnsCount", this.getColumnsCount).add("listRoleGrantsCount", this.listRoleGrantsCount).add("rolesPushedCount", this.rolesPushedCount).add("granteesPushedCount", this.granteesPushedCount).add("limitPushedCount", this.limitPushedCount).toString();
        }
    }
}

