/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.datatype;

import io.trino.testing.datatype.ColumnSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CreateAndTrinoInsertDataSetup
implements DataSetup {
    private final SqlExecutor sqlExecutor;
    private final TrinoSqlExecutor trinoSqlExecutor;
    private final String tableNamePrefix;

    public CreateAndTrinoInsertDataSetup(SqlExecutor sqlExecutor, TrinoSqlExecutor trinoSqlExecutor, String tableNamePrefix) {
        this.sqlExecutor = sqlExecutor;
        this.trinoSqlExecutor = trinoSqlExecutor;
        this.tableNamePrefix = tableNamePrefix;
    }

    @Override
    public TestTable setupTestTable(List<ColumnSetup> inputs) {
        TestTable testTable = this.createTestTable(inputs);
        try {
            this.insertRows(testTable, inputs);
        }
        catch (Exception e) {
            testTable.close();
            throw e;
        }
        return testTable;
    }

    private void insertRows(TestTable testTable, List<ColumnSetup> inputs) {
        String valueLiterals = inputs.stream().map(ColumnSetup::getInputLiteral).collect(Collectors.joining(", "));
        this.trinoSqlExecutor.execute(String.format("INSERT INTO %s VALUES(%s)", testTable.getName(), valueLiterals));
    }

    private TestTable createTestTable(List<ColumnSetup> inputs) {
        return new TestTable(this.sqlExecutor, this.tableNamePrefix, "(" + this.columnDefinitions(inputs) + ")");
    }

    private String columnDefinitions(List<ColumnSetup> inputs) {
        List columnTypeDefinitions = inputs.stream().map(input -> input.getDeclaredType().orElseThrow(() -> new IllegalArgumentException("declared type not set"))).collect(Collectors.toList());
        return IntStream.range(0, columnTypeDefinitions.size()).mapToObj(i -> String.format("col_%d %s", i, columnTypeDefinitions.get(i))).collect(Collectors.joining(",\n"));
    }
}

