/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.airlift.discovery.server.testing.TestingDiscoveryServer;
import io.airlift.log.Logger;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.cost.StatsCalculator;
import io.trino.execution.FailureInjector;
import io.trino.execution.QueryManager;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AllNodes;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.SqlFunction;
import io.trino.plugin.exchange.FileSystemExchangePlugin;
import io.trino.server.BasicQueryInfo;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.type.TypeManager;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Plan;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.ResultWithQueryId;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProvider;
import io.trino.testing.TestingTrinoClient;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;

public class DistributedQueryRunner
implements QueryRunner {
    private static final Logger log = Logger.get(DistributedQueryRunner.class);
    private static final String ENVIRONMENT = "testing";
    private final TestingDiscoveryServer discoveryServer;
    private final TestingTrinoServer coordinator;
    private final Optional<TestingTrinoServer> backupCoordinator;
    private List<TestingTrinoServer> servers;
    private final Closer closer = Closer.create();
    private final TestingTrinoClient trinoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static Builder<?> builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private DistributedQueryRunner(Session defaultSession, int nodeCount, Map<String, String> extraProperties, Map<String, String> coordinatorProperties, Optional<Map<String, String>> backupCoordinatorProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, List<SystemAccessControl> systemAccessControls, List<EventListener> eventListeners) throws Exception {
        long start;
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        if (backupCoordinatorProperties.isPresent()) {
            Preconditions.checkArgument((nodeCount >= 2 ? 1 : 0) != 0, (Object)"the nodeCount must be greater than or equal to two!");
        }
        try {
            int i;
            start = System.nanoTime();
            this.discoveryServer = new TestingDiscoveryServer(environment);
            this.closer.register(() -> DistributedQueryRunner.closeUnchecked((AutoCloseable)this.discoveryServer));
            log.info("Created TestingDiscoveryServer in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
            ImmutableList.Builder servers = ImmutableList.builder();
            int n = i = backupCoordinatorProperties.isEmpty() ? 1 : 2;
            while (i < nodeCount) {
                TestingTrinoServer worker = (TestingTrinoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingTrinoServer(this.discoveryServer.getBaseUrl(), false, extraProperties, environment, additionalModule, baseDataDir, (List<SystemAccessControl>)ImmutableList.of(), (List<EventListener>)ImmutableList.of()));
                servers.add((Object)worker);
                ++i;
            }
            HashMap<String, String> extraCoordinatorProperties = new HashMap<String, String>();
            extraCoordinatorProperties.putAll(extraProperties);
            extraCoordinatorProperties.putAll(coordinatorProperties);
            if (!extraCoordinatorProperties.containsKey("web-ui.authentication.type")) {
                extraCoordinatorProperties.put("web-ui.authentication.type", "fixed");
                extraCoordinatorProperties.put("web-ui.user", "admin");
            }
            this.coordinator = (TestingTrinoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingTrinoServer(this.discoveryServer.getBaseUrl(), true, extraCoordinatorProperties, environment, additionalModule, baseDataDir, systemAccessControls, eventListeners));
            servers.add((Object)this.coordinator);
            if (backupCoordinatorProperties.isPresent()) {
                HashMap<String, String> extraBackupCoordinatorProperties = new HashMap<String, String>();
                extraBackupCoordinatorProperties.putAll(extraProperties);
                extraBackupCoordinatorProperties.putAll(backupCoordinatorProperties.get());
                this.backupCoordinator = Optional.of((TestingTrinoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingTrinoServer(this.discoveryServer.getBaseUrl(), true, extraBackupCoordinatorProperties, environment, additionalModule, baseDataDir, systemAccessControls, eventListeners)));
                servers.add((Object)this.backupCoordinator.get());
            } else {
                this.backupCoordinator = Optional.empty();
            }
            this.servers = servers.build();
        }
        catch (Exception e) {
            try {
                throw this.closer.rethrow((Throwable)e, Exception.class);
            }
            catch (Throwable throwable) {
                this.closer.close();
                throw throwable;
            }
        }
        defaultSession = defaultSession.toSessionRepresentation().toSession(this.coordinator.getSessionPropertyManager(), defaultSession.getIdentity().getExtraCredentials());
        this.trinoClient = (TestingTrinoClient)this.closer.register((Closeable)new TestingTrinoClient(this.coordinator, defaultSession));
        this.waitForAllNodesGloballyVisible();
        start = System.nanoTime();
        for (TestingTrinoServer server : this.servers) {
            server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
        log.info("Added functions in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    private static TestingTrinoServer createTestingTrinoServer(URI discoveryUri, boolean coordinator, Map<String, String> extraProperties, String environment, Module additionalModule, Optional<Path> baseDataDir, List<SystemAccessControl> systemAccessControls, List<EventListener> eventListeners) {
        long start = System.nanoTime();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"internal-communication.shared-secret", (Object)"test-secret").put((Object)"query.client.timeout", (Object)"10m").put((Object)"discovery.http-client.min-threads", (Object)"1").put((Object)"exchange.http-client.min-threads", (Object)"1").put((Object)"node-manager.http-client.min-threads", (Object)"1").put((Object)"exchange.page-buffer-client.max-callback-threads", (Object)"5").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"task.max-index-memory", (Object)"16kB").put((Object)"distributed-index-joins-enabled", (Object)"true");
        if (coordinator) {
            propertiesBuilder.put((Object)"node-scheduler.include-coordinator", (Object)"true");
            propertiesBuilder.put((Object)"join-distribution-type", (Object)"PARTITIONED");
            propertiesBuilder.put((Object)"failure-detector.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"memoryManager.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"scheduler.http-client.min-threads", (Object)"1");
            propertiesBuilder.put((Object)"workerInfo.http-client.min-threads", (Object)"1");
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)propertiesBuilder.buildOrThrow());
        properties.putAll(extraProperties);
        TestingTrinoServer server = TestingTrinoServer.builder().setCoordinator(coordinator).setProperties(properties).setEnvironment(environment).setDiscoveryUri(discoveryUri).setAdditionalModule(additionalModule).setBaseDataDir(baseDataDir).setSystemAccessControls(systemAccessControls).setEventListeners(eventListeners).build();
        String nodeRole = coordinator ? "coordinator" : "worker";
        log.info("Created %s TestingTrinoServer in %s: %s", new Object[]{nodeRole, Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit(), server.getBaseUrl()});
        return server;
    }

    public void addServers(int nodeCount) throws Exception {
        ImmutableList.Builder serverBuilder = ImmutableList.builder().addAll(this.servers);
        for (int i = 0; i < nodeCount; ++i) {
            TestingTrinoServer server = (TestingTrinoServer)this.closer.register((Closeable)DistributedQueryRunner.createTestingTrinoServer(this.discoveryServer.getBaseUrl(), false, (Map<String, String>)ImmutableMap.of(), ENVIRONMENT, Modules.EMPTY_MODULE, Optional.empty(), (List<SystemAccessControl>)ImmutableList.of(), (List<EventListener>)ImmutableList.of()));
            serverBuilder.add((Object)server);
            server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        }
        this.servers = serverBuilder.build();
        this.waitForAllNodesGloballyVisible();
    }

    private void waitForAllNodesGloballyVisible() throws InterruptedException {
        long start = System.nanoTime();
        while (!this.allNodesGloballyVisible()) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(10.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        log.info("Announced servers in %s", new Object[]{Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    private boolean allNodesGloballyVisible() {
        for (TestingTrinoServer server : this.servers) {
            AllNodes allNodes = server.refreshNodes();
            if (allNodes.getInactiveNodes().isEmpty() && allNodes.getActiveNodes().size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    public TestingTrinoClient getClient() {
        return this.trinoClient;
    }

    public int getNodeCount() {
        return this.servers.size();
    }

    public Session getDefaultSession() {
        return this.trinoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.coordinator.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.coordinator.getMetadata();
    }

    public TypeManager getTypeManager() {
        return this.coordinator.getTypeManager();
    }

    public QueryExplainer getQueryExplainer() {
        return this.coordinator.getQueryExplainer();
    }

    public SessionPropertyManager getSessionPropertyManager() {
        return this.coordinator.getSessionPropertyManager();
    }

    public SplitManager getSplitManager() {
        return this.coordinator.getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.coordinator.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.coordinator.getNodePartitioningManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.coordinator.getStatsCalculator();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.coordinator.getAccessControl();
    }

    public TestingGroupProvider getGroupProvider() {
        return this.coordinator.getGroupProvider();
    }

    public SessionPropertyDefaults getSessionPropertyDefaults() {
        return this.coordinator.getSessionPropertyDefaults();
    }

    public TestingTrinoServer getCoordinator() {
        return this.coordinator;
    }

    public Optional<TestingTrinoServer> getBackupCoordinator() {
        return this.backupCoordinator;
    }

    public List<TestingTrinoServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    public void installPlugin(Plugin plugin) {
        long start = System.nanoTime();
        for (TestingTrinoServer server : this.servers) {
            server.installPlugin(plugin);
        }
        log.info("Installed plugin %s in %s", new Object[]{plugin.getClass().getSimpleName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.servers.forEach(server -> server.getMetadata().addFunctions(functions));
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        long start = System.nanoTime();
        HashSet<CatalogName> catalogNames = new HashSet<CatalogName>();
        for (TestingTrinoServer server : this.servers) {
            catalogNames.add(server.createCatalog(catalogName, connectorName, properties));
        }
        CatalogName catalog = (CatalogName)Iterables.getOnlyElement(catalogNames);
        log.info("Created catalog %s (%s) in %s", new Object[]{catalogName, catalog, Duration.nanosSince((long)start)});
        start = System.nanoTime();
        while (!this.isConnectionVisibleToAllNodes(catalog)) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(100.0, TimeUnit.SECONDS), (String)("waiting for connector " + catalog + " to be initialized in every node"));
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        log.info("Announced catalog %s (%s) in %s", new Object[]{catalogName, catalog, Duration.nanosSince((long)start)});
    }

    private boolean isConnectionVisibleToAllNodes(CatalogName catalogName) {
        for (TestingTrinoServer server : this.servers) {
            server.refreshNodes();
            Set activeNodesWithConnector = server.getActiveNodesWithConnector(catalogName);
            if (activeNodesWithConnector.size() == this.servers.size()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.trinoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.trinoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.trinoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.trinoClient.execute(session, sql).getResult();
            return materializedResult;
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("SQL: " + sql));
            throw e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWithQueryId<MaterializedResult> executeWithQueryId(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            ResultWithQueryId<MaterializedResult> resultWithQueryId = this.trinoClient.execute(session, sql);
            return resultWithQueryId;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public QueryRunner.MaterializedResultWithPlan executeWithPlan(Session session, String sql, WarningCollector warningCollector) {
        ResultWithQueryId<MaterializedResult> resultWithQueryId = this.executeWithQueryId(session, sql);
        return new QueryRunner.MaterializedResultWithPlan(resultWithQueryId.getResult().toTestTypes(), this.getQueryPlan(resultWithQueryId.getQueryId()));
    }

    public Plan createPlan(Session session, String sql, WarningCollector warningCollector) {
        QueryId queryId = this.executeWithQueryId(session, sql).getQueryId();
        Plan queryPlan = this.getQueryPlan(queryId);
        this.coordinator.getQueryManager().cancelQuery(queryId);
        return queryPlan;
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.coordinator.getQueryPlan(queryId);
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public void injectTaskFailure(String traceToken, int stageId, int partitionId, int attemptId, FailureInjector.InjectedFailureType injectionType, Optional<ErrorType> errorType) {
        for (TestingTrinoServer server : this.servers) {
            server.injectTaskFailure(traceToken, stageId, partitionId, attemptId, injectionType, errorType);
        }
    }

    public void loadExchangeManager(String name, Map<String, String> properties) {
        for (TestingTrinoServer server : this.servers) {
            server.loadExchangeManager(name, properties);
        }
    }

    public final void close() {
        this.cancelAllQueries();
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void cancelAllQueries() {
        QueryManager queryManager = this.coordinator.getQueryManager();
        for (BasicQueryInfo queryInfo : queryManager.getQueries()) {
            if (queryInfo.getState().isDone()) continue;
            try {
                queryManager.cancelQuery(queryInfo.getQueryId());
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to cancel query");
            }
        }
    }

    private static void closeUnchecked(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class Builder<SELF extends Builder<?>> {
        private Session defaultSession;
        private int nodeCount = 3;
        private Map<String, String> extraProperties = new HashMap<String, String>();
        private Map<String, String> coordinatorProperties = ImmutableMap.of();
        private Optional<Map<String, String>> backupCoordinatorProperties = Optional.empty();
        private Map<String, String> exchangeManagerProperties = ImmutableMap.of();
        private String environment = "testing";
        private Module additionalModule = Modules.EMPTY_MODULE;
        private Optional<Path> baseDataDir = Optional.empty();
        private List<SystemAccessControl> systemAccessControls = ImmutableList.of();
        private List<EventListener> eventListeners = ImmutableList.of();

        protected Builder(Session defaultSession) {
            this.defaultSession = Objects.requireNonNull(defaultSession, "defaultSession is null");
        }

        public SELF amendSession(Function<Session.SessionBuilder, Session.SessionBuilder> amendSession) {
            Session.SessionBuilder builder = Session.builder((Session)this.defaultSession);
            this.defaultSession = amendSession.apply(builder).build();
            return this.self();
        }

        public SELF setNodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this.self();
        }

        public SELF setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = new HashMap<String, String>(extraProperties);
            return this.self();
        }

        public SELF addExtraProperty(String key, String value) {
            this.extraProperties.put(key, value);
            return this.self();
        }

        public SELF setCoordinatorProperties(Map<String, String> coordinatorProperties) {
            this.coordinatorProperties = coordinatorProperties;
            return this.self();
        }

        public SELF setBackupCoordinatorProperties(Map<String, String> backupCoordinatorProperties) {
            this.backupCoordinatorProperties = Optional.of(backupCoordinatorProperties);
            return this.self();
        }

        public SELF setExchangeManagerProperties(Map<String, String> exchangeManagerProperties) {
            this.exchangeManagerProperties = ImmutableMap.copyOf(Objects.requireNonNull(exchangeManagerProperties, "exchangeManagerProperties is null"));
            return this.self();
        }

        public SELF setSingleCoordinatorProperty(String key, String value) {
            return this.setCoordinatorProperties((Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }

        public SELF setEnvironment(String environment) {
            this.environment = environment;
            return this.self();
        }

        public SELF setAdditionalModule(Module additionalModule) {
            this.additionalModule = Objects.requireNonNull(additionalModule, "additionalModules is null");
            return this.self();
        }

        public SELF setBaseDataDir(Optional<Path> baseDataDir) {
            this.baseDataDir = Objects.requireNonNull(baseDataDir, "baseDataDir is null");
            return this.self();
        }

        public SELF setSystemAccessControl(SystemAccessControl systemAccessControl) {
            return this.setSystemAccessControls((List<SystemAccessControl>)ImmutableList.of((Object)Objects.requireNonNull(systemAccessControl, "systemAccessControl is null")));
        }

        public SELF setSystemAccessControls(List<SystemAccessControl> systemAccessControls) {
            this.systemAccessControls = ImmutableList.copyOf((Collection)Objects.requireNonNull(systemAccessControls, "systemAccessControls is null"));
            return this.self();
        }

        public SELF setEventListener(EventListener eventListener) {
            return this.setEventListeners((List<EventListener>)ImmutableList.of((Object)Objects.requireNonNull(eventListener, "eventListener is null")));
        }

        public SELF setEventListeners(List<EventListener> eventListeners) {
            this.eventListeners = ImmutableList.copyOf((Collection)Objects.requireNonNull(eventListeners, "eventListeners is null"));
            return this.self();
        }

        public SELF enableBackupCoordinator() {
            if (this.backupCoordinatorProperties.isEmpty()) {
                this.setBackupCoordinatorProperties((Map<String, String>)ImmutableMap.of());
            }
            return this.self();
        }

        protected SELF self() {
            return (SELF)this;
        }

        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = new DistributedQueryRunner(this.defaultSession, this.nodeCount, this.extraProperties, this.coordinatorProperties, this.backupCoordinatorProperties, this.environment, this.additionalModule, this.baseDataDir, this.systemAccessControls, this.eventListeners);
            if (!this.exchangeManagerProperties.isEmpty()) {
                queryRunner.installPlugin((Plugin)new FileSystemExchangePlugin());
                queryRunner.loadExchangeManager("filesystem", this.exchangeManagerProperties);
            }
            return queryRunner;
        }
    }
}

