/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.cost.StatsAndCosts;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestDistributedQueries;
import io.trino.testing.DataProviders;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.TestTable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseConnectorTest
extends AbstractTestDistributedQueries {
    @Override
    @Deprecated
    protected final boolean supportsCreateSchema() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA);
    }

    @Override
    @Deprecated
    protected final boolean supportsCreateTable() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE);
    }

    @Override
    @Deprecated
    protected final boolean supportsInsert() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT);
    }

    @Override
    @Deprecated
    protected final boolean supportsDelete() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE);
    }

    @Override
    @Deprecated
    protected final boolean supportsViews() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW);
    }

    @Override
    @Deprecated
    protected final boolean supportsArrays() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ARRAY);
    }

    @Override
    @Deprecated
    protected final boolean supportsCommentOnTable() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE);
    }

    @Override
    @Deprecated
    protected final boolean supportsCommentOnColumn() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN);
    }

    @Override
    @Deprecated
    protected boolean supportsRenameTable() {
        return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE);
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    @Override
    @Test
    public void ensureTestNamingConvention() {
        Assertions.assertThat((String)this.getClass().getName()).endsWith((CharSequence)"ConnectorTest");
    }

    @Test
    public void testColumnsInReverseOrder() {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM orders");
    }

    @Test
    public void testCharVarcharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS char(3))),    (3, CAST('   ' AS char(3))),   (6, CAST('x  ' AS char(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(2))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(4))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))", "VALUES (6, 'x  ')");
        }
    }

    @Test
    public void testVarcharCharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_varchar_char", "(k, v) AS VALUES   (-1, CAST(NULL AS varchar(3))),    (0, CAST('' AS varchar(3))),   (1, CAST(' ' AS varchar(3))),    (2, CAST('  ' AS varchar(3))),    (3, CAST('   ' AS varchar(3))),   (4, CAST('x' AS varchar(3))),   (5, CAST('x ' AS varchar(3))),   (6, CAST('x  ' AS varchar(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS char(2))", "VALUES (0, ''), (1, ' '), (2, '  '), (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS char(2))", "VALUES (4, 'x'), (5, 'x '), (6, 'x  ')");
        }
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(orderkey) FROM orders");
        this.assertQuery("SELECT sum(totalprice) FROM orders");
        this.assertQuery("SELECT max(comment) FROM nation");
        this.assertQuery("SELECT count(*) FROM orders");
        this.assertQuery("SELECT count(*) FROM orders WHERE orderkey > 10");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders LIMIT 10)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders WHERE orderkey > 10 LIMIT 10)");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation");
        this.assertQuery("SELECT regionkey FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT regionkey, nationkey FROM nation GROUP BY GROUPING SETS ((regionkey), (nationkey))", "SELECT NULL, nationkey FROM nation UNION ALL SELECT DISTINCT regionkey, NULL FROM nation");
        this.assertQuery("SELECT regionkey, nationkey, count(*) FROM nation GROUP BY GROUPING SETS ((), (regionkey), (nationkey), (regionkey, nationkey))", "SELECT NULL, NULL, count(*) FROM nation UNION ALL SELECT NULL, nationkey, 1 FROM nation UNION ALL SELECT regionkey, NULL, count(*) FROM nation GROUP BY regionkey UNION ALL SELECT regionkey, nationkey, 1 FROM nation");
        this.assertQuery("SELECT count(regionkey) FROM nation");
        this.assertQuery("SELECT count(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT min(regionkey), max(regionkey) FROM nation");
        this.assertQuery("SELECT min(DISTINCT regionkey), max(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, min(regionkey), min(name), max(regionkey), max(name) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, sum(regionkey) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT avg(nationkey) FROM nation", "SELECT avg(CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT avg(DISTINCT nationkey) FROM nation", "SELECT avg(DISTINCT CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey", "SELECT regionkey, avg(CAST(nationkey AS double)) FROM nation GROUP BY regionkey");
    }

    @Test
    public void testExactPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32", "VALUES (1301)");
    }

    @Test
    public void testInListPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IN (10, 11, 20, 21)");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392, 7), (1301, 32), (670, 33)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392), (1301), (670)");
    }

    @Test
    public void testIsNullPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IS NULL");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10 OR orderkey IS NULL");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301)");
    }

    @Test
    public void testLikePredicate() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L__'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L__'");
    }

    @Test
    public void testMultipleRangesPredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testRangePredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testPredicateReflectedInExplain() {
        this.assertExplain("EXPLAIN SELECT name FROM nation WHERE nationkey = 42", "(predicate|filterPredicate|constraint).{0,10}(nationkey|NATIONKEY)");
    }

    @Test
    public void testSortItemsReflectedInExplain() {
        String expectedPattern = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN) ? "sortOrder=\\[(?i:nationkey):.* DESC NULLS LAST] limit=5" : "\\[5 by \\((?i:nationkey) DESC NULLS LAST\\)]";
        this.assertExplain("EXPLAIN SELECT name FROM nation ORDER BY nationkey DESC NULLS LAST LIMIT 5", expectedPattern);
    }

    @Test
    public void testConcurrentScans() {
        String unionMultipleTimes = String.join((CharSequence)" UNION ALL ", Collections.nCopies(25, "SELECT * FROM orders"));
        this.assertQuery("SELECT sum(if(rand() >= 0, orderkey)) FROM (" + unionMultipleTimes + ")", "VALUES 11246812500");
    }

    @Test
    public void testSelectAll() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test(timeOut=300000L, dataProvider="joinDistributionTypes")
    public void testJoinWithEmptySides(FeaturesConfig.JoinDistributionType joinDistributionType) {
        Session session = this.noJoinReordering(joinDistributionType);
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM region JOIN nation ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
    }

    @DataProvider
    public Object[][] joinDistributionTypes() {
        return (Object[][])Stream.of(FeaturesConfig.JoinDistributionType.values()).collect(DataProviders.toDataProvider());
    }

    @Test
    public void testJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("ignore_stats_calculator_failures", "false").build();
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey WHERE n.name = 'ARGENTINA'");
        this.assertQuery(session, "SELECT c.name, n.name, n.count, r.name FROM (SELECT name, regionkey, nationkey, count(*) count FROM nation GROUP BY name, regionkey, nationkey) n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE orders");
        Assert.assertEquals((Iterable)actualColumns, (Iterable)expectedColumns);
    }

    @Override
    public void testView() {
        super.testView();
    }

    @Test
    public void testMaterializedView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW nation_mv AS SELECT * FROM nation", "This connector does not support creating materialized views");
            return;
        }
        QualifiedObjectName view = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), "test_materialized_view_" + TestTable.randomTableSuffix());
        QualifiedObjectName otherView = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), "other_schema", "test_materialized_view_" + TestTable.randomTableSuffix());
        QualifiedObjectName viewWithComment = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), "test_materialized_view_with_comment_" + TestTable.randomTableSuffix());
        this.createTestingMaterializedView(view, Optional.empty());
        this.createTestingMaterializedView(otherView, Optional.of("sarcastic comment"));
        this.createTestingMaterializedView(viewWithComment, Optional.of("mv_comment"));
        MaterializedResult materializedRows = this.computeActual("SHOW CREATE MATERIALIZED VIEW " + viewWithComment);
        Assertions.assertThat((String)((String)materializedRows.getOnlyValue())).contains(new CharSequence[]{"COMMENT 'mv_comment'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + view.getCatalogName() + "' AND schema_name = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.getObjectName() + "', null), ('" + viewWithComment.getObjectName() + "', 'mv_comment')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + view))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewWithComment))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + view.getObjectName() + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.getObjectName() + "', 'BASE TABLE')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.getSchemaName() + "' and table_name = '" + view.getObjectName() + "'", "VALUES ('" + view.getObjectName() + "', 'BASE TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'TABLE')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + view.getCatalogName() + "' AND table_schem = '" + view.getSchemaName() + "' AND table_name = '" + view.getObjectName() + "'", "VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + view.getObjectName()))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + view.getObjectName()))).projected(new int[]{0}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.getObjectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.getSchemaName() + "' and table_name = '" + view.getObjectName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.getObjectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        this.checkInformationSchemaViewsForMaterializedView(view.getSchemaName(), view.getObjectName());
        String expectedValues = "VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'nationkey'), ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'name'), ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'regionkey'), ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'comment')";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll(expectedValues);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + view.getSchemaName() + "%'"))).skippingTypesCheck().containsAll(expectedValues);
        this.assertQuery("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + view.getObjectName() + "%'", expectedValues);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + view.getObjectName()))).matches((CharSequence)("(?s)CREATE MATERIALIZED VIEW \\Q" + view + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewWithComment);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.getCatalogName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRows(view, otherView));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + otherView.getCatalogName() + "'", "schema_name = '" + otherView.getSchemaName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(otherView, "sarcastic comment"));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.getCatalogName() + "'", "schema_name = '" + view.getSchemaName() + "'", "name = '" + view.getObjectName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("schema_name LIKE '%" + view.getSchemaName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("name LIKE '%" + view.getObjectName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, "REFRESH MATERIALIZED VIEW " + view))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
        this.assertUpdate("DROP MATERIALIZED VIEW " + view);
        this.assertUpdate("DROP MATERIALIZED VIEW " + otherView);
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + view.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + otherView.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + viewWithComment.getObjectName() + "'"));
    }

    @Test
    public void testRenameMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String schema = "rename_mv_test";
        Session session = Session.builder((Session)this.getSession()).setSchema(schema).build();
        QualifiedObjectName originalMaterializedView = new QualifiedObjectName((String)session.getCatalog().orElseThrow(), (String)session.getSchema().orElseThrow(), "test_materialized_view_rename_" + TestTable.randomTableSuffix());
        this.createTestingMaterializedView(originalMaterializedView, Optional.empty());
        String renamedMaterializedView = "test_materialized_view_rename_new_" + TestTable.randomTableSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW)) {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + originalMaterializedView + " RENAME TO " + renamedMaterializedView, "This connector does not support renaming materialized views");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + originalMaterializedView);
            return;
        }
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + originalMaterializedView + " RENAME TO " + renamedMaterializedView);
        this.assertTestingMaterializedViewQuery(schema, renamedMaterializedView);
        this.assertQuery(session, "SELECT catalog_name, schema_name FROM system.metadata.materialized_views WHERE name = '" + renamedMaterializedView + "'", String.format("VALUES ('%s', '%s')", originalMaterializedView.getCatalogName(), originalMaterializedView.getSchemaName()));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.getObjectName() + "'"));
        String testExistsMaterializedViewName = "test_materialized_view_rename_exists_" + TestTable.randomTableSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW IF EXISTS " + renamedMaterializedView + " RENAME TO " + testExistsMaterializedViewName);
        this.assertTestingMaterializedViewQuery(schema, testExistsMaterializedViewName);
        String uppercaseName = "TEST_MATERIALIZED_VIEW_RENAME_UPPERCASE_" + TestTable.randomTableSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + testExistsMaterializedViewName + " RENAME TO " + uppercaseName);
        this.assertTestingMaterializedViewQuery(schema, uppercaseName.toLowerCase(Locale.ENGLISH));
        String otherSchema = "rename_mv_other_schema";
        this.assertUpdate(String.format("CREATE SCHEMA IF NOT EXISTS %s", otherSchema));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW_ACROSS_SCHEMAS)) {
            this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.getObjectName());
            this.assertTestingMaterializedViewQuery(otherSchema, originalMaterializedView.getObjectName());
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + otherSchema + "." + originalMaterializedView.getObjectName());
        } else {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.getObjectName(), "Materialized View rename across schemas is not supported");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + uppercaseName);
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, originalMaterializedView.toString()));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, renamedMaterializedView));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, testExistsMaterializedViewName));
        this.assertUpdate(session, "ALTER TABLE IF EXISTS " + originalMaterializedView + " RENAME TO " + renamedMaterializedView);
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + renamedMaterializedView + "'"));
    }

    private void assertTestingMaterializedViewQuery(String schema, String materializedViewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + schema + "." + materializedViewName))).skippingTypesCheck().matches("SELECT * FROM nation");
    }

    private void createTestingMaterializedView(QualifiedObjectName view, Optional<String> comment) {
        this.assertUpdate(String.format("CREATE SCHEMA IF NOT EXISTS %s", view.getSchemaName()));
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s %s AS SELECT * FROM nation", view, comment.map(c -> String.format("COMMENT '%s'", c)).orElse("")));
    }

    private String getTestingMaterializedViewsResultRow(QualifiedObjectName materializedView, String comment) {
        return String.format("VALUES ('%s', '%s', '%s', '%s', 'SELECT *\nFROM\n  nation\n')", materializedView.getCatalogName(), materializedView.getSchemaName(), materializedView.getObjectName(), comment);
    }

    private String getTestingMaterializedViewsResultRows(QualifiedObjectName materializedView, QualifiedObjectName otherMaterializedView) {
        String viewDefinitionSql = "SELECT *\nFROM\n  nation\n";
        return String.format("VALUES ('%s', '%s', '%s', '', '%s'),('%s', '%s', '%s', 'sarcastic comment', '%s')", materializedView.getCatalogName(), materializedView.getSchemaName(), materializedView.getObjectName(), viewDefinitionSql, otherMaterializedView.getCatalogName(), otherMaterializedView.getSchemaName(), otherMaterializedView.getObjectName(), viewDefinitionSql);
    }

    private String listMaterializedViewsSql(String ... filterClauses) {
        StringBuilder sql = new StringBuilder("SELECT   catalog_name,   schema_name,   name,   comment,   definition FROM system.metadata.materialized_views WHERE true");
        for (String filterClause : filterClauses) {
            sql.append(" AND ").append(filterClause);
        }
        return sql.toString();
    }

    @Test
    public void testViewAndMaterializedViewTogether() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            return;
        }
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String regularViewName = "test_views_together_normal_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE VIEW " + regularViewName + " AS SELECT * FROM region");
        String materializedViewName = "test_views_together_materialized_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + materializedViewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + regularViewName + "'");
        this.checkInformationSchemaViewsForMaterializedView(schemaName, materializedViewName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + regularViewName))).containsAll("SELECT * FROM region");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + materializedViewName))).containsAll("SELECT * FROM nation");
        this.assertUpdate("DROP VIEW " + regularViewName);
        this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
    }

    protected void checkInformationSchemaViewsForMaterializedView(String schemaName, String viewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + viewName + "'");
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk UNION ALL SELECT sum(orderkey), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW COLUMNS FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN ANALYZE SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW FUNCTIONS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW TABLES", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SCHEMAS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW CATALOGS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SESSION", new String[0]);
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders WHERE orderkey < 0", new String[0]);
    }

    @Test
    public void testTableSampleSystem() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult randomSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (50)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= randomSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testTableSampleWithFiltering() {
        MaterializedResult emptySample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (99) WHERE orderkey BETWEEN 0 AND 0");
        MaterializedResult halfSample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (50) WHERE orderkey BETWEEN 0 AND 9999999999");
        MaterializedResult all = this.computeActual("SELECT orderkey, orderdate FROM orders");
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= halfSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)");
    }

    @Test
    public void testSelectInformationSchemaTables() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll("^.", "_");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "' AND table_name = 'orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schema + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = '" + catalog + "' AND table_schema LIKE '" + schema + "' AND table_name LIKE '%orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.tables WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll(".$", "_");
        String ordersTableWithColumns = "VALUES ('orders', 'orderkey'), ('orders', 'custkey'), ('orders', 'orderstatus'), ('orders', 'totalprice'), ('orders', 'orderdate'), ('orders', 'orderpriority'), ('orders', 'clerk'), ('orders', 'shippriority'), ('orders', 'comment')";
        this.assertQuery("SELECT table_schema FROM information_schema.columns WHERE table_schema = '" + schema + "' GROUP BY table_schema", "VALUES '" + schema + "'");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE table_name = 'orders' GROUP BY table_name", "VALUES 'orders'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'orders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name LIKE '%rders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '_rder_'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '%orders%'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns");
        this.assertQuery("SELECT DISTINCT table_name, column_name FROM information_schema.columns WHERE table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "'");
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_name LIKE '%'");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.columns WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('role_authorization_descriptors'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testShowCreateInformationSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW CREATE SCHEMA information_schema"))).skippingTypesCheck().matches(String.format("VALUES 'CREATE SCHEMA %s.information_schema'", this.getSession().getCatalog().orElseThrow()));
    }

    @Test
    public void testShowCreateInformationSchemaTable() {
        this.assertQueryFails("SHOW CREATE VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a view");
        this.assertQueryFails("SHOW CREATE MATERIALIZED VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a materialized view");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE information_schema.schemata"))).isEqualTo("CREATE TABLE " + (String)this.getSession().getCatalog().orElseThrow() + ".information_schema.schemata (\n   catalog_name varchar,\n   schema_name varchar\n)");
    }

    @Test
    public void testRollback() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        String table = "test_rollback_" + TestTable.randomTableSuffix();
        this.computeActual(String.format("CREATE TABLE %s (x int)", table));
        Assertions.assertThatThrownBy(() -> this.inTransaction(session -> {
            this.assertUpdate((Session)session, String.format("INSERT INTO %s VALUES (42)", table), 1L);
            throw new RollbackException();
        })).isInstanceOf(RollbackException.class);
        this.assertQuery(String.format("SELECT count(*) FROM %s", table), "SELECT 0");
    }

    @Test
    public void testWriteNotAllowedInTransaction() {
        BaseConnectorTest.skipTestUnless(!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA, "CREATE SCHEMA write_not_allowed");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "CREATE TABLE write_not_allowed (x int)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "DROP TABLE region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA, "CREATE TABLE write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, "CREATE VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, "CREATE MATERIALIZED VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE, "ALTER TABLE region RENAME TO region_name");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_INSERT, "INSERT INTO region (regionkey) VALUES (123)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_DELETE, "DELETE FROM region WHERE regionkey = 123");
    }

    protected void assertWriteNotAllowedInTransaction(TestingConnectorBehavior behavior, @Language(value="SQL") String sql) {
        if (this.hasBehavior(behavior)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, sql))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
    }

    @Test
    public void testRenameSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA)) {
            String schemaName = (String)this.getSession().getSchema().orElseThrow();
            this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", schemaName, schemaName + TestTable.randomTableSuffix()), "This connector does not support renaming schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new SkipException("Skipping as connector does not support CREATE SCHEMA");
        }
        String schemaName = "test_rename_schema_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            this.assertUpdate("ALTER SCHEMA " + schemaName + " RENAME TO " + schemaName + "_renamed");
        }
        finally {
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName + "_renamed");
        }
    }

    @Test
    public void testRenameTableAcrossSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
                throw new SkipException("Skipping since rename table is not supported at all");
            }
            this.assertQueryFails("ALTER TABLE nation RENAME TO other_schema.yyyy", "This connector does not support renaming tables across schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE SCHEMA, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_rename_old_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String schemaName = "test_schema_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        String renamedTable = schemaName + ".test_rename_new_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + renamedTable);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQuery("SELECT x FROM " + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + renamedTable);
        this.assertUpdate("DROP SCHEMA " + schemaName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
    }

    @Override
    public void testAddColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation ADD COLUMN test_add_column bigint", "This connector does not support adding columns");
            return;
        }
        super.testAddColumn();
    }

    @Override
    public void testDropColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation DROP COLUMN nationkey", "This connector does not support dropping columns");
            return;
        }
        super.testDropColumn();
    }

    @Override
    public void testRenameColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation RENAME COLUMN nationkey TO test_rename_column", "This connector does not support renaming columns");
            return;
        }
        super.testRenameColumn();
    }

    @Test
    public void testInsertIntoNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT)) {
            this.assertQueryFails("CREATE TABLE not_null_constraint (not_null_col INTEGER NOT NULL)", String.format("line 1:35: Catalog '%s' does not support non-null column for column name 'not_null_col'", this.getSession().getCatalog().orElseThrow()));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_not_null", "(nullable_col INTEGER, not_null_col INTEGER NOT NULL)");){
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (nullable_col) VALUES (1)", table.getName()), this.errorMessageForInsertIntoNotNullColumn("not_null_col"));
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "commuted_not_null", "(nullable_col BIGINT, not_null_col BIGINT NOT NULL)");
        try {
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (NULL, 3)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
        }
        finally {
            table.close();
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void verifySupportsDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_delete", "AS SELECT * FROM region");){
            this.assertQueryFails("DELETE FROM " + table.getName(), "This connector does not support deletes");
        }
    }

    @Test
    public void verifySupportsRowLevelDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_row_level_delete", "AS SELECT * FROM region");){
            this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE regionkey = 2", "This connector does not support deletes");
        }
    }

    @Test
    public void testDeleteAllDataFromTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_all_data", "AS SELECT * FROM region");){
            this.getQueryRunner().execute("DELETE FROM " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testRowLevelDelete() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_row_delete", "AS SELECT * FROM region");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey = 2", 1L);
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 4");
        }
    }

    @Test
    public void testUpdate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support updates");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update", "AS TABLE tpch.tiny.nation");){
            String tableName = table.getName();
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = 100 + nationkey WHERE regionkey = 2", 5L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT IF(regionkey=2, nationkey + 100, nationkey) nationkey, name, regionkey, comment FROM tpch.tiny.nation");
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = nationkey * 2 WHERE regionkey IN (2,3)", 10L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT CASE regionkey WHEN 2 THEN 2*(nationkey+100) WHEN 3 THEN 2*nationkey ELSE nationkey END nationkey, name, regionkey, comment FROM tpch.tiny.nation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, invocationCount=4)
    public void testUpdateRowConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_concurrent_update", IntStream.range(0, threads).mapToObj(i -> String.format("col%s integer", i)).collect(Collectors.joining(", ", "(", ")")));){
            String tableName = table.getName();
            this.assertUpdate(String.format("INSERT INTO %s VALUES (%s)", tableName, String.join((CharSequence)",", Collections.nCopies(threads, "0"))), 1L);
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    String columnName = "col" + threadNumber;
                    this.getQueryRunner().execute(String.format("UPDATE %s SET %s = %s + 1", tableName, columnName, columnName));
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentUpdateFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (trinoException != e && verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            })).collect(ImmutableList.toImmutableList());
            String expected = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).map(success -> success != false ? "1" : "0").collect(Collectors.joining(",", "VALUES (", ")"));
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).matches(expected);
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentUpdateFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent update failure", e);
    }

    @Test
    public void testTruncateTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TRUNCATE)) {
            this.assertQueryFails("TRUNCATE TABLE nation", "This connector does not support truncating tables");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_truncate", "AS SELECT * FROM region");){
            this.assertUpdate("TRUNCATE TABLE " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testMaterializedViewColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testMaterializedViewColumnName(columnName, false);
        }
        this.testMaterializedViewColumnName(columnName, true);
    }

    private void testMaterializedViewColumnName(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String viewName = "tcn_" + ((String)nameInSql).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_") + "_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT 'sample value' key, 'abc' " + (String)nameInSql);
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES ('sample value', 'abc')");
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    protected Consumer<Plan> assertPartialLimitWithPreSortedInputsCount(Session session, int expectedCount) {
        return plan -> {
            int actualCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof LimitNode && ((LimitNode)node).isPartial() && ((LimitNode)node).requiresPreSortedInputs()).findAll().size();
            if (actualCount != expectedCount) {
                Metadata metadata = this.getDistributedQueryRunner().getCoordinator().getMetadata();
                String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (TypeProvider)plan.getTypes(), (Metadata)metadata, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
                throw new AssertionError((Object)String.format("Expected [\n%s\n] partial limit but found [\n%s\n] partial limit. Actual plan is [\n\n%s\n]", expectedCount, actualCount, formattedPlan));
            }
        };
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }
}

