/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.operator.OperatorStats;
import io.trino.server.DynamicFilterService;
import io.trino.spi.QueryId;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.ResultWithQueryId;
import io.trino.tpch.TpchTable;
import io.trino.util.DynamicFiltersTestUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class BaseDynamicPartitionPruningTest
extends AbstractTestQueryFramework {
    private static final String PARTITIONED_LINEITEM = "partitioned_lineitem";
    private static final long LINEITEM_COUNT = 60175L;
    protected static final Set<TpchTable<?>> REQUIRED_TABLES = ImmutableSet.of((Object)TpchTable.LINE_ITEM, (Object)TpchTable.ORDERS, (Object)TpchTable.SUPPLIER);
    protected static final Map<String, String> EXTRA_PROPERTIES = ImmutableMap.of((Object)"dynamic-filtering.large-partitioned.max-distinct-values-per-driver", (Object)"100", (Object)"dynamic-filtering.large-partitioned.range-row-limit-per-driver", (Object)"100000", (Object)"optimizer.rewrite-filtering-semi-join-to-inner-join", (Object)"false");

    @Override
    @BeforeClass
    public void init() throws Exception {
        super.init();
        this.createLineitemTable(PARTITIONED_LINEITEM, (List<String>)ImmutableList.of((Object)"orderkey", (Object)"partkey", (Object)"suppkey"), (List<String>)ImmutableList.of((Object)"suppkey"));
    }

    protected abstract void createLineitemTable(String var1, List<String> var2, List<String> var3);

    @Override
    protected Session getSession() {
        return Session.builder((Session)super.getSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).setSystemProperty("enable_large_dynamic_filters", "true").build();
    }

    @Test(timeOut=30000L)
    public void testJoinWithEmptyBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name = 'abc'";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)0L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.none((Type)BigintType.BIGINT).toString(this.getSession().toConnectorSession()));
        Assert.assertTrue((boolean)domainStats.getCollectionDuration().isPresent());
    }

    @Test(timeOut=30000L)
    public void testJoinWithSelectiveBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name = 'Supplier#000000001'";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)615L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testJoinWithNonSelectiveBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem JOIN supplier ON partitioned_lineitem.suppkey = supplier.suppkey";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assertions.assertThat((String)domainStats.getSimplifiedDomain()).isEqualTo(DynamicFiltersTestUtil.getSimplifiedDomainString((long)1L, (long)100L, (int)100, (Type)BigintType.BIGINT));
    }

    @Test(timeOut=30000L)
    public void testJoinLargeBuildSideRangeDynamicFiltering() {
        String selectQuery = "SELECT * FROM partitioned_lineitem JOIN orders ON partitioned_lineitem.orderkey = orders.orderkey";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)60000L, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testJoinWithMultipleDynamicFiltersOnProbe() {
        String selectQuery = "SELECT * FROM (SELECT supplier.suppkey FROM partitioned_lineitem JOIN tpch.tiny.supplier ON partitioned_lineitem.suppkey = supplier.suppkey AND supplier.name IN ('Supplier#000000001', 'Supplier#000000002')) t JOIN supplier ON t.suppkey = supplier.suppkey AND supplier.suppkey IN (2, 3)";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)558L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)2L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)2L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((int)dynamicFiltersStats.getDynamicFiltersCompleted(), (int)2);
        List domainStats = dynamicFiltersStats.getDynamicFilterDomainStats();
        Assertions.assertThat((List)domainStats).map(DynamicFilterService.DynamicFilterDomainStats::getSimplifiedDomain).containsExactlyInAnyOrder((Object[])new String[]{DynamicFiltersTestUtil.getSimplifiedDomainString((long)2L, (long)3L, (int)2, (Type)BigintType.BIGINT), DynamicFiltersTestUtil.getSimplifiedDomainString((long)2L, (long)2L, (int)1, (Type)BigintType.BIGINT)});
    }

    @Test(timeOut=30000L)
    public void testJoinWithImplicitCoercion() {
        this.createLineitemTable("partitioned_lineitem_int", (List<String>)ImmutableList.of((Object)"orderkey", (Object)"CAST(suppkey as int) suppkey_int"), (List<String>)ImmutableList.of((Object)"suppkey_int"));
        this.assertQuery("SELECT count(*) FROM partitioned_lineitem_int", "VALUES 60175");
        String selectQuery = "SELECT * FROM partitioned_lineitem_int l JOIN supplier s ON l.suppkey_int = s.suppkey AND s.name = 'Supplier#000000001'";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName("partitioned_lineitem_int"));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)615L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testSemiJoinWithEmptyBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem WHERE suppkey IN (SELECT suppkey FROM supplier WHERE name = 'abc')";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)0L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.none((Type)BigintType.BIGINT).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testSemiJoinWithSelectiveBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem WHERE suppkey IN (SELECT suppkey FROM supplier WHERE name = 'Supplier#000000001')";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)615L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testSemiJoinWithNonSelectiveBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem WHERE suppkey IN (SELECT suppkey FROM supplier)";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assertions.assertThat((String)domainStats.getSimplifiedDomain()).isEqualTo(DynamicFiltersTestUtil.getSimplifiedDomainString((long)1L, (long)100L, (int)100, (Type)BigintType.BIGINT));
    }

    @Test(timeOut=30000L)
    public void testSemiJoinLargeBuildSideRangeDynamicFiltering() {
        String selectQuery = "SELECT * FROM partitioned_lineitem WHERE orderkey IN (SELECT orderkey FROM orders)";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)60000L, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testRightJoinWithEmptyBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem l RIGHT JOIN supplier s ON l.suppkey = s.suppkey WHERE name = 'abc'";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)0L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.none((Type)BigintType.BIGINT).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testRightJoinWithSelectiveBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem l RIGHT JOIN supplier s ON l.suppkey = s.suppkey WHERE name = 'Supplier#000000001'";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)615L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assert.assertEquals((String)domainStats.getSimplifiedDomain(), (String)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L).toString(this.getSession().toConnectorSession()));
    }

    @Test(timeOut=30000L)
    public void testRightJoinWithNonSelectiveBuildSide() {
        String selectQuery = "SELECT * FROM partitioned_lineitem l RIGHT JOIN supplier s ON l.suppkey = s.suppkey";
        ResultWithQueryId<MaterializedResult> result = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), selectQuery);
        MaterializedResult expected = this.computeActual(this.withDynamicFilteringDisabled(), selectQuery);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getResult(), expected);
        OperatorStats probeStats = this.searchScanFilterAndProjectOperatorStats(result.getQueryId(), this.getQualifiedTableName(PARTITIONED_LINEITEM));
        Assert.assertEquals((long)probeStats.getInputPositions(), (long)60175L);
        DynamicFilterService.DynamicFiltersStats dynamicFiltersStats = this.getDynamicFilteringStats(result.getQueryId());
        Assert.assertEquals((long)dynamicFiltersStats.getTotalDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getLazyDynamicFilters(), (long)1L);
        Assert.assertEquals((long)dynamicFiltersStats.getReplicatedDynamicFilters(), (long)0L);
        Assert.assertEquals((long)dynamicFiltersStats.getDynamicFiltersCompleted(), (long)1L);
        DynamicFilterService.DynamicFilterDomainStats domainStats = (DynamicFilterService.DynamicFilterDomainStats)Iterables.getOnlyElement((Iterable)dynamicFiltersStats.getDynamicFilterDomainStats());
        Assertions.assertThat((String)domainStats.getSimplifiedDomain()).isEqualTo(DynamicFiltersTestUtil.getSimplifiedDomainString((long)1L, (long)100L, (int)100, (Type)BigintType.BIGINT));
    }

    private DynamicFilterService.DynamicFiltersStats getDynamicFilteringStats(QueryId queryId) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getDynamicFiltersStats();
    }

    private Session withDynamicFilteringDisabled() {
        return Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "false").build();
    }

    private QualifiedObjectName getQualifiedTableName(String tableName) {
        Session session = this.getQueryRunner().getDefaultSession();
        return new QualifiedObjectName((String)session.getCatalog().orElseThrow(), (String)session.getSchema().orElseThrow(), tableName);
    }
}

