/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;

@AggregationFunction(value="custom_sum")
public final class CustomSum {
    private CustomSum() {
    }

    @InputFunction
    public static void input(@AggregationState NullableLongState state, @SqlType(value="bigint") long value) {
        state.setLong(state.getLong() + value);
        state.setNull(false);
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong(state.getLong() + otherState.getLong());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, (NullableLongState)state, (BlockBuilder)out);
    }
}

