/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

public abstract class BaseConnectorSmokeTest
extends AbstractTestQueryFramework {
    protected static final List<TpchTable<?>> REQUIRED_TPCH_TABLES = ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.REGION);

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Override
    @Test
    public void ensureTestNamingConvention() {
        Assertions.assertThat((String)this.getClass().getName()).endsWith((CharSequence)"ConnectorSmokeTest");
    }

    @Test
    public void testSelect() {
        this.assertQuery("SELECT name FROM region");
    }

    @Test
    public void testPredicate() {
        this.assertQuery("SELECT name, regionkey FROM nation WHERE nationkey = 10");
        this.assertQuery("SELECT name, regionkey FROM nation WHERE nationkey BETWEEN 5 AND 15");
        this.assertQuery("SELECT name, regionkey FROM nation WHERE name = 'EGYPT'");
    }

    @Test
    public void testLimit() {
        this.assertQuery("SELECT name FROM region LIMIT 5");
    }

    @Test
    public void testTopN() {
        this.assertQuery("SELECT regionkey FROM nation ORDER BY name LIMIT 3");
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(nationkey) FROM nation GROUP BY regionkey");
    }

    @Test
    public void testHaving() {
        this.assertQuery("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 58", "VALUES (4, 58)");
    }

    @Test
    public void testJoin() {
        this.assertQuery("SELECT n.name, r.name FROM nation n JOIN region r on n.regionkey = r.regionkey");
    }

    @Test
    public void testCreateTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            this.assertQueryFails("CREATE TABLE xxxx (a bigint, b double)", "This connector does not support creating tables");
            return;
        }
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + tableName))).returnsEmptyResult();
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelect() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            this.assertQueryFails("CREATE TABLE xxxx AS SELECT BIGINT '42' a, DOUBLE '-38.5' b", "This connector does not support creating tables with data");
            return;
        }
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '42' a, DOUBLE '-38.5' b", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + tableName))).matches("VALUES (BIGINT '42', -385e-1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsert() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO region (regionkey) VALUES (42)", "This connector does not support inserts");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double)");
        this.assertUpdate("INSERT INTO " + tableName + " (a, b) VALUES (42, -38.5)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + tableName))).matches("VALUES (BIGINT '42', -385e-1)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDelete() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE)) {
            this.assertQueryFails("DELETE FROM region", "This connector does not support deletes");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE)) {
            this.assertQueryFails("DELETE FROM region WHERE regionkey = 2", ".*[Dd]elet(e|ing).*(not |un)supported.*");
            return;
        }
        String tableName = "test_delete_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM region", 5L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey = 2", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT regionkey FROM " + tableName))).skippingTypesCheck().matches("VALUES 1, 3, 4, 5");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            this.assertQueryFails("CREATE SCHEMA xxxxxx", "This connector does not support creating schemas");
            this.getSession().getSchema().ifPresent(s -> this.assertQueryFails("DROP SCHEMA " + s, "This connector does not support dropping schemas"));
            return;
        }
        String schemaName = "test_schema_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW SCHEMAS"))).skippingTypesCheck().containsAll(String.format("VALUES '%s', '%s'", this.getSession().getSchema().orElseThrow(), schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testRenameTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
            this.assertQueryFails("ALTER TABLE nation RENAME TO yyyy", "This connector does not support renaming tables");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String oldTable = "test_rename_old_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + oldTable + " (a bigint, b double)");
        String newTable = "test_rename_new_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + oldTable + "'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + newTable))).returnsEmptyResult();
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertUpdate("INSERT INTO " + newTable + " (a, b) VALUES (42, -38.5)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + newTable))).matches("VALUES (BIGINT '42', -385e-1)");
        }
        this.assertUpdate("DROP TABLE " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + newTable + "'"))).returnsEmptyResult();
    }

    @Test
    public void testRenameTableAcrossSchemas() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
                throw new SkipException("Skipping since rename table is not supported at all");
            }
            this.assertQueryFails("ALTER TABLE nation RENAME TO other_schema.yyyy", "This connector does not support renaming tables across schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE SCHEMA, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String oldTable = "test_rename_old_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + oldTable + " (a bigint, b double)");
        String schemaName = "test_schema_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        String newTable = schemaName + ".test_rename_new_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + oldTable + "'"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a, b FROM " + newTable))).returnsEmptyResult();
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertUpdate("INSERT INTO " + newTable + " (a, b) VALUES (42, -38.5)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(a AS bigint), b FROM " + newTable))).matches("VALUES (BIGINT '42', -385e-1)");
        }
        this.assertUpdate("DROP TABLE " + newTable);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES LIKE '" + newTable + "'"))).returnsEmptyResult();
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testSelectInformationSchemaTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().orElseThrow())))).skippingTypesCheck().containsAll("VALUES 'nation', 'region'");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(String.format("SELECT column_name FROM information_schema.columns WHERE table_schema = '%s' AND table_name = 'region'", this.getSession().getSchema().orElseThrow())))).skippingTypesCheck().matches("VALUES 'regionkey', 'name', 'comment'");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).matches((CharSequence)String.format("CREATE TABLE %s.%s.region \\(\n   regionkey (bigint|decimal\\(19, 0\\)),\n   name varchar(\\(\\d+\\))?,\n   comment varchar(\\(\\d+\\))?\n\\)", Pattern.quote((String)this.getSession().getCatalog().orElseThrow()), Pattern.quote((String)this.getSession().getSchema().orElseThrow())));
    }

    @Test
    public void testView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            this.assertQueryFails("CREATE VIEW nation_v AS SELECT * FROM nation", "This connector does not support creating views");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String viewName = "test_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewName))).skippingTypesCheck().matches("SELECT * FROM nation");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE VIEW " + viewName))).matches((CharSequence)("(?s)CREATE VIEW \\Q" + catalogName + "." + schemaName + "." + viewName + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP  VIEW " + viewName);
    }

    @Test
    public void testMaterializedView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW nation_mv AS SELECT * FROM nation", "This connector does not support creating materialized views");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String viewName = "test_materialized_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewName))).skippingTypesCheck().matches("SELECT * FROM nation");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + viewName))).matches((CharSequence)("(?s)CREATE MATERIALIZED VIEW \\Q" + catalogName + "." + schemaName + "." + viewName + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }
}

