/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metadata.FunctionListBuilder;
import io.trino.metadata.SqlFunction;
import io.trino.operator.scalar.ApplyFunction;
import io.trino.operator.scalar.InvokeFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.CreateHll;
import io.trino.testing.CustomAdd;
import io.trino.testing.CustomRank;
import io.trino.testing.CustomSum;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.StatefulSleepingSum;
import io.trino.testing.assertions.Assert;
import io.trino.tpch.TpchTable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestQueries
extends AbstractTestQueryFramework {
    protected static final List<TpchTable<?>> REQUIRED_TPCH_TABLES = ImmutableList.of((Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION, (Object)TpchTable.ORDERS, (Object)TpchTable.REGION, (Object)TpchTable.LINE_ITEM);
    protected static final List<SqlFunction> CUSTOM_FUNCTIONS = new FunctionListBuilder().aggregates(CustomSum.class).window(CustomRank.class).scalars(CustomAdd.class).scalars(CreateHll.class).functions(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION, InvokeFunction.INVOKE_FUNCTION, StatefulSleepingSum.STATEFUL_SLEEPING_SUM}).getFunctions();

    @Test
    public void testAggregationOverUnknown() {
        this.assertQuery("SELECT clerk, min(totalprice), max(totalprice), min(nullvalue), max(nullvalue) FROM (SELECT clerk, totalprice, null AS nullvalue FROM orders) GROUP BY clerk");
    }

    @Test
    public void testLimitMax() {
        this.assertQuery("SELECT orderkey FROM orders LIMIT 2147483647");
        this.assertQuery("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 2147483647");
        this.assertQuery("SELECT nationkey FROM nation LIMIT 9223372036854775807", "SELECT nationkey FROM nation");
        this.assertQueryFails("SELECT nationkey FROM nation ORDER BY nationkey LIMIT 9223372036854775807", "ORDER BY LIMIT > 2147483647 is not supported");
    }

    @Test
    public void testComplexQuery() {
        this.assertQueryOrdered("SELECT sum(orderkey), row_number() OVER (ORDER BY orderkey) FROM orders WHERE orderkey <= 10 GROUP BY orderkey HAVING sum(orderkey) >= 3 ORDER BY orderkey DESC LIMIT 3", "VALUES (7, 5), (6, 4), (5, 3)");
    }

    @Test
    public void testDistinctMultipleFields() {
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders");
    }

    @Test
    public void testArithmeticNegation() {
        this.assertQuery("SELECT -custkey FROM orders");
    }

    @Test
    public void testDistinct() {
        this.assertQuery("SELECT DISTINCT custkey FROM orders");
    }

    @Test
    public void testDistinctHaving() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) AS count FROM orders GROUP BY orderdate HAVING COUNT(DISTINCT clerk) > 1");
    }

    @Test
    public void testDistinctLimit() {
        this.assertQuery("SELECT DISTINCT orderstatus, custkey FROM (SELECT orderstatus, custkey FROM orders ORDER BY orderkey LIMIT 10) LIMIT 10");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT DISTINCT orderstatus, custkey FROM orders LIMIT 10)");
        this.assertQuery("SELECT DISTINCT custkey, orderstatus FROM orders WHERE custkey = 1268 LIMIT 2");
        this.assertQuery("SELECT DISTINCT x FROM (VALUES 1) t(x) JOIN (VALUES 10, 20) u(a) ON t.x < u.a LIMIT 100", "SELECT 1");
    }

    @Test
    public void testDistinctWithOrderBy() {
        this.assertQueryOrdered("SELECT DISTINCT custkey FROM orders ORDER BY custkey LIMIT 10");
    }

    @Test
    public void testRepeatedAggregations() {
        this.assertQuery("SELECT SUM(orderkey), SUM(orderkey) FROM orders");
    }

    @Test
    public void testLimit() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitWithAggregation() {
        MaterializedResult actual = this.computeActual("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT custkey, SUM(CAST(totalprice * 100 AS BIGINT)) FROM orders GROUP BY custkey", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testLimitInInlineView() {
        MaterializedResult actual = this.computeActual("SELECT orderkey FROM (SELECT orderkey FROM orders LIMIT 100) T LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
    }

    @Test
    public void testCountAll() {
        this.assertQuery("SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(42 + 42) FROM orders", "SELECT COUNT(*) FROM orders");
        this.assertQuery("SELECT COUNT(null) FROM orders", "SELECT 0");
    }

    @Test
    public void testCountColumn() {
        this.assertQuery("SELECT COUNT(orderkey) FROM orders");
        this.assertQuery("SELECT COUNT(orderstatus) FROM orders");
        this.assertQuery("SELECT COUNT(orderdate) FROM orders");
        this.assertQuery("SELECT COUNT(1) FROM orders");
        this.assertQuery("SELECT COUNT(NULLIF(orderstatus, 'F')) FROM orders");
        this.assertQuery("SELECT COUNT(CAST(NULL AS BIGINT)) FROM orders");
    }

    @Test
    public void testSelectWithComparison() {
        this.assertQuery("SELECT orderkey FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testIn() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1.5, 2.3)", "SELECT orderkey FROM orders LIMIT 0");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (1, 2E0, 3)");
        this.assertQuery("SELECT orderkey FROM orders WHERE totalprice IN (1, 2, 3)");
    }

    @Test(dataProvider="largeInValuesCount")
    public void testLargeIn(int valuesCount) {
        String longValues = IntStream.range(0, valuesCount).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (mod(1000, orderkey), " + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (mod(1000, orderkey), " + longValues + ")");
    }

    @DataProvider
    public static Object[][] largeInValuesCount() {
        return new Object[][]{{200}, {500}, {1000}, {5000}};
    }

    @Test
    public void testShowSchemas() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)((String)this.getSession().getSchema().get()), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasFrom() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS FROM %s", this.getSession().getCatalog().get()));
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)((String)this.getSession().getSchema().get()), (Object)"information_schema")));
    }

    @Test
    public void testShowSchemasLike() {
        MaterializedResult result = this.computeActual(String.format("SHOW SCHEMAS LIKE '%s'", this.getSession().getSchema().get()));
        Assert.assertEquals((Set)result.getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)((String)this.getSession().getSchema().get())));
    }

    @Test
    public void testShowSchemasLikeWithEscape() {
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE ''", "Escape string must be a single character");
        this.assertQueryFails("SHOW SCHEMAS LIKE 't$_%' ESCAPE '$$'", "Escape string must be a single character");
        Set allSchemas = this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet();
        Assert.assertEquals((Set)allSchemas, (Set)this.computeActual("SHOW SCHEMAS LIKE '%_%'").getOnlyColumnAsSet());
        Set result = this.computeActual("SHOW SCHEMAS LIKE '%$_%' ESCAPE '$'").getOnlyColumnAsSet();
        org.testng.Assert.assertNotEquals((Object)allSchemas, (Object)result);
        Assertions.assertThat((Iterable)result).contains(new Object[]{"information_schema"}).allMatch(schemaName -> ((String)schemaName).contains("_"));
    }

    @Test
    public void testShowTables() {
        Set expectedTables = (Set)REQUIRED_TPCH_TABLES.stream().map(TpchTable::getTableName).collect(ImmutableSet.toImmutableSet());
        MaterializedResult result = this.computeActual("SHOW TABLES");
        Assertions.assertThat((Iterable)result.getOnlyColumnAsSet()).containsAll((Iterable)expectedTables);
    }

    @Test
    public void testShowTablesLike() {
        Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES LIKE 'or%'").getOnlyColumnAsSet()).contains(new Object[]{"orders"}).allMatch(tableName -> ((String)tableName).startsWith("or"));
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expectedUnparametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
        MaterializedResult expectedParametrizedVarchar = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        org.testng.Assert.assertTrue((actual.equals((Object)expectedParametrizedVarchar) || actual.equals((Object)expectedUnparametrizedVarchar) ? 1 : 0) != 0, (String)String.format("%s does not matche neither of %s and %s", actual, expectedParametrizedVarchar, expectedUnparametrizedVarchar));
    }

    @Test
    public void testInformationSchemaFiltering() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE data_type = 'bigint' AND table_name = 'customer' and column_name = 'custkey' LIMIT 1", "SELECT 'customer' table_name");
    }

    @Test
    public void testInformationSchemaUppercaseName() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'LOCAL'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'TINY'", "SELECT '' WHERE false");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'ORDERS'", "SELECT '' WHERE false");
    }

    @Test
    public void testTopN() {
        this.assertQueryOrdered("SELECT n.name, r.name FROM nation n LEFT JOIN region r ON n.regionkey = r.regionkey ORDER BY n.name LIMIT 1");
        this.assertQueryOrdered("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey FROM orders ORDER BY orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderpriority, totalprice FROM orders ORDER BY orderpriority DESC, totalprice ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey FROM orders WHERE orderkey > 10 ORDER BY orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT sum(totalprice), clerk FROM orders GROUP BY clerk ORDER BY sum(totalprice) LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, totalprice FROM (SELECT orderkey, totalprice FROM orders ORDER BY 1, 2 LIMIT 10) ORDER BY 2, 1 LIMIT 5");
        this.assertQueryOrdered("SELECT totalprice_sum, clerk FROM (SELECT SUM(totalprice) as totalprice_sum, clerk FROM orders WHERE orderpriority='1-URGENT' GROUP BY clerk ORDER BY totalprice_sum DESC LIMIT 10)ORDER BY clerk DESC LIMIT 5");
        this.assertQueryOrdered("SELECT * FROM (SELECT SUM(totalprice) as sum, custkey AS total FROM orders GROUP BY custkey HAVING COUNT(*) > 3) ORDER BY sum DESC LIMIT 10");
    }

    @Test
    public void testTopNByMultipleFields() {
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey ASC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY orderkey DESC, custkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey ASC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY custkey DESC, orderkey DESC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS FIRST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) DESC NULLS LAST, custkey ASC LIMIT 10");
        this.assertQueryOrdered("SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC, custkey ASC LIMIT 10", "SELECT orderkey, custkey, orderstatus FROM orders ORDER BY nullif(orderkey, 3) ASC NULLS LAST, custkey ASC LIMIT 10");
    }

    @Test
    public void testLimitPushDown() {
        MaterializedResult actual = this.computeActual("(TABLE orders ORDER BY orderkey) UNION ALL SELECT * FROM orders WHERE orderstatus = 'F' UNION ALL (TABLE orders ORDER BY orderkey LIMIT 20) UNION ALL (TABLE orders LIMIT 5) UNION ALL TABLE orders LIMIT 10");
        MaterializedResult all = this.computeExpected("SELECT * FROM orders", actual.getTypes());
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)10);
        QueryAssertions.assertContains(all, actual);
        this.assertQuery("SELECT name FROM nation ORDER BY nationkey LIMIT 3");
        this.assertQuery("SELECT name FROM nation ORDER BY regionkey LIMIT 5");
        this.assertQuery("SELECT max(regionkey) FROM nation LIMIT 5");
        this.assertQuery("SELECT regionkey, max(name) FROM nation GROUP BY regionkey LIMIT 5");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation LIMIT 5");
        this.assertQuery("SELECT regionkey, count(*) FROM nation WHERE name < 'EGYPT' GROUP BY regionkey LIMIT 3");
    }

    @Test
    public void testPredicate() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT orderkey+1 AS a FROM orders WHERE orderstatus = 'F' UNION ALL \n  SELECT orderkey FROM orders WHERE orderkey % 2 = 0 UNION ALL \n  (SELECT orderkey+custkey FROM orders ORDER BY orderkey LIMIT 10)\n) \nWHERE a < 20 OR a > 100 \nORDER BY a");
    }

    @Test
    public void testTableSampleBernoulliBoundaryValues() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (0)");
        MaterializedResult all = this.computeExpected("SELECT orderkey FROM orders", fullSample.getTypes());
        QueryAssertions.assertContains(all, fullSample);
        Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
    }

    @Test
    public void testTableSampleBernoulli() {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        int total = this.computeExpected("SELECT orderkey FROM orders", (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT)).getMaterializedRows().size();
        for (int i = 0; i < 100; ++i) {
            List values = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE BERNOULLI (50)").getMaterializedRows();
            Assert.assertEquals((int)values.size(), (int)ImmutableSet.copyOf((Collection)values).size(), (String)"TABLESAMPLE produced duplicate rows");
            stats.addValue((double)values.size() * 1.0 / (double)total);
        }
        double mean = stats.getGeometricMean();
        org.testng.Assert.assertTrue((mean > 0.45 && mean < 0.55 ? 1 : 0) != 0, (String)String.format("Expected mean sampling rate to be ~0.5, but was %s", mean));
    }

    @Test
    public void testFilterPushdownWithAggregation() {
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE 0=1");
        this.assertQuery("SELECT * FROM (SELECT count(*) FROM orders) WHERE null");
    }
}

