/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.base.Throwables;
import io.trino.testng.services.Listeners;
import java.util.Optional;
import org.testng.IClassListener;
import org.testng.ITestClass;

public class ReportInnerTestClasses
implements IClassListener {
    public void onBeforeClass(ITestClass iTestClass) {
        try {
            this.reportInnerTestClasses(iTestClass);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportInnerTestClasses.class, "Failed to process %s: \n%s", iTestClass, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void reportInnerTestClasses(ITestClass testClass) {
        Class realClass = testClass.getRealClass();
        if (realClass.getName().startsWith("io.trino.testng.services")) {
            return;
        }
        Optional<Class<?>> maybeEnclosingClass = Optional.ofNullable(realClass.getEnclosingClass());
        maybeEnclosingClass.ifPresent(enclosingClass -> Listeners.reportListenerFailure(ReportInnerTestClasses.class, "Test class %s is defined as an inner class, has an enclosing class %s", realClass.getName(), enclosingClass.getName()));
    }

    public void onAfterClass(ITestClass iTestClass) {
    }
}

