/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import io.airlift.log.Logger;
import io.trino.testng.services.Listeners;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.testng.IClassListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class ProgressLoggingListener
implements IClassListener,
ITestListener,
IInvokedMethodListener {
    private static final Logger LOGGER = Logger.get(ProgressLoggingListener.class);
    private final boolean enabled = ProgressLoggingListener.isEnabled();

    public ProgressLoggingListener() {
        if (!this.enabled) {
            LOGGER.info("ProgressLoggingListener is disabled!");
        }
    }

    private static boolean isEnabled() {
        if (System.getProperty("ProgressLoggingListener.enabled") != null) {
            return Boolean.getBoolean("ProgressLoggingListener.enabled");
        }
        return System.getenv("CONTINUOUS_INTEGRATION") != null;
    }

    public void onStart(ITestContext context) {
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (!this.enabled) {
            return;
        }
        boolean testMethod = method.isTestMethod();
        boolean configurationMethod = method.isConfigurationMethod();
        if (testMethod) {
            LOGGER.info("[TEST START] %s", new Object[]{Listeners.formatTestName(testResult)});
        }
        if (configurationMethod) {
            LOGGER.info("[CONFIGURATION] %s", new Object[]{method});
        }
        if (!testMethod && !configurationMethod) {
            LOGGER.info("[UNKNOWN THING] %s for %s", new Object[]{method, Listeners.formatTestName(testResult)});
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void onTestStart(ITestResult testCase) {
    }

    public void onTestSuccess(ITestResult testCase) {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("[TEST SUCCESS] %s; (took: %s)", new Object[]{Listeners.formatTestName(testCase), ProgressLoggingListener.formatDuration(testCase)});
    }

    public void onTestFailure(ITestResult testCase) {
        if (!this.enabled) {
            return;
        }
        if (testCase.getThrowable() != null) {
            LOGGER.error(testCase.getThrowable(), "[TEST FAILURE] %s; (took: %s)", new Object[]{Listeners.formatTestName(testCase), ProgressLoggingListener.formatDuration(testCase)});
        } else {
            LOGGER.error("[TEST FAILURE] %s; (took: %s)", new Object[]{Listeners.formatTestName(testCase), ProgressLoggingListener.formatDuration(testCase)});
        }
    }

    public void onTestSkipped(ITestResult testCase) {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("[TEST SKIPPED] %s", new Object[]{Listeners.formatTestName(testCase)});
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult testCase) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onBeforeClass(ITestClass testClass) {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("[BEFORE CLASS] %s", new Object[]{Listeners.formatTestName(testClass)});
    }

    public void onAfterClass(ITestClass testClass) {
        if (!this.enabled) {
            return;
        }
        LOGGER.info("[AFTER CLASS] %s", new Object[]{Listeners.formatTestName(testClass)});
    }

    private static String formatDuration(ITestResult testCase) {
        return ProgressLoggingListener.formatDuration(testCase.getEndMillis() - testCase.getStartMillis());
    }

    private static String formatDuration(long durationInMillis) {
        BigDecimal durationSeconds = ProgressLoggingListener.durationInSeconds(durationInMillis);
        if (durationSeconds.longValue() < 60L) {
            return String.format("%s seconds", durationSeconds);
        }
        long minutes = durationSeconds.longValue() / 60L;
        long restSeconds = durationSeconds.longValue() % 60L;
        return String.format("%d minutes and %d seconds", minutes, restSeconds);
    }

    private static BigDecimal durationInSeconds(long millis) {
        return new BigDecimal(millis).divide(new BigDecimal(1000), 1, RoundingMode.HALF_UP);
    }
}

