/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.testng.services.Listeners;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.annotations.Test;

public class ReportPrivateMethods
implements IClassListener {
    public void onBeforeClass(ITestClass testClass) {
        try {
            this.reportPrivateTestMethods(testClass);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportPrivateMethods.class, "Failed to process %s: \n%s", testClass, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void reportPrivateTestMethods(ITestClass testClass) {
        Class realClass = testClass.getRealClass();
        List<Method> privateTestMethods = ReportPrivateMethods.findPrivateTestMethods(realClass);
        if (!privateTestMethods.isEmpty()) {
            Listeners.reportListenerFailure(ReportPrivateMethods.class, "By convention the following methods in the test class %s should be public:%s", realClass.getName(), privateTestMethods.stream().map(Method::toString).collect(Collectors.joining("\n\t\t", "\n\t\t", "")));
        }
    }

    @VisibleForTesting
    static List<Method> findPrivateTestMethods(Class<?> realClass) {
        return (List)ReportPrivateMethods.inheritanceChain(realClass).flatMap(clazz -> Stream.of(clazz.getDeclaredMethods())).filter(method -> !Modifier.isPublic(method.getModifiers())).filter(method -> !method.isBridge()).filter(ReportPrivateMethods::isTestAnnotated).filter(method -> !method.isAnnotationPresent(Suppress.class)).collect(ImmutableList.toImmutableList());
    }

    public void onAfterClass(ITestClass testClass) {
    }

    private static Stream<Class<?>> inheritanceChain(Class<?> mostDerived) {
        return Stream.iterate(mostDerived, clazz -> clazz.getSuperclass() != null, Class::getSuperclass);
    }

    private static boolean isTestAnnotated(Method method) {
        return Arrays.stream(method.getAnnotations()).map(Annotation::annotationType).anyMatch(annotationClass -> {
            if (Test.class.getPackage().equals(annotationClass.getPackage())) {
                return true;
            }
            return "io.trino.tempto".equals(annotationClass.getPackage().getName());
        });
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Suppress {
    }
}

